/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.korisnici.gui;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Dokumentparameter;
import rs.pezar.db.entity.DokumentparameterPK;
import rs.pezar.globals.TipDokumentStructure;
import rs.pezar.korisnici.gui.sortiranjeNaDokumentima.PzDialogUnosSortiranja;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;

public class PzDialogSortiranjeNaDokumentima
extends PzDialog {
    private PzPanelHeader pzPanelHeader1;
    private PzButtonPanel btnPanel;
    private JScrollPane jScrollPane1;
    private PzTable table;
    private PzButton btnCancel;
    private PzButton btnOK;
    private PzPanel pnlMain;
    private HashMap<String, String> mapNew;
    private List<TipDokumentStructure.Tip> tipovi = TipDokumentStructure.loadStructure();
    private HashMap<String, String> mapBase;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogSortiranjeNaDokumentima inst = new PzDialogSortiranjeNaDokumentima(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogSortiranjeNaDokumentima(JFrame frame) {
        super(frame);
        this.mapNew = new LinkedHashMap<String, String>();
        this.mapBase = new HashMap();
        this.getDokumentParameter();
        this.setCBData();
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout thisLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)thisLayout);
            this.setTitle("Sortiranje na dokumentima");
            this.pzPanelHeader1 = new PzPanelHeader();
            this.getContentPane().add((Component)this.pzPanelHeader1, new AnchorConstraint(0, 0, 161, 0, 2, 2, 0, 2));
            this.pzPanelHeader1.setTitle("Sortiranje na dokumentima");
            this.pzPanelHeader1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/document_refresh.png")));
            this.btnPanel = new PzButtonPanel();
            GridBagLayout btnPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.btnPanel, new AnchorConstraint(927, 0, 0, 0, 0, 2, 2, 2));
            btnPanelLayout.rowWeights = new double[]{0.1};
            btnPanelLayout.rowHeights = new int[]{7};
            btnPanelLayout.columnWeights = new double[]{0.1, 0.1};
            btnPanelLayout.columnWidths = new int[]{7, 7};
            this.btnPanel.setLayout((LayoutManager)btnPanelLayout);
            this.btnPanel.setPreferredSize(new Dimension(565, 54));
            this.btnOK = new PzButton();
            this.btnPanel.add((Component)this.btnOK, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 5), 0, 0));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/check.png")));
            this.btnOK.setName("btnOK");
            this.btnOK.setText("OK");
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.btnOK.setActionCommand("ok");
            this.btnCancel = new PzButton();
            this.btnPanel.add((Component)this.btnCancel, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 1, 0), 0, 0));
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/forbidden.png")));
            this.btnCancel.setText("Nazad");
            this.btnCancel.addActionListener((ActionListener)((Object)this));
            this.btnCancel.setActionCommand("nazad");
            this.pnlMain = new PzPanel();
            BorderLayout pnlMainLayout = new BorderLayout();
            this.getContentPane().add((Component)this.pnlMain, new AnchorConstraint(70, 1000, 927, 0, 2, 1, 0, 2));
            this.pnlMain.setLayout((LayoutManager)pnlMainLayout);
            this.pnlMain.setPreferredSize(new Dimension(542, 284));
            this.jScrollPane1 = new JScrollPane();
            this.pnlMain.add((Component)this.jScrollPane1, (Object)"Center");
            this.table = new PzTable();
            this.jScrollPane1.setViewportView((Component)this.table);
            this.table.setModel((TableModel)this.model());
            this.table.setHorizontalScrollEnabled(true);
            this.table.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    String key = (String)PzDialogSortiranjeNaDokumentima.this.table.getValueAt(PzDialogSortiranjeNaDokumentima.this.table.getSelectedRow(), 0);
                    String value = (String)PzDialogSortiranjeNaDokumentima.this.table.getValueAt(PzDialogSortiranjeNaDokumentima.this.table.getSelectedRow(), 1);
                    PzDialogSortiranjeNaDokumentima.this.getSession().putParameter("key", (Object)key);
                    PzDialogSortiranjeNaDokumentima.this.getSession().putParameter("value", (Object)value);
                    PzDialogSortiranjeNaDokumentima.this.showDialog(PzDialogUnosSortiranja.class);
                    for (Map.Entry entry : PzDialogSortiranjeNaDokumentima.this.mapNew.entrySet()) {
                        if (!((String)entry.getKey()).equals(key)) continue;
                        entry.setValue(PzDialogUnosSortiranja.getSort());
                    }
                    value = PzDialogUnosSortiranja.getSort();
                    ((DefaultTableModel)PzDialogSortiranjeNaDokumentima.this.table.getModel()).setValueAt(value, PzDialogSortiranjeNaDokumentima.this.table.getSelectedRow(), 1);
                    ((DefaultTableModel)PzDialogSortiranjeNaDokumentima.this.table.getModel()).fireTableCellUpdated(PzDialogSortiranjeNaDokumentima.this.table.getSelectedRow(), 1);
                }
            });
            this.pack();
            this.setSize(558, 446);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equalsIgnoreCase("nazad")) {
            this.dispose();
        } else if (actionCommand.equalsIgnoreCase("ok")) {
            EntityManager em = PzEntityManager.getEm();
            try {
                try {
                    em.getTransaction().begin();
                    for (Map.Entry<String, String> entry : this.mapNew.entrySet()) {
                        if (this.mapBase.containsKey(entry.getKey()) && entry.getValue().equals("")) {
                            this.removeDocParam(entry, em);
                            continue;
                        }
                        if (this.mapBase.containsKey(entry.getKey()) && this.mapBase.get(entry.getKey()).equals(entry.getValue())) continue;
                        if (this.mapBase.containsKey(entry.getKey()) && !this.mapBase.get(entry.getKey()).equals(entry.getValue())) {
                            this.updateDocParam(entry, em);
                            continue;
                        }
                        if (entry.getValue().equals("")) continue;
                        this.addDocParam(entry, em);
                    }
                    em.getTransaction().commit();
                }
                catch (Exception ex) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    ex.printStackTrace();
                    em.close();
                    this.dispose();
                }
            }
            finally {
                em.close();
                this.dispose();
            }
        } else {
            actionCommand.equalsIgnoreCase("cb");
        }
    }

    private void removeDocParam(Map.Entry<String, String> e, EntityManager em) {
        DokumentparameterPK dpRemovePK = new DokumentparameterPK();
        dpRemovePK.setTipDok(this.getTipDok(e.getKey()));
        dpRemovePK.setTipParam("SORT");
        Dokumentparameter dpRemove = (Dokumentparameter)em.find(Dokumentparameter.class, (Object)dpRemovePK);
        em.remove((Object)dpRemove);
    }

    private void updateDocParam(Map.Entry<String, String> e, EntityManager em) {
        DokumentparameterPK dpRemovePK = new DokumentparameterPK();
        dpRemovePK.setTipDok(this.getTipDok(e.getKey()));
        dpRemovePK.setTipParam("SORT");
        Dokumentparameter dpUpdate = (Dokumentparameter)em.find(Dokumentparameter.class, (Object)dpRemovePK);
        dpUpdate.setVrednost(e.getValue());
        em.merge((Object)dpUpdate);
    }

    private void addDocParam(Map.Entry<String, String> e, EntityManager em) {
        Dokumentparameter dp = new Dokumentparameter();
        DokumentparameterPK dpPK = new DokumentparameterPK();
        dpPK.setTipDok(this.getTipDok(e.getKey()));
        dpPK.setTipParam("SORT");
        dp.setId(dpPK);
        dp.setVrednost(e.getValue());
        em.persist((Object)dp);
    }

    private void setCBData() {
        for (TipDokumentStructure.Tip tip : this.tipovi) {
            if (this.mapBase.containsKey(tip.getNaziv())) {
                this.mapNew.put(tip.getNaziv(), this.mapBase.get(tip.getNaziv()));
                continue;
            }
            this.mapNew.put(tip.getNaziv(), "");
        }
    }

    private String getTipDok(String naziv) {
        String pomTip = "";
        for (TipDokumentStructure.Tip tip : this.tipovi) {
            if (!tip.getNaziv().equals(naziv)) continue;
            pomTip = tip.getTip();
        }
        return pomTip;
    }

    private void getDokumentParameter() {
        EntityManager emDP = PzEntityManager.getEm();
        Vector dpBaseTemp = new Vector();
        String query = "SELECT dp FROM Dokumentparameter dp WHERE dp.id.tipParam ='SORT'";
        Query q = emDP.createQuery(query);
        dpBaseTemp = (Vector)q.getResultList();
        if (dpBaseTemp != null || dpBaseTemp.size() != 0) {
            for (TipDokumentStructure.Tip tip : this.tipovi) {
                int i = 0;
                while (i < dpBaseTemp.size()) {
                    if (tip.getTip().equals(((Dokumentparameter)dpBaseTemp.get(i)).getId().getTipDok())) {
                        this.mapBase.put(tip.getNaziv(), ((Dokumentparameter)dpBaseTemp.get(i)).getVrednost());
                    }
                    ++i;
                }
            }
        }
        emDP.close();
    }

    private DefaultTableModel model() {
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        };
        Object[] tableColumnNames = new String[]{"Naziv dokumenta", "Sortiranje"};
        model.setColumnIdentifiers(tableColumnNames);
        Object[] object = new Object[2];
        for (Map.Entry<String, String> entry : this.mapNew.entrySet()) {
            object[0] = entry.getKey();
            object[1] = entry.getValue();
            model.addRow(object);
        }
        return model;
    }
}

