/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.korisnici.gui;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.intern.CDockable;
import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.gui.defaultWidgets.mainView.MainViewWidget;
import rs.pezar.core.gui.defaultWidgets.mainView.TreeElement;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Dozvola;
import rs.pezar.db.entity.DozvolaPK;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentStructure;
import rs.pezar.korisnici.PzUserUtil;
import rs.pezar.korisnici.gui.PzCheckBoxList;
import rs.pezar.korisnici.gui.PzCheckBoxTreeCellRenderer;
import rs.pezar.korisnici.gui.PzInterfaceKorisnik;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;

public class PzPanelDozvoleKorisnika
extends PzPanel
implements PzInterfaceKorisnik,
ActionListener {
    private static final long serialVersionUID = -3590064304632661367L;
    private static final String ID = "DEFINICIJE_KORISNIKA";
    private PzPanelHeader pzPanelHeader1;
    private PzPanel pnlMain;
    private DefaultSingleCDockable dockable;
    private CheckboxTree stablo;
    private JScrollPane scp;
    private PzButton btnCollapse;
    private PzPanel pnlPosebneDozvole;
    private PzButton posebneDeselektuj;
    private PzButton posebneSelektuj;
    private PzButtonPanel btnPnlPosebneDozvole;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane1;
    private PzPanel pnlBrisanje;
    private PzPanel pnlArhiviranje;
    private PzPanel pnlSnimanje;
    private PzCheckBoxList listSnimanje;
    private PzPanel pnlDozvoleZaDokumente;
    private PzPanel pnlDozvoleZaPristup;
    private JTabbedPane tabbedPane;
    private PzButton btnUncheck;
    private PzButtonPanel pnlButton;
    private PzButton btnExpand;
    private TreePath[] tp;
    private String tip = "TREE";
    private PzCheckBoxList listArhiviranje;
    private PzCheckBoxList listBrisanje;
    private PzButtonPanel btnPnlSnimanje;
    private PzButton snimanjeSelektuj;
    private PzButton snimanjeDeselektuj;
    private PzButtonPanel btnPnlArhiviranje;
    private PzButton arhiviranjeSelektuj;
    private PzButton arhiviranjeDeselektuj;
    private PzButtonPanel btnPnlBrisanje;
    private PzButton brisanjeSelektuj;
    private PzButton brisanjeDeselektuj;
    private PzCheckBoxList listPosebne;
    private HashMap<String, String> posebneDozvole;
    private HashMap<String, String> dozvoleRjMap = new LinkedHashMap<String, String>();
    private PzPanel pnlDozvoleRJ;
    private JScrollPane jScrollPane5;
    private PzButtonPanel btnPnlDozvoleRJ;
    private PzButton rjSelektuj;
    private PzButton rjDeselektuj;
    private PzCheckBoxList listRJ;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add((Component)((Object)new PzPanelDozvoleKorisnika()));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public PzPanelDozvoleKorisnika() {
        this.getRJ();
        this.posebneDozvole = new HashMap();
        this.posebneDozvole.put("FAKTURA_PROMENA_CENE", "Promena cene pri izradi fakture");
        this.posebneDozvole.put("FAKTURA_PROMENA_RABATA", "Promena rabata pri izradi fakture");
        this.posebneDozvole.put("ALARM_RACUNI_DOBAVLJACA", "Upozorenje o nepla\u0107enim fakturama dobavlja\u010da");
        this.posebneDozvole.put("PREUZIMANJE_PORUDZBINE", "Preuzimanje porud\u017ebine");
        this.initGUI();
    }

    private void initGUI() {
        try {
            AnchorLayout thisLayout = new AnchorLayout();
            this.setLayout((LayoutManager)thisLayout);
            this.setPreferredSize(new Dimension(622, 536));
            this.pnlMain = new PzPanel();
            BorderLayout pnlMainLayout = new BorderLayout();
            this.pnlMain.setLayout((LayoutManager)pnlMainLayout);
            this.add((Component)this.pnlMain, new AnchorConstraint(81, 0, 1000, 0, 2, 2, 1, 2));
            this.pnlMain.setPreferredSize(new Dimension(622, 455));
            this.pnlMain.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.tabbedPane = new JTabbedPane();
            this.pnlMain.add((Component)this.tabbedPane, (Object)"Center");
            this.pnlDozvoleZaPristup = new PzPanel();
            BorderLayout pnlDozvoleZaPristupLayout = new BorderLayout();
            this.pnlDozvoleZaPristup.setLayout((LayoutManager)pnlDozvoleZaPristupLayout);
            this.tabbedPane.addTab("Dozvole za pristup", null, (Component)this.pnlDozvoleZaPristup, null);
            this.scp = new JScrollPane();
            this.pnlDozvoleZaPristup.add((Component)this.scp, (Object)"Center");
            this.scp.setPreferredSize(new Dimension(607, 370));
            MainViewWidget w = (MainViewWidget)PzApplication.getApplication().getWorkbench().getWorkArea().getWidgetById(MainViewWidget.ID);
            this.stablo = new CheckboxTree(w.getStablo().getModel());
            BorderLayout stabloLayout = new BorderLayout();
            this.stablo.setLayout((LayoutManager)stabloLayout);
            PzCheckBoxTreeCellRenderer renderer = new PzCheckBoxTreeCellRenderer();
            this.stablo.setCellRenderer((TreeCellRenderer)((Object)renderer));
            this.stablo.setRowHeight(20);
            this.scp.setViewportView((Component)this.stablo);
            this.pnlButton = new PzButtonPanel();
            GridBagLayout pnlButtonLayout = new GridBagLayout();
            this.pnlDozvoleZaPristup.add((Component)this.pnlButton, (Object)"South");
            this.pnlButton.setPreferredSize(new Dimension(617, 35));
            pnlButtonLayout.rowWeights = new double[]{0.1};
            pnlButtonLayout.rowHeights = new int[]{7};
            pnlButtonLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
            pnlButtonLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlButton.setLayout((LayoutManager)pnlButtonLayout);
            this.btnExpand = new PzButton();
            this.pnlButton.add((Component)this.btnExpand, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.btnExpand.setName("btnExpand");
            this.btnExpand.addActionListener((ActionListener)this);
            this.btnExpand.setActionCommand("expand");
            this.btnExpand.setText("Razvij stablo");
            this.btnExpand.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/branch.png")));
            this.btnUncheck = new PzButton();
            this.pnlButton.add((Component)this.btnUncheck, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnUncheck.setName("btnUncheck");
            this.btnUncheck.addActionListener((ActionListener)this);
            this.btnUncheck.setActionCommand("uncheck");
            this.btnUncheck.setText("Deselektuj sve");
            this.btnUncheck.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_delete.png")));
            this.btnCollapse = new PzButton();
            this.pnlButton.add((Component)this.btnCollapse, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnCollapse.setName("btnCollapse");
            this.btnCollapse.addActionListener((ActionListener)this);
            this.btnCollapse.setActionCommand("collapse");
            this.btnCollapse.setText("Skupi stablo");
            this.btnCollapse.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/branch_delete.png")));
            this.pnlDozvoleZaDokumente = new PzPanel();
            GridBagLayout pnlDozvoleZaDokumenteLayout = new GridBagLayout();
            pnlDozvoleZaDokumenteLayout.rowWeights = new double[]{0.1};
            pnlDozvoleZaDokumenteLayout.rowHeights = new int[]{7};
            pnlDozvoleZaDokumenteLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
            pnlDozvoleZaDokumenteLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlDozvoleZaDokumente.setLayout((LayoutManager)pnlDozvoleZaDokumenteLayout);
            this.tabbedPane.addTab("Dozvole za rad sa dokumentima", null, (Component)this.pnlDozvoleZaDokumente, null);
            this.pnlSnimanje = new PzPanel();
            BorderLayout pnlSnimanjeLayout = new BorderLayout();
            this.pnlSnimanje.setLayout((LayoutManager)pnlSnimanjeLayout);
            this.pnlDozvoleZaDokumente.add((Component)this.pnlSnimanje, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlSnimanje.setBorder((Border)BorderFactory.createTitledBorder("Dozvole za izradu dokumenta"));
            this.jScrollPane1 = new JScrollPane();
            this.pnlSnimanje.add((Component)this.jScrollPane1, (Object)"Center");
            this.listSnimanje = new PzCheckBoxList();
            this.listSnimanje.setListData(this.setDocumentList());
            this.jScrollPane1.setViewportView(this.listSnimanje);
            this.btnPnlSnimanje = new PzButtonPanel();
            GridBagLayout btnPnlSnimanjeLayout = new GridBagLayout();
            this.pnlSnimanje.add((Component)this.btnPnlSnimanje, (Object)"South");
            btnPnlSnimanjeLayout.rowWeights = new double[]{0.1};
            btnPnlSnimanjeLayout.rowHeights = new int[]{7};
            btnPnlSnimanjeLayout.columnWeights = new double[]{0.1, 0.1};
            btnPnlSnimanjeLayout.columnWidths = new int[]{7, 7};
            this.btnPnlSnimanje.setLayout((LayoutManager)btnPnlSnimanjeLayout);
            this.snimanjeSelektuj = new PzButton();
            this.btnPnlSnimanje.add((Component)this.snimanjeSelektuj, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.snimanjeSelektuj.setName("snimanjeSelektuj");
            this.snimanjeSelektuj.addActionListener((ActionListener)this);
            this.snimanjeSelektuj.setActionCommand("snimanjeSelektuj");
            this.snimanjeSelektuj.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_check.png")));
            this.snimanjeDeselektuj = new PzButton();
            this.btnPnlSnimanje.add((Component)this.snimanjeDeselektuj, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.snimanjeDeselektuj.setName("snimanjeDeselektuj");
            this.snimanjeDeselektuj.addActionListener((ActionListener)this);
            this.snimanjeDeselektuj.setActionCommand("snimanjeDeselektuj");
            this.snimanjeDeselektuj.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_delete.png")));
            this.pnlArhiviranje = new PzPanel();
            BorderLayout pnlArhiviranjeLayout = new BorderLayout();
            this.pnlArhiviranje.setLayout((LayoutManager)pnlArhiviranjeLayout);
            this.pnlDozvoleZaDokumente.add((Component)this.pnlArhiviranje, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlArhiviranje.setBorder((Border)BorderFactory.createTitledBorder("Dozvole za arhiviranje dokumenta"));
            this.jScrollPane2 = new JScrollPane();
            this.pnlArhiviranje.add((Component)this.jScrollPane2, (Object)"Center");
            this.listArhiviranje = new PzCheckBoxList();
            this.listArhiviranje.setListData(this.setDocumentList());
            this.jScrollPane2.setViewportView(this.listArhiviranje);
            this.btnPnlArhiviranje = new PzButtonPanel();
            GridBagLayout btnPnlArhiviranjeLayout = new GridBagLayout();
            this.pnlArhiviranje.add((Component)this.btnPnlArhiviranje, (Object)"South");
            btnPnlArhiviranjeLayout.rowWeights = new double[]{0.1};
            btnPnlArhiviranjeLayout.rowHeights = new int[]{7};
            btnPnlArhiviranjeLayout.columnWeights = new double[]{0.1, 0.1};
            btnPnlArhiviranjeLayout.columnWidths = new int[]{7, 7};
            this.btnPnlArhiviranje.setLayout((LayoutManager)btnPnlArhiviranjeLayout);
            this.arhiviranjeSelektuj = new PzButton();
            this.btnPnlArhiviranje.add((Component)this.arhiviranjeSelektuj, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.arhiviranjeSelektuj.setName("arhiviranjeSelektuj");
            this.arhiviranjeSelektuj.addActionListener((ActionListener)this);
            this.arhiviranjeSelektuj.setActionCommand("arhiviranjeSelektuj");
            this.arhiviranjeSelektuj.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_check.png")));
            this.arhiviranjeDeselektuj = new PzButton();
            this.btnPnlArhiviranje.add((Component)this.arhiviranjeDeselektuj, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.arhiviranjeDeselektuj.setName("arhiviranjeDeselektuj");
            this.arhiviranjeDeselektuj.addActionListener((ActionListener)this);
            this.arhiviranjeDeselektuj.setActionCommand("arhiviranjeDeselektuj");
            this.arhiviranjeDeselektuj.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_delete.png")));
            this.pnlBrisanje = new PzPanel();
            BorderLayout pnlBrisanjeLayout = new BorderLayout();
            this.pnlBrisanje.setLayout((LayoutManager)pnlBrisanjeLayout);
            this.pnlDozvoleZaDokumente.add((Component)this.pnlBrisanje, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlBrisanje.setBorder((Border)BorderFactory.createTitledBorder("Dozvole za brisanje dokumenta u pripremi"));
            this.jScrollPane3 = new JScrollPane();
            this.pnlBrisanje.add((Component)this.jScrollPane3, (Object)"Center");
            this.listBrisanje = new PzCheckBoxList();
            this.listBrisanje.setListData(this.setDocumentList());
            this.jScrollPane3.setViewportView(this.listBrisanje);
            this.btnPnlBrisanje = new PzButtonPanel();
            GridBagLayout btnPnlBrisanjeLayout = new GridBagLayout();
            this.pnlBrisanje.add((Component)this.btnPnlBrisanje, (Object)"South");
            btnPnlBrisanjeLayout.rowWeights = new double[]{0.1};
            btnPnlBrisanjeLayout.rowHeights = new int[]{7};
            btnPnlBrisanjeLayout.columnWeights = new double[]{0.1, 0.1};
            btnPnlBrisanjeLayout.columnWidths = new int[]{7, 7};
            this.btnPnlBrisanje.setLayout((LayoutManager)btnPnlBrisanjeLayout);
            this.brisanjeSelektuj = new PzButton();
            this.btnPnlBrisanje.add((Component)this.brisanjeSelektuj, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.brisanjeSelektuj.setName("brisanjeSelektuj");
            this.brisanjeSelektuj.addActionListener((ActionListener)this);
            this.brisanjeSelektuj.setActionCommand("brisanjeSelektuj");
            this.brisanjeSelektuj.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_check.png")));
            this.brisanjeDeselektuj = new PzButton();
            this.btnPnlBrisanje.add((Component)this.brisanjeDeselektuj, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.brisanjeDeselektuj.setName("brisanjeDeselektuj");
            this.brisanjeDeselektuj.addActionListener((ActionListener)this);
            this.brisanjeDeselektuj.setActionCommand("brisanjeDeselektuj");
            this.brisanjeDeselektuj.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_delete.png")));
            this.pnlDozvoleRJ = new PzPanel();
            this.tabbedPane.addTab("Dozvole za rad sa radnim jedinicama", null, (Component)this.pnlDozvoleRJ, null);
            BorderLayout pnlDozvoleRJLayout = new BorderLayout();
            this.pnlDozvoleRJ.setLayout((LayoutManager)pnlDozvoleRJLayout);
            this.pnlDozvoleRJ.setName("pnlDozvoleRJ");
            this.jScrollPane5 = new JScrollPane();
            this.pnlDozvoleRJ.add((Component)this.jScrollPane5, (Object)"Center");
            this.listRJ = new PzCheckBoxList();
            this.listRJ.setListData(this.setDozvoleRJList());
            this.jScrollPane5.setViewportView(this.listRJ);
            this.btnPnlDozvoleRJ = new PzButtonPanel();
            GridBagLayout btnPnlDozvoleRJLayout = new GridBagLayout();
            this.pnlDozvoleRJ.add((Component)this.btnPnlDozvoleRJ, (Object)"South");
            btnPnlDozvoleRJLayout.rowWeights = new double[]{0.1};
            btnPnlDozvoleRJLayout.rowHeights = new int[]{7};
            btnPnlDozvoleRJLayout.columnWeights = new double[]{0.1, 0.1};
            btnPnlDozvoleRJLayout.columnWidths = new int[]{7, 7};
            this.btnPnlDozvoleRJ.setLayout((LayoutManager)btnPnlDozvoleRJLayout);
            this.rjSelektuj = new PzButton();
            this.btnPnlDozvoleRJ.add((Component)this.rjSelektuj, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.rjSelektuj.setName("rjSelektuj");
            this.rjSelektuj.addActionListener((ActionListener)this);
            this.rjSelektuj.setActionCommand("rjSelektuj");
            this.rjSelektuj.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_check.png")));
            this.rjSelektuj.setText("Selektuj sve");
            this.rjDeselektuj = new PzButton();
            this.btnPnlDozvoleRJ.add((Component)this.rjDeselektuj, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.rjDeselektuj.setName("rjDeselektuj");
            this.rjDeselektuj.addActionListener((ActionListener)this);
            this.rjDeselektuj.setActionCommand("rjDeselektuj");
            this.rjDeselektuj.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_delete.png")));
            this.rjDeselektuj.setText("Deselektuj sve");
            this.pnlPosebneDozvole = new PzPanel();
            BorderLayout pnlPosebneDozvoleLayout = new BorderLayout();
            this.pnlPosebneDozvole.setLayout((LayoutManager)pnlPosebneDozvoleLayout);
            this.tabbedPane.addTab("Posebne dozvole", null, (Component)this.pnlPosebneDozvole, null);
            this.jScrollPane4 = new JScrollPane();
            this.pnlPosebneDozvole.add((Component)this.jScrollPane4, (Object)"Center");
            this.listPosebne = new PzCheckBoxList();
            this.listPosebne.setListData(this.getPosebneDozvoleList());
            this.jScrollPane4.setViewportView(this.listPosebne);
            this.btnPnlPosebneDozvole = new PzButtonPanel();
            GridBagLayout btnPnlPosebneDozvoleLayout = new GridBagLayout();
            this.pnlPosebneDozvole.add((Component)this.btnPnlPosebneDozvole, (Object)"South");
            btnPnlPosebneDozvoleLayout.rowWeights = new double[]{0.1};
            btnPnlPosebneDozvoleLayout.rowHeights = new int[]{7};
            btnPnlPosebneDozvoleLayout.columnWeights = new double[]{0.1, 0.1};
            btnPnlPosebneDozvoleLayout.columnWidths = new int[]{7, 7};
            this.btnPnlPosebneDozvole.setLayout((LayoutManager)btnPnlPosebneDozvoleLayout);
            this.posebneSelektuj = new PzButton();
            this.btnPnlPosebneDozvole.add((Component)this.posebneSelektuj, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.posebneSelektuj.setName("posebneSelektuj");
            this.posebneSelektuj.addActionListener((ActionListener)this);
            this.posebneSelektuj.setActionCommand("posebneSelektuj");
            this.posebneSelektuj.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_check.png")));
            this.posebneDeselektuj = new PzButton();
            this.btnPnlPosebneDozvole.add((Component)this.posebneDeselektuj, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.posebneDeselektuj.setName("posebneDeselektuj");
            this.posebneDeselektuj.addActionListener((ActionListener)this);
            this.posebneDeselektuj.setActionCommand("posebneDeselektuj");
            this.posebneDeselektuj.setIcon((Icon)new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/selection_delete.png")));
            this.pzPanelHeader1 = new PzPanelHeader();
            this.add((Component)this.pzPanelHeader1, new AnchorConstraint(0, 0, 140, 0, 2, 2, 0, 2));
            this.pzPanelHeader1.setPreferredSize(new Dimension(622, 75));
            this.pzPanelHeader1.setTitle("Dozvole korisnika");
            this.pzPanelHeader1.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/korisnici/resource/img/certificate.png")));
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)((Object)this));
        }
        catch (Exception e) {
            e.printStackTrace();
            e.getLocalizedMessage();
        }
    }

    @Override
    public void setUser(Pzuser user) {
        if (user.getDozvolas() == null || user.getDozvolas().size() == 0) {
            return;
        }
        this.setDozvolePristupa(user);
        Vector<Dozvola> dozvoleSnimanja = this.getDocumentDozvolas(user, "DOK_SNIMANJE");
        Vector<Dozvola> dozvoleArhiviranja = this.getDocumentDozvolas(user, "DOK_ARHIVIRANJE");
        Vector<Dozvola> dozvoleBrisanja = this.getDocumentDozvolas(user, "DOK_BRISANJE");
        Vector<Dozvola> dozvolePosebne = this.getDocumentDozvolas(user, "POSEBNA DOZVOLA");
        Vector<Dozvola> dozvoleRJ = this.getDocumentDozvolas(user, "RJ");
        this.setDozvoleDokumenata(dozvoleSnimanja, this.listSnimanje);
        this.setDozvoleDokumenata(dozvoleArhiviranja, this.listArhiviranje);
        this.setDozvoleDokumenata(dozvoleBrisanja, this.listBrisanje);
        this.setPosebneDozvole(dozvolePosebne);
        this.setDozvoleRJ(dozvoleRJ, this.listRJ);
    }

    @Override
    public void saveData(Pzuser user, Boolean update, EntityManager em) {
        Vector<Dozvola> dozvole = new Vector<Dozvola>();
        this.saveDozvolePristupa(user, dozvole);
        this.saveDozvoleDokumenata(user, this.listSnimanje, dozvole, "DOK_SNIMANJE");
        this.saveDozvoleDokumenata(user, this.listArhiviranje, dozvole, "DOK_ARHIVIRANJE");
        this.saveDozvoleDokumenata(user, this.listBrisanje, dozvole, "DOK_BRISANJE");
        this.savePosebneDozvole(user, this.listPosebne, dozvole, "POSEBNA DOZVOLA");
        this.saveDozvoleRJ(user, dozvole, "RJ");
        PzUserUtil.removeDozvolaUnlisted(user, dozvole);
    }

    private void saveDozvolePristupa(Pzuser user, Vector<Dozvola> dozvole) {
        TreePath[] treePathArray = this.tp = this.stablo.getCheckingPaths();
        int n = this.tp.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            if (path.getLastPathComponent() instanceof TreeElement && !((TreeElement)path.getLastPathComponent()).hasChildren() && ((TreeElement)path.getLastPathComponent()).getActionClass() != null && !((TreeElement)path.getLastPathComponent()).getActionClass().equals("")) {
                String klasa = String.valueOf(((TreeElement)path.getLastPathComponent()).getActionClass()) + "[" + ((TreeElement)path.getLastPathComponent()).getParameter() + "]";
                Dozvola newDozvola = new Dozvola();
                DozvolaPK newDozvolaPK = new DozvolaPK();
                newDozvolaPK.setTip("TREE");
                newDozvolaPK.setOpcija(klasa);
                newDozvolaPK.setPzusername(user.getPzusername());
                newDozvola.setId(newDozvolaPK);
                newDozvola.setPzuser(user);
                PzUserUtil.addDozvola(user, newDozvola);
                dozvole.add(newDozvola);
            }
            ++n2;
        }
    }

    private void setDozvolePristupa(Pzuser user) {
        this.stablo.expandAll();
        ArrayList<TreePath> tp = new ArrayList<TreePath>();
        Vector<TreePath> treePaths = new Vector<TreePath>();
        int i = 0;
        while (i < this.stablo.getRowCount()) {
            if (!(this.stablo.getPathForRow(i).getLastPathComponent() instanceof Vector)) {
                treePaths.add(this.stablo.getPathForRow(i));
            }
            ++i;
        }
        Vector<String> dozvole = new Vector<String>();
        int i2 = 0;
        while (i2 < user.getDozvolas().size()) {
            dozvole.add(((Dozvola)user.getDozvolas().get(i2)).getId().getOpcija());
            ++i2;
        }
        i2 = 0;
        while (i2 < treePaths.size()) {
            int j = 0;
            while (j < dozvole.size()) {
                String klasa = String.valueOf(((TreeElement)((TreePath)treePaths.get(i2)).getLastPathComponent()).getActionClass()) + "[" + ((TreeElement)((TreePath)treePaths.get(i2)).getLastPathComponent()).getParameter() + "]";
                if (((String)dozvole.get(j)).equals(klasa)) {
                    tp.add((TreePath)treePaths.get(i2));
                }
                ++j;
            }
            ++i2;
        }
        this.stablo.setCheckingPaths(tp.toArray(new TreePath[tp.size()]));
    }

    private Vector<JCheckBox> setDocumentList() {
        Vector<JCheckBox> cbList = new Vector<JCheckBox>();
        List tipovi = TipDokumentStructure.loadStructure();
        for (TipDokumentStructure.Tip tip : tipovi) {
            JCheckBox cb = new JCheckBox();
            cb.setText(tip.getNaziv());
            cbList.add(cb);
        }
        return cbList;
    }

    private void saveDozvoleDokumenata(Pzuser user, PzCheckBoxList list, Vector<Dozvola> dozvolas, String tip) {
        int i = 0;
        while (i < list.getModel().getSize()) {
            if (((JCheckBox)list.getModel().getElementAt(i)).isSelected()) {
                Dozvola newDozvola = new Dozvola();
                DozvolaPK newDozvolaPK = new DozvolaPK();
                newDozvolaPK.setTip(tip);
                newDozvolaPK.setOpcija(this.getTip(((JCheckBox)list.getModel().getElementAt(i)).getText()).getTip());
                newDozvolaPK.setPzusername(user.getPzusername());
                newDozvola.setId(newDozvolaPK);
                newDozvola.setPzuser(user);
                PzUserUtil.addDozvola(user, newDozvola);
                dozvolas.add(newDozvola);
            }
            ++i;
        }
    }

    private TipDokumentStructure.Tip getTip(String naziv) {
        List tipovi = TipDokumentStructure.loadStructure();
        TipDokumentStructure.Tip tipReturn = null;
        for (TipDokumentStructure.Tip tipPom : tipovi) {
            if (!tipPom.getNaziv().equals(naziv)) continue;
            tipReturn = tipPom;
            break;
        }
        return tipReturn;
    }

    private Vector<Dozvola> getDocumentDozvolas(Pzuser user, String tip) {
        Vector<Dozvola> dozvole = new Vector<Dozvola>();
        int i = 0;
        while (i < user.getDozvolas().size()) {
            if (((Dozvola)user.getDozvolas().get(i)).getId().getTip().equals(tip)) {
                dozvole.add((Dozvola)user.getDozvolas().get(i));
            }
            ++i;
        }
        return dozvole;
    }

    private void setDozvoleDokumenata(Vector<Dozvola> dozvole, PzCheckBoxList list) {
        int j = 0;
        while (j < dozvole.size()) {
            TipDokumentStructure.Tip tip = this.getNazivDokumenta(dozvole.get(j).getId().getOpcija());
            int i = 0;
            while (i < list.getModel().getSize()) {
                if (((JCheckBox)list.getModel().getElementAt(i)).getText().equals(tip.getNaziv())) {
                    ((JCheckBox)list.getModel().getElementAt(i)).setSelected(true);
                }
                ++i;
            }
            ++j;
        }
    }

    private TipDokumentStructure.Tip getNazivDokumenta(String tip) {
        List tipovi = TipDokumentStructure.loadStructure();
        TipDokumentStructure.Tip tipReturn = null;
        for (TipDokumentStructure.Tip tipPom : tipovi) {
            if (!tipPom.getTip().equals(tip)) continue;
            tipReturn = tipPom;
            break;
        }
        return tipReturn;
    }

    private void getRJ() {
        EntityManager emRJ = PzEntityManager.getEm();
        String query = "SELECT rj FROM Radnajedinica rj ORDER BY rj.id.oznRj";
        Query q = emRJ.createQuery(query);
        Vector rj = (Vector)q.getResultList();
        for (Radnajedinica temp : rj) {
            this.dozvoleRjMap.put(temp.getId().getOznRj(), temp.getNaziv());
        }
        emRJ.close();
    }

    private Vector<JCheckBox> setDozvoleRJList() {
        Vector<JCheckBox> cbList = new Vector<JCheckBox>();
        for (Map.Entry<String, String> temp : this.dozvoleRjMap.entrySet()) {
            JCheckBox cb = new JCheckBox();
            cb.setText(String.valueOf(temp.getKey()) + " " + temp.getValue());
            cbList.add(cb);
        }
        return cbList;
    }

    private void saveDozvoleRJ(Pzuser user, Vector<Dozvola> dozvolas, String tip) {
        int i = 0;
        while (i < this.listRJ.getModel().getSize()) {
            if (((JCheckBox)this.listRJ.getModel().getElementAt(i)).isSelected()) {
                for (Map.Entry<String, String> temp : this.dozvoleRjMap.entrySet()) {
                    if (!((JCheckBox)this.listRJ.getModel().getElementAt(i)).getText().equals(String.valueOf(temp.getKey()) + " " + temp.getValue())) continue;
                    Dozvola newDozvola = new Dozvola();
                    DozvolaPK newDozvolaPK = new DozvolaPK();
                    newDozvolaPK.setTip(tip);
                    newDozvolaPK.setOpcija(temp.getKey());
                    newDozvolaPK.setPzusername(user.getPzusername());
                    newDozvola.setId(newDozvolaPK);
                    newDozvola.setPzuser(user);
                    PzUserUtil.addDozvola(user, newDozvola);
                    dozvolas.add(newDozvola);
                }
            }
            ++i;
        }
    }

    private Map.Entry<String, String> getEntry(String key) {
        for (Map.Entry<String, String> entry : this.dozvoleRjMap.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    private void setDozvoleRJ(Vector<Dozvola> dozvoleRJ, PzCheckBoxList list) {
        int j = 0;
        while (j < dozvoleRJ.size()) {
            String dozvola = dozvoleRJ.get(j).getId().getOpcija();
            Map.Entry<String, String> entry = this.getEntry(dozvola);
            int i = 0;
            while (i < list.getModel().getSize()) {
                if (((JCheckBox)list.getModel().getElementAt(i)).getText().equals(String.valueOf(entry.getKey()) + " " + entry.getValue())) {
                    ((JCheckBox)list.getModel().getElementAt(i)).setSelected(true);
                }
                ++i;
            }
            ++j;
        }
    }

    private void savePosebneDozvole(Pzuser user, PzCheckBoxList list, Vector<Dozvola> dozvolas, String tip) {
        int i = 0;
        while (i < list.getModel().getSize()) {
            if (((JCheckBox)list.getModel().getElementAt(i)).isSelected()) {
                Dozvola newDozvola = new Dozvola();
                DozvolaPK newDozvolaPK = new DozvolaPK();
                newDozvolaPK.setTip(tip);
                newDozvolaPK.setOpcija(this.getPosebnaDozvola(((JCheckBox)list.getModel().getElementAt(i)).getText()));
                newDozvolaPK.setPzusername(user.getPzusername());
                newDozvola.setId(newDozvolaPK);
                newDozvola.setPzuser(user);
                PzUserUtil.addDozvola(user, newDozvola);
                dozvolas.add(newDozvola);
            }
            ++i;
        }
    }

    private String getPosebnaDozvola(String naziv) {
        for (Map.Entry<String, String> entry : this.posebneDozvole.entrySet()) {
            if (!naziv.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void setPosebneDozvole(Vector<Dozvola> dozvolePosebne) {
        int j = 0;
        while (j < dozvolePosebne.size()) {
            String dozvola = dozvolePosebne.get(j).getId().getOpcija();
            String tempValue = "";
            for (Map.Entry<String, String> entry : this.posebneDozvole.entrySet()) {
                if (!dozvola.equals(entry.getKey())) continue;
                tempValue = entry.getValue();
                int i = 0;
                while (i < this.listPosebne.getModel().getSize()) {
                    if (((JCheckBox)this.listPosebne.getModel().getElementAt(i)).getText().equals(tempValue)) {
                        ((JCheckBox)this.listPosebne.getModel().getElementAt(i)).setSelected(true);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    private Vector<JCheckBox> getPosebneDozvoleList() {
        Vector<JCheckBox> cbList = new Vector<JCheckBox>();
        ArrayList<String> nazivi = new ArrayList<String>();
        nazivi.addAll(this.posebneDozvole.values());
        for (String dozvola : nazivi) {
            JCheckBox cb = new JCheckBox();
            cb.setText(dozvola);
            cbList.add(cb);
        }
        return cbList;
    }

    public DefaultSingleCDockable getDockable() {
        if (this.dockable == null) {
            this.dockable = new DefaultSingleCDockable(this.getID(), this.getTitle(), (Component)((Object)this), new CAction[0]);
            this.dockable.setCloseable(this.isCloseable());
            this.dockable.addFocusListener(new CFocusListener(){

                public void focusLost(CDockable arg0) {
                }

                public void focusGained(CDockable arg0) {
                }
            });
        }
        return this.dockable;
    }

    public boolean isCloseable() {
        return false;
    }

    public String getID() {
        return ID;
    }

    public String getTitle() {
        return "Dozvole korisnika";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equalsIgnoreCase("expand")) {
            this.stablo.expandAll();
        } else if (actionCommand.equalsIgnoreCase("uncheck")) {
            this.stablo.clearChecking();
        } else if (actionCommand.equalsIgnoreCase("collapse")) {
            int row = this.stablo.getRowCount() - 1;
            while (row >= 0) {
                this.stablo.collapseRow(row);
                --row;
            }
        } else if (actionCommand.equalsIgnoreCase("snimanjeSelektuj")) {
            this.listSnimanje.setSelectedAll();
        } else if (actionCommand.equalsIgnoreCase("snimanjeDeselektuj")) {
            this.listSnimanje.setDeselectAll();
        } else if (actionCommand.equalsIgnoreCase("arhiviranjeSelektuj")) {
            this.listArhiviranje.setSelectedAll();
        } else if (actionCommand.equalsIgnoreCase("arhiviranjeDeselektuj")) {
            this.listArhiviranje.setDeselectAll();
        } else if (actionCommand.equalsIgnoreCase("brisanjeSelektuj")) {
            this.listBrisanje.setSelectedAll();
        } else if (actionCommand.equalsIgnoreCase("brisanjeDeselektuj")) {
            this.listBrisanje.setDeselectAll();
        } else if (actionCommand.equalsIgnoreCase("posebneSelektuj")) {
            this.listPosebne.setSelectedAll();
        } else if (actionCommand.equalsIgnoreCase("posebneDeselektuj")) {
            this.listPosebne.setDeselectAll();
        } else if (actionCommand.equalsIgnoreCase("rjSelektuj")) {
            this.listRJ.setSelectedAll();
        } else if (actionCommand.equalsIgnoreCase("rjDeselektuj")) {
            this.listRJ.setDeselectAll();
        }
    }
}

