/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.kasa.gui.Arhiviranje;
import rs.pezar.kasa.gui.Kolicina;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogStorno
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzTextAreaPanel razlog;
    private JLabel jLabel6;
    private PzPanel panelRazlog;
    private PzToolBarIcon icnArhiva;
    private PzPanel pnlGlavni;
    private JToolBar toolbar;
    private PzButton icnInverznaSelekcija;
    private PzButton icnDeselektujSve;
    private PzButton icnSelektujSve;
    private PzButton icnSelektuj;
    private JPanel pnlSelect;
    private PzButton btnOK;
    private PzDateField datIzrade;
    private JLabel jLabel1;
    private PzToolBarIcon icnIzmena;
    private PzTable table;
    private JScrollPane scpArtikli;
    private HashMap<String, Double> mapaKolicina = null;
    private Fiskalniracun racun;

    public PzDialogStorno(PzDialog parent) {
        super(parent);
        try {
            this.racun = (Fiskalniracun)this.getSession().getParameter("stornoRacun");
            if (this.racun.getProizvodfiskalniracuns() != null && this.racun.getProizvodfiskalniracuns().size() > 0) {
                for (Proizvodfiskalniracun p : this.racun.getProizvodfiskalniracuns()) {
                    p.setProcRabata(0.0);
                }
            }
            this.mapaKolicina = this.setMapaKolicina(this.racun);
            this.initGUI();
            this.setTitle("Storno maloprodajnog racuna");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
        this.paintPanel();
    }

    private HashMap<String, Double> setMapaKolicina(Fiskalniracun f) {
        HashMap<String, Double> rez = new HashMap<String, Double>();
        for (Proizvodfiskalniracun a : f.getProizvodfiskalniracuns()) {
            rez.put(String.valueOf(a.getId().getSfrProizvod()) + "/" + a.getId().getrBroj(), a.getKolicina());
        }
        return rez;
    }

    public double getKolicinaFor(Proizvodfiskalniracun af) {
        return this.mapaKolicina.get(String.valueOf(af.getId().getSfrProizvod()) + "/" + af.getId().getrBroj());
    }

    public List<Proizvodfiskalniracun> prebaciUListu(List<PzEntity> lista) {
        Vector<Proizvodfiskalniracun> rez = null;
        if (lista != null) {
            rez = new Vector<Proizvodfiskalniracun>();
            for (PzEntity entitet : lista) {
                rez.add((Proizvodfiskalniracun)entitet);
            }
        }
        return rez;
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setPreferredSize(new Dimension(943, 367));
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            pnlGlavniLayout.rowHeights = new int[]{115, 142, 159, 7};
            this.pnlGlavni.setOpaque(false);
            this.scpArtikli = new JScrollPane();
            this.pnlGlavni.add((Component)this.scpArtikli, (Object)new GridBagConstraints(0, 1, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            this.table = new PzTable(this.racun.getProizvodfiskalniracuns(), Proizvodfiskalniracun.class);
            this.table.setCheckboxColumn(0, KeyStroke.getKeyStroke(113, 0), KeyStroke.getKeyStroke(113, 512), KeyStroke.getKeyStroke(113, 128), KeyStroke.getKeyStroke(113, 640));
            this.table.unCheckAll();
            this.scpArtikli.setViewportView((Component)this.table);
            this.table.getTableHeader().setFocusable(false);
            this.table.requestFocusInWindow();
            this.table.setRowSelectionInterval(0, 0);
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setOpaque(false);
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("A\u017euriranje|koli\u010dine|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/product_edit_small.png")));
            this.icnIzmena.setActionCommand("Kolicina");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnArhiva = new PzToolBarIcon();
            this.icnArhiva.setText("Arhiva|i \u0161tampa|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/printer_preferences.png")));
            this.icnArhiva.setActionCommand("arhiva");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.pnlSelect = new JPanel();
            FlowLayout pnlSelectLayout = new FlowLayout();
            pnlSelectLayout.setAlignment(0);
            pnlSelectLayout.setVgap(2);
            this.pnlSelect.setLayout(pnlSelectLayout);
            this.toolbar.add(this.pnlSelect);
            this.pnlSelect.setPreferredSize(new Dimension(221, 113));
            this.pnlSelect.setOpaque(false);
            this.icnSelektuj = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektuj);
            this.icnSelektuj.setText("Selektuj trenutni (f2)");
            this.icnSelektuj.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/selektuj.png")));
            this.icnSelektuj.setPreferredSize(new Dimension(207, 24));
            this.icnSelektuj.setHorizontalAlignment(10);
            this.icnSelektuj.setFocusable(false);
            this.icnSelektuj.setOpaque(false);
            this.icnSelektuj.addActionListener((ActionListener)((Object)this));
            this.icnSelektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektujSve);
            this.icnSelektujSve.setText("Selektuj sve (alt+f2)");
            this.icnSelektujSve.setOpaque(false);
            this.icnSelektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/selection_sve.png")));
            this.icnSelektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnSelektujSve.setHorizontalAlignment(10);
            this.icnSelektujSve.setFocusable(false);
            this.icnSelektujSve.addActionListener((ActionListener)((Object)this));
            this.icnDeselektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnDeselektujSve);
            this.icnDeselektujSve.setText("Deselektuj sve (ctrl+f2)");
            this.icnDeselektujSve.setOpaque(false);
            this.icnDeselektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnDeselektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/deselektuj_sve.png")));
            this.icnDeselektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnDeselektujSve.setHorizontalAlignment(10);
            this.icnDeselektujSve.setFocusable(false);
            this.icnDeselektujSve.addActionListener((ActionListener)((Object)this));
            this.icnInverznaSelekcija = new PzButton();
            this.pnlSelect.add((Component)this.icnInverznaSelekcija);
            this.icnInverznaSelekcija.setText("Inverzna selekcija (ctrl+alt+f2)");
            this.icnInverznaSelekcija.setOpaque(false);
            this.icnInverznaSelekcija.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnInverznaSelekcija.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/selektuj inverzno.png")));
            this.icnInverznaSelekcija.setPreferredSize(new Dimension(208, 24));
            this.icnInverznaSelekcija.setHorizontalAlignment(10);
            this.icnInverznaSelekcija.setFocusable(false);
            this.icnInverznaSelekcija.addActionListener((ActionListener)((Object)this));
            this.panelRazlog = new PzPanel();
            this.pnlGlavni.add((Component)this.panelRazlog, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout panelRazlogLayout = new GridBagLayout();
            panelRazlogLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1, 0.1};
            panelRazlogLayout.rowHeights = new int[]{25, 25, 20, 30, 35};
            panelRazlogLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelRazlogLayout.columnWidths = new int[]{80, 85, 110, 20};
            this.panelRazlog.setLayout((LayoutManager)panelRazlogLayout);
            this.panelRazlog.setPreferredSize(new Dimension(1295, 163));
            this.panelRazlog.setOpaque(false);
            this.jLabel6 = new JLabel();
            this.panelRazlog.add((Component)this.jLabel6, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.jLabel6.setText("Razlog storniranja:");
            this.razlog = new PzTextAreaPanel();
            this.panelRazlog.add((Component)this.razlog, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 8, 10), 0, 0));
            this.razlog.setPreferredSize(new Dimension(762, 96));
            this.razlog.setTransferFocusOnEnter(true);
            this.jLabel1 = new JLabel();
            this.panelRazlog.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 5), 0, 0));
            this.jLabel1.setText("Datum izrade:");
            this.jLabel1.setHorizontalAlignment(2);
            this.datIzrade = new PzDateField();
            this.panelRazlog.add((Component)this.datIzrade, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.datIzrade.setFont(new Font("Tahoma", 0, 14));
            this.btnOK = new PzButton();
            this.panelRazlog.add((Component)this.btnOK, (Object)new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 4, 0), 0, 0));
            this.btnOK.setText("Dalje");
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/check.png")));
            this.btnOK.setPreferredSize(new Dimension(100, 30));
            this.btnOK.setActionCommand("dalje");
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.btnOK.setShortcut("ctrl+w");
            this.setLocationRelativeTo(null);
            this.pack();
            this.setSize(1100, 645);
            this.setMinimumSize(new Dimension(1100, 645));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.icnSelektujSve) {
            this.table.checkAll();
        } else if (arg0.getSource() == this.icnDeselektujSve) {
            this.table.unCheckAll();
        } else if (arg0.getSource() == this.icnInverznaSelekcija) {
            this.table.inverseCheck();
        } else if (arg0.getSource() == this.icnSelektuj) {
            this.table.switchIt();
        } else {
            String actionCommand = ((AbstractButton)arg0.getSource()).getActionCommand();
            if (actionCommand.equalsIgnoreCase("kolicina")) {
                this.getSession().putParameter("tabela", (Object)this.table);
                this.getSession().putParameter("artikal", (Object)this.table.getSelectedEntity());
                this.showDialog(Kolicina.class);
            } else if (actionCommand.equals("arhiva")) {
                this.btnOK.setEnabled(true);
                this.icnArhiva.setActionCommand("dalje");
                this.razlog.getArea().requestFocusInWindow();
            } else if (actionCommand.equals("dalje")) {
                if (this.table.getCheckedEntities().size() == 0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Mora biti selektovan barem jedan artikal!", "Informacija", 1);
                    return;
                }
                if (this.razlog.getVal().trim().length() == 0) {
                    JOptionPane.showMessageDialog(this.getParent(), "Morate uneti razlog storniranja!", "Informacija", 1);
                    this.razlog.requestFocusInWindow();
                    return;
                }
                this.arhiviraj();
            }
        }
    }

    private Timestamp getDatum(Date datum) {
        Calendar cal = Calendar.getInstance();
        int sat = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        cal.setTime(datum);
        cal.set(11, sat);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, 0);
        return new Timestamp(cal.getTimeInMillis());
    }

    /*
     * Unable to fully structure code
     */
    private void arhiviraj() {
        block10: {
            em = PzEntityManager.getEm();
            stornoRacun = (Fiskalniracun)PzEntityUtil.createStorno((PzDokument)this.racun);
            if (stornoRacun != null) break block10;
            while (true) {
                em.close();
                return;
            }
        }
        try {
            try {
                stornoRacun.setVreme(this.getDatum(this.datIzrade.getVal()));
                stornoRacun.setStorno(1);
                stornoRacun.setPoruka(this.razlog.getVal());
                stornoRacun.setProizvodfiskalniracuns(this.prebaciUListu(this.table.getCheckedEntities()));
                this.getSession().putParameter("racun", (Object)stornoRacun);
                this.getSession().putParameter("parameter", (Object)"storno");
                this.showDialog(Arhiviranje.class);
                if ((stornoRacun = (Fiskalniracun)this.getSession().getParameter("racun")) == null) ** continue;
                if (stornoRacun.getRadnajedinica().getpTip().equals("V") && !PzParameter.getBoolean((String)"KOLICINE_U_VRED_PROD", (boolean)false, (EntityManager)em).booleanValue()) {
                    PzDokumentManager.getInstance().arhivirajStorno((PzDokument)stornoRacun, PzEntityManager.KOLICINE_NEPROMENJENE, PzEntityManager.KOLICINA_UKUPNA, true, null);
                } else {
                    PzDokumentManager.getInstance().arhivirajStorno((PzDokument)stornoRacun, PzEntityManager.KOLICINE_UVECANJE, PzEntityManager.KOLICINA_UKUPNA, true, null);
                }
                if (Boolean.TRUE.equals(this.getSession().getParameter("saNivelacijom")) && (nivelacija = PzEntityUtil.createNivelacija((PzDokument)stornoRacun, (boolean)false, (boolean)false, (EntityManager)em)) != null && nivelacija.getArtikalnivelacijas() != null && nivelacija.getArtikalnivelacijas().size() > 0) {
                    PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivelacija, true, null, em);
                }
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)stornoRacun);
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)this, (Throwable)e);
                PzSwingUtility.showErrorMessage((Component)this.scpArtikli, (String)"Gre\u0161ka prilikom storniranja fakture. Poku\u0161ajte ponovo.");
                em.close();
            }
        }
        catch (Throwable var4_5) {
            em.close();
            throw var4_5;
        }
        em.close();
        this.dispose();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogStorno(Boolean.FALSE);
    }

    public PzDialogStorno(Boolean initGUI) {
    }
}

