/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;

public class UzmiDokument
extends PzDialog {
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzTable tblTabela;
    private JScrollPane scrollPane;
    private PzToolBarIcon btnSlika;
    private final Komitent komitent;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private Faktura selektovanaFaktura;
    private final Fiskalniracun racun;

    public UzmiDokument(PzDialog dialog) {
        super(dialog);
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        this.racun = (Fiskalniracun)this.getSession().getParameter("racun");
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Izaberite profakturu");
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnSlika = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSlika);
            this.btnSlika.setText("Slika|dokumenta|(F2)");
            this.btnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/presentation_chart.png")));
            this.btnSlika.setActionCommand("slika");
            this.btnSlika.addActionListener((ActionListener)((Object)this));
            this.btnSlika.setShortcut("F2");
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(7, 7, 7, 7), 0, 0));
            this.tblTabela = new PzTable();
            this.scrollPane.setViewportView((Component)this.tblTabela);
            this.tblTabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Faktura dok = (Faktura)entity;
                    return new Object[]{dok.getOznDokumenta(), dok.getIznos(), dok.getIznos(), dok.getDatum(), dok.getDatValute()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Oznaka dokumenta", "Iznos dokumenta", "Dug po dokumentu", "Datum dokumenta", "Datum valute"};
                }
            });
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            System.out.println("Komitent je: " + this.komitent);
            q = em.createQuery("SELECT f FROM Faktura f where f.tip='PROFAKTURA' and f.komitent.sfrKomitent=:sifra and f.arhiviran = 1  and f.radnajedinica.id.oznRj =:oznRj and f.radnajedinica.id.oznOgranak =:ogranak ORDER BY f.datum, f.rbrDok");
            q.setParameter("sifra", (Object)this.komitent.getSfrKomitent());
            q.setParameter("oznRj", (Object)this.racun.getRadnajedinica().getId().getOznRj());
            q.setParameter("ogranak", (Object)this.racun.getRadnajedinica().getId().getOznOgranak());
            Vector data = (Vector)q.getResultList();
            System.out.println("Nasao je kalkulacija: " + data.size());
            this.tblTabela.setData(data, Faktura.class);
            em.close();
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.requestFocusInWindow();
            if (this.tblTabela.getDataSize() > 0) {
                this.tblTabela.setRowSelectionInterval(0, 0);
            }
            this.tblTabela.setEnterAction(new AbstractAction(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText(" Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(800, 450);
            this.setMinimumSize(new Dimension(800, 450));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("slika")) {
            this.showReport();
        }
    }

    public void showReport() {
        try {
            if (this.tblTabela.getSelectedEntity() != null) {
                Faktura f = (Faktura)this.tblTabela.getSelectedEntity();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)f);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void updateStanje(Fiskalniracun racun, EntityManager em) {
        for (Proizvodfiskalniracun p : racun.getProizvodfiskalniracuns()) {
            Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(p.getSifra(), racun.getRadnajedinica()));
            if (s == null) {
                s = new Stanje();
                s.setId(new StanjePK(p.getSifra(), racun.getRadnajedinica()));
                s.setAlocKolicina(s.getAlocKolicina() + p.getKolicina());
                s.setArtikal(p.getArtikal());
                em.persist((Object)s);
                continue;
            }
            s.setAlocKolicina(s.getAlocKolicina() + p.getKolicina());
        }
    }

    static /* synthetic */ PzTable access$0(UzmiDokument uzmiDokument) {
        return uzmiDokument.tblTabela;
    }

    static /* synthetic */ void access$1(UzmiDokument uzmiDokument, Faktura faktura) {
        uzmiDokument.selektovanaFaktura = faktura;
    }

    static /* synthetic */ Fiskalniracun access$2(UzmiDokument uzmiDokument) {
        return uzmiDokument.racun;
    }

    static /* synthetic */ Faktura access$3(UzmiDokument uzmiDokument) {
        return uzmiDokument.selektovanaFaktura;
    }

    static /* synthetic */ void access$4(UzmiDokument uzmiDokument, Fiskalniracun fiskalniracun, EntityManager entityManager) {
        uzmiDokument.updateStanje(fiskalniracun, entityManager);
    }
}

