/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.analize.artikli;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogPregledNabavkeOdDobavljaca
extends PzDialog {
    public static final String DETALJAN_PREGLED = "Detaljan pregled";
    public static final String ZBIRNI_PREGLED = "Zbirni pregled";
    private PzPanel mainPanel;
    private PzPanel pnlPeriod;
    private JLabel lblPocetni;
    private JButton btnPotvrdi;
    private PzTextField tfNaziv;
    private PzFieldIndikator indSifra;
    private PzTextField tfSifra;
    private JLabel lblSifra;
    private PzPanel pnlValuta;
    private PzRadioGroup<String> panelRBs;
    private PzDateField dfKrajnji;
    private JLabel lblKrajnji;
    private PzDateField dfPocetni;
    private PzComboBox cbValuta;
    private Komitent entKomitent;
    private ScrollableCursor cursor = null;

    public PzDialogPregledNabavkeOdDobavljaca(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Pregled nabavke od dobavlja\u010da");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{20, 86, 10, 25, 15, 32, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{5, 207, 5, 133, 5, 132, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pnlPeriod = new PzPanel();
            GridBagLayout pnlPeriodLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlPeriod, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlPeriod.setBorder((Border)BorderFactory.createTitledBorder("Period pregleda"));
            pnlPeriodLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlPeriodLayout.rowHeights = new int[]{5, 25, 25, 7};
            pnlPeriodLayout.columnWeights = new double[]{0.0, 0.0, 0.0};
            pnlPeriodLayout.columnWidths = new int[]{85, 97, 15};
            this.pnlPeriod.setLayout((LayoutManager)pnlPeriodLayout);
            this.lblPocetni = new JLabel();
            this.pnlPeriod.add((Component)this.lblPocetni, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblPocetni.setText("Po\u010detni datum");
            this.dfPocetni = new PzDateField();
            this.pnlPeriod.add((Component)this.dfPocetni, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblKrajnji = new JLabel();
            this.pnlPeriod.add((Component)this.lblKrajnji, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblKrajnji.setText("Krajnji datum");
            this.dfKrajnji = new PzDateField();
            this.pnlPeriod.add((Component)this.dfKrajnji, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.panelRBs = new PzRadioGroup((Object[])new String[]{DETALJAN_PREGLED, ZBIRNI_PREGLED});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRBs, 1);
            this.panelRBs.setLayout((LayoutManager)panelRBsLayout);
            this.mainPanel.add(this.panelRBs, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs.setBorder((Border)BorderFactory.createTitledBorder("Izgled informacije"));
            this.panelRBs.setSelectedValue((Object)DETALJAN_PREGLED);
            this.panelRBs.setOpaque(false);
            this.pnlValuta = new PzPanel();
            this.pnlValuta.setLayout(null);
            this.mainPanel.add((Component)this.pnlValuta, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlValuta.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta, (Object)"Center");
            this.cbValuta.setBounds(10, 31, 107, 27);
            this.lblSifra = new JLabel();
            this.mainPanel.add((Component)this.lblSifra, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra dobavlja\u010da");
            this.tfSifra = new PzTextField();
            this.mainPanel.add((Component)this.tfSifra, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 90, 0, 20), 0, 0));
            this.tfSifra.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.indSifra = new PzFieldIndikator();
            this.mainPanel.add((Component)this.indSifra, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv = new PzTextField();
            this.mainPanel.add((Component)this.tfNaziv, (Object)new GridBagConstraints(3, 3, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv.setEditable(false);
            this.tfNaziv.setFocusable(false);
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.tfSifra.setStateIndikator(this.indSifra);
            this.pack();
            this.setSize(508, 253);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.mainPanel.validateForm(true)) {
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogPregledNabavkeOdDobavljaca.this.cursor != null) {
                        PzDialogPregledNabavkeOdDobavljaca.this.cursor.close();
                    }
                    String upit = "";
                    Query q = null;
                    String valuta = PzDialogPregledNabavkeOdDobavljaca.this.cbValuta.getSelectedChoice().getValue().toString();
                    upit = ((String)PzDialogPregledNabavkeOdDobavljaca.this.panelRBs.getSelectedValue()).equals(PzDialogPregledNabavkeOdDobavljaca.DETALJAN_PREGLED) ? "SELECT ad1.sfrProizvod, ad1.naziv, d1.datum, d1.oznDokumenta, d1.rBroj, sum(ad1.kolicina),  sum(ad2.kolicina), ad1.fakturnaCena%valuta%, ad1.procRabata, rj.oznRj FROM Radnajedinica rj, Artikal a, (Kalkulacija d1 INNER JOIN ArtikalKalkulacija ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Kalkulacija d2 INNER JOIN ArtikalKalkulacija ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.datum >= ':datumOd' AND d1.datum <= ':datumDo' AND d1.storno = 0 and d1.arhiviran = 1 and rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and rj.oznRj IN (%listaRj%) and d1.sfrKomitent =':komitent' AND d1.tip = '%tipK%' and a.sfrProizvod = ad1.sfrProizvod " : "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina),  sum(ad2.kolicina), sum(CASE WHEN (ad1.procRabata IS null ) THEN 0.0 ELSE (ad1.kolicina*ad1.fakturnaCena*ad1.procRabata/100)%valuta% END),  sum(CASE WHEN (ad2.procRabata IS null ) THEN 0.0 ELSE (ad2.kolicina*ad2.fakturnaCena*ad2.procRabata/100)%valuta% END),  sum(CASE WHEN (ad1.procRabata IS null ) THEN (ad1.kolicina*ad1.fakturnaCena)%valuta% ELSE (ad1.kolicina*(ad1.fakturnaCena*(1-ad1.procRabata/100)))%valuta% END), sum(CASE WHEN (ad1.procRabata IS null ) THEN (ad2.kolicina*ad2.fakturnaCena)%valuta% ELSE (ad2.kolicina*(ad2.fakturnaCena*(1-ad2.procRabata/100)))%valuta% END) FROM Radnajedinica rj, Artikal a, (Kalkulacija d1 INNER JOIN ArtikalKalkulacija ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Kalkulacija d2 INNER JOIN ArtikalKalkulacija ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.datum >= ':datumOd' AND d1.datum <= ':datumDo' AND d1.storno = 0 and d1.arhiviran = 1 and rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and rj.oznRj IN (%listaRj%) and d1.sfrKomitent =':komitent' AND d1.tip = '%tipK%' and a.sfrProizvod = ad1.sfrProizvod ";
                    upit = upit.replace(":komitent", PzDialogPregledNabavkeOdDobavljaca.this.entKomitent.getSfrKomitent());
                    upit = upit.replace(":datumOd", PzDialogPregledNabavkeOdDobavljaca.this.dfPocetni.getVal().toString());
                    upit = upit.replace(":datumDo", PzDialogPregledNabavkeOdDobavljaca.this.dfKrajnji.getVal().toString());
                    upit = ((String)PzDialogPregledNabavkeOdDobavljaca.this.panelRBs.getSelectedValue()).equals(PzDialogPregledNabavkeOdDobavljaca.DETALJAN_PREGLED) ? String.valueOf(upit) + " GROUP BY a.sfrSort, ad1.sfrProizvod, a.sfrProizvod,  ad1.naziv, d1.datum, d1.oznDokumenta, d1.rBroj, ad1.fakturnaCena, ad1.procRabata, rj.oznRj %valutaG% ORDER BY a.sfrSort" : String.valueOf(upit) + " GROUP BY a.sfrSort, ad1.sfrProizvod, a.sfrProizvod, ad1.naziv ORDER BY a.sfrSort";
                    upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                    upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                    upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and");
                    upit = upit.replace("%valutaG%", valuta.equals("") ? " " : ", kurs.srednji,kurs.jedinica");
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogPregledNabavkeOdDobavljaca.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogPregledNabavkeOdDobavljaca.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    block6: {
                        try {
                            try {
                                this.get();
                                if (PzDialogPregledNabavkeOdDobavljaca.this.cursor.size() == 0) {
                                    JOptionPane.showMessageDialog(PzDialogPregledNabavkeOdDobavljaca.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                                    PzWorkerDialog.hideStatus();
                                    break block6;
                                }
                                PzDialogPregledNabavkeOdDobavljaca.this.showReports();
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPregledNabavkeOdDobavljaca.this), (Throwable)e);
                                PzWorkerDialog.hideStatus();
                                em.close();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                }
            };
            worker.execute();
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.entKomitent = (Komitent)entity;
            if (this.entKomitent != null) {
                this.tfSifra.setVal((Object)this.entKomitent.getSfrKomitent());
                this.tfNaziv.setVal((Object)this.entKomitent.getNaziv());
            }
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        data.add(PzFirma.getFirma());
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "PREGLED NABAVKE ARTIKALA OD DOBAVLJACA: [ " + this.entKomitent.getSfrKomitent() + " ] " + this.entKomitent.getNaziv();
        String subtitle = "u periodu od " + PzDateUtility.formatDate((Date)this.dfPocetni.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfKrajnji.getVal());
        String fname = "";
        fname = ((String)this.panelRBs.getSelectedValue()).equals(DETALJAN_PREGLED) ? "rs/pezar/analitike/resource/reports/compiled/pregled.nabavke.po.dobavljacu.jasper" : "rs/pezar/analitike/resource/reports/compiled/pregled.nabavke.po.dobavljacu.zbirno.jasper";
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Date today = PzDateUtility.getCurrentDate();
        params.put("title", title);
        params.put("datum", today);
        params.put("subtitle", subtitle);
        params.put("reklama", "");
        params.put("valuta", valuta);
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }
}

