/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.garniture;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.artikli.garniture.Demontaza.UtvrdjivanjePrncKomponenti;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalgarnitura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Garnitura;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stavkagarniture;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.reports.PzReportManager;
import rs.pezar.sifarnici.gui.PzDialogArtikliExtended;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogFormiranjeGarnitura
extends PzDialog {
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private JLabel lblSifraGarniture;
    private PzDoubleField dfKolicina;
    private JLabel lblKolicina;
    private PzFieldIndikator indSifraGarniture;
    private JLabel lblMogucaKolicina;
    private PzTextField tfNaziv;
    private PzTextField tfSifra;
    private PzDateField dfDatum;
    private JLabel lblDatumIzrade;
    private PzButton btnPotvrdi;
    private Artikal garnitura;
    private Radnajedinica rj;
    private Garnitura zapisnik;
    private String parametar;
    private double kolicinaGarniture;
    private Nivelacija nivelacija;

    public PzDialogFormiranjeGarnitura() {
        this.initGUI();
    }

    public PzDialogFormiranjeGarnitura(JFrame frame, String parametar) {
        super(frame);
        this.parametar = parametar;
        this.initGUI();
    }

    protected void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setPreferredSize(new Dimension(400, 300));
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{82, 72, 53, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(392, 277));
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{41, 25, 25, 25, 25, 25, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{136, 114, 115, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblDatumIzrade = new JLabel();
            this.pnlFields.add((Component)this.lblDatumIzrade, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblDatumIzrade.setName("lblDatumIzrade");
            this.dfDatum = new PzDateField();
            this.pnlFields.add((Component)this.dfDatum, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblSifraGarniture = new JLabel();
            this.pnlFields.add((Component)this.lblSifraGarniture, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblSifraGarniture.setName("lblSifraGarniture");
            this.tfSifra = new PzTextField();
            this.pnlFields.add((Component)this.tfSifra, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifra.setFKField(Artikal.class, PzDialogArtikliExtended.class, true, null);
            this.tfSifra.setVerifyInput(true);
            this.tfSifra.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogFormiranjeGarnitura.this.tfSifra.getVal().equals("")) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogFormiranjeGarnitura.this), (String)"Ne mo\u017eete napustiti polje dokle god unos nije validan. Ukoliko \u017eelite da prekinete unos stisnite ESC.");
                        return false;
                    }
                    if (PzDialogFormiranjeGarnitura.this.garnitura.getGarnitura() != 1) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogFormiranjeGarnitura.this), (String)"\u0160ifra nije u bazi garnitura");
                        PzDialogFormiranjeGarnitura.this.tfSifra.requestFocus();
                        PzDialogFormiranjeGarnitura.this.tfNaziv.setText("");
                        return false;
                    }
                    if (PzDialogFormiranjeGarnitura.this.garnitura.getDeloviGarniture().size() == 0) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogFormiranjeGarnitura.this), (String)"Garnitura nama definisanu strukturu");
                        PzDialogFormiranjeGarnitura.this.tfSifra.requestFocus();
                        PzDialogFormiranjeGarnitura.this.indSifraGarniture.setState(PzFieldIndikator.STATE_INVALID);
                        PzDialogFormiranjeGarnitura.this.tfNaziv.setText("");
                        return false;
                    }
                    if (PzDialogFormiranjeGarnitura.this.parametar.equals("zapisnik")) {
                        PzDialogFormiranjeGarnitura.this.lblMogucaKolicina.setText("Mogu\u0107e formirati " + PzDialogFormiranjeGarnitura.this.getBrojGarnitura() + " garnitura");
                    } else {
                        PzDialogFormiranjeGarnitura.this.lblMogucaKolicina.setText("Mogu\u0107e demontirati " + PzDialogFormiranjeGarnitura.this.kolicinaGarniture + " garnitura");
                    }
                    return true;
                }
            });
            this.tfNaziv = new PzTextField();
            this.pnlFields.add((Component)this.tfNaziv, (Object)new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv.setForeground(new Color(255, 0, 0));
            this.tfNaziv.setFocusable(false);
            this.lblMogucaKolicina = new JLabel();
            this.pnlFields.add((Component)this.lblMogucaKolicina, (Object)new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.lblMogucaKolicina.setForeground(new Color(0, 0, 255));
            this.lblMogucaKolicina.setFont(new Font("Tahoma", 1, 12));
            this.lblKolicina = new JLabel();
            this.pnlFields.add((Component)this.lblKolicina, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblKolicina.setName("lblKolicina");
            this.dfKolicina = new PzDoubleField();
            this.pnlFields.add((Component)this.dfKolicina, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfKolicina.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogFormiranjeGarnitura.this.dfKolicina.getVal() == 0.0) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogFormiranjeGarnitura.this), (String)"Nije mogu\u0107e formirati garnituru sa koli\u010dinom 0");
                        return false;
                    }
                    if (PzDialogFormiranjeGarnitura.this.parametar.equals("zapisnik") && PzDialogFormiranjeGarnitura.this.dfKolicina.getVal() > PzDialogFormiranjeGarnitura.this.getBrojGarnitura()) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogFormiranjeGarnitura.this), (String)("Nije mogu\u0107e formirati vi\u0161e od " + PzDialogFormiranjeGarnitura.this.getBrojGarnitura() + " garnitura"));
                        return false;
                    }
                    if (PzDialogFormiranjeGarnitura.this.parametar.equals("demontaza") && PzDialogFormiranjeGarnitura.this.dfKolicina.getVal() > PzDialogFormiranjeGarnitura.this.kolicinaGarniture) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogFormiranjeGarnitura.this), (String)"Nema dovoljno koli\u010dine za demonta\u017eu. Zabranjen odlazak u minus");
                        return false;
                    }
                    return true;
                }
            });
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.indSifraGarniture = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indSifraGarniture, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
            this.tfSifra.setStateIndikator(this.indSifraGarniture);
            this.pack();
            this.setSize(400, 300);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.pnlFields.validateForm(true)) {
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("potvrdi")) {
                    if (this.parametar.equals("zapisnik")) {
                        em.getTransaction().begin();
                        this.createGarnitura(em, false);
                        this.azurirajStanje(em, false);
                        em.getTransaction().commit();
                        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.zapisnik);
                        if (this.nivelacija != null) {
                            PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.nivelacija);
                        }
                    } else if (this.rj.getNacinVodjenja().equals("PRODAJNA")) {
                        em.getTransaction().begin();
                        this.createGarnitura(em, true);
                        this.azurirajStanje(em, true);
                        em.getTransaction().commit();
                        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.zapisnik);
                        if (this.nivelacija != null) {
                            PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)this.nivelacija);
                        }
                    } else {
                        this.getSession().putParameter("garnitura", (Object)this.garnitura);
                        this.getSession().putParameter("rj", (Object)this.rj);
                        this.getSession().putParameter("datum", (Object)this.dfDatum.getVal());
                        this.getSession().putParameter("kolicina", (Object)this.dfKolicina.getVal());
                        this.getSession().putParameter("em", (Object)em);
                        this.showDialog(UtvrdjivanjePrncKomponenti.class);
                    }
                    this.dispose();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void azurirajStanje(EntityManager em, boolean demontaza) throws Exception {
        int br = 1;
        double prodCena = 0.0;
        double prncCena = 0.0;
        for (Artikalgarnitura artGar : this.garnitura.getDeloviGarniture()) {
            Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(artGar.getId().getDeo(), this.rj));
            if (stanje == null) {
                throw new PzInfoException("Artikal " + artGar.getId().getDeo() + " " + artGar.getDeo().getNaziv() + " nema formiranu prodajnu cenu. Dalji rad nemoguc.");
            }
            Stavkagarniture artZp = new Stavkagarniture();
            artZp.setId(this.zapisnik.getIdDok(), artGar.getId().getDeo(), br);
            artZp.setNaziv(artGar.getDeo().getNaziv());
            artZp.setJm(artGar.getDeo().getJedMere());
            artZp.setOpstidokument((Opstidokument)this.zapisnik);
            artZp.setCelina(0);
            artZp.setKoeficijent(artGar.getKolicina());
            artZp.setKolicina(artGar.getKolicina() * this.dfKolicina.getVal());
            artZp.setProsNabCena(stanje.getProsNabCena());
            artZp.setProdCena(new BigDecimal(stanje.getProdCena()));
            em.persist((Object)artZp);
            stanje.setDatZadIzlaza(this.dfDatum.getVal());
            if (demontaza) {
                stanje.setKolicina(stanje.getKolicina() + artGar.getKolicina() * this.dfKolicina.getVal());
            } else {
                stanje.setKolicina(stanje.getKolicina() - artGar.getKolicina() * this.dfKolicina.getVal());
            }
            stanje.setKumIzlaza(stanje.getKumIzlaza() + artGar.getKolicina());
            em.merge((Object)stanje);
            this.zapisnik.getArtikalopstidokuments().add(artZp);
            System.out.println(stanje.getProdCena());
            System.out.println(stanje.getProdCena() * artGar.getKolicina());
            prodCena = BDConverter.getProdCena((double)(prodCena + stanje.getProdCena() * artGar.getKolicina())).doubleValue();
            prncCena = BDConverter.getPrnc((double)(prncCena + stanje.getProsNabCena().doubleValue() * artGar.getKolicina())).doubleValue();
            ++br;
        }
        this.zapisnik.setPrncCena(prncCena);
        this.zapisnik.setProdCena(prodCena);
        this.zapisnik.setIznos(this.rj.getNacinVodjenja().equals("PRODAJNA") ? new BigDecimal(prodCena) : new BigDecimal(prncCena));
        Stanje stanjeGar = (Stanje)em.find(Stanje.class, (Object)new StanjePK(this.garnitura.getSfrProizvod(), this.rj));
        if (stanjeGar == null) {
            stanjeGar = new Stanje();
            stanjeGar.setId(new StanjePK(this.garnitura.getSfrProizvod(), this.rj));
            stanjeGar.setArtikal(this.garnitura);
            stanjeGar.setProdCena(prodCena);
            stanjeGar.setProsNabCena(new BigDecimal(prncCena));
            em.persist((Object)stanjeGar);
        }
        stanjeGar.setDatZadIzlaza(this.dfDatum.getVal());
        if (prodCena != stanjeGar.getProdCena()) {
            Faktura f = this.getFaktura(stanjeGar, prodCena, em);
            this.nivelacija = PzEntityUtil.createNivelacija((PzDokument)f, (boolean)true, (boolean)true, (EntityManager)em);
            stanjeGar.setProdCena(prodCena);
            this.arhiviraj(this.nivelacija, em);
        }
        if (demontaza) {
            stanjeGar.setKolicina(stanjeGar.getKolicina() - this.dfKolicina.getVal());
        } else {
            stanjeGar.setKolicina(stanjeGar.getKolicina() + this.dfKolicina.getVal());
        }
        stanjeGar.setKumIzlaza(stanjeGar.getKumIzlaza() + this.dfKolicina.getVal());
        Stavkagarniture artZp = new Stavkagarniture();
        artZp.setId(this.zapisnik.getIdDok(), this.garnitura.getSfrProizvod(), ++br);
        artZp.setNaziv(this.garnitura.getNaziv());
        artZp.setJm(this.garnitura.getJedMere());
        artZp.setOpstidokument((Opstidokument)this.zapisnik);
        artZp.setCelina(1);
        artZp.setKolicina(this.dfKolicina.getVal().doubleValue());
        artZp.setProsNabCena(stanjeGar.getProsNabCena());
        artZp.setProdCena(new BigDecimal(stanjeGar.getProdCena()));
        em.persist((Object)artZp);
        this.zapisnik.getArtikalopstidokuments().add(artZp);
        System.out.println(String.valueOf(prodCena) + "=" + stanjeGar.getProdCena());
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.zapisnik, true, null, em);
    }

    public Faktura getFaktura(Stanje stanje, double prodCena, EntityManager em) {
        Faktura f = null;
        f = new Faktura();
        f.setTip("FAKTURA");
        f.setArtikalfakturas((List)new IndirectList());
        f.setRadnajedinica(this.rj);
        f.setDatum(PzDateUtility.getCurrentDate());
        Artikalfaktura af = new Artikalfaktura();
        Artikal a = (Artikal)em.find(Artikal.class, (Object)stanje.getId().getSfrProizvod());
        af.setArtikal(a);
        af.setId(1, stanje.getId().getSfrProizvod(), 1);
        af.setKolicina(stanje.getKolicina());
        af.setCena(prodCena);
        af.setNaziv(a.getNaziv());
        af.setJm(a.getJedMere());
        af.setAftaksas(new Vector());
        af.getAftaksas().add(new Aftaksa(f.getIdDok(), a.getSfrProizvod(), a.getTarifnaGrupa("PDV").getOznTarGr(), 0, a.getTarifnaGrupa("PDV").getStopa(), a.getTarifnaGrupa("PDV").getVrstatg().getOznVrstaTG(), ""));
        f.getArtikalfakturas().add(af);
        return f;
    }

    private void arhiviraj(Nivelacija nivel, EntityManager em) throws Exception {
        if (nivel == null) {
            return;
        }
        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivel, true, null, em);
    }

    private void createGarnitura(EntityManager em, boolean demontaza) throws Exception {
        Integer broj;
        this.zapisnik = new Garnitura();
        if (demontaza) {
            broj = (Integer)em.createQuery("SELECT MAX(g.brojGarniture) FROM Garnitura g where g.storno=1").getSingleResult();
            this.zapisnik.setStorno(1);
        } else {
            this.zapisnik.setStorno(0);
            broj = (Integer)em.createQuery("SELECT MAX(g.brojGarniture) FROM Garnitura g where g.storno=0").getSingleResult();
        }
        broj = broj == null ? Integer.valueOf(1) : Integer.valueOf(broj + 1);
        this.zapisnik.setBrojGarniture(broj.intValue());
        this.zapisnik.setTip("GARNITURA");
        this.zapisnik.setUserPoc(PzApplication.getApplication().getSession().getLoggedUser());
        this.zapisnik.setUserKraj(PzApplication.getApplication().getSession().getLoggedUser());
        this.zapisnik.setSifra(this.garnitura.getSfrProizvod());
        this.zapisnik.setNaziv(this.garnitura.getNaziv());
        this.zapisnik.setRadnajedinica(this.rj);
        this.zapisnik.setDatum(this.dfDatum.getVal());
        this.zapisnik.setArhiviran((short)0);
        this.zapisnik.setKolicina(this.dfKolicina.getVal().doubleValue());
        this.zapisnik.setArtikalopstidokuments((List)new IndirectList());
        PzDokumentManager.getInstance().snimiDokument((PzDokument)this.zapisnik, true, null, em);
    }

    private Double getBrojGarnitura() {
        EntityManager em = PzEntityManager.getEm();
        int brGarnitura = Integer.MAX_VALUE;
        for (Artikalgarnitura art : this.garnitura.getDeloviGarniture()) {
            int broj = 0;
            Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(art.getId().getDeo(), this.rj));
            if (stanje == null) {
                brGarnitura = 0;
                break;
            }
            if (!(stanje.getKolicina() >= art.getKolicina())) {
                brGarnitura = 0;
                break;
            }
            broj = (int)(stanje.getKolicina() / art.getKolicina());
            if (broj >= brGarnitura) continue;
            brGarnitura = broj;
        }
        return brGarnitura;
    }

    public boolean shouldBeShown() {
        try {
            this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0))});
            if (this.rj != null) {
                if (this.parametar.equals("zapisnik")) {
                    this.setTitle("FORMIRANJE GARNITURE U RJ: " + this.rj.getId().getOznRj());
                } else {
                    this.setTitle("DEMONTA\u017dA GARNITURE U RJ: " + this.rj.getId().getOznRj());
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return false;
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        try {
            if (entity == null) {
                return;
            }
            this.garnitura = (Artikal)entity;
            this.tfSifra.setVal((Object)this.garnitura.getSfrProizvod());
            this.tfNaziv.setVal((Object)this.garnitura.getNaziv());
            if (!this.parametar.equals("zapisnik")) {
                Stanje stanje = (Stanje)PzEntityManager.getEm().find(Stanje.class, (Object)new StanjePK(this.garnitura.getSfrProizvod(), this.rj));
                this.kolicinaGarniture = stanje == null ? 0.0 : stanje.getKolicina();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogFormiranjeGarnitura(Boolean.FALSE);
    }

    public PzDialogFormiranjeGarnitura(Boolean initGUI) {
    }
}

