/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.lagerLista;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import rs.pezar.analitike.gui.artikli.lagerLista.importListe.ImportCellRenderer;
import rs.pezar.analitike.gui.artikli.lagerLista.importListe.ImportUtil;
import rs.pezar.analitike.gui.artikli.lagerLista.importListe.LagerLista;
import rs.pezar.analitike.gui.artikli.lagerLista.importListe.LagerListaStanje;
import rs.pezar.analitike.gui.artikli.lagerLista.importListe.PlanImporta;
import rs.pezar.analitike.gui.artikli.lagerLista.importListe.UnosPutanje;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.sifarnici.gui.PzDialogArtikliExtended;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.data.models.PzTableModel;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogImportLagerListe
extends PzDialog {
    private PzPanel pnlContent;
    private JToolBar toolbar;
    private PzToolBarIcon btnKartica;
    private PzToolBarIcon btnUpitURJ;
    private PzToolBarIcon btnFilter;
    private PzToolBarIcon btnNadjiArtikal;
    private PzToolBarIcon btnStampanje;
    private PzPanel plLabeleDugmici;
    private PzTable tblTable;
    private PzPanel plTabela;
    private JScrollPane scPane;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel("");
    private final JLabel vrednost = new JLabel("");
    private Radnajedinica rj;
    private JPanel pnlSelect;
    private PzButton icnSelektuj;
    private PzButton icnSelektujSve;
    private PzButton icnDeselektujSve;
    private PzButton icnInverznaSelekcija;
    private double suma;

    public PzDialogImportLagerListe(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Lager lista");
            this.pnlContent = new PzPanel();
            this.pnlContent.setPaintGradient(true);
            GridBagLayout pnlContentLayout = new GridBagLayout();
            pnlContentLayout.columnWidths = new int[]{7, 7};
            pnlContentLayout.rowHeights = new int[]{91, 7};
            pnlContentLayout.columnWeights = new double[]{0.0, 0.1};
            pnlContentLayout.rowWeights = new double[]{0.0, 0.1};
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.pnlContent.setLayout((LayoutManager)pnlContentLayout);
            this.toolbar = new JToolBar();
            this.pnlContent.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(20);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnKartica = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnKartica);
            this.btnKartica.setText("Uvoz|(F2)");
            this.btnKartica.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/import2.png")));
            this.btnKartica.addActionListener((ActionListener)((Object)this));
            this.btnKartica.setShortcut("f2");
            this.btnKartica.setActionCommand("uvoz");
            this.pnlSelect = new JPanel();
            FlowLayout pnlSelectLayout = new FlowLayout();
            pnlSelectLayout.setAlignment(0);
            pnlSelectLayout.setVgap(2);
            this.pnlSelect.setLayout(pnlSelectLayout);
            this.toolbar.add(this.pnlSelect);
            this.pnlSelect.setPreferredSize(new Dimension(221, 113));
            this.pnlSelect.setOpaque(false);
            this.icnSelektuj = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektuj);
            this.icnSelektuj.setText("Selektuj trenutni (f2)");
            this.icnSelektuj.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektuj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/selektuj.png")));
            this.icnSelektuj.setPreferredSize(new Dimension(207, 24));
            this.icnSelektuj.setHorizontalAlignment(10);
            this.icnSelektuj.setFocusable(false);
            this.icnSelektuj.setOpaque(false);
            this.icnSelektuj.addActionListener((ActionListener)((Object)this));
            this.icnSelektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnSelektujSve);
            this.icnSelektujSve.setText("Selektuj sve (alt+f2)");
            this.icnSelektujSve.setOpaque(false);
            this.icnSelektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnSelektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/selection_sve.png")));
            this.icnSelektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnSelektujSve.setHorizontalAlignment(10);
            this.icnSelektujSve.setFocusable(false);
            this.icnSelektujSve.addActionListener((ActionListener)((Object)this));
            this.icnDeselektujSve = new PzButton();
            this.pnlSelect.add((Component)this.icnDeselektujSve);
            this.icnDeselektujSve.setText("Deselektuj sve (ctrl+f2)");
            this.icnDeselektujSve.setOpaque(false);
            this.icnDeselektujSve.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnDeselektujSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/deselektuj_sve.png")));
            this.icnDeselektujSve.setPreferredSize(new Dimension(207, 24));
            this.icnDeselektujSve.setHorizontalAlignment(10);
            this.icnDeselektujSve.setFocusable(false);
            this.icnDeselektujSve.addActionListener((ActionListener)((Object)this));
            this.icnInverznaSelekcija = new PzButton();
            this.pnlSelect.add((Component)this.icnInverznaSelekcija);
            this.icnInverznaSelekcija.setText("Inverzna selekcija (ctrl+alt+f2)");
            this.icnInverznaSelekcija.setOpaque(false);
            this.icnInverznaSelekcija.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.icnInverznaSelekcija.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/selektuj inverzno.png")));
            this.icnInverznaSelekcija.setPreferredSize(new Dimension(208, 24));
            this.icnInverznaSelekcija.setHorizontalAlignment(10);
            this.icnInverznaSelekcija.setFocusable(false);
            this.icnInverznaSelekcija.addActionListener((ActionListener)((Object)this));
            this.plTabela = new PzPanel();
            this.pnlContent.add((Component)this.plTabela, (Object)new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(7, 7, 7, 7), 0, 0));
            GridBagLayout plTabelaLayout = new GridBagLayout();
            plTabelaLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            plTabelaLayout.rowHeights = new int[]{7, 7, 7, 7};
            plTabelaLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            plTabelaLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.plTabela.setLayout((LayoutManager)plTabelaLayout);
            this.plTabela.setOpaque(false);
            this.scPane = new JScrollPane();
            this.plTabela.add((Component)this.scPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tblTable = new PzTable();
            this.scPane.setViewportView((Component)this.tblTable);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText(" Broj \u0160ifara");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JLabel renderer1 = new JLabel();
                    renderer1.setText("Uporedni pregled podataka iz fajla i stanja. Ako \u017eelite za zavr\u0161ite uvoz pritisnite dugme Uvoz!");
                    renderer1.setForeground(new Color(200, 0, 0));
                    JLabel renderer2 = new JLabel();
                    renderer2.setText("Ukupna vrednost:");
                    PzDialogImportLagerListe.this.statusBar.add((Component)PzDialogImportLagerListe.this.brDok);
                    PzDialogImportLagerListe.this.statusBar.add((Component)renderer2);
                    PzDialogImportLagerListe.this.statusBar.add((Component)PzDialogImportLagerListe.this.vrednost);
                    PzDialogImportLagerListe.this.statusBar.add((Component)renderer1);
                    PzDialogImportLagerListe.this.brDok.setFocusable(false);
                    PzDialogImportLagerListe.this.brDok.setOpaque(false);
                }
            });
            this.pack();
            this.setRestorable(false);
            this.setMinimumSize(new Dimension(1140, 759));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        if (actionCommand.equals("uvoz")) {
            try {
                if (this.tblTable.getRowCount() == 0) {
                    return;
                }
                em.getTransaction().begin();
                List lista = this.tblTable.getCheckedEntities();
                for (LagerLista lagerlista : lista) {
                    if (lagerlista.getLgStanje() == null) {
                        Stanje s;
                        Artikal aL = (Artikal)em.find(Artikal.class, (Object)lagerlista.getArtikal().getSfrProizvod());
                        if (aL == null) {
                            Artikal a = lagerlista.getArtikal();
                            a.setCenaBazna(0.0);
                            em.persist((Object)a);
                        }
                        if ((s = this.getStanje(lagerlista.getArtikal().getSfrProizvod(), this.rj, em)) == null) {
                            s = new Stanje();
                            s.setId(new StanjePK(lagerlista.getArtikal().getSfrProizvod(), this.rj));
                            s.setRadnajedinica(this.rj);
                            s.setCenaNaPS(lagerlista.getArtikal().getCenaBazna());
                            s.setProdCena(lagerlista.getArtikal().getCenaBazna());
                            s.setKolPop(lagerlista.getArtikal().getKolicina());
                            s.setKolicina(lagerlista.getArtikal().getKolicina());
                            em.persist((Object)s);
                            continue;
                        }
                        s.setCenaNaPS(lagerlista.getArtikal().getCenaBazna());
                        s.setProdCena(lagerlista.getArtikal().getCenaBazna());
                        s.setKolicina(lagerlista.getArtikal().getKolicina());
                        s.setKolPop(lagerlista.getArtikal().getKolicina());
                        em.merge((Object)s);
                        continue;
                    }
                    Stanje s = this.getStanje(lagerlista.getLgStanje().getSfrProizvod(), this.rj, em);
                    if (s == null) {
                        s = new Stanje();
                        s.setId(new StanjePK(lagerlista.getLgStanje().getSfrProizvod(), this.rj));
                        s.setRadnajedinica(this.rj);
                        s.setCenaNaPS(lagerlista.getArtikal().getCenaBazna());
                        s.setProdCena(lagerlista.getArtikal().getCenaBazna());
                        s.setKolPop(lagerlista.getArtikal().getKolicina());
                        s.setKolicina(lagerlista.getArtikal().getKolicina());
                        em.persist((Object)s);
                        continue;
                    }
                    s.setCenaNaPS(lagerlista.getArtikal().getCenaBazna());
                    s.setProdCena(lagerlista.getArtikal().getCenaBazna());
                    s.setKolicina(lagerlista.getArtikal().getKolicina());
                    s.setKolPop(lagerlista.getArtikal().getKolicina());
                    em.merge((Object)s);
                }
                em.getTransaction().commit();
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
        if (e.getSource() == this.icnSelektujSve) {
            this.tblTable.checkAll();
        } else if (e.getSource() == this.icnDeselektujSve) {
            this.tblTable.unCheckAll();
        } else if (e.getSource() == this.icnInverznaSelekcija) {
            this.tblTable.inverseCheck();
        } else if (e.getSource() == this.icnSelektuj) {
            this.tblTable.switchIt();
        }
    }

    private Stanje getStanje(String sifra, Radnajedinica rj, EntityManager em) throws Exception {
        return (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(sifra, rj), (EntityManager)em);
    }

    public void loadTable(List<LagerLista> lagerLista) {
        this.tblTable.setModel((TableModel)new PzTableModel(){
            private static final long serialVersionUID = 2633014369978516912L;

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return super.isCellEditable(rowIndex, columnIndex) || columnIndex == 8;
            }
        });
        this.tblTable.setData(lagerLista, LagerLista.class);
        this.brDok.setText(String.valueOf(this.tblTable.getRowCount()));
        this.tblTable.setCheckboxColumn(0);
        this.tblTable.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new ImportCellRenderer()));
        final PzTextField editorComponent = new PzTextField();
        editorComponent.setFKField(Artikal.class, PzDialogArtikliExtended.class, true, null);
        editorComponent.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent arg0) {
                if (!editorComponent.getVal().equals("")) {
                    if (PzDialogImportLagerListe.this.existLgStanje(editorComponent.getVal())) {
                        PzSwingUtility.showErrorMessage((Component)((Object)PzDialogImportLagerListe.this), (String)"Artikal ve\u0107 postoji!");
                        return false;
                    }
                    LagerLista ll = (LagerLista)PzDialogImportLagerListe.this.tblTable.getSelectedEntity();
                    Stanjeartikal s = (Stanjeartikal)PzEntityManager.findEntity(Stanjeartikal.class, (Object)new StanjeartikalPK(editorComponent.getVal(), PzDialogImportLagerListe.this.rj));
                    ll.setLgStanje(new LagerListaStanje(s.getId().getSfrProizvod(), s.getNaziv(), s.getJedMere(), s.getOznRobGr(), "T1", s.getKolicina(), s.getProdCena()));
                    PzDialogImportLagerListe.this.tblTable.updateSelectedEntity((PzEntity)ll, false);
                    return true;
                }
                return false;
            }
        });
        this.tblTable.getColumn(8).setCellEditor(new DefaultCellEditor((JTextField)editorComponent));
        int i = 0;
        while (i < this.tblTable.getRowCount()) {
            if (ImportUtil.similarity(this.tblTable.getValueAt(i, 2).toString(), this.tblTable.getValueAt(i, 9).toString()) >= 0.7 && (Double)this.tblTable.getValueAt(i, 4) != 0.0) {
                this.tblTable.setRowChecked(i, true);
                this.suma += (Double)this.tblTable.getValueAt(i, 4) * (Double)this.tblTable.getValueAt(i, 7);
                this.vrednost.setText(String.valueOf(this.suma));
            }
            ++i;
        }
        this.tblTable.addCheckboxListener(new PzTableCheckboxListener(){

            public void valueChanged(int rowIndex, PzEntity entity, boolean newValue) {
                if (newValue) {
                    PzDialogImportLagerListe pzDialogImportLagerListe = PzDialogImportLagerListe.this;
                    pzDialogImportLagerListe.suma = pzDialogImportLagerListe.suma + (Double)PzDialogImportLagerListe.this.tblTable.getValueAt(rowIndex, 4) * (Double)PzDialogImportLagerListe.this.tblTable.getValueAt(rowIndex, 7);
                } else {
                    PzDialogImportLagerListe pzDialogImportLagerListe = PzDialogImportLagerListe.this;
                    pzDialogImportLagerListe.suma = pzDialogImportLagerListe.suma - (Double)PzDialogImportLagerListe.this.tblTable.getValueAt(rowIndex, 4) * (Double)PzDialogImportLagerListe.this.tblTable.getValueAt(rowIndex, 7);
                }
                PzDialogImportLagerListe.this.vrednost.setText(String.valueOf(PzDialogImportLagerListe.this.suma));
            }
        });
    }

    public boolean shouldBeShown() {
        block3: {
            block4: {
                try {
                    this.rj = PzDialogRJ.getRJ((PzDialog)this);
                    if (this.rj == null) break block3;
                    this.showDialog(UnosPutanje.class);
                    File file = (File)this.getSession().getParameter("file");
                    if (file != null) break block4;
                    return false;
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    return false;
                }
            }
            boolean importL = false;
            this.getSession().putParameter("dlg", (Object)this);
            this.getSession().putParameter("rj", (Object)this.rj);
            this.showDialog(PlanImporta.class);
            boolean bl = importL = this.getSession().getParameter("import") != null;
            return importL;
        }
        return false;
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        PzTextField editor = (PzTextField)component;
        Artikal a = (Artikal)entity;
        editor.setText(a.getSfrProizvod());
    }

    private boolean existLgStanje(String sifra) {
        boolean res = false;
        for (PzEntity lager : this.tblTable.getAllEntities()) {
            LagerLista ll = (LagerLista)lager;
            if (!ll.existStanje(sifra)) continue;
            res = true;
        }
        return res;
    }
}

