/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.lagerLista;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.artikli.lagerLista.PzDialogFilter;
import rs.pezar.analitike.gui.artikli.lagerLista.PzDialogIzborStampe;
import rs.pezar.analitike.gui.artikli.lagerLista.PzDialogKriterijumZaAnalizu;
import rs.pezar.analitike.util.AnalitikaUtil;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.rf.LagerListaRF;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.artikli.Upit;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.renderers.PzDoubleCellRenderer;
import rs.pezar.util.PzDateUtility;

public class PzDialogLagerListaZaAnalizu
extends PzDialog {
    private static final long serialVersionUID = 1824157487300032779L;
    private Radnajedinica rj;
    private ScrollableCursor cursor;
    private PzTextField tfKolicina;
    private PzScrollableTable tblLagerLista;
    private JScrollPane scPane;
    private PzPanel plTabela;
    private JLabel lblCena;
    private JLabel lblKolicina;
    private PzDoubleField dfUkupnaVrednost;
    private JLabel lblUkupnaVrednost;
    private JLabel jLabel1;
    private PzTextField tfCena;
    private PzTextField tfRj;
    private PzPanel plLabeleDugmici;
    private JToolBar toolbar;
    private PzToolBarIcon btnStampanje;
    private PzToolBarIcon btnNadjiArtikal;
    private PzToolBarIcon btnFilter;
    private PzToolBarIcon btnUpitURJ;
    private PzToolBarIcon btnKartica;
    private EntityManager em;
    private String qFilter = "";
    private String kriterijum;
    private PzPanel pnlContent;
    private Firma firma;
    private String queryG;
    private String queryV;
    private String panelTitle;
    BigDecimal vrednost = new BigDecimal(0.0);
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel("");
    private String[] krit;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogLagerListaZaAnalizu inst = new PzDialogLagerListaZaAnalizu(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogLagerListaZaAnalizu(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogLagerListaZaAnalizu() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Lager lista");
            this.pnlContent = new PzPanel();
            this.pnlContent.setPaintGradient(true);
            GridBagLayout pnlContentLayout = new GridBagLayout();
            pnlContentLayout.columnWidths = new int[]{7};
            pnlContentLayout.rowHeights = new int[]{91, 78, 7};
            pnlContentLayout.columnWeights = new double[]{0.1};
            pnlContentLayout.rowWeights = new double[]{0.0, 0.0, 1.0};
            this.getContentPane().add((Component)this.pnlContent, "Center");
            this.pnlContent.setLayout((LayoutManager)pnlContentLayout);
            this.toolbar = new JToolBar();
            this.pnlContent.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(20);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnKartica = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnKartica);
            this.btnKartica.setText("Kartica|(F2)");
            this.btnKartica.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_header.png")));
            this.btnKartica.addActionListener((ActionListener)((Object)this));
            this.btnKartica.setShortcut("f2");
            this.btnUpitURJ = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnUpitURJ);
            this.btnUpitURJ.setText("Upit u RJ|(F3)");
            this.btnUpitURJ.addActionListener((ActionListener)((Object)this));
            this.btnUpitURJ.setShortcut("F3");
            this.btnUpitURJ.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/message.png")));
            this.btnFilter = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnFilter);
            this.btnFilter.setText("Filter|(F4)");
            this.btnFilter.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/funnel.png")));
            this.btnFilter.addActionListener((ActionListener)((Object)this));
            this.btnFilter.setShortcut("f4");
            this.btnNadjiArtikal = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnNadjiArtikal);
            this.btnNadjiArtikal.setText("Na\u0111i artikal|(F8)");
            this.btnNadjiArtikal.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/find_text.png")));
            this.btnStampanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnStampanje);
            this.btnStampanje.setText("\u0160tampanje|(Alt+S)");
            this.btnStampanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.btnStampanje.addActionListener((ActionListener)((Object)this));
            this.btnStampanje.setShortcut("alt+s");
            this.plLabeleDugmici = new PzPanel();
            this.pnlContent.add((Component)this.plLabeleDugmici, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout plLabeleDugmiciLayout = new GridBagLayout();
            this.plLabeleDugmici.setLayout((LayoutManager)plLabeleDugmiciLayout);
            plLabeleDugmiciLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            plLabeleDugmiciLayout.rowHeights = new int[]{12, 25, 25, 12};
            plLabeleDugmiciLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.0, 0.1};
            plLabeleDugmiciLayout.columnWidths = new int[]{74, 124, 141, 7, 75, 20};
            this.plLabeleDugmici.setOpaque(false);
            this.tfRj = new PzTextField();
            this.plLabeleDugmici.add((Component)this.tfRj, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfRj.setName("tfRj");
            this.tfRj.setEditable(false);
            this.tfRj.setFocusable(false);
            this.tfRj.setFont(new Font("Tahoma", 1, 14));
            this.tfCena = new PzTextField();
            this.plLabeleDugmici.add((Component)this.tfCena, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfCena.setName("tfCena");
            this.tfCena.setFont(new Font("Tahoma", 1, 14));
            this.tfCena.setEditable(false);
            this.tfCena.setFocusable(false);
            this.tfCena.setSize(124, 25);
            this.tfKolicina = new PzTextField();
            this.plLabeleDugmici.add((Component)this.tfKolicina, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfKolicina.setName("tfKolicina");
            this.tfKolicina.setFocusable(false);
            this.tfKolicina.setEditable(false);
            this.tfKolicina.setFont(new Font("Tahoma", 1, 14));
            this.jLabel1 = new JLabel();
            this.plLabeleDugmici.add((Component)this.jLabel1, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.jLabel1.setText("Radna jedinica:");
            this.jLabel1.setFont(new Font("Tahoma", 1, 14));
            this.jLabel1.setForeground(new Color(0, 0, 255));
            this.lblUkupnaVrednost = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblUkupnaVrednost, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblUkupnaVrednost.setText("Ukupna vrednost:");
            this.lblUkupnaVrednost.setFont(new Font("Tahoma", 1, 14));
            this.lblUkupnaVrednost.setForeground(new Color(0, 0, 255));
            this.dfUkupnaVrednost = new PzDoubleField();
            this.plLabeleDugmici.add((Component)this.dfUkupnaVrednost, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfUkupnaVrednost.setFont(new Font("Tahoma", 1, 14));
            this.dfUkupnaVrednost.setEditable(false);
            this.dfUkupnaVrednost.setFocusable(false);
            this.lblKolicina = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblKolicina, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblKolicina.setText("Koli\u010dina:");
            this.lblKolicina.setFont(new Font("Tahoma", 1, 14));
            this.lblKolicina.setForeground(new Color(0, 0, 255));
            this.lblCena = new JLabel();
            this.plLabeleDugmici.add((Component)this.lblCena, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblCena.setText("Cena:");
            this.lblCena.setFont(new Font("Tahoma", 1, 14));
            this.lblCena.setForeground(new Color(0, 0, 255));
            this.plTabela = new PzPanel();
            this.pnlContent.add((Component)this.plTabela, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            AnchorLayout plTabelaLayout = new AnchorLayout();
            this.plTabela.setLayout((LayoutManager)plTabelaLayout);
            this.plTabela.setOpaque(false);
            this.scPane = new JScrollPane();
            this.plTabela.add((Component)this.scPane, (Object)new AnchorConstraint(37, 987, 976, 14, 1, 1, 1, 1));
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText(" Broj \u0161ifara");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(900, 740);
            this.setMinimumSize(new Dimension(950, 740));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.btnFilter) {
                this.tblLagerLista = new PzScrollableTable();
                this.tblLagerLista.getColumnByName("Koli\u010dina").setCellRenderer((TableCellRenderer)new PzDoubleCellRenderer(PzFormatFactory.getKolicinaFormat()));
                this.qFilter = PzDialogFilter.getQuery(this);
                if (this.qFilter == null) {
                    return;
                }
                this.initializationTable(this.createQuery(this.kriterijum), this.getVrednostQuery(this.kriterijum), "Filtriranje lager liste je u toku. Molim, sa\u010dekajte.");
            } else if (e.getSource() == this.btnStampanje) {
                this.showReport();
            } else if (e.getSource() == this.btnKartica) {
                int selectedRow = this.tblLagerLista.getRealSelectedRowIndex();
                if (selectedRow == -1) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Morate obele\u017eiti artikal u tabeli.");
                } else {
                    String a = this.tblLagerLista.getModel().getValueAt(selectedRow, 0).toString();
                    Artikal artikal = (Artikal)PzEntityManager.find(Artikal.class, (Object)a);
                    AnalitikaUtil.karticaArtikla((PzDialog)this, artikal, this.rj, null);
                }
            } else if (e.getSource() == this.btnUpitURJ) {
                int selectedRow = this.tblLagerLista.getRealSelectedRowIndex();
                if (selectedRow == -1) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Morate obele\u017eiti artikal u tabeli.");
                } else {
                    String a = this.tblLagerLista.getModel().getValueAt(selectedRow, 0).toString();
                    Artikal artikal = (Artikal)PzEntityManager.find(Artikal.class, (Object)a);
                    Upit.upit((PzDialog)this, (Artikal)artikal);
                }
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void initializationTable(final String queryGlavni, final String queryVrednost, String poruka) {
        final EntityManager em = PzEntityManager.getEm();
        PzWorkerDialog.showStatus((String)poruka, (PzDialog)this);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                if (PzDialogLagerListaZaAnalizu.this.cursor != null) {
                    PzDialogLagerListaZaAnalizu.this.cursor.close();
                }
                em.getTransaction().begin();
                Query q = null;
                if (!PzDialogLagerListaZaAnalizu.this.krit[0].equals("najveca_nabavka") && !PzDialogLagerListaZaAnalizu.this.krit[0].equals("najveca_prodaja")) {
                    q = em.createNativeQuery(queryVrednost);
                    PzDialogLagerListaZaAnalizu.this.vrednost = (BigDecimal)q.getSingleResult();
                }
                q = em.createNativeQuery(queryGlavni);
                q.setHint("eclipselink.cursor.scrollable", (Object)true);
                PzDialogLagerListaZaAnalizu.this.cursor = (ScrollableCursor)q.getSingleResult();
                em.getTransaction().commit();
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        System.out.println(PzDialogLagerListaZaAnalizu.this.vrednost);
                        PzDialogLagerListaZaAnalizu.this.dfUkupnaVrednost.setVal((Object)(PzDialogLagerListaZaAnalizu.this.vrednost == null ? 0.0 : PzDialogLagerListaZaAnalizu.this.vrednost.doubleValue()));
                        PzDialogLagerListaZaAnalizu.this.brDok.setText(String.valueOf(PzDialogLagerListaZaAnalizu.this.cursor.size()));
                        String[] columnNames = PzDialogLagerListaZaAnalizu.this.krit[0].equals("najveca_nabavka") ? new String[]{"\u0160ifra", "Naziv", "Bli\u017ei opis", "JM", "Kumulativ ulaza", "Robna grupa", "Model", "Proizvo\u0111a\u010d", "Lokacija"} : (PzDialogLagerListaZaAnalizu.this.krit[0].equals("najveca_prodaja") ? new String[]{"\u0160ifra", "Naziv", "Bli\u017ei opis", "JM", "Kumulativ izlaza", "Robna grupa", "Model", "Proizvo\u0111a\u010d", "Lokacija"} : (PzDialogLagerListaZaAnalizu.this.krit[0].equals("neprodati_od") ? new String[]{"\u0160ifra", "Naziv", "Bli\u017ei opis", "JM", "Koli\u010dina", "Cena", "Vrednost", "Datum izlaza", "Robna grupa", "Model", "Proizvo\u0111a\u010d", "Lokacija"} : (PzDialogLagerListaZaAnalizu.this.krit[0].equals("promet") ? new String[]{"\u0160ifra", "Naziv", "Bli\u017ei opis", "JM", "Koli\u010dina", "Cena", "Vrednost", "Robna grupa", "Model", "Proizvo\u0111a\u010d", "Lokacija", "Nabavka N", "Storno N", "Prodaja P", "Storno P"} : new String[]{"\u0160ifra", "Naziv", "Bli\u017ei opis", "JM", "Koli\u010dina", "Cena", "Vrednost", "Robna grupa", "Model", "Proizvo\u0111a\u010d", "Lokacija"})));
                        if (PzDialogLagerListaZaAnalizu.this.tblLagerLista == null) {
                            PzDialogLagerListaZaAnalizu.this.tblLagerLista = new PzScrollableTable(PzDialogLagerListaZaAnalizu.this.cursor, columnNames);
                        } else {
                            PzDialogLagerListaZaAnalizu.this.tblLagerLista.read(PzDialogLagerListaZaAnalizu.this.cursor, columnNames);
                        }
                        PzDialogLagerListaZaAnalizu.this.scPane.setViewportView((Component)PzDialogLagerListaZaAnalizu.this.tblLagerLista);
                        if (PzDialogLagerListaZaAnalizu.this.cursor.size() > 0) {
                            if (PzDialogLagerListaZaAnalizu.this.krit[0].equals("promet")) {
                                PzDialogLagerListaZaAnalizu.this.tblLagerLista.insertColumn(11, "$11$-$12$", "Nabavka");
                                PzDialogLagerListaZaAnalizu.this.tblLagerLista.insertColumn(14, "$14$-$15$", "Prodaja");
                                PzDialogLagerListaZaAnalizu.this.tblLagerLista.getColumnExt(16).setVisible(false);
                                PzDialogLagerListaZaAnalizu.this.tblLagerLista.getColumnExt(15).setVisible(false);
                                PzDialogLagerListaZaAnalizu.this.tblLagerLista.getColumnExt(13).setVisible(false);
                                PzDialogLagerListaZaAnalizu.this.tblLagerLista.getColumnExt(12).setVisible(false);
                            }
                            PzDialogLagerListaZaAnalizu.this.tblLagerLista.getColumnByName("Koli\u010dina").setCellRenderer((TableCellRenderer)new PzDoubleCellRenderer(PzFormatFactory.getKolicinaFormat()));
                            PzDialogLagerListaZaAnalizu.this.tblLagerLista.setRowSelectionInterval(0, 0);
                            PzDialogLagerListaZaAnalizu.this.tblLagerLista.requestFocusInWindow();
                        }
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogLagerListaZaAnalizu.this), (Throwable)e);
                        PzDialogLagerListaZaAnalizu.this.dispose();
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    public boolean shouldBeShown() {
        try {
            this.rj = PzDialogRJ.getRJ((PzDialog)this);
            if (this.rj != null) {
                this.kriterijum = PzDialogKriterijumZaAnalizu.getKriterijum(this);
                if (this.kriterijum != null) {
                    this.krit = this.kriterijum.split("\\|");
                    if (this.krit[0].equals("trenutna") || this.krit[0].equals("pocetak_naziva") || this.krit[0].equals("kljucna_rec") || this.krit[0].equals("promet")) {
                        String string = this.krit[0].equals("trenutna") ? "LAGER LISTA" : (this.krit[0].equals("pocetak_naziva") ? "PO PO\u010cETKU NAZIVA: " + this.krit[3] : (this.panelTitle = this.krit[0].equals("promet") ? "LAGER LISTA SA PROMETOM" : "KLJU\u010cNA RE\u010c: " + this.krit[3]));
                        if (this.krit[2].equals("trenutna")) {
                            this.tfCena.setVal((Object)"PRODAJNA");
                        } else if (this.krit[2].equals("poeni")) {
                            this.tfCena.setVal((Object)"U POENIMA");
                        } else if (this.krit[2].equals("bazna")) {
                            this.tfCena.setVal((Object)"BAZNA");
                        } else if (this.krit[2].equals("prnc")) {
                            this.tfCena.setVal((Object)"PROS. NABAVNA");
                        } else if (this.krit[2].equals("zadnjaNabavna")) {
                            this.tfCena.setVal((Object)"ZAD. NABAVNA");
                        }
                        if (this.krit[1].equals("raspoloziva")) {
                            this.tfKolicina.setVal((Object)"RASPOLO\u017dIVA");
                        } else if (this.krit[1].equals("ukupna")) {
                            this.tfKolicina.setVal((Object)"UKUPNA");
                        } else {
                            this.tfKolicina.setVal((Object)"ALOCIRANA");
                        }
                    } else if (this.krit[0].equals("pocetno_stanje")) {
                        this.panelTitle = "LAGER LISTA PO\u010cETNOG STANJA";
                        this.tfCena.setVal((Object)"PO\u010cETNA");
                        this.tfKolicina.setVal((Object)"PO\u010cETNA");
                    } else if (this.krit[0].equals("najveca_nabavka")) {
                        this.panelTitle = "PO KUMULATIVU ULAZA";
                        this.tfCena.setVal((Object)"KUMULATIV ULAZA");
                        this.tfKolicina.setVal((Object)"BEZ CENE");
                        this.dfUkupnaVrednost.setEditable(false);
                    } else if (this.krit[0].equals("najveca_prodaja")) {
                        this.panelTitle = "PO KUMULATIVU IZLAZA";
                        this.tfCena.setVal((Object)"KUMULATIV IZLAZA");
                        this.tfKolicina.setVal((Object)"BEZ CENE");
                        this.dfUkupnaVrednost.setEditable(false);
                    } else if (this.krit[0].equals("neprodati_od")) {
                        this.panelTitle = "LAGER NEPRODATIH OD " + PzDateUtility.formatDate((Date)Date.valueOf(this.krit[3]));
                        this.tfCena.setVal((Object)"TRENUTNA");
                        this.tfKolicina.setVal((Object)"ZATE\u010cENA");
                        this.dfUkupnaVrednost.setEditable(false);
                    } else if (this.krit[0].equals("bez_promene_u_godini")) {
                        this.panelTitle = "LAGER BEZ PROMENA U GODINI";
                        this.tfCena.setVal((Object)"TRENUTNA");
                        this.tfKolicina.setVal((Object)"ZATE\u010cENA");
                    } else if (this.krit[0].equals("pali_na_nulu")) {
                        this.panelTitle = "LAGER LISTA ARTIKALA SA KOLI\u010cINOM NULA";
                        this.tfKolicina.setVal((Object)"PALI NA NULU");
                        if (this.krit[2].equals("trenutna")) {
                            this.tfCena.setVal((Object)"PRODAJNA");
                        } else if (this.krit[2].equals("poeni")) {
                            this.tfCena.setVal((Object)"U POENIMA");
                        } else if (this.krit[2].equals("bazna")) {
                            this.tfCena.setVal((Object)"BAZNA");
                        } else if (this.krit[2].equals("prnc")) {
                            this.tfCena.setVal((Object)"PROS. NABAVNA");
                        } else if (this.krit[2].equals("zadnjaNabavna")) {
                            this.tfCena.setVal((Object)"ZAD. NABAVNA");
                        }
                    } else if (this.krit[0].equals("sa_pali_na_nulu")) {
                        this.panelTitle = "LAGER LISTA ARTIKALA SA ARTIKLIMA SA KOLI\u010cINOM NULA";
                        this.tfKolicina.setVal((Object)"RASPOLOZIVA");
                        if (this.krit[2].equals("trenutna")) {
                            this.tfCena.setVal((Object)"PRODAJNA");
                        } else if (this.krit[2].equals("poeni")) {
                            this.tfCena.setVal((Object)"U POENIMA");
                        } else if (this.krit[2].equals("bazna")) {
                            this.tfCena.setVal((Object)"BAZNA");
                        } else if (this.krit[2].equals("prnc")) {
                            this.tfCena.setVal((Object)"PROS. NABAVNA");
                        } else if (this.krit[2].equals("zadnjaNabavna")) {
                            this.tfCena.setVal((Object)"ZAD. NABAVNA");
                        }
                    }
                    this.initializationTable(this.createQuery(this.kriterijum), this.getVrednostQuery(this.kriterijum), "Sastavljanje lager liste je u toku. Molim, sa\u010dekajte.");
                    this.tfRj.setVal((Object)("[" + this.rj.getId().getOznRj() + "] " + this.rj.getNaziv()));
                    this.plLabeleDugmici.setBorder((Border)BorderFactory.createTitledBorder(null, this.panelTitle, 2, 0, new Font("Tahoma", 1, 18)));
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return false;
        }
    }

    private String getPrometS() {
        String upit = ", sum(CASE WHEN (d1.tip = '%tipK%' and d1.datum>='%datumOD%' and d1.datum<='%datumDO%') THEN ad1.kolicina ELSE 0 END),  sum(CASE WHEN (d2.tip = '%tipK%' and d2.datum>='%datumOD%' and d2.datum<='%datumDO%' ) THEN ad2.kolicina ELSE 0 END), sum(CASE WHEN (ad1.vrstaPromene = 'P' and d1.datum>='%datumOD%' and d1.datum<='%datumDO%' ) THEN ad1.kolicina ELSE 0 END), sum(CASE WHEN (ad2.vrstaPromene = 'PS' and d2.datum>='%datumOD%' and d2.datum<='%datumDO%' ) THEN ad2.kolicina ELSE 0 END) ";
        upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
        upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
        upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
        String[] datum = this.krit[3].split(";");
        upit = upit.replace("%datumOD%", datum[0]);
        upit = upit.replace("%datumDO%", datum[1]);
        return upit;
    }

    private String getPrometF() {
        String upit = ",(Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok ) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND CASE WHEN (d1.tip = '%tipK%' ) THEN ad1.nabCena = ad2.nabCena ELSE ad1.prodCena = ad2.prodCena END ";
        upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
        return upit;
    }

    private String createQuery(String kriterijum) {
        String[] fk;
        String[] krit = kriterijum.split("\\|");
        String filKrit = (String)this.getSession().getParameter("filter");
        String query = "SELECT a.sfrProizvod, a.naziv, a.bliziOpis, a.jedMere, CAST(%kolicina% AS NUMERIC), CAST(%cena% AS NUMERIC), CAST(%kolicina%*%cena% AS NUMERIC), a.oznRobGr, a.oznModel, a.proizvodjac, (a.stalaza || a.nivo || a.paleta) as lokacija %prometS% FROM StanjeArtikal a %kritFrom% %prometF% WHERE %kritWhere% %prometW% %kolicina% IS NOT NULL %filter% ";
        query = query.replaceAll("%filter%", this.qFilter);
        query = krit[0].equals("promet") ? query.replaceAll("%prometS%", this.getPrometS()) : query.replaceAll("%prometS%", "");
        query = krit[0].equals("promet") ? query.replaceAll("%prometF%", this.getPrometF()) : query.replaceAll("%prometF%", "");
        String string = query = krit[0].equals("promet") ? query.replaceAll("%prometW%", " a.sfrProizvod = ad1.sfrProizvod and ") : query.replaceAll("%prometW%", "");
        if (krit[0].equals("promet")) {
            query = String.valueOf(query) + " and d1.oznRj=a.oznRj and d1.oznOgranak=a.oznOgranak AND a.oznRj = %oznRj% AND a.oznOgranak = %oznOgranak%   GROUP BY a.sfrProizvod, a.naziv, a.bliziOpis, a.jedMere, %kolicina% , %cena% , a.oznRobGr, a.oznModel, a.proizvodjac, a.stalaza, a.nivo,a.paleta ORDER BY %sort%";
            query = query.replaceAll("%oznRj%", "'" + this.rj.getId().getOznRj() + "'").replaceAll("%oznOgranak%", "'" + this.rj.getId().getOznOgranak() + "'");
        }
        if (krit[0].equals("trenutna") || krit[0].equals("kljucna_rec") || krit[0].equals("pocetak_naziva") || krit[0].equals("promet")) {
            query = String.valueOf(query) + (krit[0].equals("pocetak_naziva") || krit[0].equals("kljucna_rec") ? " AND %upitNaziv% " : "%krit%");
            query = query.replaceAll("%kolicina%", krit[1].equals("raspoloziva") ? "(a.kolicina - a.alocKolicina)" : (krit[1].equals("ukupna") ? "a.kolicina" : "a.alocKolicina"));
            query = query.replaceAll("%cena%", krit[2].equals("trenutna") ? "a.prodCena" : (krit[2].equals("poeni") ? "a.cenaPoeni" : (krit[2].equals("bazna") ? "a.cenaBazna" : (krit[2].equals("prnc") ? "a.prosNabCena" : "a.zadNabCena"))));
            query = krit[0].equals("kljucna_rec") ? query.replaceAll("%upitNaziv%", this.getUpitNaziv()) : query.replaceAll("%krit%", "");
            query = krit[0].equals("pocetak_naziva") ? query.replaceAll("%upitNaziv%", this.getUpitNazivPoc()) : query.replaceAll("%krit%", "");
        } else if (krit[0].equals("pocetno_stanje")) {
            query = query.replaceAll("%kolicina%", "a.kolPop").replaceAll("%cena%", "a.cenaNaPs");
        } else if (krit[0].equals("najveca_nabavka")) {
            query = "SELECT a.sfrProizvod, a.naziv, a.bliziOpis, a.jedMere, CAST(%kolicina% AS NUMERIC), a.oznRobGr, a.oznModel, a.proizvodjac, (a.stalaza || a.nivo || a.paleta) as lokacija FROM StanjeArtikal a WHERE %kolicina%<>0 AND %kolicina% IS NOT NULL %filter% ";
            query = query.replaceAll("%filter%", this.qFilter);
            query = query.replaceAll("%kolicina%", "a.kumUlaza");
        } else if (krit[0].equals("najveca_prodaja")) {
            query = "SELECT a.sfrProizvod, a.naziv, a.bliziOpis, a.jedMere, CAST(%kolicina% AS NUMERIC), a.oznRobGr, a.oznModel, a.proizvodjac, (a.stalaza || a.nivo || a.paleta) as lokacija FROM StanjeArtikal a WHERE %kolicina%<>0 AND %kolicina% IS NOT NULL %filter% ";
            query = query.replaceAll("%filter%", this.qFilter);
            query = query.replaceAll("%kolicina%", "a.kumIzlaza");
        } else if (krit[0].equals("neprodati_od")) {
            query = "SELECT a.sfrProizvod, a.naziv, a.bliziOpis, a.jedMere, CAST(%kolicina% AS NUMERIC), CAST(%cena% AS NUMERIC), CAST(%kolicina%*%cena% AS NUMERIC), a.datZadIzlaza, a.oznRobGr, a.oznModel, a.proizvodjac, (a.stalaza || a.nivo || a.paleta) as lokacija FROM StanjeArtikal a WHERE %kolicina%<>0 and (a.datZadIzlaza<='%datum%' or a.datZadIzlaza is null) AND %kolicina% IS NOT NULL %filter% ";
            query = query.replaceAll("%filter%", this.qFilter);
            query = query.replaceAll("%kolicina%", "a.kolicina").replaceAll("%cena%", "a.prodCena").replaceAll("%datum%", krit[3]);
        } else if (krit[0].equals("bez_promene_u_godini")) {
            query = String.valueOf(query) + " AND (a.datZadIzlaza < '%datum%' or a.datZadIzlaza is null) AND (a.datZadUlaza < '%datum%' or a.datZadUlaza is null)";
            query = query.replaceAll("%kolicina%", "a.kolicina").replaceAll("%cena%", "a.prodCena").replaceAll("%datum%", PzDateUtility.getFirstDayOfCurrentYear().toString());
        } else if (krit[0].equals("pali_na_nulu")) {
            query = "SELECT a.sfrProizvod, a.naziv, a.bliziOpis, a.jedMere, CAST(0.0 AS NUMERIC), CAST(%cena% AS NUMERIC), CAST(0.0 AS NUMERIC), a.oznRobGr, a.oznModel, a.proizvodjac, (a.stalaza || a.nivo || a.paleta) as lokacija FROM StanjeArtikal a WHERE a.sfrProizvod IN (Select distinct art.sfrProizvod FROM Artikaldokument art, Dokument dok  Where art.iddok = dok.iddok and art.vrsta = 'I' and dok.oznRj = %oznRj% AND dok.oznOgranak = %oznOgranak%) and (a.kolicina - a.alocKolicina) = 0 AND (a.kolicina - a.alocKolicina) IS NOT NULL %filter% ";
            query = query.replaceAll("%filter%", this.qFilter);
            query = query.replaceAll("%cena%", krit[2].equals("trenutna") ? "a.prodCena" : (krit[2].equals("poeni") ? "a.cenaPoeni" : (krit[2].equals("bazna") ? "a.cenaBazna" : (krit[2].equals("prnc") ? "a.prosNabCena" : "a.zadNabCena"))));
        } else if (krit[0].equals("sa_pali_na_nulu")) {
            query = "SELECT a.sfrProizvod, a.naziv, a.bliziOpis, a.jedMere, CAST(%kolicina% AS NUMERIC), CAST(%cena% AS NUMERIC), CAST(0.0 AS NUMERIC), a.oznRobGr, a.oznModel, a.proizvodjac, (a.stalaza || a.nivo || a.paleta) as lokacija FROM StanjeArtikal a WHERE  %kolicina% IS NOT NULL %filter% ";
            query = query.replaceAll("%filter%", this.qFilter);
            query = query.replaceAll("%kolicina%", "a.kolicina");
            query = query.replaceAll("%cena%", krit[2].equals("trenutna") ? "a.prodCena" : (krit[2].equals("poeni") ? "a.cenaPoeni" : (krit[2].equals("bazna") ? "a.cenaBazna" : (krit[2].equals("prnc") ? "a.prosNabCena" : "a.zadNabCena"))));
        }
        if (!krit[0].equals("promet")) {
            query = String.valueOf(query) + " AND a.oznRj = %oznRj% AND a.oznOgranak = %oznOgranak%  ORDER BY %sort%";
            query = query.replaceAll("%oznRj%", "'" + this.rj.getId().getOznRj() + "'").replaceAll("%oznOgranak%", "'" + this.rj.getId().getOznOgranak() + "'");
        }
        query = filKrit != null && !filKrit.equals("") ? ((fk = filKrit.split(";"))[0].equals("T") ? query.replaceAll("%kritFrom%", ", Tarifnagrupa t, TGArtikal c ").replaceAll("%kritWhere%", "t.oznVrstaTG='PDV' and t.oznTarGr=c.oznTarGr and c.sfrProizvod=a.sfrProizvod and ") : query.replaceAll("%kritFrom%", "").replaceAll("%kritWhere%", "")) : query.replaceAll("%kritFrom%", "").replaceAll("%kritWhere%", "");
        query = krit[4] != null && krit[4].equals("sort_naziv") ? query.replace("%sort%", " a.naziv ASC") : query.replace("%sort%", " a.sfrSort");
        return query;
    }

    private String getVrednostQuery(String kriterijum) {
        String[] fk;
        String[] krit = kriterijum.split("\\|");
        String filKrit = (String)this.getSession().getParameter("filter");
        String query = "SELECT SUM(ROUND(CAST(%kolicina%*%cena% AS NUMERIC), 2)) FROM Stanjeartikal a %kritFrom% WHERE %kritWhere% %kolicina%<>0 AND %kolicina% IS NOT NULL %filter% AND a.oznRj = %oznRj% AND a.oznOgranak = %oznOgranak%";
        query = query.replaceAll("%filter%", this.qFilter);
        if (krit[0].equals("trenutna") || krit[0].equals("kljucna_rec") || krit[0].equals("pocetak_naziva") || krit[0].equals("promet")) {
            query = String.valueOf(query) + (krit[0].equals("pocetak_naziva") || krit[0].equals("kljucna_rec") ? " AND %upitNaziv% " : "%krit%");
            query = query.replaceAll("%kolicina%", krit[1].equals("raspoloziva") ? "(a.kolicina - a.alocKolicina)" : (krit[1].equals("ukupna") ? "a.kolicina" : "a.alocKolicina"));
            query = query.replaceAll("%cena%", krit[2].equals("trenutna") ? "a.prodCena" : (krit[2].equals("poeni") ? "a.cenaPoeni" : (krit[2].equals("bazna") ? "a.cenaBazna" : (krit[2].equals("prnc") ? "a.prosNabCena" : "a.zadNabCena"))));
            query = krit[0].equals("pocetak_naziva") || krit[0].equals("kljucna_rec") ? query.replaceAll("%upitNaziv%", this.getUpitNaziv()) : query.replaceAll("%krit%", "");
        } else if (krit[0].equals("pocetno_stanje")) {
            query = query.replaceAll("%kolicina%", "a.kolPop").replaceAll("%cena%", "a.cenaNaPs");
        } else if (krit[0].equals("neprodati_od")) {
            query = "SELECT SUM(ROUND(CAST(%kolicina%*%cena% AS NUMERIC), 2)) FROM Stanjeartikal a WHERE %kolicina%<>0 AND %kolicina% IS NOT NULL %filter% AND a.oznRj = %oznRj% AND a.oznOgranak = %oznOgranak% and a.datZadIzlaza<='%datum%'";
            query = query.replaceAll("%filter%", this.qFilter);
            query = query.replaceAll("%kolicina%", "a.kolicina").replaceAll("%cena%", "a.prodCena").replaceAll("%datum%", krit[3]);
        } else if (krit[0].equals("bez_promene_u_godini")) {
            query = String.valueOf(query) + " AND (a.datZadIzlaza < '%datum%' or a.datZadIzlaza is null) AND (a.datZadUlaza < '%datum%' or a.datZadUlaza is null)";
            query = query.replaceAll("%kolicina%", "a.kolicina").replaceAll("%cena%", "a.prodCena").replaceAll("%datum%", PzDateUtility.getFirstDayOfCurrentYear().toString());
        } else if (krit[0].equals("pali_na_nulu")) {
            query = "SELECT SUM(0.00) FROM Stanjeartikal a WHERE  %kolicina%=0 AND %kolicina% IS NOT NULL %filter% AND a.oznRj = %oznRj% AND a.oznOgranak = %oznOgranak%";
            query = query.replaceAll("%filter%", this.qFilter);
            query = query.replaceAll("%kolicina%", "(a.kolicina - a.alocKolicina)");
        } else if (krit[0].equals("sa_pali_na_nulu")) {
            query = "SELECT SUM(ROUND(CAST(%kolicina%*%cena% AS NUMERIC), 2)) FROM Stanjeartikal a WHERE %kolicina% IS NOT NULL %filter% AND a.oznRj = %oznRj% AND a.oznOgranak = %oznOgranak%";
            query = query.replaceAll("%filter%", this.qFilter);
            query = query.replaceAll("%cena%", krit[2].equals("trenutna") ? "a.prodCena" : (krit[2].equals("poeni") ? "a.cenaPoeni" : (krit[2].equals("bazna") ? "a.cenaBazna" : (krit[2].equals("prnc") ? "a.prosNabCena" : "a.zadNabCena"))));
            query = query.replaceAll("%kolicina%", "(a.kolicina - a.alocKolicina)");
        }
        query = query.replaceAll("%oznRj%", "'" + this.rj.getId().getOznRj() + "'").replaceAll("%oznOgranak%", "'" + this.rj.getId().getOznOgranak() + "'");
        query = filKrit != null && !filKrit.equals("") ? ((fk = filKrit.split(";"))[0].equals("T") ? query.replaceAll("%kritFrom%", ", Tarifnagrupa t, TGArtikal c ").replaceAll("%kritWhere%", "t.oznVrstaTG='PDV' and t.oznTarGr=c.oznTarGr and c.sfrProizvod=a.sfrProizvod and ") : query.replaceAll("%kritFrom%", "").replaceAll("%kritWhere%", "")) : query.replaceAll("%kritFrom%", "").replaceAll("%kritWhere%", "");
        return query;
    }

    private String getUpitNaziv() {
        Vector<String> vector = new Vector<String>();
        String pomString = "";
        String pomString1 = "";
        String upitNaziv = "";
        if (!this.krit[3].equals("")) {
            int i = 0;
            while (i < this.krit[3].length()) {
                pomString = this.krit[3].substring(i, i + 1);
                if (!pomString.equals(" ")) {
                    pomString1 = String.valueOf(pomString1) + pomString;
                } else {
                    vector.add(pomString1);
                    pomString1 = "";
                }
                ++i;
            }
            vector.add(pomString1);
            i = 0;
            while (i < vector.size()) {
                upitNaziv = String.valueOf(upitNaziv) + "LOWER(a.naziv) LIKE '%" + ((String)vector.elementAt(i)).toLowerCase() + "%'";
                if (i != vector.size() - 1) {
                    upitNaziv = String.valueOf(upitNaziv) + " AND ";
                }
                ++i;
            }
        }
        return upitNaziv;
    }

    private String getUpitNazivPoc() {
        Vector<String> vector = new Vector<String>();
        String pomString = "";
        String pomString1 = "";
        String upitNaziv = "";
        if (!this.krit[3].equals("")) {
            int i = 0;
            while (i < this.krit[3].length()) {
                pomString = this.krit[3].substring(i, i + 1);
                pomString1 = String.valueOf(pomString1) + pomString;
                ++i;
            }
            vector.add(pomString1);
            i = 0;
            while (i < vector.size()) {
                upitNaziv = String.valueOf(upitNaziv) + "LOWER(a.naziv) LIKE '" + ((String)vector.elementAt(i)).toLowerCase() + "%'";
                if (i != vector.size() - 1) {
                    upitNaziv = String.valueOf(upitNaziv) + " AND ";
                }
                ++i;
            }
        }
        return upitNaziv;
    }

    private void showReport() {
        try {
            String izbor = PzDialogIzborStampe.getIzborZaStampu(this);
            if (izbor == null) {
                return;
            }
            String sort = "";
            String cenaKolicina = "";
            String pregled = "";
            String fname = "";
            String title = ((TitledBorder)this.plLabeleDugmici.getBorder()).getTitle();
            String kolKrit = (String)this.getSession().getParameter("kolicina");
            String filKrit = (String)this.getSession().getParameter("filter");
            String kolicina = "";
            String filter = "";
            if (kolKrit != null && filKrit != null) {
                if (kolKrit.equals("manja")) {
                    kolicina = "Koli\u010dina je manja od 0";
                } else if (kolKrit.equals("veca")) {
                    kolicina = "Koli\u010dina je va\u0107a od 0";
                }
                if (!filKrit.equals("")) {
                    String[] fk = filKrit.split(";");
                    if (fk[0].equals("R")) {
                        filter = "Robna grupa je: " + fk[1];
                    } else if (fk[0].equals("P")) {
                        filter = "Proizvo\u0111a\u010d je:" + fk[1];
                    } else if (fk[0].equals("M")) {
                        filter = "Model je:" + fk[1];
                    } else if (fk[0].equals("T")) {
                        filter = "Tarifna grupa je:" + fk[1];
                    }
                }
            }
            String kriterijum = "";
            kriterijum = !kolicina.equals("") && !filter.equals("") ? String.valueOf(kolicina) + ";" + filter : String.valueOf(kolicina) + filter;
            HashMap<String, String> params = new HashMap<String, String>();
            if (izbor.equals("kolicinaIcenaBezL")) {
                if (this.krit[0].equals("trenutna") || this.krit[0].equals("sa_pali_na_nulu")) {
                    sort = "\u0161ifra      KOLI\u010cINA: " + this.tfKolicina.getVal() + "      CENA: " + this.tfCena.getVal();
                    fname = "rs/pezar/reports/compiled/lager.lista.analiza.pocetno.stanje.jasper";
                } else if (this.krit[0].equals("najveca_nabavka") || this.krit[0].equals("najveca_prodaja")) {
                    sort = "\u0160ifra";
                    pregled = this.krit[0].equals("najveca_nabavka") ? "nabavka" : "prodaja";
                    fname = "rs/pezar/reports/compiled/lager.lista.analiza.nabavka.prodaja.jasper";
                } else if (this.krit[0].equals("pali_na_nulu")) {
                    sort = "\u0161ifra      KOLI\u010cINA: " + this.tfKolicina.getVal() + "      CENA: " + this.tfCena.getVal();
                    fname = "rs/pezar/reports/compiled/lager.lista.analiza.bez.lokacija.jasper";
                } else if (this.krit[0].equals("promet")) {
                    sort = "\u0161ifra      KOLI\u010cINA: " + this.tfKolicina.getVal() + "      CENA: " + this.tfCena.getVal();
                    fname = "rs/pezar/reports/compiled/lager.lista.analiza.promet.jasper";
                } else {
                    sort = "\u0160ifra";
                    fname = "rs/pezar/reports/compiled/lager.lista.analiza.pocetno.stanje.jasper";
                }
            } else if (izbor.equals("kolicinaIcenaSaL")) {
                if (this.krit[0].equals("trenutna")) {
                    sort = "Lokacija+\u0161ifra      KOLI\u010cINA: " + this.tfKolicina.getVal() + "      CENA: " + this.tfCena.getVal();
                    pregled = this.krit[0].equals("pali_na_nulu") ? "nula" : "";
                    fname = "rs/pezar/reports/compiled/lager.lista.analiza.cena.i.kolicina.jasper";
                } else if (this.krit[0].equals("najveca_nabavka") || this.krit[0].equals("najveca_prodaja")) {
                    sort = "Lokacija+\u0161ifra ";
                    pregled = this.krit[0].equals("najveca_nabavka") ? "nabavka" : "prodaja";
                    fname = "rs/pezar/reports/compiled/lager.lista.analiza.nabavka.prodaja.sa.lok.jasper";
                } else if (this.krit[0].equals("pali_na_nulu")) {
                    sort = "Lokacija+\u0161ifra      KOLI\u010cINA: " + this.tfKolicina.getVal() + "      CENA: " + this.tfCena.getVal();
                    pregled = this.krit[0].equals("pali_na_nulu") ? "nula" : "";
                    fname = "rs/pezar/reports/compiled/lager.lista.analiza.sa.lokacijom.jasper";
                } else if (this.krit[0].equals("promet")) {
                    sort = "Lokacija+\u0161ifra      KOLI\u010cINA: " + this.tfKolicina.getVal() + "      CENA: " + this.tfCena.getVal();
                    fname = "rs/pezar/reports/compiled/lager.lista.analiza.promet.lokacija.jasper";
                } else {
                    sort = "Lokacija+\u0161ifra ";
                    fname = "rs/pezar/reports/compiled/lager.lista.analiza.cena.i.kolicina.jasper";
                }
            } else if (izbor.equals("bezCene")) {
                title = "LAGER LISTA PO LOKACIJAMA BEZ CENE";
                fname = this.krit[0].equals("najveca_nabavka") || this.krit[0].equals("najveca_prodaja") ? "rs/pezar/reports/compiled/lager.lista.analiza.bez.cene.kolicine.kumulativ.jasper" : (this.krit[0].equals("promet") ? "rs/pezar/reports/compiled/lager.lista.analiza.promet.bez.cene.kolicine.jasper" : "rs/pezar/reports/compiled/lager.lista.analiza.bez.cene.kolicine.jasper");
                cenaKolicina = izbor;
            } else if (izbor.equals("bezKolicine")) {
                title = "LAGER LISTA PO LOKACIJAMA BEZ KOLI\u010cINA";
                fname = this.krit[0].equals("najveca_nabavka") || this.krit[0].equals("najveca_prodaja") ? "rs/pezar/reports/compiled/lager.lista.analiza.bez.cene.kolicine.kumulativ.jasper" : (this.krit[0].equals("promet") ? "rs/pezar/reports/compiled/lager.lista.analiza.promet.bez.cene.kolicine.jasper" : "rs/pezar/reports/compiled/lager.lista.analiza.bez.cene.kolicine.jasper");
                cenaKolicina = izbor;
            }
            Vector<Object> eData = new Vector<Object>();
            eData.add(this.rj);
            eData.add(PzFirma.getFirma());
            params.put("title", title);
            params.put("sort", sort);
            params.put("izbor", cenaKolicina);
            params.put("izborK", pregled);
            params.put("krit", kriterijum);
            params.put("sortiranje", this.krit[4]);
            LagerListaRF.showReport((PzScrollableTable)this.tblLagerLista, eData, (PzDialog)this, (String)title, (String)fname, params);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null) {
            this.cursor.close();
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }
}

