/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.artikli.uvecanje_umanjenje.umanjenje;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.db.entity.StanjeartikalPK;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.event.PzStanjeartikalChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class Dodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanelHeader header;
    private PzButton btnPotvrdi;
    private PzDoubleField dfPrRabata;
    private PzDoubleField dfCena;
    private JLabel lblSifraArtikla;
    private PzPanel mainPanel;
    private PzTextField tfJedMere;
    private PzTextField tfProizvodjac;
    private PzTextField tfRG;
    private PzTextField tfTG;
    private PzDoubleField dfPakovanje;
    private PzDoubleField dfRasKolicina;
    private PzDoubleField dfZadnjaNC;
    private PzDoubleField dfPlanskaCena;
    private PzDoubleField dfProsecnaNC;
    private PzDoubleField dfProdajnaCena;
    private JLabel jLabel10;
    private JLabel jLabel9;
    private JLabel jLabel8;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JLabel jLabel5;
    private JLabel jLabel4;
    private PzDoubleField dfKolicina;
    private PzTextField tfSifraArtikla;
    private JLabel lblPrRabata;
    private JLabel lblCena;
    private JLabel lblKolicina;
    private PzPanel plGlavni;
    private Opstidokument umanjenje;
    private Artikalopstidokument artumanjenje;
    private Artikalopstidokument artumanjenjeStari;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanel jPanelPromet;
    private boolean izmena;
    private double stopPDV;
    private String tg;
    private String lokacija;
    private BigDecimal prethodniIznosBezPDV;
    private BigDecimal prethodniIznosSaPDV;
    String naziv;
    String jm;
    Stanjeartikal a;
    Artikal art;
    private PzTable tabela;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Dodavanje inst = new Dodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Dodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.umanjenje = (Opstidokument)this.getSession().getParameter("umanjenje");
        this.izmena = (Boolean)this.getSession().getParameter("update");
        this.tabela = (PzTable)this.getSession().popParameter("table");
        this.tfSifraArtikla.setParamToPass((Object)this.umanjenje.getRadnajedinica());
        this.tfSifraArtikla.setEntityChecker((PzEntityChecker)new PzStanjeartikalChecker((PzField)this.tfSifraArtikla, this.umanjenje.getRadnajedinica()));
        if (this.izmena) {
            this.artumanjenje = (Artikalopstidokument)this.tabela.getSelectedEntity();
            this.artumanjenjeStari = (Artikalopstidokument)this.tabela.getSelectedEntity();
            this.a = null;
            try {
                this.a = (Stanjeartikal)PzEntityManager.find(Stanjeartikal.class, (Object)new StanjeartikalPK(this.tfSifraArtikla.getVal(), this.umanjenje.getRadnajedinica()));
                this.art = (Artikal)PzEntityManager.find(Artikal.class, (Object)this.tfSifraArtikla.getVal());
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
            this.stopPDV = this.art.getStopa("PDV");
            this.naziv = this.a.getNaziv();
            this.tg = this.art.getTarifnaGrupa("PDV").getOznTarGr();
            this.jm = this.a.getJedMere();
            this.lokacija = this.a.getStalaza() == null ? "00" : (String.valueOf(this.a.getStalaza()) + this.a.getNivo() == null ? "00" : (String.valueOf(this.a.getNivo()) + this.a.getPaleta() == null ? "00" : this.a.getPaleta()));
            this.dfKolicina.setVal((Object)this.artumanjenje.getKolicina());
            if (this.umanjenje.getRadnajedinica().getgTip().equals(Character.valueOf('E'))) {
                this.dfCena.setVal((Object)this.artumanjenje.getCenaSaPorezom());
            } else {
                this.dfCena.setVal((Object)this.artumanjenje.getCenaBezPoreza());
            }
            this.setStanje(this.a);
            this.dfKolicina.requestFocus();
            this.dfCena.setEnabled(true);
        } else {
            this.tfSifraArtikla.requestFocus();
        }
    }

    protected void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.mainPanel.setPreferredSize(new Dimension(575, 93));
            this.plGlavni = new PzPanel();
            this.mainPanel.add((Component)this.plGlavni, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout plGlavniLayout = new GridBagLayout();
            this.plGlavni.setPreferredSize(new Dimension(575, 368));
            plGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{31, 31, 30, 31, 7};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{79, 105, 7};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.plGlavni.setOpaque(false);
            this.lblSifraArtikla = new JLabel();
            this.plGlavni.add((Component)this.lblSifraArtikla, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblSifraArtikla.setText("\u0160ifra artikla");
            this.lblKolicina = new JLabel();
            this.plGlavni.add((Component)this.lblKolicina, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblKolicina.setText("Koli\u010dina");
            this.lblCena = new JLabel();
            this.plGlavni.add((Component)this.lblCena, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblCena.setText("Cena");
            this.lblPrRabata = new JLabel();
            this.plGlavni.add((Component)this.lblPrRabata, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 0, 0, 5), 0, 0));
            this.lblPrRabata.setText("% rabata");
            this.lblPrRabata.setVisible(false);
            this.tfSifraArtikla = new PzTextField();
            this.plGlavni.add((Component)this.tfSifraArtikla, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
            this.tfSifraArtikla.setFont(new Font("Tahoma", 0, 14));
            this.tfSifraArtikla.setPreferredSize(new Dimension(60, 24));
            this.tfSifraArtikla.setFKField(Stanjeartikal.class, PzArtikliBrowser.class, true, null);
            this.tfSifraArtikla.setSize(60, 24);
            this.tfSifraArtikla.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    block8: {
                        Stanje s;
                        block10: {
                            block9: {
                                block7: {
                                    s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(Dodavanje.this.tfSifraArtikla.getVal(), Dodavanje.this.umanjenje.getRadnajedinica()));
                                    if (s != null || Dodavanje.this.umanjenje.getRadnajedinica().getgTip().equals("E") && (Dodavanje.this.umanjenje.getRadnajedinica().getpTip().equals("V") || Dodavanje.this.umanjenje.getRadnajedinica().getpTip().equals("W"))) break block7;
                                    JOptionPane.showMessageDialog(null, "Artikal nema stanje!", "Informacija", 1);
                                    return false;
                                }
                                if (s == null) break block8;
                                if (s.getProsNabCena().doubleValue() != 0.0 || !Dodavanje.this.umanjenje.getRadnajedinica().equals("V") || !Dodavanje.this.umanjenje.getRadnajedinica().getNacinVodjenja().equals("PRNC")) break block9;
                                JOptionPane.showMessageDialog(null, "Artikal nema formiranu prose\u010dnu nabavnu cenu. RAD NEMOGU\u0106!", "Informacija", 1);
                                return false;
                            }
                            if (s.getProdCena() != 0.0 || !Dodavanje.this.umanjenje.getRadnajedinica().equals("V") || !Dodavanje.this.umanjenje.getRadnajedinica().getNacinVodjenja().equals("PRODAJNA")) break block10;
                            JOptionPane.showMessageDialog(null, "Artikal nema formiranu prodajnu cenu. RAD NEMOGU\u0106!", "Informacija", 1);
                            return false;
                        }
                        if (Dodavanje.this.umanjenje.getRadnajedinica().getgTip().equals("E") && (Dodavanje.this.umanjenje.getRadnajedinica().getpTip().equals("V") || Dodavanje.this.umanjenje.getRadnajedinica().getpTip().equals("W")) || !(s.getKolicina() - s.getAlocKolicina() <= 0.0) || !Dodavanje.this.umanjenje.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN")) break block8;
                        double kol = s.getKolicina() - s.getAlocKolicina();
                        JOptionPane.showMessageDialog(null, "Artikal u magacinu (prodavnici) " + kol + ". RAD NEMOGU\u0106", "Informacija", 1);
                        return false;
                    }
                    try {
                        if (Dodavanje.this.umanjenje.artikalExists(Dodavanje.this.tfSifraArtikla.getVal())) {
                            PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)"Artikal ve\u0107 postoji na umanjenju!");
                            return false;
                        }
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)SwingUtilities.getRoot(input), (Throwable)e);
                    }
                    return true;
                }
            });
            this.dfKolicina = new PzDoubleField();
            this.plGlavni.add((Component)this.dfKolicina, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
            this.dfKolicina.setFont(new Font("Tahoma", 0, 14));
            this.dfKolicina.setPreferredSize(new Dimension(60, 24));
            this.dfKolicina.setLimit(5, 3);
            this.dfKolicina.setSize(60, 24);
            this.dfKolicina.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    block5: {
                        block6: {
                            Stanje s;
                            block4: {
                                try {
                                    if (!(Dodavanje.this.dfKolicina.getVal() <= 0.0)) break block4;
                                    JOptionPane.showMessageDialog(null, "Koli\u010dina ne mo\u017ee biti 0!", "Informacija", 1);
                                    return false;
                                }
                                catch (Exception e) {
                                    PzMysqlExceptionHandler.handle((Component)SwingUtilities.getRoot(input), (Throwable)e);
                                    return true;
                                }
                            }
                            if (Dodavanje.this.umanjenje.getRadnajedinica().getgTip().equals("E") && (Dodavanje.this.umanjenje.getRadnajedinica().getpTip().equals("V") || Dodavanje.this.umanjenje.getRadnajedinica().getpTip().equals("W")) || !((s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(Dodavanje.this.tfSifraArtikla.getVal(), Dodavanje.this.umanjenje.getRadnajedinica()))).getKolicina() - s.getAlocKolicina() - Dodavanje.this.dfKolicina.getVal() < 0.0)) break block5;
                            if (!Dodavanje.this.umanjenje.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN")) break block6;
                            JOptionPane.showMessageDialog(null, "Zabranjen ulazak u minus!", "Informacija", 1);
                            return false;
                        }
                        int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(input), "Nedovoljna koli\u010dina. OK?", "Informacija", 0);
                        if (rez != 1) break block5;
                        Dodavanje.this.dfKolicina.requestFocus();
                        return false;
                    }
                    return true;
                }
            });
            this.dfCena = new PzDoubleField();
            this.plGlavni.add((Component)this.dfCena, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 15), 0, 0));
            this.dfCena.setFont(new Font("Tahoma", 0, 14));
            this.dfCena.setPreferredSize(new Dimension(60, 24));
            this.dfCena.setLimit(7, 2);
            this.dfCena.setSize(60, 24);
            this.dfCena.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (Dodavanje.this.dfCena.getVal() <= 0.0) {
                        JOptionPane.showMessageDialog(null, "Cena ne mo\u017ee biti 0!", "Informacija", 1);
                        return false;
                    }
                    return true;
                }
            });
            this.dfPrRabata = new PzDoubleField();
            this.plGlavni.add((Component)this.dfPrRabata, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 15), 0, 0));
            this.dfPrRabata.setFont(new Font("Tahoma", 0, 14));
            this.dfPrRabata.setPreferredSize(new Dimension(60, 24));
            this.dfPrRabata.setLimit(3, 2);
            this.dfPrRabata.setSize(60, 24);
            this.dfPrRabata.setVisible(false);
            this.btnPotvrdi = new PzButton();
            this.plGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.plGlavni.add((Component)this.getJPanelPromet(), (Object)new GridBagConstraints(2, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.header = new PzPanelHeader();
            this.mainPanel.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.header.setOpaque(false);
            this.tfSifraArtikla.requestFocus();
            this.pack();
            this.setSize(575, 479);
            this.setResizable(false);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        EntityManager em = PzEntityManager.getEm();
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("insert")) {
            try {
                Stanje s;
                if (this.dfKolicina.getVal() <= 0.0) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Koli\u010dina mora biti ve\u0107a od 0.");
                    this.dfKolicina.requestFocus();
                    return;
                }
                if (this.dfCena.getVal() <= 0.0) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Cena ne mo\u017ee biti manja od 0.");
                    this.dfCena.requestFocus();
                    return;
                }
                if ((!this.umanjenje.getRadnajedinica().getgTip().equals("E") || !this.umanjenje.getRadnajedinica().getpTip().equals("V") && !this.umanjenje.getRadnajedinica().getpTip().equals("W")) && (s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(this.tfSifraArtikla.getVal(), this.umanjenje.getRadnajedinica()))).getKolicina() - s.getAlocKolicina() - this.dfKolicina.getVal() < 0.0) {
                    if (this.umanjenje.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN")) {
                        JOptionPane.showMessageDialog(null, "Zabranjen ulazak u minus!", "Informacija", 1);
                        return;
                    }
                    int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nedovoljna koli\u010dina. OK?", "Informacija", 0);
                    if (rez == 1) {
                        this.dfKolicina.requestFocus();
                        return;
                    }
                }
                this.artumanjenje = new Artikalopstidokument();
                this.artumanjenje.init(this.art, (PzDokument)this.umanjenje);
                this.artumanjenje.setKolicina(this.dfKolicina.getVal().doubleValue());
                this.artumanjenje.setNaziv(this.naziv);
                if (this.umanjenje.getRadnajedinica().getgTip().equals("E")) {
                    this.artumanjenje.setCenaSaPorezom(this.dfCena.getVal().doubleValue());
                    this.artumanjenje.setCenaBezPoreza(this.dfCena.getVal() * 100.0 / (100.0 + this.stopPDV));
                    this.artumanjenje.setProdCena(BDConverter.getProdCena((double)this.dfCena.getVal()));
                } else {
                    this.artumanjenje.setCenaBezPoreza(this.dfCena.getVal().doubleValue());
                    this.artumanjenje.setCenaSaPorezom(this.dfCena.getVal() * (1.0 + this.stopPDV / 100.0));
                    this.artumanjenje.setProdCena(BDConverter.getProdCena((double)this.dfCena.getVal()));
                }
                this.artumanjenje.setProcRabata(0.0);
                this.artumanjenje.setJm(this.jm);
                this.artumanjenje.setLokacija(this.lokacija);
                this.artumanjenje.setProsNabCena(BDConverter.getPrnc((double)this.dfProsecnaNC.getVal()));
                this.artumanjenje.setOpstidokument(this.umanjenje);
                this.umanjenje.setIznosBezPoreza(this.umanjenje.getIznosBezPoreza().add(BDConverter.getIznos((double)(this.artumanjenje.getKolicina() * this.artumanjenje.getCenaBezPoreza()))));
                this.umanjenje.setIznosSaPorezom(this.umanjenje.getIznosSaPorezom().add(BDConverter.getIznos((double)(this.artumanjenje.getKolicina() * this.artumanjenje.getCenaSaPorezom()))));
                this.umanjenje.setPdvIznos(this.umanjenje.getIznosSaPorezom().subtract(this.umanjenje.getIznosBezPoreza()));
                em.getTransaction().begin();
                em.merge((Object)this.umanjenje);
                this.tabela.insert((PzEntity)this.artumanjenje, em);
                em.getTransaction().commit();
                this.tabela.commitInsert();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                    this.tabela.removeSelectedEntity(false, false);
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        } else if (actionCommand.equals("update")) {
            try {
                Stanje s;
                if (this.dfKolicina.getVal() <= 0.0) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Koli\u010dina mora biti ve\u0107a od 0.");
                    this.dfKolicina.requestFocus();
                    return;
                }
                if (this.dfCena.getVal() <= 0.0) {
                    PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Cena ne mo\u017ee biti manja od 0.");
                    this.dfCena.requestFocus();
                    return;
                }
                if ((!this.umanjenje.getRadnajedinica().getgTip().equals("E") || !this.umanjenje.getRadnajedinica().getpTip().equals("V") && !this.umanjenje.getRadnajedinica().getpTip().equals("W")) && (s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(this.tfSifraArtikla.getVal(), this.umanjenje.getRadnajedinica()))).getKolicina() - s.getAlocKolicina() - this.dfKolicina.getVal() <= 0.0) {
                    if (this.umanjenje.getRadnajedinica().getMinusKolicine().equals("ZABRANJEN")) {
                        JOptionPane.showMessageDialog(null, "Zabranjen ulazak u minus!", "Informacija", 1);
                        return;
                    }
                    int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Nedovoljna koli\u010dina. OK?", "Informacija", 0);
                    if (rez == 1) {
                        this.dfKolicina.requestFocus();
                        return;
                    }
                }
                this.artumanjenje.setKolicina(this.dfKolicina.getVal().doubleValue());
                this.artumanjenje.setNaziv(this.naziv);
                if (this.umanjenje.getRadnajedinica().getgTip().equals("E")) {
                    this.artumanjenje.setCenaSaPorezom(this.dfCena.getVal().doubleValue());
                    this.artumanjenje.setCenaBezPoreza(this.dfCena.getVal() * 100.0 / (100.0 + this.stopPDV));
                    this.artumanjenje.setProdCena(BDConverter.getProdCena((double)this.dfCena.getVal()));
                } else {
                    this.artumanjenje.setCenaBezPoreza(this.dfCena.getVal().doubleValue());
                    this.artumanjenje.setCenaSaPorezom(this.dfCena.getVal() * (1.0 + this.stopPDV / 100.0));
                    this.artumanjenje.setProdCena(BDConverter.getProdCena((double)this.dfCena.getVal()));
                }
                this.artumanjenje.setJm(this.jm);
                this.artumanjenje.setLokacija(this.lokacija);
                this.artumanjenje.setProsNabCena(BDConverter.getPrnc((double)this.dfProsecnaNC.getVal()));
                System.out.println(this.prethodniIznosBezPDV);
                System.out.println(this.prethodniIznosSaPDV);
                this.umanjenje.setIznosBezPoreza(this.umanjenje.getIznosBezPoreza().subtract(this.prethodniIznosBezPDV).add(BDConverter.getIznos((double)(this.artumanjenje.getKolicina() * this.artumanjenje.getCenaBezPoreza()))));
                this.umanjenje.setIznosSaPorezom(this.umanjenje.getIznosSaPorezom().subtract(this.prethodniIznosSaPDV).add(BDConverter.getIznos((double)(this.artumanjenje.getKolicina() * this.artumanjenje.getCenaSaPorezom()))));
                this.umanjenje.setPdvIznos(this.umanjenje.getIznosSaPorezom().subtract(this.umanjenje.getIznosBezPoreza()));
                em.getTransaction().begin();
                em.merge((Object)this.umanjenje);
                this.tabela.updateSelectedEntity((PzEntity)this.artumanjenje, em);
                em.getTransaction().commit();
                this.tabela.commitUpdate();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                    this.tabela.updateSelectedEntity((PzEntity)this.artumanjenjeStari, false);
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
        this.dispose();
    }

    protected void onInsert() {
        this.btnPotvrdi.setActionCommand("insert");
    }

    protected void onUpdate() {
        try {
            this.btnPotvrdi.setActionCommand("update");
            this.tabela = (PzTable)this.getSession().getParameter("table");
            Artikalopstidokument artotpis = (Artikalopstidokument)this.tabela.getSelectedEntity();
            this.tfSifraArtikla.setVal((Object)artotpis.getId().getSfrProizvod());
            this.tfSifraArtikla.setEnabled(false);
            this.dfKolicina.setVal((Object)artotpis.getKolicina());
            this.dfKolicina.setEnabled(true);
            if (artotpis.getOpstidokument().getRadnajedinica().getgTip().equals(Character.valueOf('E'))) {
                this.dfCena.setVal((Object)artotpis.getCenaSaPorezom());
            } else {
                this.dfCena.setVal((Object)artotpis.getCenaBezPoreza());
            }
            this.dfCena.setEnabled(true);
            this.tfSifraArtikla.setEnabled(false);
            this.prethodniIznosBezPDV = BDConverter.getIznos((double)(artotpis.getKolicina() * artotpis.getCenaBezPoreza()));
            this.prethodniIznosSaPDV = BDConverter.getIznos((double)(artotpis.getKolicina() * artotpis.getCenaSaPorezom()));
            System.out.println(this.prethodniIznosBezPDV);
            System.out.println(this.prethodniIznosSaPDV);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void setStanje(Stanjeartikal a) {
        try {
            this.tfRG.setVal((Object)a.getOznRobGr());
            this.dfPakovanje.setVal((Object)a.getStandPak());
            Stanje s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(a.getId().getSfrProizvod(), this.umanjenje.getRadnajedinica()));
            this.dfRasKolicina.setVal((Object)(s != null ? s.getKolicina() - s.getAlocKolicina() : 0.0));
            this.dfZadnjaNC.setVal((Object)(s != null ? s.getZadNabCena() : 0.0));
            this.dfProdajnaCena.setVal((Object)(s != null ? s.getProdCena() : 0.0));
            this.dfProsecnaNC.setVal((Object)(s != null ? s.getProsNabCena() : Double.valueOf(0.0)));
            this.dfPlanskaCena.setVal((Object)a.getCenaPlanska());
            this.tfProizvodjac.setVal((Object)(a.getProizvodjac() != null ? a.getSfrProizvodjac() : ""));
            this.tfJedMere.setVal((Object)a.getJedMere());
            if (!this.izmena) {
                if (s != null) {
                    if (this.umanjenje.getRadnajedinica().getgTip().equals("V") && this.umanjenje.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                        this.dfCena.setVal((Object)s.getProsNabCena());
                    } else {
                        this.dfCena.setVal((Object)s.getProdCena());
                    }
                } else {
                    this.dfCena.setVal((Object)0.0);
                }
            }
            this.dfCena.setEnabled(true);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        this.a = (Stanjeartikal)entity;
        this.tfSifraArtikla.setVal((Object)this.a.getId().getSfrProizvod());
        try {
            this.art = (Artikal)PzEntityManager.find(Artikal.class, (Object)this.a.getId().getSfrProizvod());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        this.stopPDV = this.art.getStopa("PDV");
        this.naziv = this.a.getNaziv();
        this.tg = this.art.getTarifnaGrupa("PDV").getOznTarGr();
        this.jm = this.a.getJedMere();
        this.lokacija = this.a.getStalaza() == null ? "00" : (String.valueOf(this.a.getStalaza()) + this.a.getNivo() == null ? "00" : (String.valueOf(this.a.getNivo()) + this.a.getPaleta() == null ? "00" : this.a.getPaleta()));
        this.dfKolicina.requestFocus();
        this.setStanje(this.a);
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Unos podataka");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/book_blue_add.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena podataka");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/book_blue_add.png")));
    }

    public static Object getGUIBuilderInstance() {
        return new Dodavanje(Boolean.FALSE);
    }

    public Dodavanje(Boolean initGUI) {
    }

    private PzPanel getJPanelPromet() {
        if (this.jPanelPromet == null) {
            this.jPanelPromet = new PzPanel();
            this.jPanelPromet.setBorder((Border)BorderFactory.createTitledBorder(null, "Promet", 4, 0, new Font("Segoe UI", 1, 12), new Color(0, 0, 165)));
            this.jPanelPromet.setOpaque(false);
            GridBagLayout jPanelPrometLayout = new GridBagLayout();
            this.jPanelPromet.setPreferredSize(new Dimension(359, 297));
            jPanelPrometLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            jPanelPrometLayout.rowHeights = new int[]{7, 20, 20, 20, 20, 20, 20, 7, 7, 7};
            jPanelPrometLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            jPanelPrometLayout.columnWidths = new int[]{163, 100, 20};
            this.jPanelPromet.setLayout((LayoutManager)jPanelPrometLayout);
            this.jPanelPromet.setFocusable(false);
            this.jPanelPromet.add((Component)this.getJLabel1(), (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel2(), (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel3(), (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel4(), (Object)new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel5(), (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel6(), (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel7(), (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel8(), (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel9(), (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getJLabel10(), (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanelPromet.add((Component)this.getDfProdajnaCena(), (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getDfProsecnaNC(), (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getDfPlanskaCena(), (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getDfZadnjaNC(), (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getDfRasKolicina(), (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getDfPakovanje(), (Object)new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getTfTG(), (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getTfRG(), (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getTfProizvodjac(), (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanelPromet.add((Component)this.getTfJedMere(), (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.jPanelPromet;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Raspolo\u017eiva koli\u010dina");
        }
        return this.jLabel1;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Proizvo\u0111a\u010d");
        }
        return this.jLabel2;
    }

    private JLabel getJLabel3() {
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Jedinica mere");
        }
        return this.jLabel3;
    }

    private JLabel getJLabel4() {
        if (this.jLabel4 == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("Pakovanje");
        }
        return this.jLabel4;
    }

    private JLabel getJLabel5() {
        if (this.jLabel5 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("Prodajna cena");
        }
        return this.jLabel5;
    }

    private JLabel getJLabel6() {
        if (this.jLabel6 == null) {
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("Tarifna grupa");
        }
        return this.jLabel6;
    }

    private JLabel getJLabel7() {
        if (this.jLabel7 == null) {
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("Robna grupa");
        }
        return this.jLabel7;
    }

    private JLabel getJLabel8() {
        if (this.jLabel8 == null) {
            this.jLabel8 = new JLabel();
            this.jLabel8.setText("Prose\u010dna nabavna cena");
        }
        return this.jLabel8;
    }

    private JLabel getJLabel9() {
        if (this.jLabel9 == null) {
            this.jLabel9 = new JLabel();
            this.jLabel9.setText("Planska cena");
        }
        return this.jLabel9;
    }

    private JLabel getJLabel10() {
        if (this.jLabel10 == null) {
            this.jLabel10 = new JLabel();
            this.jLabel10.setText("Zadnja nabavna cena");
        }
        return this.jLabel10;
    }

    private PzDoubleField getDfProdajnaCena() {
        if (this.dfProdajnaCena == null) {
            this.dfProdajnaCena = new PzDoubleField();
            this.dfProdajnaCena.setFont(new Font("Tahoma", 0, 14));
            this.dfProdajnaCena.setPreferredSize(new Dimension(60, 24));
            this.dfProdajnaCena.setSize(60, 24);
            this.dfProdajnaCena.setFocusable(false);
            this.dfProdajnaCena.setEditable(false);
        }
        return this.dfProdajnaCena;
    }

    private PzDoubleField getDfProsecnaNC() {
        if (this.dfProsecnaNC == null) {
            this.dfProsecnaNC = new PzDoubleField();
            this.dfProsecnaNC.setFont(new Font("Tahoma", 0, 14));
            this.dfProsecnaNC.setPreferredSize(new Dimension(60, 24));
            this.dfProsecnaNC.setSize(60, 24);
            this.dfProsecnaNC.setFocusable(false);
            this.dfProsecnaNC.setEditable(false);
        }
        return this.dfProsecnaNC;
    }

    private PzDoubleField getDfPlanskaCena() {
        if (this.dfPlanskaCena == null) {
            this.dfPlanskaCena = new PzDoubleField();
            this.dfPlanskaCena.setFont(new Font("Tahoma", 0, 14));
            this.dfPlanskaCena.setPreferredSize(new Dimension(60, 24));
            this.dfPlanskaCena.setSize(60, 24);
            this.dfPlanskaCena.setFocusable(false);
            this.dfPlanskaCena.setEditable(false);
        }
        return this.dfPlanskaCena;
    }

    private PzDoubleField getDfZadnjaNC() {
        if (this.dfZadnjaNC == null) {
            this.dfZadnjaNC = new PzDoubleField();
            this.dfZadnjaNC.setFont(new Font("Tahoma", 0, 14));
            this.dfZadnjaNC.setPreferredSize(new Dimension(60, 24));
            this.dfZadnjaNC.setSize(60, 24);
            this.dfZadnjaNC.setFocusable(false);
            this.dfZadnjaNC.setEditable(false);
        }
        return this.dfZadnjaNC;
    }

    private PzDoubleField getDfRasKolicina() {
        if (this.dfRasKolicina == null) {
            this.dfRasKolicina = new PzDoubleField();
            this.dfRasKolicina.setFont(new Font("Tahoma", 0, 14));
            this.dfRasKolicina.setPreferredSize(new Dimension(60, 24));
            this.dfRasKolicina.setSize(60, 24);
            this.dfRasKolicina.setFocusable(false);
            this.dfRasKolicina.setEditable(false);
        }
        return this.dfRasKolicina;
    }

    private PzDoubleField getDfPakovanje() {
        if (this.dfPakovanje == null) {
            this.dfPakovanje = new PzDoubleField();
            this.dfPakovanje.setFont(new Font("Tahoma", 0, 14));
            this.dfPakovanje.setPreferredSize(new Dimension(60, 24));
            this.dfPakovanje.setSize(60, 24);
            this.dfPakovanje.setFocusable(false);
            this.dfPakovanje.setEditable(false);
        }
        return this.dfPakovanje;
    }

    private PzTextField getTfTG() {
        if (this.tfTG == null) {
            this.tfTG = new PzTextField();
            this.tfTG.setFont(new Font("Tahoma", 0, 14));
            this.tfTG.setPreferredSize(new Dimension(60, 24));
            this.tfTG.setSize(60, 24);
            this.tfTG.setFocusable(false);
            this.tfTG.setEditable(false);
        }
        return this.tfTG;
    }

    private PzTextField getTfRG() {
        if (this.tfRG == null) {
            this.tfRG = new PzTextField();
            this.tfRG.setFont(new Font("Tahoma", 0, 14));
            this.tfRG.setPreferredSize(new Dimension(60, 24));
            this.tfRG.setSize(60, 24);
            this.tfRG.setFocusable(false);
            this.tfRG.setEditable(false);
        }
        return this.tfRG;
    }

    private PzTextField getTfProizvodjac() {
        if (this.tfProizvodjac == null) {
            this.tfProizvodjac = new PzTextField();
            this.tfProizvodjac.setFont(new Font("Tahoma", 0, 14));
            this.tfProizvodjac.setPreferredSize(new Dimension(60, 24));
            this.tfProizvodjac.setSize(60, 24);
            this.tfProizvodjac.setFocusable(false);
            this.tfProizvodjac.setEditable(false);
        }
        return this.tfProizvodjac;
    }

    private PzTextField getTfJedMere() {
        if (this.tfJedMere == null) {
            this.tfJedMere = new PzTextField();
            this.tfJedMere.setFont(new Font("Tahoma", 0, 14));
            this.tfJedMere.setPreferredSize(new Dimension(60, 24));
            this.tfJedMere.setSize(60, 24);
            this.tfJedMere.setFocusable(false);
            this.tfJedMere.setEditable(false);
        }
        return this.tfJedMere;
    }
}

