/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.avansi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.avansi.PzDialogIzbor;
import rs.pezar.analitike.gui.avansi.PzDialogIzborDatumaKarticaAvansa;
import rs.pezar.analitike.gui.avansi.PzDialogIzborDokumentaKarticaAvansa;
import rs.pezar.analitike.gui.avansi.PzDialogUpitKomitent;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.util.PzDateUtility;

public class PzDialogKarticaAvansa
extends PzDialog {
    private JToolBar jToolBar1;
    private JScrollPane jScrollPane1;
    private PzToolBarIcon icoSlikaDokumenta;
    private PzToolBarIcon icoUpitUPodatke;
    private PzPanel contentPanel;
    private PzPanel panelData;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzDoubleField txtSaldo;
    private PzDoubleField txtPotrazuje;
    private PzDoubleField txtDuguje;
    private PzToolBarIcon icoStampaDo;
    private PzToolBarIcon icoStampa;
    private PzToolBarIcon icoNadjiDokumenta;
    private PzToolBarIcon icoUpitUNalog;
    private PzToolBarIcon icoGarancije;
    private PzTable table;
    private PzPanel pzPanel1;
    private Komitent komitent;
    private String oznKomitenta;
    private Date datumDo;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogKarticaAvansa inst = new PzDialogKarticaAvansa(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogKarticaAvansa(JFrame frame) {
        super(frame);
        this.initGUI();
        this.datumDo = PzDateUtility.getCurrentDate();
    }

    private void initGUI() {
        try {
            this.contentPanel = new PzPanel();
            this.contentPanel.setPaintGradient(true);
            BorderLayout contentPanelLayout = new BorderLayout();
            this.getContentPane().add((Component)this.contentPanel, "Center");
            this.contentPanel.setLayout((LayoutManager)contentPanelLayout);
            this.jToolBar1 = new PzToolBar();
            this.jToolBar1.setOpaque(false);
            this.contentPanel.add((Component)this.jToolBar1, (Object)"North");
            this.jToolBar1.setPreferredSize(new Dimension(924, 97));
            this.icoSlikaDokumenta = new PzToolBarIcon();
            this.jToolBar1.add((Component)this.icoSlikaDokumenta);
            this.icoSlikaDokumenta.setName("icoSlikaDokumenta");
            this.icoSlikaDokumenta.setPreferredSize(new Dimension(66, 67));
            this.icoSlikaDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/documents.png")));
            this.icoUpitUPodatke = new PzToolBarIcon();
            this.jToolBar1.add((Component)this.icoUpitUPodatke);
            this.icoUpitUPodatke.setName("icoUpitUPodatke");
            this.icoUpitUPodatke.setPreferredSize(new Dimension(62, 67));
            this.icoUpitUPodatke.addActionListener((ActionListener)((Object)this));
            this.icoUpitUPodatke.setActionCommand("upit");
            this.icoUpitUPodatke.setShortcut("F3");
            this.icoUpitUPodatke.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/businessman_text.png")));
            this.icoGarancije = new PzToolBarIcon();
            this.jToolBar1.add((Component)this.icoGarancije);
            this.icoGarancije.setName("icoGarancije");
            this.icoGarancije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/businessman_search.png")));
            this.icoUpitUNalog = new PzToolBarIcon();
            this.jToolBar1.add((Component)this.icoUpitUNalog);
            this.icoUpitUNalog.setName("icoUpitUNalog");
            this.icoUpitUNalog.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document_info48x48.png")));
            this.icoUpitUNalog.setActionCommand("upit_u_nalog");
            this.icoUpitUNalog.addActionListener((ActionListener)((Object)this));
            this.icoNadjiDokumenta = new PzToolBarIcon();
            this.jToolBar1.add((Component)this.icoNadjiDokumenta);
            this.icoNadjiDokumenta.setName("icoNadjiDokumenta");
            this.icoNadjiDokumenta.setPreferredSize(new Dimension(68, 67));
            this.icoNadjiDokumenta.addActionListener((ActionListener)((Object)this));
            this.icoNadjiDokumenta.setActionCommand("trazi_dokument");
            this.icoNadjiDokumenta.setShortcut("F8");
            this.icoNadjiDokumenta.setText("Na\u0111i dokument");
            this.icoNadjiDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/documentsearch.png")));
            this.icoStampa = new PzToolBarIcon();
            this.jToolBar1.add((Component)this.icoStampa);
            this.icoStampa.setName("icoStampa");
            this.icoStampa.addActionListener((ActionListener)((Object)this));
            this.icoStampa.setActionCommand("stampaj_pripremno");
            this.icoStampa.setShortcut("ALT+S");
            this.icoStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icoStampaDo = new PzToolBarIcon();
            this.jToolBar1.add((Component)this.icoStampaDo);
            this.icoStampaDo.setName("pzToolBarIcon1");
            this.icoStampaDo.addActionListener((ActionListener)((Object)this));
            this.icoStampaDo.setActionCommand("stampaj_do");
            this.icoStampaDo.setShortcut("ALT+D");
            this.icoStampaDo.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.pzPanel1 = new PzPanel();
            this.contentPanel.add((Component)this.pzPanel1, (Object)"Center");
            GridBagLayout pzPanel1Layout = new GridBagLayout();
            this.pzPanel1.setLayout((LayoutManager)pzPanel1Layout);
            pzPanel1Layout.rowWeights = new double[]{0.1};
            pzPanel1Layout.rowHeights = new int[]{7};
            pzPanel1Layout.columnWeights = new double[]{0.1};
            pzPanel1Layout.columnWidths = new int[]{7};
            this.jScrollPane1 = new JScrollPane();
            GridBagConstraints gbc_scp = new GridBagConstraints();
            gbc_scp.insets = new Insets(5, 5, 0, 5);
            gbc_scp.fill = 1;
            gbc_scp.gridx = 0;
            gbc_scp.gridy = 0;
            this.pzPanel1.add((Component)this.jScrollPane1, (Object)gbc_scp);
            this.table = new PzTable();
            this.tableFilter(this.table);
            this.jScrollPane1.setViewportView((Component)this.table);
            this.panelData = new PzPanel();
            this.contentPanel.add((Component)this.panelData, (Object)"South");
            this.panelData.setLayout(null);
            this.panelData.setPreferredSize(new Dimension(924, 71));
            this.jLabel1 = new JLabel();
            this.panelData.add((Component)this.jLabel1);
            this.jLabel1.setBounds(205, 33, 56, 16);
            this.jLabel1.setName("jLabel1");
            this.jLabel2 = new JLabel();
            this.panelData.add((Component)this.jLabel2);
            this.jLabel2.setBounds(12, 33, 42, 16);
            this.jLabel2.setName("jLabel2");
            this.jLabel3 = new JLabel();
            this.panelData.add((Component)this.jLabel3);
            this.jLabel3.setBounds(410, 33, 39, 17);
            this.jLabel3.setName("jLabel3");
            this.txtDuguje = this.table.createExpresionField("$3$");
            this.panelData.add((Component)this.txtDuguje);
            this.txtDuguje.setBounds(59, 28, 134, 26);
            this.txtDuguje.setEnabled(false);
            this.txtPotrazuje = this.table.createExpresionField("$4$");
            this.panelData.add((Component)this.txtPotrazuje, (Object)"South");
            this.txtPotrazuje.setEnabled(false);
            this.txtPotrazuje.setBounds(264, 28, 132, 30);
            this.txtPotrazuje.setSize(132, 26);
            this.txtSaldo = this.table.createExpresionField("$3$-$4$");
            this.panelData.add((Component)this.txtSaldo, (Object)"East");
            this.txtSaldo.setBounds(449, 28, 133, 26);
            this.txtSaldo.setEnabled(false);
            this.txtSaldo.setSize(134, 26);
            this.pack();
            this.setSize(940, 640);
            this.setMinimumSize(new Dimension(940, 640));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        try {
            if (actionCommand.equalsIgnoreCase("upit")) {
                this.getSession().putParameter("update", (Object)true);
                this.getSession().putParameter("komitent", (Object)this.komitent);
                this.showDialog(PzDialogUpitKomitent.class);
            } else if (actionCommand.equalsIgnoreCase("trazi_dokument")) {
                this.showDialog(PzDialogIzborDokumentaKarticaAvansa.class);
                String oznDok = (String)this.getSession().getParameter("oznDokumenta");
                if (oznDok == null) {
                    return;
                }
                int i = 0;
                while (i < this.table.getRowCount()) {
                    if (((Uplata)this.table.getEntity(i)).getOznDokumenta().equalsIgnoreCase(oznDok)) {
                        this.table.setRowSelectionInterval(i, i);
                        return;
                    }
                    ++i;
                }
            } else {
                if (actionCommand.equalsIgnoreCase("stampaj_pripremno")) {
                    this.showReport();
                    return;
                }
                if (actionCommand.equalsIgnoreCase("stampaj_do")) {
                    this.showDialog(PzDialogIzborDatumaKarticaAvansa.class);
                    this.datumDo = (Date)this.getSession().getParameter("datumDo");
                    this.showReport();
                    this.datumDo = PzDateUtility.getCurrentDate();
                    return;
                }
                if (actionCommand.equals("upit_u_nalog")) {
                    PzGenericService gs = PzApplication.getApplication().getGenericServiceRegistry().getService("NZK_SERVICE");
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("NZK_DOKUMENT", this.table.getSelectedEntity());
                    params.put("NZK_PARENT_DIALOG", (Object)this);
                    gs.run(params);
                    return;
                }
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public boolean shouldBeShown() {
        this.oznKomitenta = PzDialogIzbor.getSelectedKomitent(this);
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        if (this.oznKomitenta == null) {
            return false;
        }
        if (this.oznKomitenta.equalsIgnoreCase("")) {
            return false;
        }
        this.table.setData(this.tableData(this.createQuery()), Uplata.class);
        this.table.calculateFields();
        this.setTitle("Kartica avansa " + (this.oznKomitenta.equalsIgnoreCase("Kupac") ? "KUPCA" : "DOBAVLJA\u010cA") + " " + this.komitent.getSfrKomitent() + "/" + this.komitent.getNaziv());
        this.setFirstComponentInFocus((Component)this.table);
        return true;
    }

    private void tableFilter(PzTable table) {
        table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Uplata u = (Uplata)entity;
                BigDecimal duguje = new BigDecimal(0);
                BigDecimal potrazujeUPL = new BigDecimal(0);
                BigDecimal potrazujePOV = new BigDecimal(0);
                BigDecimal potrazuje = new BigDecimal(0);
                if (PzDialogKarticaAvansa.this.oznKomitenta.equalsIgnoreCase("Kupac")) {
                    duguje = u.getTip().equalsIgnoreCase(TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC) ? u.getIznosSaPorezom() : new BigDecimal(0.0);
                    potrazujeUPL = u.getTip().equalsIgnoreCase(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS) ? u.getIznosSaPorezom() : new BigDecimal(0.0);
                    potrazujePOV = u.getTip().equalsIgnoreCase(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ) ? u.getIznosSaPorezom() : new BigDecimal(0.0);
                    potrazujePOV = potrazujePOV.multiply(new BigDecimal(-1));
                    potrazuje = potrazujePOV.add(potrazujeUPL);
                    if (u.getTip().equalsIgnoreCase("PRIMLJEN_AVANS")) {
                        u.getOznDokumenta();
                    } else {
                        u.getOznDokumenta();
                    }
                } else if (PzDialogKarticaAvansa.this.oznKomitenta.equalsIgnoreCase("Dobavljac")) {
                    potrazuje = u.getTip().equalsIgnoreCase(TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC) ? u.getIznosSaPorezom() : new BigDecimal(0.0);
                    BigDecimal dugujeUPL = u.getTip().equalsIgnoreCase(TipDokumentConfig.get().UPLATA_DAT_AVANS) ? u.getIznosSaPorezom() : new BigDecimal(0.0);
                    BigDecimal dugujePOV = u.getTip().equalsIgnoreCase(TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ) ? u.getIznosSaPorezom() : new BigDecimal(0.0);
                    dugujePOV = dugujePOV.multiply(new BigDecimal(-1));
                    duguje = dugujePOV.add(dugujeUPL);
                }
                return new Object[]{u.getDatum(), String.valueOf(u.getOpis()) + " po " + u.getOznDokumenta(), u.getOznDokumenta(), duguje, potrazuje, u.getSaldo(), u.getProknjizen() == 1 ? "DA" : "NE"};
            }

            public String[] getColumnNames() {
                return new String[]{"Datum", "Opis", "Faktura", "Duguje", "Potra\u017euje", "Saldo", "Proknji\u017een"};
            }
        });
    }

    private String createQuery() {
        String query = "";
        query = this.oznKomitenta.equalsIgnoreCase("Kupac") ? "SELECT u FROM Uplata u WHERE (u.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS + "' OR u.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC + "' OR u.tip='" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ + "') AND  u.komitent.sfrKomitent = '" + this.komitent.getSfrKomitent() + "' AND u.arhiviran != -1 ORDER BY u.datum" : "SELECT u FROM Uplata u WHERE (u.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' OR u.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "' OR u.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "') AND u.komitent.sfrKomitent = '" + this.komitent.getSfrKomitent() + "' AND u.arhiviran != -1 ORDER BY u.datum";
        return query;
    }

    private Vector tableData(String query) {
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery(query);
        Vector data = (Vector)q.getResultList();
        BigDecimal saldo = new BigDecimal(0);
        int i = 0;
        while (i < data.size()) {
            Uplata upl = (Uplata)data.get(i);
            upl.setNzk(this.nzk(upl.getIdDok(), em));
            if (this.oznKomitenta.equalsIgnoreCase("Kupac")) {
                BigDecimal duguje = upl.getTip().equalsIgnoreCase(TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC) ? upl.getIznosSaPorezom() : new BigDecimal(0.0);
                BigDecimal potrazujeUPL = upl.getTip().equalsIgnoreCase(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS) ? upl.getIznosSaPorezom() : new BigDecimal(0.0);
                BigDecimal potrazujePOV = upl.getTip().equalsIgnoreCase(TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ) ? upl.getIznosSaPorezom() : new BigDecimal(0.0);
                potrazujePOV = potrazujePOV.multiply(new BigDecimal(-1));
                BigDecimal potrazuje = potrazujePOV.add(potrazujeUPL);
                saldo = saldo.add(duguje).subtract(potrazuje);
            } else {
                BigDecimal potrazuje = upl.getTip().equalsIgnoreCase(TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC) ? upl.getIznosSaPorezom() : new BigDecimal(0.0);
                BigDecimal dugujeUPL = upl.getTip().equalsIgnoreCase(TipDokumentConfig.get().UPLATA_DAT_AVANS) ? upl.getIznosSaPorezom() : new BigDecimal(0.0);
                BigDecimal dugujePOV = upl.getTip().equalsIgnoreCase(TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ) ? upl.getIznosSaPorezom() : new BigDecimal(0.0);
                dugujePOV = dugujePOV.multiply(new BigDecimal(-1));
                BigDecimal duguje = dugujePOV.add(dugujeUPL);
                saldo = saldo.add(duguje).subtract(potrazuje);
            }
            ((Uplata)data.get(i)).setSaldo(saldo);
            ++i;
        }
        return data;
    }

    private int nzk(int iddok, EntityManager em) {
        String query = "SELECT DISTINCT(n.id.idNalog) FROM Stavkanzk n WHERE n.dokument.idDok=" + iddok + " AND n.dokument.idDok IS NOT NULL";
        Query q = em.createQuery(query);
        int idNalog = 0;
        idNalog = q.getResultList().size() == 0 ? 0 : (Integer)q.getSingleResult();
        return idNalog;
    }

    private void showReport() {
        try {
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("datum", new Date(new java.util.Date().getTime()));
            String title = null;
            String fname = null;
            title = this.oznKomitenta.equalsIgnoreCase("Kupac") ? "Analiti\u010dka kartica avansa kupca: " + this.komitent.getSfrKomitent() + " / " + this.komitent.getNaziv() : "Analiti\u010dka kartica avansa dobavlja\u010da: " + this.komitent.getSfrKomitent() + " / " + this.komitent.getNaziv();
            fname = "rs/pezar/reports/compiled/kartica.avansa.jasper";
            params.put("datumDo", this.datumDo);
            params.put("title", title);
            params.put("reklama", "");
            try {
                PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)fname, params, (String)title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKarticaAvansa(Boolean.FALSE);
    }

    public PzDialogKarticaAvansa(Boolean initGUI) {
    }
}

