/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.knjiznoZaduzenjeRazduzenje;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzToolBarIcon;

public class PzDialogIzborDokumenata
extends PzDialog {
    private PzPanel pnlTable;
    private JScrollPane jScrollPane1;
    private PzToolBarIcon btnIzborDok;
    private PzToolBar jToolBar1;
    private PzTable table;
    private Vector tableData;
    private EntityManager em;
    private String oznKomitenta;
    private Vector tableDataNeplacene;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogIzborDokumenata inst = new PzDialogIzborDokumenata(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogIzborDokumenata(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogIzborDokumenata(PzDialog dialog) {
        super(dialog);
        this.oznKomitenta = (String)this.getSession().getParameter("oznKomitenta");
        this.initGUI();
        if (this.oznKomitenta.equalsIgnoreCase("Kupac")) {
            this.table.setData(this.getData(), Faktura.class);
        } else {
            this.table.setData(this.getData(), Kalkulacija.class);
        }
        this.setFirstComponentInFocus((Component)this.table);
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Izbor dokumenata za komitenta");
            this.jToolBar1 = new PzToolBar();
            this.getContentPane().add((Component)this.jToolBar1, "North");
            this.jToolBar1.setPreferredSize(new Dimension(769, 85));
            this.btnIzborDok = new PzToolBarIcon();
            FlowLayout btnIzborDokLayout = new FlowLayout();
            this.btnIzborDok.setLayout((LayoutManager)btnIzborDokLayout);
            this.jToolBar1.add((Component)this.btnIzborDok);
            this.btnIzborDok.setName("btnIzborDok");
            this.btnIzborDok.addActionListener((ActionListener)((Object)this));
            this.btnIzborDok.setActionCommand("samo_neplacene");
            this.btnIzborDok.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/currency_dollar.png")));
            this.btnIzborDok.setPreferredSize(new Dimension(63, 81));
            this.pnlTable = new PzPanel();
            AnchorLayout pnlTableLayout = new AnchorLayout();
            this.getContentPane().add((Component)this.pnlTable, "Center");
            this.pnlTable.setPreferredSize(new Dimension(769, 378));
            this.pnlTable.setLayout((LayoutManager)pnlTableLayout);
            this.jScrollPane1 = new JScrollPane();
            this.pnlTable.add((Component)this.jScrollPane1, (Object)new AnchorConstraint(19, 7, 966, 12, 1, 2, 1, 2));
            this.jScrollPane1.setPreferredSize(new Dimension(750, 358));
            this.table = new PzTable();
            this.jScrollPane1.setViewportView((Component)this.table);
            this.table.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Object[] o = new Object();
                    if (entity instanceof Faktura) {
                        Faktura f = (Faktura)entity;
                        o = new Object[]{f.getOznDokumenta(), f.getIznos(), f.getIznos().subtract(f.getStornoIznos()).subtract(f.getUplata()), f.getDatum(), f.getDatValute()};
                    } else {
                        Kalkulacija k = (Kalkulacija)entity;
                        o = new Object[]{k.getOznDokumenta(), k.getIznos(), k.getIznos().subtract(k.getStornoIznos()).subtract(k.getUplata()), k.getDatum(), k.getDatValute()};
                    }
                    return o;
                }

                public String[] getColumnNames() {
                    return new String[]{"Oznaka dokumenta", "Iznos", "Dug po dokument", "Datum dokumenta", "Datum valute"};
                }
            });
            this.setSize(785, 460);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
        if (actionCommand.equalsIgnoreCase("samo_neplacene")) {
            if (this.oznKomitenta.equalsIgnoreCase("Kupac")) {
                this.table.setData(this.getSamoNeplacene(), Faktura.class);
            } else {
                this.table.setData(this.getSamoNeplacene(), Kalkulacija.class);
            }
        }
    }

    public Vector getData() {
        this.em = PzEntityManager.getEm();
        Query q = null;
        if (this.oznKomitenta.equalsIgnoreCase("Kupac")) {
            String query = "SELECT f FROM Faktura f WHERE f.arhiviran = 1 AND f.storno = 0 AND f.komitent.sfrKomitent=" + ((Komitent)this.getSession().getParameter("komitent")).getSfrKomitent() + " AND (f.tip='" + TipDokumentConfig.get().FAKTURA + "'" + " OR f.tip='" + TipDokumentConfig.get().FAKTURA_SERVISA + "' OR f.tip='" + TipDokumentConfig.get().FAKTURA_USLUGA + "')";
            q = this.em.createQuery(query);
        } else {
            ArrayList<String> podTipovi = new ArrayList<String>();
            podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA);
            podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA);
            String query = "SELECT k FROM Kalkulacija k WHERE k.arhiviran = 1 AND k.storno = 0 AND (k.podTip NOT IN :podTipovi OR k.podTip IS NULL) AND k.komitent.sfrKomitent=" + ((Komitent)this.getSession().getParameter("komitent")).getSfrKomitent();
            q = this.em.createQuery(query).setParameter("podTipovi", podTipovi);
        }
        this.tableData = (Vector)q.getResultList();
        this.em.clear();
        this.em.close();
        return this.tableData;
    }

    public Vector getSamoNeplacene() {
        this.em = PzEntityManager.getEm();
        Query q = null;
        if (this.oznKomitenta.equalsIgnoreCase("Kupac")) {
            String query = "SELECT f FROM Faktura f WHERE f.arhiviran = 1 AND f.storno = 0 AND f.komitent.sfrKomitent=" + ((Komitent)this.getSession().getParameter("komitent")).getSfrKomitent() + " AND (f.tip='" + TipDokumentConfig.get().FAKTURA + "'" + " OR f.tip='" + TipDokumentConfig.get().FAKTURA_SERVISA + "' OR f.tip='" + TipDokumentConfig.get().FAKTURA_USLUGA + "') AND f.iznos-f.stornoIznos-f.uplata<>0";
            q = this.em.createQuery(query);
        } else {
            ArrayList<String> podTipovi = new ArrayList<String>();
            podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA);
            podTipovi.add(TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA);
            String query = "SELECT k FROM Kalkulacija k WHERE k.arhiviran = 1 AND k.storno = 0 AND (k.podTip NOT IN :podTipovi OR k.podTip IS NULL) AND ((k.iznos-k.stornoIznos-k.uplata)<>0) AND k.komitent.sfrKomitent=" + ((Komitent)this.getSession().getParameter("komitent")).getSfrKomitent();
            q = this.em.createQuery(query).setParameter("podTipovi", podTipovi);
        }
        this.tableDataNeplacene = (Vector)q.getResultList();
        this.em.clear();
        this.em.close();
        return this.tableDataNeplacene;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogIzborDokumenata(Boolean.FALSE);
    }

    public PzDialogIzborDokumenata(Boolean initGUI) {
    }
}

