/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.komitenti;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.analitike.PzFinansijeManager;
import rs.pezar.analitike.gui.komitenti.PzDialogObracunKamate;
import rs.pezar.analitike.gui.komitenti.kartcaKomitenata.IzborKomitenta;
import rs.pezar.analitike.gui.komitenti.kartcaKomitenata.IzborValute;
import rs.pezar.analitike.gui.komitenti.kartcaKomitenata.KarticaKomitentaBody;
import rs.pezar.analitike.gui.komitenti.kartcaKomitenata.PzCellRendererKarticaKomitenta;
import rs.pezar.analitike.tableModels.PzTableModelKarticaKomitenta;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Komitent;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.komintenti.Garancije;
import rs.pezar.sifarnici.util.UpitUPodatke;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTable;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzDateUtility;

public class PzDialogKarticaKomitenata
extends PzDialog {
    public static byte KARTICA_KUPCA = 0;
    public static byte KARTICA_DOBAVLJACA = 1;
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    private PzToolBarIcon icnUpitUNalog;
    private PzToolBarIcon icnNadjiDokument;
    private JLabel lblstatus;
    private PzStatusBar pzStatusBar;
    private JScrollPane jScrollPane1;
    private PzScrollableTable table;
    private JPanel pzPanel1;
    private PzToolBarIcon icnGarancije;
    private PzToolBarIcon icnStampa;
    private PzToolBarIcon icnSlikaDokumenta;
    private String rtitle;
    private static Komitent komitent;
    private static IzborKomitenta izborKomitenta;
    private ScrollableCursor cursor;
    private PzTableModelKarticaKomitenta model;
    private PzEntity firma;
    private BigDecimal avans;
    private PzToolBarIcon icnObracunKamate;
    private EntityManager em;
    private String valuta = "EUR";
    private PzToolBarIcon icnValuta;
    private JLabel lblstranaValuta;
    private HashMap<String, Object> data;
    private PzPanel pzPanel1_1;
    private PzToolBarIcon icnFold;
    private BigDecimal valutaDanas;
    private PzToolBarIcon icnStampaValuta;
    private SwingWorker<ScrollableCursor, Object> worker;
    private final Calendar cal = Calendar.getInstance();
    private PzToolBarIcon icnUpitUPodatke;

    public String getValuta() {
        return this.valuta;
    }

    public PzDialogKarticaKomitenata(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogKarticaKomitenata(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void showKarticaKomitenta(PzDialog dialog, Komitent komitent1, byte kupacDobavljac) throws Exception {
        PzDialogKarticaKomitenata kartica = new PzDialogKarticaKomitenata(dialog);
        if (komitent1 == null) throw new Exception("Komitent ne moze biti null vrednost!");
        izborKomitenta = new IzborKomitenta(true);
        izborKomitenta.setKupac(true);
        izborKomitenta.setKomitent(komitent1);
        izborKomitenta.setPrikazSve(true);
        if (kupacDobavljac == KARTICA_DOBAVLJACA) {
            izborKomitenta.setDobavljac(true);
            izborKomitenta.setKupac(false);
        } else {
            izborKomitenta.setDobavljac(false);
            izborKomitenta.setKupac(true);
        }
        komitent = komitent1;
        if (kupacDobavljac == KARTICA_KUPCA) {
            kartica.rtitle = "kupca";
        } else {
            if (kupacDobavljac != KARTICA_DOBAVLJACA) throw new Exception("Prosledjena je losa vrednost za kupacDobavljac, koristiti staticke vrednosti klase.");
            kartica.rtitle = "dobavlja\u010da";
        }
        kartica.fillInTheInfo();
        kartica.restoreSize();
        kartica.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("stampa")) {
                this.onStampaPressed();
                return;
            }
            if (actionCommand.equals("garancije")) {
                this.onGarancijePressed();
                return;
            }
            if (actionCommand.equals("upitunalog")) {
                this.onUpitUNalogPressed();
                return;
            }
            if (actionCommand.equals("obracunkamate")) {
                this.onObracunKamatePressed();
                return;
            }
            if (actionCommand.equals("nadjidokument")) {
                this.onNadjiDokumentPressed();
                return;
            }
            if (actionCommand.equals("slikadokumenta")) {
                this.onSlikaDokumentaPressed();
                return;
            }
            if (actionCommand.equals("valuta")) {
                this.onValutaPressed();
                return;
            }
            if (actionCommand.equals("prikazi")) {
                this.onInfoPressed();
                return;
            }
            if (actionCommand.equals("stampaV")) {
                this.onStampaVPressed();
                return;
            }
            if (actionCommand.equals("upitUPodatke")) {
                this.onUpitUPodatkePressed();
                return;
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void onInfoPressed() {
        ((KarticaKomitentaBody)((Object)this.pzPanel1)).foldInfo();
    }

    private void onValutaPressed() {
        this.valuta = IzborValute.getValutaFromUser(this);
        if (this.valuta == null) {
            this.valuta = "";
        }
        this.fillInTheInfo();
    }

    private void onSlikaDokumentaPressed() {
        if (this.table.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati dokument iz tabele.", "Info", 1);
            return;
        }
        Integer iddok = (Integer)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(this.table.getSelectedRow()), this.table.getColumnByName("idDok").getModelIndex());
        PzDokument d = null;
        try {
            d = (PzDokument)PzEntityManager.find(Dokument.class, (Object)iddok);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)d);
    }

    private void initGUI() {
        this.data = new HashMap();
        try {
            this.setTitle("Analiti\u010dka kartica komitenta");
            this.setLocationByPlatform(true);
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setPreferredSize(new Dimension(1093, 722));
            this.pzStatusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.pzStatusBar, "South");
            this.pzStatusBar.setPreferredSize(new Dimension(922, 25));
            this.lblstatus = new JLabel();
            this.lblstranaValuta = new JLabel();
            this.pzStatusBar.add((Component)this.lblstatus);
            this.pzStatusBar.add((Component)this.lblstranaValuta);
            this.lblstatus.setName("lblstatus");
            this.toolbar = new JToolBar();
            this.getContentPane().add((Component)this.toolbar, "North");
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setAlignmentY(0.5f);
            this.toolbar.setBorder(new SoftBevelBorder(0, null, null, null, null));
            this.pzPanel1_1 = new PzPanel();
            this.pzPanel1 = new KarticaKomitentaBody(this.pzPanel1_1);
            this.getContentPane().add((Component)this.pzPanel1, "Center");
            BorderLayout pzPanel1Layout = new BorderLayout();
            this.pzPanel1_1.setLayout((LayoutManager)pzPanel1Layout);
            this.pzPanel1_1.setPreferredSize(new Dimension(842, 590));
            this.pzPanel1_1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.icnSlikaDokumenta = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSlikaDokumenta);
            this.icnSlikaDokumenta.setText("Slika|dokumenta (F2)");
            this.icnSlikaDokumenta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/document.png")));
            this.icnSlikaDokumenta.setActionCommand("slikadokumenta");
            this.icnSlikaDokumenta.setToolTipText("Prikazuje dokument ozna\u010den u tabeli (F2)");
            this.icnSlikaDokumenta.setPreferredSize(new Dimension(91, 84));
            this.icnSlikaDokumenta.addActionListener((ActionListener)((Object)this));
            this.icnSlikaDokumenta.setShortcut("F2");
            this.icnNadjiDokument = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnNadjiDokument);
            this.icnNadjiDokument.setText("Nadji|Dokument (F8)");
            this.icnNadjiDokument.setActionCommand("nadjidokument");
            this.icnNadjiDokument.setPreferredSize(new Dimension(91, 84));
            this.icnNadjiDokument.setToolTipText("Pretra\u017euje dokument vezan za ovog komitenta u tabeli (F8)");
            this.icnNadjiDokument.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/documentsearch.png")));
            this.icnNadjiDokument.setSize(91, 84);
            this.icnNadjiDokument.addActionListener((ActionListener)((Object)this));
            this.icnNadjiDokument.setShortcut("F8");
            this.icnFold = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnFold);
            this.icnFold.setText("Info(F7)");
            this.icnFold.setActionCommand("prikazi");
            this.icnFold.setPreferredSize(new Dimension(91, 84));
            this.icnFold.setToolTipText("Prikazuje i skriva informacije o komitentu");
            this.icnFold.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/form_blue.png")));
            this.icnFold.setSize(91, 84);
            this.icnFold.addActionListener((ActionListener)((Object)this));
            this.icnFold.setShortcut("F7");
            this.icnUpitUNalog = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUpitUNalog);
            this.icnUpitUNalog.setText("Upit u nalog|za knji\u017eenje(F5)");
            this.icnUpitUNalog.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note.png")));
            this.icnUpitUNalog.setActionCommand("upitunalog");
            this.icnUpitUNalog.setPreferredSize(new Dimension(91, 84));
            this.icnUpitUNalog.setToolTipText("Prikazuje nalog za knji\u017eenje obele\u017eenog dokumenta (F5)");
            this.icnUpitUNalog.setSize(91, 84);
            this.icnUpitUNalog.addActionListener((ActionListener)((Object)this));
            this.icnUpitUNalog.setShortcut("F5");
            this.icnGarancije = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnGarancije);
            this.icnGarancije.setText("Garancije|(F4)");
            this.icnGarancije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/businessman_text.png")));
            this.icnGarancije.setActionCommand("garancije");
            this.icnGarancije.setPreferredSize(new Dimension(91, 84));
            this.icnGarancije.setToolTipText("Prikazuje garancije pla\u0107anja kupca (F4)");
            this.icnGarancije.setSize(91, 84);
            this.icnGarancije.addActionListener((ActionListener)((Object)this));
            this.icnGarancije.setShortcut("F4");
            this.icnObracunKamate = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnObracunKamate);
            this.icnObracunKamate.setText("Obra\u010dun kamate|(ALT+K)");
            this.icnObracunKamate.setActionCommand("obracunkamate");
            this.icnObracunKamate.setPreferredSize(new Dimension(91, 84));
            this.icnObracunKamate.setToolTipText("Otvara dijalog za obra\u010dun kamate nad dokumentima van valute.");
            this.icnObracunKamate.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/percent_interest.png")));
            this.icnObracunKamate.addActionListener((ActionListener)((Object)this));
            this.icnObracunKamate.setShortcut("ALT+K");
            this.icnObracunKamate.setName("icnObracunKamate");
            this.icnValuta = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnValuta);
            this.icnValuta.setText("Valuta za|prikaz(ALT+V)");
            this.icnValuta.setActionCommand("valuta");
            this.icnValuta.setPreferredSize(new Dimension(91, 84));
            this.icnValuta.setToolTipText("Izbor valute u kojoj \u0107e biti prikazana ova kartica.");
            this.icnValuta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/currency_euro.png")));
            this.icnValuta.setSize(91, 84);
            this.icnValuta.addActionListener((ActionListener)((Object)this));
            this.icnValuta.setShortcut("ALT+V");
            this.icnStampa = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampa);
            this.icnStampa.setText("\u0160tampa|(ALT+S)");
            this.icnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampa.setActionCommand("stampa");
            this.icnStampa.setPreferredSize(new Dimension(91, 84));
            this.icnStampa.setToolTipText("\u0160tampa karticu komitenta (ALT+S)");
            this.icnStampa.addActionListener((ActionListener)((Object)this));
            this.icnStampa.setShortcut("ALT+S");
            this.icnStampaValuta = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampaValuta);
            this.icnStampaValuta.setText("\u0160tampa|s.valuta|(CTRL+ALT+S)");
            this.icnStampaValuta.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampaValuta.setActionCommand("stampaV");
            this.icnStampaValuta.setPreferredSize(new Dimension(91, 84));
            this.icnStampaValuta.setToolTipText("\u0160tampa karticu komitenta u stranoj valuti (CTRL+ALT+S)");
            this.icnStampaValuta.addActionListener((ActionListener)((Object)this));
            this.icnStampaValuta.setShortcut("CTRL+ALT+S");
            this.icnUpitUPodatke = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUpitUPodatke);
            this.icnUpitUPodatke.setText("Upit u|podatke (F3)");
            this.icnUpitUPodatke.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/message_edit.png")));
            this.icnUpitUPodatke.addActionListener((ActionListener)((Object)this));
            this.icnUpitUPodatke.setShortcut("F3");
            this.icnUpitUPodatke.setActionCommand("upitUPodatke");
            this.jScrollPane1 = new JScrollPane();
            this.pzPanel1_1.add((Component)this.jScrollPane1, (Object)"Center");
            this.jScrollPane1.setPreferredSize(new Dimension(900, 463));
            this.table = new PzScrollableTable();
            this.pack();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean shouldBeShown() {
        izborKomitenta = IzborKomitenta.GetNewInstance(this, true, true);
        komitent = izborKomitenta.GetKomitentIstance();
        if (komitent != null) {
            this.rtitle = izborKomitenta.isKupac() ? "kupca" : "dobavlja\u010da";
            this.fillInTheInfo();
            return true;
        }
        return false;
    }

    private void fillInTheInfo() {
        String datumi;
        String a;
        this.data.put("SIFRA", komitent.getSfrKomitent());
        this.data.put("TIP_KARTICE", new String(izborKomitenta.isKupac() ? "Kupac" : "Dobavlja\u010d"));
        this.data.put("NAZIV", komitent.getNaziv());
        this.data.put("KONTAKT", komitent.getKontakt());
        this.data.put("TELEFON", komitent.getTelefoni());
        this.data.put("ADRESA", komitent.getAdresa());
        this.data.put("MESTO", komitent.getGrad());
        this.setTitle("Kartica " + (izborKomitenta.isKupac() ? "Kupca" : "Dobavlja\u010da") + ": [" + komitent.getSfrKomitent() + "] " + komitent.getNaziv() + ", " + komitent.getAdresa() + ", " + komitent.getPostBroj() + " " + komitent.getGrad());
        try {
            this.firma = PzFirma.getFirma();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Query q = null;
        this.em = PzEntityManager.getEm();
        String val = "(SELECT k.srednji FROM Kurs k WHERE k.datum = '" + PzDateUtility.getCurrentDate() + "' AND k.oznvaluta = '" + this.valuta + "') ";
        q = this.em.createNativeQuery(val);
        try {
            this.valutaDanas = (BigDecimal)q.getSingleResult();
        }
        catch (Exception exception) {
            this.valutaDanas = null;
        }
        if (this.cursor != null && !this.cursor.isClosed()) {
            this.cursor.close();
        }
        if (izborKomitenta.isDobavljac()) {
            a = "SELECT  SUM(CASE \t\t\t\tWHEN b.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' THEN -b.iznos " + "\t\t\t\tWHEN b.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "' THEN  b.iznos " + "\t\t\t\tWHEN b.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "' THEN  b.iznos " + "\t\t\t\tELSE 0 " + "\t\t\t END) " + "FROM dokument b WHERE (b.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' OR b.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "' OR b.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "') AND b.sfrkomitent = '" + komitent.getSfrKomitent() + "' AND b.arhiviran = 1 ";
            if (izborKomitenta.isPrikazUPeriodu()) {
                a = String.valueOf(a) + " AND (b.datum >= '" + izborKomitenta.getDatePocetni().getVal() + "' and b.datum <= '" + izborKomitenta.getDateKrajnji().getVal() + "')";
            }
            q = this.em.createNativeQuery(a);
            this.avans = (BigDecimal)q.getSingleResult();
            if (this.avans == null) {
                this.avans = BigDecimal.ZERO;
            }
            a = "SELECT CASE\tWHEN (a.tip ='" + TipDokumentConfig.get().KALKULACIJA + "' OR a.tip ='" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "' OR a.tip ='" + TipDokumentConfig.get().TROSAK + "' OR a.tip ='" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "') THEN (SELECT k.datFakture FROM Kalkulacija k WHERE a.iddok = k.iddok )" + "\tELSE" + "\ta.datum " + "END, " + "a.tip, " + "a.oznDokumenta, " + "a.datValute, " + "a.iznos, " + "a.storno, " + "a.sfrkomitent, " + "a.rbroj, " + "a.idDok, " + "a.proknjizen, " + "a.podtip, " + "a.stornoiznos, " + "a.uplata, " + "(CASE WHEN (((a.tip ='" + TipDokumentConfig.get().KALKULACIJA + "' and a.podTip ='" + TipDokumentConfig.get().FAKTURA + "') or a.tip ='" + TipDokumentConfig.get().TROSAK + "') and " + "(Select k.domaciKomitent From Komitent k where a.sfrkomitent=k.sfrkomitent) = 0) " + "THEN (Select k.kurs From Kalkulacija k Where a.iddok = k.iddok and k.kurs <> 0) " + "ELSE (SELECT k.srednji FROM Kurs k WHERE a.datum = k.datum AND k.oznvaluta = '" + this.valuta + "') END)," + "(SELECT k.datFakture FROM Kalkulacija k WHERE a.iddok = k.iddok ) " + "FROM Dokument a " + "WHERE " + "a.sfrKomitent = '" + komitent.getSfrKomitent() + "' AND " + "a.arhiviran = 1 AND " + "((a.tip ='" + TipDokumentConfig.get().KALKULACIJA + "' AND (a.podTip ='" + TipDokumentConfig.get().FAKTURA + "' OR a.podTip ='POCETNO')) OR " + "a.tip = '" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "' OR " + "a.tip = '" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "' OR " + "a.tip = '" + TipDokumentConfig.get().ZATVARANJE_RASHODOM + "' OR " + "(a.tip = '" + TipDokumentConfig.get().OTPIS_POTRAZIVANJA + "' and a.podTip IN ('" + TipDokumentConfig.get().PODTIP_OTPIS_KALKULACIJA + "', '" + TipDokumentConfig.get().PODTIP_OTPIS_RACUN_DOBAVLJACA + "', '" + TipDokumentConfig.get().PODTIP_OTPIS_ZAPISNIK_OTPREMNICE + "')) OR " + "a.tip = '" + TipDokumentConfig.get().KNJIZNO_ZADUZENJE_DOBAVLJACA + "' OR " + "a.tip = '" + TipDokumentConfig.get().KNJIZNO_ODOBRENJE_DOBAVLJACA + "' OR " + "a.tip = '" + TipDokumentConfig.get().POCETNO_STANJE_UPLATA + "' OR " + "a.tip = '" + TipDokumentConfig.get().UPLATA_DOBAVLJACU + "' OR " + "a.tip = '" + TipDokumentConfig.get().PRENOS_SA_FAKTURE_DOBAVLJAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().PRENOS_NA_FAKTURU_DOBAVLJAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().SA_FAKTURE_U_AVANS + "' OR " + "a.tip = '" + TipDokumentConfig.get().TROSAK + "' OR " + "a.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().UPLATA_DOBAVLJACU_POVRACAJ + "' OR " + "a.tip = '" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "' OR " + "a.tip = '" + TipDokumentConfig.get().PRIJEMNICA_REPRO + "') " + " %s " + "ORDER BY 1, a.rbrdok ASC";
            datumi = izborKomitenta.isPrikazUPeriodu() ? " AND (a.datum >= '" + izborKomitenta.getDatePocetni().getVal() + "' and a.datum <= '" + izborKomitenta.getDateKrajnji().getVal() + "')" : "";
            a = String.format(a, datumi);
            q = this.em.createNativeQuery(a);
            q.setHint("eclipselink.cursor.scrollable", (Object)"True");
            this.cursor = (ScrollableCursor)q.getSingleResult();
        } else if (izborKomitenta.isKupac()) {
            a = "SELECT  SUM(CASE \t\t\t\tWHEN b.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS + "' THEN b.iznos " + "\t\t\t\tWHEN b.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ + "' THEN  -b.iznos " + "\t\t\t\tWHEN b.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC + "' THEN  -b.iznos " + "\t\t\t\tELSE 0 " + "\t\t\t END) " + "FROM dokument b WHERE (b.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS + "' OR b.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ + "' OR b.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC + "') AND b.sfrkomitent = '" + komitent.getSfrKomitent() + "' AND b.arhiviran = 1 ";
            if (izborKomitenta.isPrikazUPeriodu()) {
                a = String.valueOf(a) + " AND (b.datum >= '" + izborKomitenta.getDatePocetni().getVal() + "' and b.datum <= '" + izborKomitenta.getDateKrajnji().getVal() + "')";
            }
            q = this.em.createNativeQuery(a);
            this.avans = (BigDecimal)q.getSingleResult();
            if (this.avans == null) {
                this.avans = BigDecimal.ZERO;
            }
            a = "SELECT a.datum, a.tip, a.oznDokumenta, a.datValute, a.iznos, a.storno, a.sfrkomitent, a.rbroj, a.idDok, a.proknjizen, a.podtip, a.stornoiznos, a.uplata, (SELECT k.srednji FROM Kurs k WHERE a.datum = k.datum AND k.oznvaluta = '" + this.valuta + "')," + "a.datum  " + "FROM Dokument a " + "WHERE " + "a.sfrKomitent = '" + komitent.getSfrKomitent() + "' AND " + "a.arhiviran = 1 AND " + "(a.tip ='" + TipDokumentConfig.get().FAKTURA + "' OR " + "a.tip = '" + TipDokumentConfig.get().FAKTURA_SERVISA + "' OR " + "a.tip = '" + TipDokumentConfig.get().FAKTURA_USLUGA + "' OR " + "(a.tip = '" + TipDokumentConfig.get().OTPIS_POTRAZIVANJA + "' AND a.podTip='" + TipDokumentConfig.get().PODTIP_OTPIS_FAKTURA + "') OR " + "a.tip = '" + TipDokumentConfig.get().ZATVARANJE_PRIHODOM + "' OR " + "a.tip = '" + TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA + "' OR " + "a.tip = '" + TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA + "' OR " + "a.tip = '" + TipDokumentConfig.get().POCETNO_STANJE_UPLATA + "' OR " + "a.tip = '" + TipDokumentConfig.get().UPLATA_KUPCA + "' OR " + "a.tip = '" + TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ + "' OR " + "a.tip = '" + TipDokumentConfig.get().PRENOS_SA_FAKTURE_KUPAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().PRENOS_NA_FAKTURU_KUPAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().UPLATA_PAZARA + "' OR " + "a.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC + "' OR " + "a.tip = '" + TipDokumentConfig.get().RACUN_KUPCA + "') " + " %s " + "ORDER BY a.datum,a.rbrDok ASC";
            datumi = izborKomitenta.isPrikazUPeriodu() ? " AND (a.datum >= '" + izborKomitenta.getDatePocetni().getVal() + "' and a.datum <= '" + izborKomitenta.getDateKrajnji().getVal() + "')" : "";
            a = String.format(a, datumi);
            q = this.em.createNativeQuery(a);
            q.setHint("eclipselink.cursor.scrollable", (Object)"True");
            this.cursor = (ScrollableCursor)q.getSingleResult();
        }
        this.em.clear();
        this.em.close();
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new PzCellRendererKarticaKomitenta()));
        this.model = new PzTableModelKarticaKomitenta(this.cursor, this, izborKomitenta.isKupac());
        BigDecimal potrazuje = BigDecimal.ZERO;
        BigDecimal duguje = BigDecimal.ZERO;
        BigDecimal stranaValutaSaldo = BigDecimal.ZERO;
        int i = 0;
        while (i < this.model.getRowCount()) {
            duguje = duguje.add((BigDecimal)this.model.getValueAt(i, 4));
            potrazuje = potrazuje.add((BigDecimal)this.model.getValueAt(i, 5));
            stranaValutaSaldo = (BigDecimal)this.model.getValueAt(i, 14);
            ++i;
        }
        BigDecimal kursZadnjeTransakcije = (BigDecimal)this.model.getValueAt(this.model.getRowCount() - 1, 11);
        BigDecimal dugValutaZadnjeTransakcije = kursZadnjeTransakcije != null && !kursZadnjeTransakcije.equals(BigDecimal.ZERO) ? BDConverter.getIznos((double)(duguje.subtract(potrazuje).subtract(this.avans).doubleValue() / kursZadnjeTransakcije.doubleValue())) : null;
        BigDecimal dugDanasValuta = this.valutaDanas != null && !this.valutaDanas.equals(BigDecimal.ZERO) ? BDConverter.getIznos((double)(duguje.subtract(potrazuje).subtract(this.avans).doubleValue() / this.valutaDanas.doubleValue())) : null;
        this.data.put("VALUTA_DANAS", this.valutaDanas);
        this.data.put("DUG_DANAS", dugDanasValuta);
        this.data.put("DUG_ZADNJA_TRANSAKCIJA", dugValutaZadnjeTransakcije);
        this.data.put("DATUM_ZADNJE_TRANSAKCIJE", this.model.getValueAt(this.table.getRowCount(), 1));
        this.data.put("AVANS", this.avans.doubleValue());
        this.data.put("DUGUJE", duguje);
        this.data.put("POTRAZUJE", potrazuje);
        this.data.put("SALDO", duguje.subtract(potrazuje));
        this.data.put("DUG_MINUS_AVANS", duguje.subtract(potrazuje).subtract(this.avans));
        this.data.put("DUG", duguje.subtract(potrazuje));
        this.data.put("VAN_VALUTE", this.getIznosVanValute());
        this.data.put("DUG_STRANA", stranaValutaSaldo);
        this.data.put("STRANA_VALUTA", this.valuta);
        this.data.put("DOMACA_VALUTA", "RSD");
        this.table.setModel((TableModel)((Object)this.model));
        this.jScrollPane1.setViewportView((Component)this.table);
        this.table.setVisibleRowCount(0);
        this.table.setEditable(false);
        this.table.restoreState();
        this.lblstatus.setText("Broj dokumenata: " + this.cursor.size());
        this.lblstranaValuta.setText("Strana valuta: " + this.valuta);
        this.preracunMesecnihDugovanja();
        ((KarticaKomitentaBody)((Object)this.pzPanel1)).updateData(this.data);
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
    }

    private void preracunMesecnihDugovanja() {
        this.worker = new SwingWorker<ScrollableCursor, Object>(){

            @Override
            protected ScrollableCursor doInBackground() throws Exception {
                BigDecimal duguje = new BigDecimal("0.00");
                BigDecimal potrazuje = new BigDecimal("0.00");
                int i = 0;
                while (i < 12) {
                    if (PzDialogKarticaKomitenata.this.data.get("DUGUJE_" + String.valueOf(i)) == null) {
                        PzDialogKarticaKomitenata.this.data.put("DUGUJE_" + String.valueOf(i), new BigDecimal("0.00"));
                    }
                    if (PzDialogKarticaKomitenata.this.data.get("POTRAZUJE_" + String.valueOf(i)) == null) {
                        PzDialogKarticaKomitenata.this.data.put("POTRAZUJE_" + String.valueOf(i), new BigDecimal("0.00"));
                    }
                    if (PzDialogKarticaKomitenata.this.data.get("SALDO_" + String.valueOf(i)) == null) {
                        PzDialogKarticaKomitenata.this.data.put("SALDO_" + String.valueOf(i), new BigDecimal("0.00"));
                    }
                    ++i;
                }
                if (PzDialogKarticaKomitenata.this.data.get("PRENETO_DUGUJE") == null) {
                    PzDialogKarticaKomitenata.this.data.put("PRENETO_DUGUJE", new BigDecimal("0.00"));
                }
                if (PzDialogKarticaKomitenata.this.data.get("PRENETO_POTRAZUJE") == null) {
                    PzDialogKarticaKomitenata.this.data.put("PRENETO_POTRAZUJE", new BigDecimal("0.00"));
                }
                if (PzDialogKarticaKomitenata.this.data.get("POST_POTRAZUJE") == null) {
                    PzDialogKarticaKomitenata.this.data.put("POST_POTRAZUJE", new BigDecimal("0.00"));
                }
                if (PzDialogKarticaKomitenata.this.data.get("POST_DUGUJE") == null) {
                    PzDialogKarticaKomitenata.this.data.put("POST_DUGUJE", new BigDecimal("0.00"));
                }
                if (PzDialogKarticaKomitenata.this.data.get("POST_SALDO") == null) {
                    PzDialogKarticaKomitenata.this.data.put("POST_SALDO", new BigDecimal("0.00"));
                }
                if (PzDialogKarticaKomitenata.this.data.get("PRENETO_SALDO") == null) {
                    PzDialogKarticaKomitenata.this.data.put("PRENETO_SALDO", new BigDecimal("0.00"));
                }
                i = 0;
                while (i < PzDialogKarticaKomitenata.this.model.getRowCount()) {
                    Date datum = (Date)PzDialogKarticaKomitenata.this.model.getValueAt(i, 1);
                    duguje = (BigDecimal)PzDialogKarticaKomitenata.this.model.getValueAt(i, 4);
                    potrazuje = (BigDecimal)PzDialogKarticaKomitenata.this.model.getValueAt(i, 5);
                    String podtip = (String)PzDialogKarticaKomitenata.this.model.getValueAt(i, 15);
                    PzDialogKarticaKomitenata.this.getYear(datum).intValue();
                    PzDialogKarticaKomitenata.this.getYear(PzDateUtility.getCurrentDate()).intValue();
                    if (!podtip.equals("POCETNO")) {
                        PzDialogKarticaKomitenata.this.data.put("DUGUJE_" + PzDialogKarticaKomitenata.this.getMonth(datum), ((BigDecimal)PzDialogKarticaKomitenata.this.data.get("DUGUJE_" + PzDialogKarticaKomitenata.this.getMonth(datum))).add(duguje));
                        PzDialogKarticaKomitenata.this.data.put("POTRAZUJE_" + PzDialogKarticaKomitenata.this.getMonth(datum), ((BigDecimal)PzDialogKarticaKomitenata.this.data.get("POTRAZUJE_" + PzDialogKarticaKomitenata.this.getMonth(datum))).add(potrazuje));
                        PzDialogKarticaKomitenata.this.data.put("SALDO_" + PzDialogKarticaKomitenata.this.getMonth(datum), ((BigDecimal)PzDialogKarticaKomitenata.this.data.get("DUGUJE_" + PzDialogKarticaKomitenata.this.getMonth(datum))).subtract((BigDecimal)PzDialogKarticaKomitenata.this.data.get("POTRAZUJE_" + PzDialogKarticaKomitenata.this.getMonth(datum))));
                    } else {
                        PzDialogKarticaKomitenata.this.data.put("PRENETO_DUGUJE", ((BigDecimal)PzDialogKarticaKomitenata.this.data.get("PRENETO_DUGUJE")).add(duguje));
                        PzDialogKarticaKomitenata.this.data.put("PRENETO_POTRAZUJE", ((BigDecimal)PzDialogKarticaKomitenata.this.data.get("PRENETO_POTRAZUJE")).add(potrazuje));
                        PzDialogKarticaKomitenata.this.data.put("PRENETO_SALDO", ((BigDecimal)PzDialogKarticaKomitenata.this.data.get("PRENETO_DUGUJE")).subtract((BigDecimal)PzDialogKarticaKomitenata.this.data.get("PRENETO_POTRAZUJE")));
                    }
                    ++i;
                }
                return null;
            }

            @Override
            protected void done() {
                ((KarticaKomitentaBody)((Object)PzDialogKarticaKomitenata.this.pzPanel1)).updateData(PzDialogKarticaKomitenata.this.data);
            }
        };
        this.worker.execute();
    }

    private Integer getMonth(Date date) {
        this.cal.setTime(date);
        return this.cal.get(2);
    }

    private Integer getYear(Date date) {
        this.cal.setTime(date);
        return this.cal.get(1);
    }

    private void preracunIPrikazKamate() {
    }

    private void showReport(boolean stranaValuta) {
        Vector<Object> data = new Vector<Object>();
        try {
            data.add(komitent);
            data.add(this.firma);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", this.rtitle);
        params.put("AVANS", this.avans);
        if (stranaValuta) {
            params.put("VALUTA", this.valuta);
        } else {
            params.put("VALUTA", "RSD");
        }
        try {
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)"rs/pezar/reports/compiled/KarticaKomitenta.jasper", params, (String)("AnalitickaKarticaKomitenta_" + komitent.getSfrKomitent()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onStampaPressed() {
        this.showReport(false);
    }

    private void onUpitUPodatkePressed() {
        this.getSession().putParameter("komitent", (Object)komitent);
        this.showDialog(UpitUPodatke.class);
    }

    private void onStampaVPressed() {
        if (!((PzTableModelKarticaKomitenta)((Object)this.table.getModel())).preuzetKurs(true)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Podaci o kursu strane valute za ceo period prikaza kartice moraju biti une\u0161eni.", "Gre\u0161ka", 0);
            return;
        }
        this.showReport(true);
    }

    private void onGarancijePressed() {
        this.getSession().putParameter("komitent", (Object)komitent);
        this.showDialog(Garancije.class);
    }

    private void onObracunKamatePressed() {
        if (!izborKomitenta.isKupac()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Obra\u010dun kamate se radi samo za kupce.", "Info", 1);
            return;
        }
        PzDialogObracunKamate.showObracunKamateDialog(this, komitent, this.kreirajListuIdVanValute());
    }

    private void onUpitUNalogPressed() {
        if (this.table.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate selektovati dokument iz tabele.", "Info", 1);
            return;
        }
        Integer iddok = (Integer)this.table.getModel().getValueAt(this.table.convertRowIndexToModel(this.table.getSelectedRow()), 10);
        PzDokument d = null;
        try {
            d = (PzDokument)PzEntityManager.find(Dokument.class, (Object)iddok);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PzFinansijeManager.getInstance().getHelper().showNzk((PzDialog)this, d);
    }

    private void onNadjiDokumentPressed() {
        try {
            Robot robot = new Robot();
            robot.keyPress(17);
            robot.keyPress(70);
            robot.keyRelease(70);
            robot.keyRelease(17);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void newFilter() {
    }

    private Vector<String> kreirajListuIdVanValute() {
        Vector<String> idovi = new Vector<String>();
        Date today = PzDateUtility.getCurrentDate();
        int i = 0;
        while (i < this.model.getRowCount()) {
            Date datum = (Date)this.model.getValueAt(i, 7);
            BigDecimal dugPoDokumentu = (BigDecimal)this.model.getValueAt(i, 9);
            if (datum != null && today.after(datum) && dugPoDokumentu.doubleValue() != 0.0) {
                idovi.add(String.valueOf(this.model.getValueAt(i, 10)));
            }
            ++i;
        }
        return idovi;
    }

    private BigDecimal getIznosVanValute() {
        BigDecimal vanValute = BigDecimal.ZERO;
        Date today = PzDateUtility.getCurrentDate();
        int i = 0;
        while (i < this.model.getRowCount()) {
            Date datum = (Date)this.model.getValueAt(i, 7);
            BigDecimal dugPoDokumentu = (BigDecimal)this.model.getValueAt(i, 9);
            if (datum != null && today.after(datum) && dugPoDokumentu.doubleValue() != 0.0) {
                vanValute = vanValute.add(dugPoDokumentu);
            }
            ++i;
        }
        return vanValute;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKarticaKomitenata(Boolean.FALSE);
    }

    public PzDialogKarticaKomitenata(Boolean initGUI) {
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.cursor != null && !this.cursor.isClosed()) {
            this.cursor.close();
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }
}

