/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.otvoreneStavke;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class PzDialogIzvodOtvoreneStavke
extends PzDialog {
    private static final String KONKRETAN_KOMITENT = "Konkretan komitent";
    private static final String SVI_KOMITENTI = "Svi komitenti";
    private static final String DATUM_VALUTE = "Datum valute";
    private static final String DATUM_DPO = "Datum DPO";
    private static final String DATUM_FAKTURE = "Datum fakture";
    private PzPanel pnlGlavni;
    private JPanel pnlRadioButton;
    private PzRadioGroup<String> panelRBs1;
    private PzPanel pnlKomitent;
    private PzDateField tfDatum;
    private JLabel lblDatum;
    private PzPanel pnlDatum;
    private JPanel pnlButton;
    private PzTextAreaPanel pnlPoruka;
    private PzTextField tfNazivKomitenta;
    private PzFieldIndikator indNazivKomitenta;
    private PzTextField tfKomitent;
    private JLabel lblKomitent;
    private PzRadioGroup<String> panelRBs2;
    private PzButton btnPotvrdi;
    private String izbor;
    private ScrollableCursor cursor;

    public PzDialogIzvodOtvoreneStavke(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogIzvodOtvoreneStavke(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle("I O S");
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            pnlGlavniLayout.rowHeights = new int[]{13, 210, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1};
            pnlGlavniLayout.columnWidths = new int[]{7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlRadioButton = new JPanel();
            GridBagLayout pnlRadioButtonLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlRadioButton, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlRadioButtonLayout.rowWeights = new double[]{0.1};
            pnlRadioButtonLayout.rowHeights = new int[]{7};
            pnlRadioButtonLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlRadioButtonLayout.columnWidths = new int[]{135, 203, 135, 20};
            this.pnlRadioButton.setLayout(pnlRadioButtonLayout);
            this.pnlRadioButton.setOpaque(false);
            this.panelRBs1 = new PzRadioGroup((Object[])new String[]{KONKRETAN_KOMITENT, SVI_KOMITENTI});
            BoxLayout panelRBs1Layout = new BoxLayout((Container)this.panelRBs1, 1);
            this.panelRBs1.setLayout((LayoutManager)panelRBs1Layout);
            this.pnlRadioButton.add((Component)this.panelRBs1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.panelRBs1.setBorder((Border)BorderFactory.createTitledBorder("Komitenti"));
            this.panelRBs1.setSelectedValue((Object)KONKRETAN_KOMITENT);
            this.panelRBs1.setOpaque(false);
            this.panelRBs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getValue().equals(PzDialogIzvodOtvoreneStavke.KONKRETAN_KOMITENT)) {
                        PzDialogIzvodOtvoreneStavke.this.setFocusableKomitnt(true);
                    } else if (evt.getValue().equals(PzDialogIzvodOtvoreneStavke.SVI_KOMITENTI)) {
                        PzDialogIzvodOtvoreneStavke.this.setFocusableKomitnt(false);
                    }
                }
            });
            this.pnlKomitent = new PzPanel();
            GridBagLayout pnlKomitentLayout = new GridBagLayout();
            this.pnlRadioButton.add((Component)this.pnlKomitent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlKomitentLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlKomitentLayout.rowHeights = new int[]{10, 26, 25, 7};
            pnlKomitentLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            pnlKomitentLayout.columnWidths = new int[]{-2, 51, 26, 37};
            this.pnlKomitent.setLayout((LayoutManager)pnlKomitentLayout);
            this.pnlKomitent.setBorder((Border)BorderFactory.createTitledBorder("Izbor komitenta"));
            this.pnlKomitent.setOpaque(false);
            this.lblKomitent = new JLabel();
            this.lblKomitent.setText("\u0160ifra komitenta");
            this.pnlKomitent.add((Component)this.lblKomitent, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 2), 0, 0));
            this.tfKomitent = new PzTextField();
            this.tfKomitent.setFont(new Font("Tahoma", 0, 14));
            this.pnlKomitent.add((Component)this.tfKomitent, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 3, 1, 0), 0, 0));
            this.tfKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.indNazivKomitenta = new PzFieldIndikator();
            this.pnlKomitent.add((Component)this.indNazivKomitenta, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNazivKomitenta = new PzTextField();
            this.pnlKomitent.add((Component)this.tfNazivKomitenta, (Object)new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 10, 1, new Insets(1, 10, 0, 10), 0, 0));
            this.tfNazivKomitenta.setFont(new Font("Tahoma", 0, 14));
            this.tfNazivKomitenta.setFocusable(false);
            this.panelRBs2 = new PzRadioGroup((Object[])new String[]{DATUM_VALUTE, DATUM_DPO, DATUM_FAKTURE});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRBs2, 1);
            this.panelRBs2.setLayout((LayoutManager)panelRBs2Layout);
            this.pnlRadioButton.add((Component)this.panelRBs2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs2.setBorder((Border)BorderFactory.createTitledBorder("Datum \u0161tampanja"));
            this.panelRBs2.setSelectedValue((Object)DATUM_VALUTE);
            this.panelRBs2.setOpaque(false);
            this.pnlDatum = new PzPanel();
            GridBagLayout pnlDatumLayout = new GridBagLayout();
            this.pnlRadioButton.add((Component)this.pnlDatum, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.pnlDatum.setBorder((Border)BorderFactory.createTitledBorder("Datum pretrage"));
            pnlDatumLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            pnlDatumLayout.rowHeights = new int[]{7, 7, 7};
            pnlDatumLayout.columnWeights = new double[]{0.0, 0.1};
            pnlDatumLayout.columnWidths = new int[]{82, 7};
            this.pnlDatum.setLayout((LayoutManager)pnlDatumLayout);
            this.pnlDatum.setOpaque(false);
            this.lblDatum = new JLabel();
            this.pnlDatum.add((Component)this.lblDatum, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.lblDatum.setName("lblDatum");
            this.tfDatum = new PzDateField();
            this.pnlDatum.add((Component)this.tfDatum, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.pnlPoruka = new PzTextAreaPanel();
            this.pnlGlavni.add((Component)this.pnlPoruka, (Object)new GridBagConstraints(-1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.pnlPoruka.setBorder((Border)BorderFactory.createTitledBorder("Dodatna poruka"));
            this.pnlPoruka.setOpaque(false);
            this.pnlButton = new JPanel();
            this.pnlGlavni.add((Component)this.pnlButton, (Object)new GridBagConstraints(-1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 25, 0, 25), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(144, 36));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setShortcut("Ctrl+W");
            this.tfKomitent.setStateIndikator(this.indNazivKomitenta);
            this.pack();
            this.setSize(701, 387);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setFocusableKomitnt(Boolean focusable) {
        this.tfKomitent.setFocusable(focusable.booleanValue());
        this.indNazivKomitenta.setEnabled(focusable.booleanValue());
        if (!focusable.booleanValue()) {
            this.tfKomitent.setText("");
            this.tfNazivKomitenta.setText("");
            this.indNazivKomitenta.setState(PzFieldIndikator.STATE_INVALID);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            if (((String)this.panelRBs1.getSelectedValue()).equals(KONKRETAN_KOMITENT) && this.tfKomitent.getVal().equals("")) {
                JOptionPane.showMessageDialog(this.getParent(), "Niste izabrali komitenta", "Informacija", 1);
                return;
            }
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogIzvodOtvoreneStavke.this.cursor != null) {
                        PzDialogIzvodOtvoreneStavke.this.cursor.close();
                    }
                    String upit = "";
                    String uplata = "";
                    Query q = null;
                    if (PzDialogIzvodOtvoreneStavke.this.izbor.equals("Kupci")) {
                        uplata = "(COALESCE((SELECT SUM(CASE WHEN (u.tip IN ('UPLATA_KUPCA_POVRACAJ','PRENOS_SA_FAK_K')) THEN -1*u.iznossaporezom  ELSE u.iznossaporezom END) FROM Opstidokument u WHERE ((u.sfrKomitent = f.sfrKomitent and u.int1 = f.iddok and u.discriminator IN ('UPLATA', 'OTPIS_POTRAZIVANJA')) or (u.sfrKomitent = f.sfrKomitent and u.int2 = f.iddok and discriminator ='PRENOS_NOVCA') or (u.sfrKomitent = f.sfrKomitent and u.oznDokumenta = f.oznDokumenta and u.int1 is null and u.int2 is null and u.discriminator IN ('UPLATA', 'OTPIS_POTRAZIVANJA', 'PRENOS_NOVCA'))) and u.arhiviran=1 and u.datum<='" + PzDialogIzvodOtvoreneStavke.this.tfDatum.getVal().toString() + "'),0))";
                        upit = "SELECT k.sfrKomitent, k.naziv, k.adresa, k.postBroj, k.grad, f.oznDokumenta, f.datum, f.datValute, f.datPrometa, f.iznos-f.stornoIznos, " + uplata + ", " + "f.rbrDok " + "FROM Faktura f, Komitent k, Radnajedinica rj " + "WHERE f.sfrKomitent=k.sfrKomitent and f.arhiviran=1 and f.storno=0 and f.iznos-f.stornoIznos - " + uplata + " <> 0 and " + "rj.oznRj = f.oznRj and f.oznOgranak = rj.oznOgranak and rj.oznRj IN (%listaRj%) and f.datum<='" + PzDialogIzvodOtvoreneStavke.this.tfDatum.getVal().toString() + " 'and " + "(f.tip='" + "FAKTURA" + "' or f.tip='" + "FAKTURA_IZ_SERVISA" + "' or f.tip='" + "FAKTURA_USLUGA" + "')";
                    } else {
                        uplata = "(COALESCE((SELECT SUM(CASE WHEN (u.tip IN ('UPLATA_DOBAVLJACU_POVRACAJ', 'PRENOS_SA_FAK_D')) THEN -1*u.iznossaporezom  ELSE u.iznossaporezom END) FROM Opstidokument u WHERE ((u.sfrKomitent = f.sfrKomitent and u.int1 = f.iddok and u.discriminator IN ('UPLATA', 'OTPIS_POTRAZIVANJA')) or (u.sfrKomitent = f.sfrKomitent and u.int2 = f.iddok and discriminator ='PRENOS_NOVCA') or (u.sfrKomitent = f.sfrKomitent and u.oznDokumenta = f.oznDokumenta and u.int1 is null and u.int2 is null and u.discriminator IN ('UPLATA', 'OTPIS_POTRAZIVANJA', 'PRENOS_NOVCA'))) and u.arhiviran=1 and u.datum<='" + PzDialogIzvodOtvoreneStavke.this.tfDatum.getVal().toString() + "'),0))";
                        upit = "SELECT k.sfrKomitent, k.naziv, k.adresa, k.postBroj, k.grad, f.oznDokumenta, f.datum, f.datValute, f.datDPO, f.iznos-f.stornoIznos, " + uplata + ", " + "f.rbrDok " + "FROM Kalkulacija f, Komitent k " + "WHERE f.sfrKomitent=k.sfrKomitent and f.arhiviran=1 and f.storno= 0 and f.iznos - f.stornoIznos - " + uplata + " <> 0 and f.datum<='" + PzDialogIzvodOtvoreneStavke.this.tfDatum.getVal().toString() + "' and " + "((f.tip='" + "KALKULACIJA" + "' and (f.podtip='" + "FAKTURA" + "' or f.podtip='" + "POCETNO" + "')) or " + "f.tip='" + "TROSAK" + "' or f.tip='" + "RACUN_DOBAVLJACA" + "' or f.tip='" + "ZAPISNIK_OTPREMNICE" + "')";
                    }
                    if (((String)PzDialogIzvodOtvoreneStavke.this.panelRBs1.getSelectedValue()).equals(PzDialogIzvodOtvoreneStavke.KONKRETAN_KOMITENT)) {
                        upit = String.valueOf(upit) + " and k.sfrKomitent=':komitent'";
                        upit = upit.replace(":komitent", PzDialogIzvodOtvoreneStavke.this.tfKomitent.getVal().toString());
                    }
                    if (PzDialogIzvodOtvoreneStavke.this.izbor.equals("Kupci")) {
                        upit = String.valueOf(upit) + " ORDER BY CAST(f.sfrKomitent as NUMERIC), f.rbrDok ASC";
                    }
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogIzvodOtvoreneStavke.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogIzvodOtvoreneStavke.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogIzvodOtvoreneStavke.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogIzvodOtvoreneStavke.this.getParent(), "Za tra\u017eeni kriterijum nama nepla\u0107enih faktura", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogIzvodOtvoreneStavke.this.showReports();
                        }
                        catch (Exception e) {
                            PzWorkerDialog.hideStatus();
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogIzvodOtvoreneStavke.this), (Throwable)e);
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        String tipDatuma = "";
        String tipFakture = this.izbor.equals("Kupci") ? "faktura" : "kalkulacija";
        if (((String)this.panelRBs2.getSelectedValue()).equals(DATUM_VALUTE)) {
            tipDatuma = "valuta";
        } else if (((String)this.panelRBs2.getSelectedValue()).equals(DATUM_DPO)) {
            tipDatuma = "DPO";
        }
        Vector<Firma> data = new Vector<Firma>();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        HashMap<String, String> params = new HashMap<String, String>();
        String title = "Izvod otvorenih stavki na dan " + PzDateUtility.formatDate((Date)this.tfDatum.getVal());
        params.put("title", title);
        params.put("tipDatum", tipDatuma);
        params.put("tip", tipFakture);
        params.put("reklama", "");
        params.put("poruke", this.pnlPoruka.getArea().getText());
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/otvorene.stavke.IOS.jasper"), params, (String)title);
    }

    public boolean shouldBeShown() {
        String izborKartice;
        String dobavljaci;
        String kupci;
        block3: {
            Vector<String> skupZaIzbor = new Vector<String>();
            kupci = new String("Kupci");
            dobavljaci = new String("Dobavlja\u010di");
            skupZaIzbor.add(kupci);
            skupZaIzbor.add(dobavljaci);
            try {
                izborKartice = PzDialogChoice.showPzDialogChoice((PzDialog)this, skupZaIzbor);
                if (izborKartice != null) break block3;
                return false;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                return false;
            }
        }
        this.izbor = izborKartice.equals(dobavljaci) ? dobavljaci : kupci;
        this.pnlKomitent.updateAllFieldsState();
        return true;
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.tfKomitent.setVal((Object)((Komitent)entity).getSfrKomitent());
            this.tfNazivKomitenta.setVal((Object)((Komitent)entity).getNaziv());
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogIzvodOtvoreneStavke(Boolean.FALSE);
    }

    public PzDialogIzvodOtvoreneStavke(Boolean initGUI) {
    }
}

