/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pocetnaStanja;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.analitike.gui.pocetnaStanja.pocetnoStanjeArtikal.DodavanjeArtikla;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzCalculatedField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogPocetnoStanjeArtikla
extends PzDialog {
    private JToolBar toolbar;
    private PzPanel pnlFields;
    private PzTable tblTabela;
    private JScrollPane scrollPaneTable;
    private PzPanel pnlGlavni;
    private PzToolBarIcon icnDodavanje;
    private PzCalculatedField dfUkupnoPoPRNC;
    private JLabel lblUkupnoPoPrnc;
    private PzCalculatedField dfUkupnoPoProdajnoj;
    private JLabel lblUkupnoPoProdajnoj;
    private PzTextField tfBrojDokumenata;
    private JLabel lblBrojDokumenata;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnBrisiSve;
    private PzToolBarIcon icnStampanje;
    private Nzk nzk;
    private Radnajedinica rj;
    private ScrollableCursor cursor;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogPocetnoStanjeArtikla(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setPreferredSize(new Dimension(718, 320));
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{99, 85, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(INSERT)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_new.png")));
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnDodavanje.setPreferredSize(new Dimension(70, 80));
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_edit.png")));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnIzmena.setPreferredSize(new Dimension(70, 80));
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(DELETE)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_delete.png")));
            this.icnBrisanje.setActionCommand("brisi");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setPreferredSize(new Dimension(70, 80));
            this.icnBrisiSve = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisiSve);
            this.icnBrisiSve.setText("Bri\u0161i sve|(Ctrl+Q)");
            this.icnBrisiSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_delete.png")));
            this.icnBrisiSve.setActionCommand("brisisve");
            this.icnBrisiSve.addActionListener((ActionListener)((Object)this));
            this.icnBrisiSve.setShortcut("Ctrl+q");
            this.icnBrisiSve.setPreferredSize(new Dimension(70, 80));
            this.icnStampanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampanje);
            this.icnStampanje.setText("\u0160tampanje|(Alt+S)");
            this.icnStampanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampanje.setActionCommand("stampa");
            this.icnStampanje.addActionListener((ActionListener)((Object)this));
            this.icnStampanje.setShortcut("Alt+s");
            this.icnStampanje.setPreferredSize(new Dimension(90, 80));
            this.scrollPaneTable = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPaneTable, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.scrollPaneTable.setBackground(new Color(255, 255, 255));
            this.tblTabela = new PzTable();
            this.scrollPaneTable.setViewportView((Component)this.tblTabela);
            this.tblTabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Stanje artikal = (Stanje)entity;
                    return new Object[]{artikal.getArtikal().getSfrProizvod(), artikal.getArtikal().getNaziv(), artikal.getKolPop(), artikal.getCenaNaPS(), artikal.getProsNabCena()};
                }

                public String[] getColumnNames() {
                    return new String[]{"\u0160ifra", "Naziv", "Koli\u010dina", "Prodajna cena", "Prnc"};
                }
            });
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{18, 25, 25, 20};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{184, 130, 150, 123, 95, 130, 20};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblUkupnoPoProdajnoj = new JLabel();
            this.pnlFields.add((Component)this.lblUkupnoPoProdajnoj, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblUkupnoPoProdajnoj.setName("lblUkupnoPoProdajnoj");
            this.lblUkupnoPoProdajnoj.setFont(new Font("Tahoma", 1, 12));
            this.dfUkupnoPoProdajnoj = this.tblTabela.createExpresionField("$2$*$3$");
            this.pnlFields.add((Component)this.dfUkupnoPoProdajnoj, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfUkupnoPoProdajnoj.setFocusable(false);
            this.lblUkupnoPoPrnc = new JLabel();
            this.pnlFields.add((Component)this.lblUkupnoPoPrnc, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblUkupnoPoPrnc.setName("lblUkupnoPoPrnc");
            this.lblUkupnoPoPrnc.setFont(new Font("Tahoma", 1, 12));
            this.dfUkupnoPoPRNC = this.tblTabela.createExpresionField("$2$*$4$");
            this.pnlFields.add((Component)this.dfUkupnoPoPRNC, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfUkupnoPoPRNC.setFocusable(false);
            this.lblBrojDokumenata = new JLabel();
            this.pnlFields.add((Component)this.lblBrojDokumenata, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 30, 0, 0), 0, 0));
            this.lblBrojDokumenata.setName("lblBrojDokumenata");
            this.lblBrojDokumenata.setFont(new Font("Tahoma", 1, 12));
            this.tfBrojDokumenata = new PzTextField();
            this.pnlFields.add((Component)this.tfBrojDokumenata, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfBrojDokumenata.setMaxLength(7);
            this.tfBrojDokumenata.setFocusable(false);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(821, 709);
            this.setMinimumSize(new Dimension(821, 709));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        this.getSession().putParameter("radnajedinica", (Object)this.rj);
        try {
            try {
                if (actionCommand.equals("dodavanje")) {
                    this.getSession().putParameter("update", (Object)false);
                    this.getSession().putParameter("tabela", (Object)this.tblTabela);
                    this.showDialog(DodavanjeArtikla.class);
                    this.refreshField();
                } else if (actionCommand.equals("izmena")) {
                    if (this.tblTabela.getRowCount() != 0) {
                        this.getSession().putParameter("update", (Object)true);
                        this.getSession().putParameter("tabela", (Object)this.tblTabela);
                        this.showDialog(DodavanjeArtikla.class);
                    }
                } else if (actionCommand.equals("brisi")) {
                    int rez;
                    if (this.tblTabela.getRowCount() != 0 && (rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?!", (String)"Brisanje", null, (boolean)false)) == 0) {
                        em.getTransaction().begin();
                        Stanje s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(((Stanje)this.tblTabela.getSelectedEntity()).getArtikal().getSfrProizvod(), this.rj));
                        s.setKolPop(0.0);
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().commit();
                        }
                        this.tblTabela.removeSelectedEntityGUI();
                        this.refreshField();
                    }
                } else if (actionCommand.equals("stampa") && this.tblTabela.getRowCount() != 0) {
                    this.showReport();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void refreshField() {
        this.tfBrojDokumenata.setVal((Object)this.tblTabela.getRowCount());
        this.brDok.setText(String.valueOf(this.tblTabela.getRowCount()) + " ");
    }

    public void initializeTable() {
        final EntityManager em = PzEntityManager.getEm();
        PzWorkerDialog.showStatus((String)"U\u010ditavanje podataka je u toku. Molim sa\u010dekajte.", (PzDialog)this);
        SwingWorker<Object, Integer> sw = new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                em.getTransaction().begin();
                Query q = null;
                FetchGroup grp = new FetchGroup();
                grp.addAttribute("artikal.sfrProizvod");
                grp.addAttribute("artikal.naziv");
                grp.addAttribute("kolPop");
                grp.addAttribute("cenaNaPS");
                grp.addAttribute("prosNabCena");
                q = em.createQuery("SELECT s FROM Stanje s join fetch s.artikal where s.id.oznRj=:rj and s.id.oznOgranak=:ogranak and s.kolPop<>0.0 ORDER BY s.artikal.sfrSort");
                q.setParameter("rj", (Object)PzDialogPocetnoStanjeArtikla.this.rj.getId().getOznRj());
                q.setParameter("ogranak", (Object)PzDialogPocetnoStanjeArtikla.this.rj.getId().getOznOgranak());
                q.setHint("eclipselink.fetch-group", (Object)grp);
                List data1 = q.getResultList();
                em.getTransaction().commit();
                return data1;
            }

            @Override
            protected void done() {
                try {
                    try {
                        List data = (List)this.get();
                        if (data.size() != 0) {
                            PzDialogPocetnoStanjeArtikla.this.tblTabela.setData(data, Stanje.class);
                            PzDialogPocetnoStanjeArtikla.this.tblTabela.calculateFields();
                            PzDialogPocetnoStanjeArtikla.this.tfBrojDokumenata.setVal((Object)data.size());
                            PzDialogPocetnoStanjeArtikla.this.brDok.setText(String.valueOf(data.size()) + " ");
                        }
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPocetnoStanjeArtikla.this), (Throwable)e);
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        sw.execute();
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        if (this.rj != null) {
            this.setTitle("PO\u010cETNO STANJE ARTIKALA Radna jedinica:" + this.rj.getId().getOznRj() + " / " + this.rj.getNaziv());
            this.initializeTable();
            return true;
        }
        return false;
    }

    public void showReport() {
        try {
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.tblTabela, data);
            HashMap<String, Object> params = new HashMap<String, Object>();
            Date today = PzDateUtility.getCurrentDate();
            params.put("title", "PO\u010cETNO STANJE ARTIKLA");
            params.put("datum", today);
            params.put("reklama", "");
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/pocetno.stanje.artikla.jasper"), params, (String)"PO\u010cETNO STANJE ARTIKLA");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPocetnoStanjeArtikla(Boolean.FALSE);
    }

    public PzDialogPocetnoStanjeArtikla(Boolean initGUI) {
    }
}

