/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pocetnaStanja;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.indirection.IndirectList;
import org.jdesktop.application.Application;
import rs.pezar.analitike.PzExtensionLoader;
import rs.pezar.analitike.gui.pocetnaStanja.pocetnoStanjeKonto.Dodavanje;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogPocetnoStanjeKonta
extends PzDialog {
    private JToolBar toolbar;
    private PzPanel pnlFields;
    private PzTable tblTabela;
    private JScrollPane scrollPaneTable;
    private PzPanel pnlGlavni;
    private PzToolBarIcon icnDodavanje;
    private JLabel lblSaldo;
    private PzDoubleField dfSaldo;
    private PzDoubleField dfPotrazuje;
    private JLabel lblPotrazuje;
    private PzDoubleField dfDuguje;
    private PzNumericOnlyTextField tfBrojDokumenata;
    private JLabel lblBrojDokumenata;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisanje;
    private JLabel lblUkupno;
    private PzToolBarIcon icnBrisiSve;
    private PzToolBarIcon icnArhiviranje;
    private PzToolBarIcon icnStampanje;
    private Nzk nzk;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPocetnoStanjeKonta inst = new PzDialogPocetnoStanjeKonta(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPocetnoStanjeKonta() {
        this.initGUI();
    }

    public PzDialogPocetnoStanjeKonta(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setPreferredSize(new Dimension(718, 320));
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{107, 90, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{18, 25, 25, 20};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{113, 130, 109, 130, 95, 130, 20};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblUkupno = new JLabel();
            this.pnlFields.add((Component)this.lblUkupno, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 30, 0, 0), 0, 0));
            this.lblUkupno.setText("Duguje");
            this.lblUkupno.setFont(new Font("Tahoma", 1, 12));
            this.lblBrojDokumenata = new JLabel();
            this.pnlFields.add((Component)this.lblBrojDokumenata, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 30, 0, 0), 0, 0));
            this.lblBrojDokumenata.setName("lblBrojDokumenata");
            this.lblBrojDokumenata.setFont(new Font("Tahoma", 1, 12));
            this.tfBrojDokumenata = new PzNumericOnlyTextField();
            this.pnlFields.add((Component)this.tfBrojDokumenata, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(1, 0, 0, 0), 0, 0));
            this.tfBrojDokumenata.setFocusable(false);
            this.dfDuguje = new PzDoubleField();
            this.pnlFields.add((Component)this.dfDuguje, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDuguje.setFocusable(false);
            this.lblPotrazuje = new JLabel();
            this.pnlFields.add((Component)this.lblPotrazuje, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 40, 0, 0), 0, 0));
            this.lblPotrazuje.setName("lblPotrazuje");
            this.lblPotrazuje.setFont(new Font("Tahoma", 1, 12));
            this.dfPotrazuje = new PzDoubleField();
            this.pnlFields.add((Component)this.dfPotrazuje, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfPotrazuje.setFocusable(false);
            this.dfSaldo = new PzDoubleField();
            this.pnlFields.add((Component)this.dfSaldo, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dfSaldo.setFocusable(false);
            this.lblSaldo = new JLabel();
            this.pnlFields.add((Component)this.lblSaldo, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 40, 0, 0), 0, 0));
            this.lblSaldo.setName("lblSaldo");
            this.lblSaldo.setFont(new Font("Tahoma", 1, 12));
            this.scrollPaneTable = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPaneTable, (Object)new GridBagConstraints(0, 2, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.tblTabela = new PzTable();
            this.scrollPaneTable.setViewportView((Component)this.tblTabela);
            this.tblTabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Stavkanzk stavka = (Stavkanzk)entity;
                    return new Object[]{stavka.getId().getOznKonto(), stavka.getId().getAnalitika(), stavka.getDuguje(), stavka.getPotrazuje(), stavka.getNazivKonta()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Konto", "Analitike", "Duguje", "Potra\u017euje", "Naziv konta"};
                }
            });
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(INSERT)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_new.png")));
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnDodavanje.setPreferredSize(new Dimension(70, 80));
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_edit.png")));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnIzmena.setPreferredSize(new Dimension(70, 80));
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(DELETE)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_delete.png")));
            this.icnBrisanje.setActionCommand("brisi");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setPreferredSize(new Dimension(70, 80));
            this.icnBrisiSve = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisiSve);
            this.icnBrisiSve.setText("Bri\u0161i sve|(Ctrl+Q)");
            this.icnBrisiSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/note_delete.png")));
            this.icnBrisiSve.setActionCommand("brisisve");
            this.icnBrisiSve.addActionListener((ActionListener)((Object)this));
            this.icnBrisiSve.setShortcut("Ctrl+q");
            this.icnBrisiSve.setPreferredSize(new Dimension(70, 80));
            this.icnStampanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampanje);
            this.icnStampanje.setText("\u0160tampanje|(Alt+S)");
            this.icnStampanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/printer_preferences.png")));
            this.icnStampanje.setActionCommand("stampaj");
            this.icnStampanje.addActionListener((ActionListener)((Object)this));
            this.icnStampanje.setShortcut("Alt+s");
            this.icnStampanje.setPreferredSize(new Dimension(90, 80));
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(764, 621);
            this.setMinimumSize(new Dimension(764, 621));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        this.getSession().putParameter("em", (Object)em);
        this.getSession().putParameter("nalog", (Object)this.nzk);
        this.getSession().putParameter("tabela", (Object)this.tblTabela);
        try {
            try {
                if (actionCommand.equals("dodavanje")) {
                    this.getSession().putParameter("update", (Object)false);
                    this.showDialog(Dodavanje.class);
                    this.fillFields();
                } else if (actionCommand.equals("izmena")) {
                    this.getSession().putParameter("update", (Object)true);
                    this.showDialog(Dodavanje.class);
                    this.fillFields();
                } else if (actionCommand.equals("brisi")) {
                    em.getTransaction();
                    this.tblTabela.removeSelectedEntity(true, true);
                    this.tblTabela.commitRemove();
                    this.fillFields();
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().commit();
                    }
                } else if (actionCommand.equals("brisiSve")) {
                    int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?!", (String)"Brisanje", null, (boolean)false);
                    if (rez == 0) {
                        em.getTransaction().begin();
                        em.remove(em.find(Nzk.class, (Object)this.nzk.getIdNalog()));
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().commit();
                        }
                        this.dispose();
                    }
                } else if (actionCommand.equals("stampaj")) {
                    this.showReport();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void fillFields() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogPocetnoStanjeKonta.this.tfBrojDokumenata.setVal((Object)PzDialogPocetnoStanjeKonta.this.nzk.getStavkanzks().size());
                PzDialogPocetnoStanjeKonta.this.brDok.setText(String.valueOf(PzDialogPocetnoStanjeKonta.this.nzk.getStavkanzks().size()));
                PzDialogPocetnoStanjeKonta.this.dfDuguje.setVal((Object)PzDialogPocetnoStanjeKonta.this.nzk.getDugujeSum());
                PzDialogPocetnoStanjeKonta.this.dfPotrazuje.setVal((Object)PzDialogPocetnoStanjeKonta.this.nzk.getPotrazujeSum());
                PzDialogPocetnoStanjeKonta.this.dfSaldo.setVal((Object)PzDialogPocetnoStanjeKonta.this.nzk.getDuguje().subtract(PzDialogPocetnoStanjeKonta.this.nzk.getPotrazuje()));
            }
        });
    }

    public boolean shouldBeShown() {
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            this.nzk = (Nzk)em.find(Nzk.class, (Object)-1);
            if (this.nzk == null) {
                this.nzk = new Nzk();
                this.nzk.setIdNalog(Integer.valueOf(-1));
                this.nzk.setArhiviran(Integer.valueOf(1));
                this.nzk.setBrojac(Integer.valueOf(0));
                this.nzk.setBrSheme(Integer.valueOf(-1));
                this.nzk.setPzuser(PzExtensionLoader.getLoggedUser());
                this.nzk.setDatum(PzDateUtility.getFirstDayOfCurrentYear());
                this.nzk.setStavkanzks((List)new IndirectList());
                em.persist((Object)this.nzk);
            }
            this.setTitle("PO\u010cETNO STANJE KONTA [ NALOG (" + this.nzk.getIdNalog() + ") ]");
            em.getTransaction().commit();
            ArrayList<Stavkanzk> stavke = new ArrayList<Stavkanzk>();
            if (this.nzk.getStavkanzks().size() > 0) {
                for (Stavkanzk stavka : this.nzk.getStavkanzks()) {
                    stavke.add(stavka);
                }
            }
            this.nzk.setStavkanzks(stavke);
            Collections.sort(this.nzk.getStavkanzks(), new Comparator<Stavkanzk>(){

                @Override
                public int compare(Stavkanzk arg0, Stavkanzk arg1) {
                    if (arg0.getId().getOznKonto().compareTo(arg1.getId().getOznKonto()) > 0) {
                        return 1;
                    }
                    if (arg0.getId().getOznKonto().compareTo(arg1.getId().getOznKonto()) < 0) {
                        return -1;
                    }
                    return arg0.getId().getAnalitika().compareTo(arg1.getId().getAnalitika());
                }
            });
            this.tblTabela.setData(this.nzk.getStavkanzks(), Stavkanzk.class);
            this.fillFields();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return false;
        }
        return true;
    }

    public void showReport() {
        try {
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.tblTabela, data);
            HashMap<String, Object> params = new HashMap<String, Object>();
            Date today = PzDateUtility.getCurrentDate();
            params.put("title", "PO\u010cETNO STANJE KONTA");
            params.put("datum", today);
            params.put("reklama", "");
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/pocetno.stanje.konto.jasper"), params, (String)"PO\u010cETNO STANJE KONTA");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPocetnoStanjeKonta(Boolean.FALSE);
    }

    public PzDialogPocetnoStanjeKonta(Boolean initGUI) {
    }
}

