/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogPregledNabavkeProdajeArtikala
extends PzDialog {
    private static final long serialVersionUID = 458924928835972378L;
    private static final String SVI_ARTIKLI = "Svi artikli";
    private static final String PO_ROBNOJ_GRUPI = "Po robnoj grupi";
    private static final String PO_PROIZVODJACU = "Po proizvo\u0111a\u010du";
    private static final String PO_DOBAVLJACU = "Po dobavlja\u010du";
    private static final String DETALJNO = "Detaljno";
    private static final String ZBIRNO = "Zbirno";
    private PzPanel pnlGlavni;
    private PzPanel pnlRadioButton;
    private JLabel lblKrajnjuDatum;
    private PzFieldIndikator indRobnaGrupa;
    private PzFieldIndikator indDobavljac;
    private PzFieldIndikator indProizvodjac;
    private PzDateField dfKrajnjiDatum;
    private PzDateField dfPocetni;
    private JLabel lblPocetniDatum;
    private PzTextField tfDobavljac;
    private JLabel lblDobavljac;
    private PzTextField tfProizvodjac;
    private JLabel lblProizvodjac;
    private PzTextField tfRobnaGrupa;
    private JLabel lblRobnaGrupa;
    private PzRadioGroup<String> panelRBs1;
    private PzButton btnPotvrdi;
    private Robnagrupa entRobnaGrupa;
    private Komitent entKomitent;
    private PzRadioGroup<String> panelRBs2;
    private String parameter;
    private Radnajedinica rj;
    private PzDialog thisDialog;
    private ScrollableCursor cursor = null;
    private PzPanel pnlStranaValuta;
    private PzComboBox cbValute;
    private PzPanel panelFields;

    public PzDialogPregledNabavkeProdajeArtikala(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.thisDialog = this;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        if (this.parameter.equals("GALH")) {
            this.panelRBs2.setEnabled(false);
        } else if (this.parameter.equals("NPRJ")) {
            this.panelRBs1.getChildButton((Object)PO_PROIZVODJACU).setEnabled(false);
            this.panelRBs1.getChildButton((Object)PO_DOBAVLJACU).setEnabled(false);
            this.panelRBs2.setEnabled(false);
        } else {
            this.panelRBs1.getChildButton((Object)PO_PROIZVODJACU).setEnabled(false);
            this.panelRBs1.getChildButton((Object)PO_DOBAVLJACU).setEnabled(false);
        }
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValute.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValute.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlGlavni.setPreferredSize(new Dimension(598, 327));
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{67, 68, 135, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlRadioButton = new PzPanel();
            GridBagLayout pnlRadioButtonLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlRadioButton, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlRadioButtonLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlRadioButtonLayout.rowHeights = new int[]{19, 45, 25, 27, 27, 6, 75, 7};
            pnlRadioButtonLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlRadioButtonLayout.columnWidths = new int[]{13, 138, 93, 115, 23, 92, 107, 7};
            this.pnlRadioButton.setLayout((LayoutManager)pnlRadioButtonLayout);
            this.pnlRadioButton.setOpaque(false);
            this.panelRBs1 = new PzRadioGroup((Object[])new String[]{SVI_ARTIKLI, PO_ROBNOJ_GRUPI, PO_PROIZVODJACU, PO_DOBAVLJACU});
            BoxLayout panelRBs1Layout = new BoxLayout((Container)this.panelRBs1, 1);
            this.panelRBs1.setLayout((LayoutManager)panelRBs1Layout);
            this.pnlRadioButton.add(this.panelRBs1, (Object)new GridBagConstraints(1, 1, 1, 5, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs1.setBorder((Border)BorderFactory.createTitledBorder("Izbor"));
            this.panelRBs1.setSelectedValue((Object)SVI_ARTIKLI);
            this.panelRBs1.setOpaque(false);
            this.panelRBs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogPregledNabavkeProdajeArtikala.SVI_ARTIKLI)) {
                            PzDialogPregledNabavkeProdajeArtikala.this.radioGroupChanged(PzDialogPregledNabavkeProdajeArtikala.SVI_ARTIKLI);
                        } else if (evt.getValue().equals(PzDialogPregledNabavkeProdajeArtikala.PO_ROBNOJ_GRUPI)) {
                            PzDialogPregledNabavkeProdajeArtikala.this.radioGroupChanged(PzDialogPregledNabavkeProdajeArtikala.PO_ROBNOJ_GRUPI);
                        } else if (evt.getValue().equals(PzDialogPregledNabavkeProdajeArtikala.PO_PROIZVODJACU)) {
                            PzDialogPregledNabavkeProdajeArtikala.this.radioGroupChanged(PzDialogPregledNabavkeProdajeArtikala.PO_PROIZVODJACU);
                        } else if (evt.getValue().equals(PzDialogPregledNabavkeProdajeArtikala.PO_DOBAVLJACU)) {
                            PzDialogPregledNabavkeProdajeArtikala.this.radioGroupChanged(PzDialogPregledNabavkeProdajeArtikala.PO_DOBAVLJACU);
                        }
                    }
                }
            });
            this.panelRBs2 = new PzRadioGroup((Object[])new String[]{DETALJNO, ZBIRNO});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRBs2, 1);
            this.panelRBs2.setLayout((LayoutManager)panelRBs2Layout);
            this.pnlRadioButton.add(this.panelRBs2, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRBs2.setBorder((Border)BorderFactory.createTitledBorder("Pregled"));
            this.panelRBs2.setSelectedValue((Object)DETALJNO);
            this.panelRBs2.setOpaque(false);
            this.lblPocetniDatum = new JLabel();
            this.pnlRadioButton.add((Component)this.lblPocetniDatum, (Object)new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblPocetniDatum.setName("lblPocetniDatum");
            this.dfPocetni = new PzDateField();
            this.pnlRadioButton.add((Component)this.dfPocetni, (Object)new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblKrajnjuDatum = new JLabel();
            this.pnlRadioButton.add((Component)this.lblKrajnjuDatum, (Object)new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKrajnjuDatum.setName("lblKrajnjuDatum");
            this.dfKrajnjiDatum = new PzDateField();
            this.pnlRadioButton.add((Component)this.dfKrajnjiDatum, (Object)new GridBagConstraints(6, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.panelFields = new PzPanel();
            GridBagLayout panelFieldsLayout = new GridBagLayout();
            this.pnlRadioButton.add((Component)this.panelFields, (Object)new GridBagConstraints(2, 1, 3, 5, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panelFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            panelFieldsLayout.rowHeights = new int[]{44, 27, 27, 27, 7};
            panelFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelFieldsLayout.columnWidths = new int[]{92, 45, 62, 7};
            this.panelFields.setLayout((LayoutManager)panelFieldsLayout);
            this.lblRobnaGrupa = new JLabel();
            this.panelFields.add((Component)this.lblRobnaGrupa, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblRobnaGrupa.setName("lblRobnaGrupa");
            this.tfRobnaGrupa = new PzTextField();
            this.panelFields.add((Component)this.tfRobnaGrupa, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfRobnaGrupa.setFocusable(false);
            this.tfRobnaGrupa.setEditable(false);
            this.tfRobnaGrupa.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, true, null);
            this.tfRobnaGrupa.setVerifyInput(true);
            this.indRobnaGrupa = new PzFieldIndikator();
            this.panelFields.add((Component)this.indRobnaGrupa, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.indRobnaGrupa.setFocusable(false);
            this.indRobnaGrupa.setEnabled(false);
            this.lblProizvodjac = new JLabel();
            this.panelFields.add((Component)this.lblProizvodjac, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblProizvodjac.setName("lblProizvodjac");
            this.tfProizvodjac = new PzTextField();
            this.panelFields.add((Component)this.tfProizvodjac, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfProizvodjac.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.tfProizvodjac.setFocusable(false);
            this.tfProizvodjac.setEditable(false);
            this.tfProizvodjac.setVerifyInput(true);
            this.indProizvodjac = new PzFieldIndikator();
            this.panelFields.add((Component)this.indProizvodjac, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.indProizvodjac.setFocusable(false);
            this.indProizvodjac.setEnabled(false);
            this.lblDobavljac = new JLabel();
            this.panelFields.add((Component)this.lblDobavljac, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblDobavljac.setName("lblDobavljac");
            this.tfDobavljac = new PzTextField();
            this.panelFields.add((Component)this.tfDobavljac, (Object)new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfDobavljac.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.tfDobavljac.setFocusable(false);
            this.tfDobavljac.setEditable(false);
            this.tfDobavljac.setVerifyInput(true);
            this.indDobavljac = new PzFieldIndikator();
            this.panelFields.add((Component)this.indDobavljac, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.indDobavljac.setFocusable(false);
            this.indDobavljac.setEnabled(false);
            this.btnPotvrdi = new PzButton();
            this.pnlRadioButton.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(3, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(130, 35));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlStranaValuta = new PzPanel();
            GridBagLayout pnlStranaValutaLayout = new GridBagLayout();
            this.pnlRadioButton.add((Component)this.pnlStranaValuta, (Object)new GridBagConstraints(2, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlStranaValuta.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            pnlStranaValutaLayout.rowWeights = new double[]{0.1, 0.0, 0.1};
            pnlStranaValutaLayout.rowHeights = new int[]{7, 25, 7};
            pnlStranaValutaLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlStranaValutaLayout.columnWidths = new int[]{22, 156, 7};
            this.pnlStranaValuta.setLayout((LayoutManager)pnlStranaValutaLayout);
            this.cbValute = new PzComboBox();
            this.pnlStranaValuta.add((Component)this.cbValute, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfRobnaGrupa.setStateIndikator(this.indRobnaGrupa);
            this.tfProizvodjac.setStateIndikator(this.indProizvodjac);
            this.tfDobavljac.setStateIndikator(this.indDobavljac);
            this.pack();
            this.setSize(607, 368);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (((String)this.panelRBs1.getSelectedValue()).equals(PO_ROBNOJ_GRUPI) && this.entRobnaGrupa == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            this.indRobnaGrupa.setState(PzFieldIndikator.STATE_INVALID);
            return;
        }
        if (((String)this.panelRBs1.getSelectedValue()).equals(PO_PROIZVODJACU) && this.entKomitent == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            this.indProizvodjac.setState(PzFieldIndikator.STATE_INVALID);
            return;
        }
        if (((String)this.panelRBs1.getSelectedValue()).equals(PO_DOBAVLJACU) && this.entKomitent == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            this.indDobavljac.setState(PzFieldIndikator.STATE_INVALID);
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogPregledNabavkeProdajeArtikala.this.cursor != null) {
                        PzDialogPregledNabavkeProdajeArtikala.this.cursor.close();
                    }
                    String upit = "";
                    Query q = null;
                    String valuta = PzDialogPregledNabavkeProdajeArtikala.this.cbValute.getSelectedChoice().getValue().toString();
                    if (PzDialogPregledNabavkeProdajeArtikala.this.parameter.equals("GALH")) {
                        upit = "SELECT a.sfrProizvod, a.naziv, rj.oznRj, rj.naziv, sum(CASE WHEN (d1.tip = '%tipK%' ) THEN ad1.kolicina ELSE 0 END),  sum(CASE WHEN (d2.tip = '%tipK%' ) THEN ad2.kolicina ELSE 0 END), sum(CASE WHEN (d1.tip = '%tipK%' ) THEN (ad1.kolicina*ad1.nabCena)%valuta1% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipK%' ) THEN (ad2.kolicina*ad2.nabCena)%valuta1% ELSE 0 END), sum(CASE WHEN (d1.tip = '%tipF%' or d1.tip = '%tipFI%' or d1.tip = '%tipFS%' or d1.tip = '%tipFR%' ) THEN ad1.kolicina ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFI%' or d2.tip = '%tipFS%' or d2.tip = '%tipFR%' ) THEN ad2.kolicina ELSE 0 END), sum(CASE WHEN (d1.tip = '%tipF%' or d1.tip = '%tipFS%' or d1.tip = '%tipFI%' or d1.tip = '%tipFR%' ) THEN (ad1.kolicina*ad1.prodCena)%valuta1% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFS%' or d2.tip = '%tipFI%' or d2.tip = '%tipFR%' ) THEN (ad2.kolicina*ad2.prodCena)%valuta1% ELSE 0 END), s.kolicina-s.alocKolicina FROM RobnaGrupa rg, Artikal a, Radnajedinica rj, Stanjeartikal s, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND CASE WHEN (d1.tip = '%tipK%' ) THEN ad1.nabCena = ad2.nabCena ELSE ad1.prodCena = ad2.prodCena END WHERE a.sfrProizvod = ad1.sfrProizvod %valutaW% and s.sfrProizvod = a.sfrProizvod and s.oznRj = rj.oznRj and s.oznOgranak = rj.oznOgranak and d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND a.oznRobGr = rg.oznRobGr AND rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%','%tipFS%', '%tipFR%','%tipK%') AND d1.datum>=':datumOd'  AND d1.datum<=':datumDo' AND d1.storno = 0 and d1.arhiviran = 1 ";
                        if (((String)PzDialogPregledNabavkeProdajeArtikala.this.panelRBs1.getSelectedValue()).equals(PzDialogPregledNabavkeProdajeArtikala.PO_ROBNOJ_GRUPI)) {
                            upit = String.valueOf(upit) + " and rg.oznRobGr IN :robGrupa";
                            upit = upit.replace(":robGrupa", PzDialogPregledNabavkeProdajeArtikala.this.entRobnaGrupa.getRobnaGrupaListAsString());
                        } else if (((String)PzDialogPregledNabavkeProdajeArtikala.this.panelRBs1.getSelectedValue()).equals(PzDialogPregledNabavkeProdajeArtikala.PO_PROIZVODJACU)) {
                            upit = String.valueOf(upit) + " and a.proizvodjac=':komitent'";
                            upit = upit.replace(":komitent", PzDialogPregledNabavkeProdajeArtikala.this.tfProizvodjac.getVal().toString());
                        } else if (((String)PzDialogPregledNabavkeProdajeArtikala.this.panelRBs1.getSelectedValue()).equals(PzDialogPregledNabavkeProdajeArtikala.PO_DOBAVLJACU)) {
                            upit = String.valueOf(upit) + " and a.dobavljac=':komitent' ";
                            upit = upit.replace(":komitent", PzDialogPregledNabavkeProdajeArtikala.this.tfDobavljac.getVal().toString());
                        }
                        upit = String.valueOf(upit) + "GROUP BY  ad1.sfrSort, rj.oznRj, a.sfrProizvod, a.naziv, rj.naziv, rj.oznOgranak, s.kolicina, s.alocKolicina ORDER BY ad1.sfrSort";
                        upit = upit.replace(":datumOd", PzDialogPregledNabavkeProdajeArtikala.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzDialogPregledNabavkeProdajeArtikala.this.dfKrajnjiDatum.getVal().toString());
                        upit = upit.replace("%valuta1%", valuta.equals("") ? " " : "/k.srednji/k.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs k ON k.datum = d1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " and k.oznValuta='" + valuta + "'");
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                        upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        q = em.createNativeQuery(upit);
                    } else if (PzDialogPregledNabavkeProdajeArtikala.this.parameter.equals("GALD") && ((String)PzDialogPregledNabavkeProdajeArtikala.this.panelRBs2.getSelectedValue()).equals(PzDialogPregledNabavkeProdajeArtikala.DETALJNO)) {
                        upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina), sum(ad2.kolicina),ad1.prodCena%valuta%, ad1.procRabata, d1.oznDokumenta, d1.sfrKomitent FROM RobnaGrupa rg, Artikal a, Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE a.sfrProizvod = ad1.sfrProizvod  %valutaW% and d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND rj.oznRj=':rj' AND rj.oznOgranak=':ogranak' AND a.oznRobGr = rg.oznRobGr AND d1.storno = 0 and d1.arhiviran = 1 AND d1.datum>=':datumOd' AND d1.datum<=':datumDo' AND rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%','%tipFS%', '%tipFR%') ";
                        if (((String)PzDialogPregledNabavkeProdajeArtikala.this.panelRBs1.getSelectedValue()).equals(PzDialogPregledNabavkeProdajeArtikala.PO_ROBNOJ_GRUPI)) {
                            upit = String.valueOf(upit) + " and rg.oznRobGr IN :robGrupa";
                            upit = upit.replace(":robGrupa", PzDialogPregledNabavkeProdajeArtikala.this.entRobnaGrupa.getRobnaGrupaListAsString());
                        }
                        upit = upit.replace(":rj", PzDialogPregledNabavkeProdajeArtikala.this.rj.getId().getOznRj());
                        upit = upit.replace(":ogranak", PzDialogPregledNabavkeProdajeArtikala.this.rj.getId().getOznOgranak());
                        upit = upit.replace(":datumOd", PzDialogPregledNabavkeProdajeArtikala.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzDialogPregledNabavkeProdajeArtikala.this.dfKrajnjiDatum.getVal().toString());
                        upit = String.valueOf(upit) + "GROUP BY ad1.sfrSort, ad1.sfrProizvod, ad1.naziv, d1.oznDokumenta, d1.sfrKomitent, ad1.kolicina, ad1.prodCena, d1.rBroj, ad1.procRabata %valutaG% ORDER BY ad1.sfrSort, ad1.sfrProizvod ";
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/k.srednji/k.jedinica ");
                        upit = upit.replace("%valutaG%", valuta.equals("") ? " " : ",k.srednji, k.jedinica ");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs k ON k.datum = d1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : "and k.oznValuta='" + valuta + "'");
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                        upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        q = em.createNativeQuery(upit);
                    } else if (PzDialogPregledNabavkeProdajeArtikala.this.parameter.equals("GALD") && ((String)PzDialogPregledNabavkeProdajeArtikala.this.panelRBs2.getSelectedValue()).equals(PzDialogPregledNabavkeProdajeArtikala.ZBIRNO)) {
                        upit = "SELECT ad1.sfrProizvod, ad1.naziv, s.kolicina-s.alocKolicina, sum(ad1.kolicina), sum(ad2.kolicina), sum(CASE WHEN (ad2.kolicina is null) THEN (ad1.kolicina*ad1.prodCena)%valuta% ELSE ((ad1.kolicina-ad2.kolicina)*ad1.prodCena)%valuta% END), sum(CASE WHEN (d1.tip = '%tipF%' or d1.tip = '%tipFR%') THEN ((ad1.kolicina*ad1.prodCena)*ad1.procRabata/100)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFR%') THEN ((ad2.kolicina*ad2.prodCena)*ad2.procRabata/100)%valuta% ELSE 0 END)  FROM RobnaGrupa rg, Artikal a, Radnajedinica rj, Stanje s, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE a.sfrProizvod = ad1.sfrProizvod %valutaW% and a.sfrProizvod = s.sfrProizvod and s.oznRj = rj.oznRj and s.oznOgranak = rj.oznOgranak and d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND rj.oznRj=':rj' AND rj.oznOgranak=':ogranak' AND a.oznRobGr = rg.oznRobGr AND d1.storno = 0 and d1.arhiviran = 1 AND d1.datum>=':datumOd' AND d1.datum<=':datumDo' AND rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%') ";
                        if (((String)PzDialogPregledNabavkeProdajeArtikala.this.panelRBs1.getSelectedValue()).equals(PzDialogPregledNabavkeProdajeArtikala.PO_ROBNOJ_GRUPI)) {
                            upit = String.valueOf(upit) + " and rg.oznRobGr IN :robGrupa";
                            upit = upit.replace(":robGrupa", PzDialogPregledNabavkeProdajeArtikala.this.entRobnaGrupa.getRobnaGrupaListAsString());
                        }
                        upit = upit.replace(":rj", PzDialogPregledNabavkeProdajeArtikala.this.rj.getId().getOznRj());
                        upit = upit.replace(":ogranak", PzDialogPregledNabavkeProdajeArtikala.this.rj.getId().getOznOgranak());
                        upit = upit.replace(":datumOd", PzDialogPregledNabavkeProdajeArtikala.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzDialogPregledNabavkeProdajeArtikala.this.dfKrajnjiDatum.getVal().toString());
                        upit = String.valueOf(upit) + " GROUP BY ad1.sfrProizvod, ad1.sfrSort, ad1.naziv, s.kolicina, s.alocKolicina ORDER BY ad1.sfrSort";
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/k.srednji/k.jedinica");
                        upit = upit.replace("%valutaG%", valuta.equals("") ? " " : ",k.srednji, k.jedinica ");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs k ON k.datum = d1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " and k.oznValuta='" + valuta + "'");
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                        upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        q = em.createNativeQuery(upit);
                    } else if (PzDialogPregledNabavkeProdajeArtikala.this.parameter.equals("NPRJ")) {
                        upit = "SELECT a.sfrProizvod, a.naziv, d1.sfrKomitent, d1.oznDokumenta, d1.datum, ad1.procRabata, ad1.nabCena%valuta%, ad1.prodCena%valuta%, sum(CASE WHEN (d1.tip = '%tipK%' ) THEN ad1.kolicina ELSE 0 END),  sum(CASE WHEN (d2.tip = '%tipK%' ) THEN ad2.kolicina ELSE 0 END), sum(CASE WHEN (d1.tip = '%tipK%' ) THEN (ad1.kolicina*ad1.nabCena)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipK%' ) THEN (ad2.kolicina*ad2.nabCena)%valuta% ELSE 0 END), sum(CASE WHEN (d1.tip = '%tipF%' or d1.tip = '%tipFI%' or d1.tip = '%tipFS%' or d1.tip = '%tipFR%' ) THEN ad1.kolicina ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFI%' or d2.tip = '%tipFS%' or d2.tip = '%tipFR%' ) THEN ad2.kolicina ELSE 0 END), sum(CASE WHEN (d1.tip = '%tipF%' or d1.tip = '%tipFS%' or d1.tip = '%tipFI%' or d1.tip = '%tipFR%' ) THEN (ad1.kolicina*ad1.prodCena)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFS%' or d2.tip = '%tipFI%' or d2.tip = '%tipFR%' ) THEN (ad2.kolicina*ad2.prodCena)%valuta% ELSE 0 END) FROM RobnaGrupa rg, Artikal a, Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND CASE WHEN (d1.tip = '%tipK%' ) THEN ad1.nabCena = ad2.nabCena ELSE ad1.prodCena = ad2.prodCena END WHERE a.sfrProizvod = ad1.sfrProizvod %valutaW% and d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND a.oznRobGr = rg.oznRobGr AND rj.oznRj ='" + PzDialogPregledNabavkeProdajeArtikala.this.rj.getId().getOznRj() + "' and rj.oznOgranak='" + PzDialogPregledNabavkeProdajeArtikala.this.rj.getId().getOznOgranak() + "' and rj.oznRj IN (%listaRj%) and " + "d1.tip IN ('%tipF%', '%tipFI%','%tipFS%', '%tipFR%','%tipK%') AND " + "d1.datum>=':datumOd'  AND d1.datum<=':datumDo' AND d1.storno = 0 and d1.arhiviran = 1 ";
                        if (((String)PzDialogPregledNabavkeProdajeArtikala.this.panelRBs1.getSelectedValue()).equals(PzDialogPregledNabavkeProdajeArtikala.PO_ROBNOJ_GRUPI)) {
                            upit = String.valueOf(upit) + " and rg.oznRobGr IN :robGrupa";
                            upit = upit.replace(":robGrupa", PzDialogPregledNabavkeProdajeArtikala.this.entRobnaGrupa.getRobnaGrupaListAsString());
                        }
                        upit = String.valueOf(upit) + "GROUP BY  ad1.sfrSort, a.sfrProizvod, a.naziv, d1.oznDokumenta, d1.sfrKomitent, d1.datum, ad1.procRabata, ad1.nabCena, ad1.prodCena %valutaG%ORDER BY ad1.sfrSort";
                        upit = upit.replace(":datumOd", PzDialogPregledNabavkeProdajeArtikala.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzDialogPregledNabavkeProdajeArtikala.this.dfKrajnjiDatum.getVal().toString());
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/k.srednji/k.jedinica");
                        upit = upit.replace("%valutaG%", valuta.equals("") ? " " : ",k.srednji, k.jedinica ");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs k ON k.datum = d1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " and k.oznValuta='" + valuta + "'");
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                        upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        q = em.createNativeQuery(upit);
                    }
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogPregledNabavkeProdajeArtikala.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogPregledNabavkeProdajeArtikala.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogPregledNabavkeProdajeArtikala.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogPregledNabavkeProdajeArtikala.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogPregledNabavkeProdajeArtikala.this.showReports();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)PzDialogPregledNabavkeProdajeArtikala.this.thisDialog, (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void radioGroupChanged(String selectionChanged) {
        this.tfRobnaGrupa.setFocusable(false);
        this.tfRobnaGrupa.setEditable(false);
        this.tfRobnaGrupa.setText("");
        this.tfProizvodjac.setFocusable(false);
        this.tfProizvodjac.setEditable(false);
        this.tfProizvodjac.setText("");
        this.tfDobavljac.setFocusable(false);
        this.tfDobavljac.setEditable(false);
        this.tfDobavljac.setText("");
        this.indRobnaGrupa.setFocusable(false);
        this.indRobnaGrupa.setEnabled(false);
        this.indRobnaGrupa.setState(0);
        this.indProizvodjac.setFocusable(false);
        this.indProizvodjac.setEnabled(false);
        this.indProizvodjac.setState(0);
        this.indDobavljac.setFocusable(false);
        this.indDobavljac.setEnabled(false);
        this.indDobavljac.setState(0);
        if (selectionChanged.equals(PO_ROBNOJ_GRUPI)) {
            this.tfRobnaGrupa.setFocusable(true);
            this.tfRobnaGrupa.setEditable(true);
            this.indRobnaGrupa.setFocusable(true);
            this.indRobnaGrupa.setEnabled(true);
            this.entKomitent = null;
        } else if (selectionChanged.equals(PO_PROIZVODJACU)) {
            this.tfProizvodjac.setFocusable(true);
            this.tfProizvodjac.setEditable(true);
            this.indProizvodjac.setFocusable(true);
            this.indProizvodjac.setEnabled(true);
            this.entRobnaGrupa = null;
        } else if (selectionChanged.equals(PO_DOBAVLJACU)) {
            this.tfDobavljac.setFocusable(true);
            this.tfDobavljac.setEditable(true);
            this.indDobavljac.setFocusable(true);
            this.indDobavljac.setEnabled(true);
            this.entRobnaGrupa = null;
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Robnagrupa) {
            this.entRobnaGrupa = (Robnagrupa)entity;
            this.tfRobnaGrupa.setVal((Object)this.entRobnaGrupa.getOznRobGr());
        } else if (entity instanceof Komitent) {
            this.entKomitent = (Komitent)entity;
            if (((String)this.panelRBs1.getSelectedValue()).equals(PO_PROIZVODJACU)) {
                this.tfProizvodjac.setVal((Object)this.entKomitent.getSfrKomitent());
            } else {
                this.tfDobavljac.setVal((Object)this.entKomitent.getSfrKomitent());
            }
        }
        this.panelFields.updateAllFieldsState();
    }

    public boolean shouldBeShown() {
        try {
            if (this.parameter.equals("GALH")) {
                this.setTitle("Uporedni pregled nabavke i prodaje");
            } else {
                this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0))});
                if (this.rj != null) {
                    this.setTitle(this.parameter.equals("GALD") ? "Pregled prodaje artikala" : "Pregled prodaje i nabavke artikala");
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            return false;
        }
    }

    private void showReports() throws Exception {
        Vector<Object> data = new Vector<Object>();
        data.add(PzFirma.getFirma());
        data.add(this.rj);
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "";
        String subtitle = "u periodu od " + PzDateUtility.formatDate((Date)this.dfPocetni.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfKrajnjiDatum.getVal());
        String fname = "";
        String krit = "";
        if (this.parameter.equals("GALH")) {
            title = "PREGLED NABAVKE I PRODAJE ARTIKALA";
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.nabavke.i.prodaje.jasper";
            if (((String)this.panelRBs1.getSelectedValue()).equals(SVI_ARTIKLI)) {
                krit = SVI_ARTIKLI;
            } else if (((String)this.panelRBs1.getSelectedValue()).equals(PO_ROBNOJ_GRUPI)) {
                krit = "Robna grupa: [ " + this.entRobnaGrupa.getOznRobGr() + " ] " + this.entRobnaGrupa.getNaziv();
            } else if (((String)this.panelRBs1.getSelectedValue()).equals(PO_PROIZVODJACU)) {
                krit = "Proizvo\u0111a\u010d: [ " + this.entKomitent.getSfrKomitent() + " ] " + this.entKomitent.getNaziv();
            } else if (((String)this.panelRBs1.getSelectedValue()).equals(PO_DOBAVLJACU)) {
                krit = "Dobavlja\u010d: [ " + this.entKomitent.getSfrKomitent() + " ] " + this.entKomitent.getNaziv();
            }
        } else if (this.parameter.equals("GALD") && ((String)this.panelRBs2.getSelectedValue()).equals(DETALJNO)) {
            title = "PREGLED PRODAJE ARTIKALA";
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.prodaje.jasper";
            krit = ((String)this.panelRBs1.getSelectedValue()).equals(SVI_ARTIKLI) ? SVI_ARTIKLI : "Robna grupa: [ " + this.entRobnaGrupa.getOznRobGr() + " ] " + this.entRobnaGrupa.getNaziv();
        } else if (this.parameter.equals("GALD") && ((String)this.panelRBs2.getSelectedValue()).equals(ZBIRNO)) {
            title = "PREGLED PRODAJE ARTIKALA";
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.prodaje.zbirno.jasper";
            krit = ((String)this.panelRBs1.getSelectedValue()).equals(SVI_ARTIKLI) ? SVI_ARTIKLI : "Robna grupa: [ " + this.entRobnaGrupa.getOznRobGr() + " ] " + this.entRobnaGrupa.getNaziv();
        } else if (this.parameter.equals("NPRJ")) {
            title = "PREGLED NABAVKE I PRODAJE ARTIKALA";
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.nabavke.prodaje.rj.jasper";
            krit = ((String)this.panelRBs1.getSelectedValue()).equals(SVI_ARTIKLI) ? SVI_ARTIKLI : "Robna grupa: [ " + this.entRobnaGrupa.getOznRobGr() + " ] " + this.entRobnaGrupa.getNaziv();
        }
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValute.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValute.getSelectedChoice().getText());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Date today = PzDateUtility.getCurrentDate();
        params.put("title", title);
        params.put("datum", today);
        params.put("subtitle", subtitle);
        params.put("reklama", "");
        params.put("valuta", valuta);
        params.put("krit", krit);
        if (this.parameter.equals("GALH")) {
            params.put("dobavljac", ((String)this.panelRBs1.getSelectedValue()).equals(PO_DOBAVLJACU));
        }
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPregledNabavkeProdajeArtikala(Boolean.FALSE);
    }

    public PzDialogPregledNabavkeProdajeArtikala(Boolean initGUI) {
    }
}

