/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaProdajePoKomercijalisti;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitentgrupa;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class PzdialogProdajaZaPeriod
extends PzDialog {
    private static final String PARAM_PRODAJA = "prodaja";
    private static final String PARAM_PRODAJA_TEREN = "prodajaTeren";
    private static final String PARAM_PROVIZIJA = "provizija";
    private static final String PARAM_TEREN = "teren";
    private static final String PARAM_DUGOVANJE = "dugovanje";
    private static final String PARAM_OTVORENE_STAVKE = "otvorene_stavke";
    private static final String PARAM_ROBNA_GRUPA = "robna_grupa";
    private PzPanel mainPanel;
    private PzDateField dfKrajnji;
    private PzComboBox cbKomercijalista;
    private JLabel lblKomercijalista;
    private PzPanel pnlDatum;
    private JPanel pnlValuta;
    private PzButton btnPotvrdi;
    private JLabel lblKrajnji;
    private PzDateField dfPocetni;
    private JLabel lblPocetnt;
    private PzComboBox cbValuta;
    private ScrollableCursor cursor = null;
    private String parameter = "";

    public PzdialogProdajaZaPeriod(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
        this.setFirstComponentInFocus((Component)this.dfPocetni);
    }

    private void postInit() {
        try {
            Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
            Iterator i = q.getResultList().iterator();
            this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
            while (i.hasNext()) {
                Valuta v = (Valuta)i.next();
                this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
            }
            if (this.parameter.equals(PARAM_PROVIZIJA) || this.parameter.equals(PARAM_DUGOVANJE) || this.parameter.equals(PARAM_OTVORENE_STAVKE) || this.parameter.equals(PARAM_ROBNA_GRUPA)) {
                this.lblKomercijalista.setVisible(true);
                this.cbKomercijalista.setVisible(true);
                Query qGrupa = PzEntityManager.getEm().createQuery("SELECT g FROM Komitentgrupa g Where g.tip = 'KOMERC' ");
                Iterator kom = qGrupa.getResultList().iterator();
                this.cbKomercijalista.addItem((Object)new PzChoice("", (Object)""));
                while (kom.hasNext()) {
                    Komitentgrupa kGrupa = (Komitentgrupa)kom.next();
                    this.cbKomercijalista.addItem((Object)new PzChoice(kGrupa.getNaziv(), (Object)kGrupa.getIdKomitentGrupa()));
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            if (this.parameter.equals(PARAM_PRODAJA)) {
                this.setTitle("Pregled prodaje za period");
            } else if (this.parameter.equals(PARAM_PROVIZIJA)) {
                this.setTitle("Pregled provizije po komercijalistima");
            } else {
                this.setTitle("Pregled dugovanja za period");
            }
            this.mainPanel = new PzPanel();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{17, 7, 49, 20, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0};
            mainPanelLayout.columnWidths = new int[]{113, 133, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlValuta = new PzPanel();
            this.mainPanel.add((Component)this.pnlValuta, (Object)new GridBagConstraints(2, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 5, 10, 10), 0, 0));
            GridBagLayout pnlValutaLayout = new GridBagLayout();
            pnlValutaLayout.rowWeights = new double[]{0.0, 0.0};
            pnlValutaLayout.rowHeights = new int[]{2, 28};
            pnlValutaLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlValutaLayout.columnWidths = new int[]{16, 135, 7};
            this.pnlValuta.setLayout(pnlValutaLayout);
            this.pnlValuta.setBorder(BorderFactory.createTitledBorder("Izbor strane valute"));
            this.pnlValuta.setOpaque(false);
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.pnlDatum = new PzPanel();
            GridBagLayout pnlDatumLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlDatum, (Object)new GridBagConstraints(0, 0, 2, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlDatumLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.1};
            pnlDatumLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlDatumLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlDatumLayout.columnWidths = new int[]{18, 97, 120, 7};
            this.pnlDatum.setLayout((LayoutManager)pnlDatumLayout);
            this.dfKrajnji = new PzDateField();
            this.pnlDatum.add((Component)this.dfKrajnji, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfPocetni = new PzDateField();
            this.pnlDatum.add((Component)this.dfPocetni, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfPocetni.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.lblPocetnt = new JLabel();
            this.pnlDatum.add((Component)this.lblPocetnt, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.lblPocetnt.setText("Po\u010detni datum");
            this.lblKrajnji = new JLabel();
            this.pnlDatum.add((Component)this.lblKrajnji, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.lblKrajnji.setText("Krajnji datum");
            this.lblKomercijalista = new JLabel();
            this.mainPanel.add((Component)this.lblKomercijalista, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 18, 0, 0), 0, 0));
            this.lblKomercijalista.setName("lblKomercijalista");
            this.lblKomercijalista.setVisible(false);
            this.cbKomercijalista = new PzComboBox();
            this.mainPanel.add((Component)this.cbKomercijalista, (Object)new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 2, 0, 10), 0, 0));
            this.cbKomercijalista.setVisible(false);
            this.cbKomercijalista.setFont(new Font("SansSerif", 0, 14));
            this.pack();
            this.setResizable(false);
            this.setRestorable(false);
            this.setSize(448, 199);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzdialogProdajaZaPeriod.this.cursor != null) {
                        PzdialogProdajaZaPeriod.this.cursor.close();
                    }
                    String upit = "";
                    String valuta = PzdialogProdajaZaPeriod.this.cbValuta.getSelectedChoice().getValue().toString();
                    Query q = null;
                    if (PzdialogProdajaZaPeriod.this.parameter.equals(PzdialogProdajaZaPeriod.PARAM_PRODAJA)) {
                        upit = "SELECT kGrupa.naziv, k.sfrKomitent, k.naziv, ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina), sum(ad2.kolicina), sum((ad1.kolicina*ad1.prodCena)%valuta%), sum((ad2.kolicina*ad2.prodCena)%valuta%), sum(CASE WHEN (d1.tip = '%tipF%' or  d1.tip = '%tipFR%') THEN ((ad1.prodCena*ad1.procRabata/100)*ad1.kolicina)%valuta% WHEN (d1.tip = '%tipFS%' or d1.tip = '%tipFI%') THEN (ad1.prodCena*ad1.kolicina)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%'  or d2.tip = '%tipFR%') THEN ((ad2.prodCena*ad2.procRabata/100)*ad2.kolicina)%valuta% WHEN (d2.tip = '%tipFS%' or d2.tip = '%tipFI%') THEN (ad2.prodCena*ad2.kolicina)%valuta% ELSE 0 END),  a.jedMere, a.tezina FROM Radnajedinica rj, Komitentgrupa kGrupa, KomitentGrupaLink kGrupaLink, Artikal a, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Faktura f ON f.iddok = d1.iddok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena Where %valutaW% a.sfrProizvod = ad1.sfrProizvod and d1.storno = 0 and d1.arhiviran = 1 AND d1.sfrKomitent = k.sfrKomitent and d1.datum >= ':datumOd' AND d1.datum <= ':datumDo' AND d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND k.sfrKomitent = kGrupaLink.sfrKomitent and kGrupaLink.idKomitentGrupa = kGrupa.idKomitentGrupa and kGrupa.tip= 'KOMERC' and rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%') ";
                        upit = String.valueOf(upit) + " GROUP BY kGrupa.naziv, k.sfrKomitent, k.naziv, ad1.sfrProizvod, ad1.sfrSort, ad1.naziv, a.jedMere, a.tezina ORDER BY kGrupa.naziv, k.sfrKomitent, ad1.sfrSort";
                        upit = upit.replace(":datumOd", PzdialogProdajaZaPeriod.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzdialogProdajaZaPeriod.this.dfKrajnji.getVal().toString());
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and");
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                        upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                    } else if (PzdialogProdajaZaPeriod.this.parameter.equals(PzdialogProdajaZaPeriod.PARAM_PRODAJA_TEREN)) {
                        upit = "SELECT p.value, k.sfrKomitent, k.naziv, ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina), sum(ad2.kolicina), sum((ad1.kolicina*ad1.prodCena)%valuta%), sum((ad2.kolicina*ad2.prodCena)%valuta%), sum(CASE WHEN (d1.tip = '%tipF%' or  d1.tip = '%tipFR%') THEN ((ad1.prodCena*ad1.procRabata/100)*ad1.kolicina)%valuta% WHEN (d1.tip = '%tipFS%' or d1.tip = '%tipFI%') THEN (ad1.prodCena*ad1.kolicina)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%'  or d2.tip = '%tipFR%') THEN ((ad2.prodCena*ad2.procRabata/100)*ad2.kolicina)%valuta% WHEN (d2.tip = '%tipFS%' or d2.tip = '%tipFI%') THEN (ad2.prodCena*ad2.kolicina)%valuta% ELSE 0 END),  a.jedMere, a.tezina FROM Radnajedinica rj, Artikal a, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Faktura f ON f.iddok = d1.iddok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent LEFT JOIN Komitentparameter p on p.sfrKomitent = k.sfrKomitent and p.idParameter LIKE '%LOKACIJA%' %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena Where %valutaW% a.sfrProizvod = ad1.sfrProizvod and d1.storno = 0 and d1.arhiviran = 1 AND d1.sfrKomitent = k.sfrKomitent and d1.datum >= ':datumOd' AND d1.datum <= ':datumDo' AND d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOgranak AND rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%') ";
                        upit = String.valueOf(upit) + " GROUP BY p.value, k.sfrKomitent, k.naziv, ad1.sfrProizvod, ad1.sfrSort, ad1.naziv, a.jedMere, a.tezina ORDER BY p.value, k.sfrKomitent, ad1.sfrSort";
                        upit = upit.replace(":datumOd", PzdialogProdajaZaPeriod.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzdialogProdajaZaPeriod.this.dfKrajnji.getVal().toString());
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and");
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                        upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                    } else if (PzdialogProdajaZaPeriod.this.parameter.equals(PzdialogProdajaZaPeriod.PARAM_PROVIZIJA)) {
                        upit = "Select kGrupa.naziv, k.sfrKomitent, k.naziv, f.oznDokumenta, f.datum, f.iznos, f.datValute, ROUND(f.iznosBezPoreza/f.iznos, 2), sum(case when (u.tip = '%tipUKP%' ) then (-u.iznossaporezom) %valuta% else u.iznossaporezom %valuta% END), kGrupa.provizija From Opstidokument u, Faktura f, Komitent k, Komitentgrupa kGrupa, KomitentGrupaLink kGrupaLink %valutaFS% where %valutaW% %komerc% u.int1 = f.iddok and u.sfrKomitent = k.sfrKomitent and k.sfrKomitent = kGrupaLink.sfrKomitent and kGrupaLink.idKomitentGrupa = kGrupa.idKomitentGrupa and kGrupa.tip= 'KOMERC' and u.datum >= ':datumOd' AND u.datum <= ':datumDo' and u.tip IN ('%tipUKP%', '%tipUK%') group by kGrupa.naziv, k.sfrKomitent, f.oznDokumenta, f.datum, f.iznos, f.datValute, kGrupa.provizija, f.iznosBezPoreza, u.datum order by kGrupa.naziv, k.sfrKomitent, f.oznDokumenta ";
                        upit = upit.replace(":datumOd", PzdialogProdajaZaPeriod.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzdialogProdajaZaPeriod.this.dfKrajnji.getVal().toString());
                        upit = PzdialogProdajaZaPeriod.this.cbKomercijalista.getSelectedChoice().getValue().toString().equals("") ? upit.replace("%komerc%", " ") : upit.replace("%komerc%", " kGrupa.idKomitentGrupa =" + PzdialogProdajaZaPeriod.this.cbKomercijalista.getSelectedChoice().getValue().toString() + " and ");
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipUKP%", TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ);
                        upit = upit.replace("%tipUK%", TipDokumentConfig.get().UPLATA_KUPCA);
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f.datPrometa");
                        upit = upit.replace("%valutaFS%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                    } else if (PzdialogProdajaZaPeriod.this.parameter.equals(PzdialogProdajaZaPeriod.PARAM_TEREN)) {
                        upit = "select p.value, k.sfrKomitent, k.naziv,sum(CASE WHEN (f.datValute <':trenutniDatum') THEN (f.iznos-f.stornoIznos-f.uplata)%valuta% ELSE 0 END), sum(CASE WHEN (f.datValute >=':trenutniDatum') THEN (f.iznos-f.stornoIznos-f.uplata)%valuta% ELSE 0 END), sum((f.iznos - f.stornoIznos - f.uplata) %valuta%), f.datValute,  f.oznDokumenta, f.datum From faktura f LEFT JOIN Komitent k on k.sfrKomitent = f.sfrKomitent LEFT JOIN Komitentparameter p on p.sfrKomitent = k.sfrKomitent and p.idParameter LIKE '%LOKACIJA%' %valutaF% Where %valutaW% f.iznos - f.stornoIznos - f.uplata != 0.0 and f.datum >= ':datumOd' AND f.datum <= ':datumDo' and f.tip IN ('%tipF%', '%tipFS%', '%tipFU%') and f.storno=0 and f.arhiviran = 1 group by p.value, k.sfrkomitent, f.oznDokumenta,  k.naziv, f.datValute, f.datum order by p.value, k.sfrkomitent, f.datValute ";
                        upit = upit.replace(":datumOd", PzdialogProdajaZaPeriod.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzdialogProdajaZaPeriod.this.dfKrajnji.getVal().toString());
                        upit = upit.replace(":trenutniDatum", PzDateUtility.getCurrentDate().toString());
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace("%tipUKP%", TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ);
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        upit = upit.replace("%tipFU%", TipDokumentConfig.get().FAKTURA_USLUGA);
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f.datPrometa");
                        upit = upit.replace("%valutaFS%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                    } else if (PzdialogProdajaZaPeriod.this.parameter.equals(PzdialogProdajaZaPeriod.PARAM_DUGOVANJE)) {
                        upit = "select kGrupa.naziv, k.sfrKomitent, k.naziv,sum(CASE WHEN (f.datValute <':trenutniDatum') THEN (f.iznos-f.stornoIznos-f.uplata)%valuta% ELSE 0 END), sum(CASE WHEN (f.datValute >=':trenutniDatum') THEN (f.iznos-f.stornoIznos-f.uplata)%valuta% ELSE 0 END), sum((f.iznos - f.stornoIznos - f.uplata) %valuta%), f.datValute,  f.oznDokumenta, f.datum From Komitentgrupa kGrupa, KomitentGrupaLink kGrupaLink, faktura f LEFT JOIN Komitent k on k.sfrKomitent = f.sfrKomitent %valutaF% Where %valutaW% %komerc% f.iznos - f.stornoIznos - f.uplata != 0.0 and f.datum >= ':datumOd' AND f.datum <= ':datumDo' and f.tip IN ('%tipF%', '%tipFS%', '%tipFU%') and f.storno=0 and f.arhiviran = 1 and k.sfrKomitent = kGrupaLink.sfrKomitent and kGrupaLink.idKomitentGrupa = kGrupa.idKomitentGrupa and kGrupa.tip= 'KOMERC' group by kGrupa.naziv, k.sfrkomitent, f.oznDokumenta,  k.naziv, f.datValute, f.datum order by kGrupa.naziv, k.sfrkomitent, f.datValute ";
                        upit = upit.replace(":datumOd", PzdialogProdajaZaPeriod.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzdialogProdajaZaPeriod.this.dfKrajnji.getVal().toString());
                        upit = upit.replace(":trenutniDatum", PzDateUtility.getCurrentDate().toString());
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = PzdialogProdajaZaPeriod.this.cbKomercijalista.getSelectedChoice().getValue().toString().equals("") ? upit.replace("%komerc%", " ") : upit.replace("%komerc%", " kGrupa.idKomitentGrupa =" + PzdialogProdajaZaPeriod.this.cbKomercijalista.getSelectedChoice().getValue().toString() + " and ");
                        upit = upit.replace("%tipUKP%", TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ);
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        upit = upit.replace("%tipFU%", TipDokumentConfig.get().FAKTURA_USLUGA);
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f.datPrometa");
                        upit = upit.replace("%valutaFS%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                    } else if (PzdialogProdajaZaPeriod.this.parameter.equals(PzdialogProdajaZaPeriod.PARAM_OTVORENE_STAVKE)) {
                        upit = "select kGrupa.naziv, k.sfrKomitent, k.naziv,sum((f.iznos-f.stornoIznos)%valuta%), sum(f.uplata %valuta%), sum((f.iznos - f.stornoIznos - f.uplata) %valuta%), f.datValute,  f.oznDokumenta, f.datum From Komitentgrupa kGrupa, KomitentGrupaLink kGrupaLink, faktura f LEFT JOIN Komitent k on k.sfrKomitent = f.sfrKomitent %valutaF% Where %valutaW% %komerc% f.iznos - f.stornoIznos - f.uplata != 0.0 and f.datum >= ':datumOd' AND f.datum <= ':datumDo' and f.tip IN ('%tipF%', '%tipFS%', '%tipFU%') and f.storno=0 and f.arhiviran = 1 and k.sfrKomitent = kGrupaLink.sfrKomitent and kGrupaLink.idKomitentGrupa = kGrupa.idKomitentGrupa and kGrupa.tip= 'KOMERC' group by kGrupa.naziv, k.sfrkomitent, f.oznDokumenta,  k.naziv, f.datValute, f.datum order by kGrupa.naziv, k.sfrkomitent, f.datValute ";
                        upit = upit.replace(":datumOd", PzdialogProdajaZaPeriod.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzdialogProdajaZaPeriod.this.dfKrajnji.getVal().toString());
                        upit = upit.replace(":trenutniDatum", PzDateUtility.getCurrentDate().toString());
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = PzdialogProdajaZaPeriod.this.cbKomercijalista.getSelectedChoice().getValue().toString().equals("") ? upit.replace("%komerc%", " ") : upit.replace("%komerc%", " kGrupa.idKomitentGrupa =" + PzdialogProdajaZaPeriod.this.cbKomercijalista.getSelectedChoice().getValue().toString() + " and ");
                        upit = upit.replace("%tipUKP%", TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ);
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        upit = upit.replace("%tipFU%", TipDokumentConfig.get().FAKTURA_USLUGA);
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f.datPrometa");
                        upit = upit.replace("%valutaFS%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                    } else if (PzdialogProdajaZaPeriod.this.parameter.equals(PzdialogProdajaZaPeriod.PARAM_ROBNA_GRUPA)) {
                        upit = "select kGrupa.naziv, k.sfrKomitent,k.naziv,rg.oznRobGr, rg.naziv,sum(CASE WHEN f.storno = 0 THEN af.kolicina*af.prodcena*(100-af.procRabata)/100 ELSE -af.kolicina*af.prodcena*(100-af.procRabata)/100 END) %valuta% From Komitentgrupa kGrupa, KomitentGrupaLink kGrupaLink, Faktura f LEFT JOIN Komitent k on k.sfrKomitent = f.sfrKomitent LEFT JOIN ArtikalFaktura af on af.idDok = f.idDok LEFT JOIN Artikal a ON af.sfrProizvod = a.sfrProizvod LEFT JOIN RobnaGrupa rg ON a.oznRobGr = rg.oznRobGr %valutaF% Where %valutaW% %komerc% f.datum >= ':datumOd' AND f.datum <= ':datumDo' and f.tip IN ('%tipF%') and f.storno=0 and f.arhiviran = 1 and k.sfrKomitent = kGrupaLink.sfrKomitent and kGrupaLink.idKomitentGrupa = kGrupa.idKomitentGrupa and kGrupa.tip= 'KOMERC' group by kGrupa.naziv, rg.oznRobGr, rg.naziv, k.sfrKomitent, k.naziv order by kGrupa.naziv, k.sfrKomitent, rg.oznRobGr";
                        upit = upit.replace(":datumOd", PzdialogProdajaZaPeriod.this.dfPocetni.getVal().toString());
                        upit = upit.replace(":datumDo", PzdialogProdajaZaPeriod.this.dfKrajnji.getVal().toString());
                        upit = upit.replace(":trenutniDatum", PzDateUtility.getCurrentDate().toString());
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = PzdialogProdajaZaPeriod.this.cbKomercijalista.getSelectedChoice().getValue().toString().equals("") ? upit.replace("%komerc%", " ") : upit.replace("%komerc%", " kGrupa.idKomitentGrupa =" + PzdialogProdajaZaPeriod.this.cbKomercijalista.getSelectedChoice().getValue().toString() + " and ");
                        upit = upit.replace("%tipUKP%", TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ);
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        upit = upit.replace("%tipFU%", TipDokumentConfig.get().FAKTURA_USLUGA);
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f.datPrometa");
                        upit = upit.replace("%valutaFS%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = f1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                    }
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzdialogProdajaZaPeriod.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzdialogProdajaZaPeriod.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    block6: {
                        try {
                            try {
                                this.get();
                                if (PzdialogProdajaZaPeriod.this.cursor.size() == 0) {
                                    JOptionPane.showMessageDialog(PzdialogProdajaZaPeriod.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                                    PzWorkerDialog.hideStatus();
                                    break block6;
                                }
                                PzdialogProdajaZaPeriod.this.showReports();
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle((Component)((Object)PzdialogProdajaZaPeriod.this), (Throwable)e);
                                PzWorkerDialog.hideStatus();
                                em.close();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = null;
        String subtitle = "Period: " + PzDateUtility.formatDate((Date)this.dfPocetni.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfKrajnji.getVal());
        String fname = "";
        String param = "";
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText());
        if (this.parameter.equals(PARAM_PRODAJA)) {
            param = PARAM_PRODAJA;
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.prodaje.komercijalista.jasper";
            title = "PREGLED PRODAJE PO KOMERCIJALISTIMA";
        } else if (this.parameter.equals(PARAM_PRODAJA_TEREN)) {
            param = PARAM_PRODAJA_TEREN;
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.prodaje.komercijalista.jasper";
            title = "PREGLED PRODAJE PO TERENIMA";
        } else if (this.parameter.equals(PARAM_PROVIZIJA)) {
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.provizije.komercijalista.jasper";
            title = "PREGLED PROVIZIJE PO KOMERCIJALISTIMA";
        } else if (this.parameter.equals(PARAM_TEREN)) {
            param = PARAM_TEREN;
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.dugovanja.po.komercijalistima.jasper";
            title = "PREGLED DUGOVANJA PO TERENIMA";
        } else if (this.parameter.equals(PARAM_DUGOVANJE)) {
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.dugovanja.po.komercijalistima.jasper";
            title = "PREGLED DUGOVANJA PO KOMERCIJALISTIMA";
        } else if (this.parameter.equals(PARAM_OTVORENE_STAVKE)) {
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.otvorenih.stavki.po.komercijalistima.jasper";
            title = "OTVORENE STAVKE PO KOMERCIJALISTIMA";
        } else if (this.parameter.equals(PARAM_ROBNA_GRUPA)) {
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.robne.grupe.po.komercijalistima.jasper";
            title = "PREGLED PRODAJE PO KUPCU I ROBROJ GRUPI";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("subtitle", subtitle);
        params.put("datum", today);
        params.put("reklama", "");
        params.put("valuta", valuta);
        params.put("parameter", param);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (this.cursor != null) {
            this.cursor.close();
        }
    }
}

