/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.tableModels;

import java.math.BigDecimal;
import java.sql.Date;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.artikli.kartica.RuleKarticaArtikla;
import rs.pezar.db.entity.Stanje;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.data.models.PzScrollableTableModel;

public class PzTableModelKarticaArtikla
extends PzScrollableTableModel {
    private static final long serialVersionUID = 1L;
    public static final String TIP_PRODAJNA = "PRODAJNA";
    public static final String TIP_PROSECNA = "PROSECNA_NABAVNA";
    public String[] kColNames = null;
    String karticaTip;
    public static final byte FIELD_DATUM = 0;
    public static final byte FIELD_KOMITENT = 1;
    public static final byte FIELD_DOKUMENT = 2;
    public static final byte FIELD_NAZIV_DOKUMENTA = 3;
    public static final byte FIELD_KALKULACIJA_BR = 4;
    public static final byte FIELD_CENA = 5;
    public static final byte FIELD_ULAZ = 6;
    public static final byte FIELD_IZLAZ = 7;
    public static final byte FIELD_STANJE = 8;
    public static final byte FIELD_RABAT = 9;
    public static final byte FIELD_VREDNOST_ULAZA = 10;
    public static final byte FIELD_VREDNOST_IZLAZA = 11;
    public static final byte FIELD_SALDO = 12;
    public static final byte FIELD_NZK = 13;
    private double[] saldoUkupno;
    private double[] stanjeUkupno;
    Double kolicinaUlaza = 0.0;
    Double kolicinaIzlaza = 0.0;
    Double vrednostUlaza = 0.0;
    Double vrednostIzlaza = 0.0;
    Double vrednostStanje = 0.0;
    Double pocetnoStKolicina = 0.0;
    Double pocetnoStCena = 0.0;
    private RuleKarticaArtikla rules = null;
    private ScrollableCursor cursor;
    public static final String[] kColNamesProdajna = new String[]{"Datum", "Komitent", "Dokument", "Opis dokumenta", "Kalkulacija", "Cena", "ULAZ", "IZLAZ", "Stanje", "%rabat", "Vrednost ulaza", "Vrednost izlaza", "Saldo", "Proknji\u017een", "Opis"};
    public static final String[] kColNamesProsNab = new String[]{"Datum", "Komitent", "Dokument", "Opis dokumenta", "Kalkulacija", "Nab. Cena", "ULAZ", "IZLAZ", "Stanje", "Vrednost ulaza", "Vrednost izlaza", "Saldo", "Pros. nabavna cena", "Prodajna cena", "Proknji\u017een", "Opis"};

    public PzTableModelKarticaArtikla(Stanje s, ScrollableCursor cursor, RuleKarticaArtikla ruleKA, String tipKartice) {
        this.cursor = cursor;
        this.saldoUkupno = new double[cursor.size()];
        this.stanjeUkupno = new double[cursor.size()];
        this.rules = ruleKA;
        this.pocetnoStKolicina = s.getKolPop();
        this.pocetnoStCena = s.getCenaNaPS();
        this.karticaTip = tipKartice;
        this.kColNames = tipKartice.equals(TIP_PROSECNA) ? kColNamesProsNab : kColNamesProdajna;
    }

    public Double getkrajnjiSaldo() {
        return this.saldoUkupno[this.getRowCount() - 1];
    }

    public Double getKolicinaUlaza() {
        return this.kolicinaUlaza;
    }

    public Double getKolicinaIzlaza() {
        return this.kolicinaIzlaza;
    }

    public Double getVrednostUlaza() {
        return this.vrednostUlaza;
    }

    public Double getVrednostIzlaza() {
        return this.vrednostIzlaza;
    }

    public Double getVrednostStanje() {
        return this.vrednostStanje;
    }

    public synchronized String getColumnName(int columnIndex) {
        if (this.cursor.isClosed()) {
            return null;
        }
        return this.kColNames[columnIndex];
    }

    public synchronized int getColumnCount() {
        return this.kColNames.length;
    }

    public synchronized int getRowCount() {
        if (this.cursor.isClosed()) {
            return 0;
        }
        return this.cursor.size();
    }

    public Object getidDokAt(int index) {
        ScrollableCursor sc = this.cursor;
        if (sc == null || sc.isClosed()) {
            return null;
        }
        sc.size();
        if (sc.size() > 0) {
            if (sc.absolute(index)) {
                Object[] e = (Object[])sc.next();
                return e[10];
            }
            return null;
        }
        return null;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ScrollableCursor sc = this.cursor;
        if (sc == null || sc.isClosed()) {
            return null;
        }
        sc.size();
        if (sc.size() > 0) {
            if (sc.absolute(rowIndex)) {
                Object[] e = (Object[])sc.next();
                return this.getValueSet(e, rowIndex)[columnIndex];
            }
            return null;
        }
        return null;
    }

    private Object[] getValueSet(Object[] dok, int rowIndex) {
        Object[] result = null;
        Date datum = (Date)dok[0];
        String komitent = dok[1] == null ? "" : dok[1];
        String dokument = dok[2] == null ? "" : dok[2];
        String tipDokumenta = dok[3] == null ? "" : dok[3];
        Integer brKalk = (Integer)(dok[4] == null ? Integer.valueOf(0) : dok[4]);
        Double cena = (Double)(dok[6] == null ? Double.valueOf(0.0) : dok[6]);
        Double ulaz = 0.0;
        Double izlaz = 0.0;
        Double rabat = (Double)(dok[5] == null ? Double.valueOf(0.0) : dok[5]);
        Double vrednostUlaza = 0.0;
        Double vrednostIzlaza = 0.0;
        String nzk = (Integer)dok[11] == null ? "0" : String.valueOf((Integer)dok[11]);
        String vrsta = (String)dok[9];
        Double kolicina = (Double)(dok[7] == null ? Double.valueOf(0.0) : dok[7]);
        BigDecimal prodajnaCena = dok[12] == null ? BigDecimal.ZERO : dok[12];
        BigDecimal prosecnaNabavnaCena = dok[13] == null ? BigDecimal.ZERO : dok[13];
        BigDecimal nabavnaCena = new BigDecimal((Double)(dok[14] == null ? new Double(0.0) : dok[14]));
        BigDecimal vrednost = (BigDecimal)(dok[15] == null ? new BigDecimal(0) : dok[15]);
        Integer storno = (Integer)(dok[16] == null ? Integer.valueOf(0) : dok[16]);
        BigDecimal cenaTemp = BigDecimal.ZERO;
        Integer rbr = (Integer)(dok[19] == null ? Integer.valueOf(0) : dok[19]);
        nzk = nzk.equals("0") ? "NE" : "DA";
        String podtip = "";
        if (dok[17] != null) {
            podtip = dok[17].equals("N/A") ? null : (String)dok[17];
        }
        if (!tipDokumenta.equals("KALKULACIJA") && !tipDokumenta.equals(TipDokumentConfig.get().PRIJEMNICA_REPRO)) {
            brKalk = 0;
        }
        String opis = RuleKarticaArtikla.getDocumentOpis(tipDokumenta, dokument, komitent, rbr, storno, datum, podtip);
        if (komitent == null) {
            komitent = "";
        }
        if (this.rules.getPrices().containsKey(tipDokumenta)) {
            cenaTemp = this.rules.getPrices().get(tipDokumenta).equals(2) ? nabavnaCena : (this.rules.getPrices().get(tipDokumenta).equals(1) ? prosecnaNabavnaCena : (this.rules.getPrices().get(tipDokumenta).equals(3) ? new BigDecimal(cena) : (this.rules.getPrices().get(tipDokumenta).equals(5) ? new BigDecimal(cena) : (this.rules.getPrices().get(tipDokumenta).equals(4) ? prodajnaCena : (this.rules.getPrices().get(tipDokumenta).equals(6) ? BigDecimal.ZERO : BigDecimal.ZERO)))));
        }
        if (this.rules.getRules().containsKey(tipDokumenta)) {
            if (this.rules.getRules().get(tipDokumenta) == 0) {
                return null;
            }
            if (this.rules.getRules().get(tipDokumenta) == 5) {
                if (vrsta.equals("I")) {
                    ulaz = -kolicina.doubleValue();
                } else if (vrsta.equals("U")) {
                    if (tipDokumenta.equals(TipDokumentConfig.get().POPIS)) {
                        if (kolicina < 0.0) {
                            izlaz = -kolicina.doubleValue();
                            ulaz = 0.0;
                        } else {
                            ulaz = kolicina;
                        }
                    } else {
                        ulaz = kolicina;
                    }
                } else if (vrsta.equals("X")) {
                    ulaz = kolicina;
                }
                vrednostUlaza = ulaz * cenaTemp.doubleValue();
                vrednostIzlaza = 0.0;
            }
            if (Math.abs(this.rules.getRules().get(tipDokumenta)) == Math.abs(2)) {
                izlaz = this.rules.getRules().get(tipDokumenta) < 0 ? Double.valueOf(-kolicina.doubleValue()) : kolicina;
                vrednostIzlaza = izlaz * cenaTemp.doubleValue();
                vrednostUlaza = 0.0;
            }
            if (Math.abs(this.rules.getRules().get(tipDokumenta)) == Math.abs(1)) {
                ulaz = this.rules.getRules().get(tipDokumenta) < 0 ? Double.valueOf(-kolicina.doubleValue()) : kolicina;
                vrednostIzlaza = 0.0;
                vrednostUlaza = ulaz * cenaTemp.doubleValue();
            }
            if (Math.abs(this.rules.getRules().get(tipDokumenta)) == Math.abs(4)) {
                vrednostIzlaza = vrednost.doubleValue();
                if (this.rules.getRules().get(tipDokumenta) < 0) {
                    vrednostIzlaza = -vrednostIzlaza.doubleValue();
                }
            }
            if (Math.abs(this.rules.getRules().get(tipDokumenta)) == Math.abs(3)) {
                vrednostUlaza = vrednost.doubleValue();
                if (this.rules.getRules().get(tipDokumenta) < 0) {
                    vrednostUlaza = -vrednostUlaza.doubleValue();
                }
            }
        }
        if (storno == 1) {
            ulaz = -ulaz.doubleValue();
            izlaz = -izlaz.doubleValue();
            vrednostIzlaza = -vrednostIzlaza.doubleValue();
            vrednostUlaza = -vrednostUlaza.doubleValue();
            opis = "Strono: " + opis;
        }
        if (rowIndex == 0) {
            this.stanjeUkupno[rowIndex] = ulaz - izlaz + this.pocetnoStKolicina;
            this.saldoUkupno[rowIndex] = this.pocetnoStKolicina * this.pocetnoStCena + vrednostUlaza - vrednostIzlaza;
        } else {
            this.stanjeUkupno[rowIndex] = ulaz - izlaz;
            this.saldoUkupno[rowIndex] = vrednostUlaza - vrednostIzlaza;
        }
        if (rowIndex != 0) {
            this.stanjeUkupno[rowIndex] = this.stanjeUkupno[rowIndex] + this.stanjeUkupno[rowIndex - 1];
            this.saldoUkupno[rowIndex] = this.saldoUkupno[rowIndex] + this.saldoUkupno[rowIndex - 1];
        }
        if (brKalk == 0) {
            brKalk = null;
        }
        result = this.karticaTip.equals(TIP_PROSECNA) ? new Object[]{datum, komitent, dokument, opis, brKalk, cenaTemp, ulaz, izlaz, this.stanjeUkupno[rowIndex], vrednostUlaza, vrednostIzlaza, this.saldoUkupno[rowIndex], prosecnaNabavnaCena, prodajnaCena.doubleValue(), nzk, opis} : new Object[]{datum, komitent, dokument, opis, brKalk, cenaTemp.doubleValue(), ulaz, izlaz, this.stanjeUkupno[rowIndex], rabat, vrednostUlaza, vrednostIzlaza, this.saldoUkupno[rowIndex], nzk, opis};
        return result;
    }
}

