/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.tableModels;

import java.util.Vector;
import rs.pezar.analitike.gui.Settings;
import rs.pezar.db.PzDokument;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.data.models.PzTableModel;

public class PzTableModelObracunKamate
extends PzTableModel {
    private static final long serialVersionUID = 1L;
    public static final byte FIELD_TIP_FAKTURE = 0;
    public static final byte FIELD_BR_FAKTURE = 1;
    public static final byte FIELD_IZN_FAKTURE = 2;
    public static final byte FIELD_DAT_VALUTE = 3;
    public static final byte FIELD_IZN_UPLATE = 4;
    public static final byte FIELD_DAT_UPLATE = 5;
    public static final byte FIELD_SUMA_UPLATA = 6;
    public static final String[] kColNames = new String[]{"Tip Fakture", "Broj fakture", "Iznos fakture", "Datum valute", "Iznos uplate", "Datum uplate", "Suma uplata"};

    public PzTableModelObracunKamate(Vector<PzDokument> data) {
        super(data, PzDokument.class);
    }

    public int getColumnCount() {
        return kColNames.length;
    }

    public int getRowCount() {
        return this.entities != null ? this.entities.size() : 0;
    }

    public String getColumnName(int arg0) {
        return kColNames[arg0];
    }

    public Object getValueAt(int arg0, int arg1) {
        try {
            if (this.entities.size() > 0) {
                PzDokument dokument = (PzDokument)this.entities.get(arg0);
                return this.getValueSet(dokument)[arg1];
            }
            return null;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object[] getValueSet(PzDokument dok) {
        int i = 0;
        while (i < Settings.obracunKamateDokumenta.size()) {
            if (dok.getTip().equalsIgnoreCase(Settings.obracunKamateDokumenta.get(i))) {
                Object[] objectArray = new Object[7];
                objectArray[0] = dok.getTip();
                objectArray[1] = dok.getOznDokumenta();
                objectArray[2] = dok.getIznos();
                objectArray[3] = dok.getDatValute();
                return objectArray;
            }
            if (Settings.obracunKamateUplateKupac.contains(dok.getTip())) {
                if (dok.getTip().equals(TipDokumentConfig.get().UPLATA_KUPCA_POVRACAJ)) {
                    dok.setIznos(dok.getIznos().abs().negate());
                }
                if (dok.getTip().equals(TipDokumentConfig.get().PRENOS_NA_FAKTURU_KUPAC)) {
                    dok.setIznos(dok.getIznos().abs().negate());
                }
                Object[] objectArray = new Object[7];
                objectArray[0] = dok.getTip();
                objectArray[4] = dok.getIznos();
                objectArray[5] = dok.getDatum();
                objectArray[6] = dok.getIznos();
                return objectArray;
            }
            ++i;
        }
        return null;
    }
}

