/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste;

import java.awt.Component;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Lista;
import rs.pezar.liste.DBManager;
import rs.pezar.liste.gui.izrada.Arhiviranje;
import rs.pezar.liste.tipovi.TipListe;
import rs.pezar.reports.PzReportViewer;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class RManager {
    private static RManager instance;
    public static final String HEADER_STANDARD = "rs/pezar/liste/resource/reports/compiled/header.standard.jasper";
    public static final String HEADER_ENVELOPE = "rs/pezar/liste/resource/reports/compiled/header.koverat.jasper";

    public static void showReports(final List<Lista> liste, final JasperReport jr, final String headerTip, final Arhiviranje dlg) {
        PzWorkerDialog.showStatus((String)"Arhiviranje dokumenta je u toku. Molim, sa\u010dekajte.", (PzDialog)dlg);
        SwingWorker<JasperPrint, Integer> sw = new SwingWorker<JasperPrint, Integer>(){
            private EntityManager em;
            List<Artikallista> data;

            @Override
            protected JasperPrint doInBackground() throws Exception {
                this.data = null;
                this.em = PzEntityManagerFactory.getInstance().createEm();
                JasperPrint jp = new JasperPrint();
                boolean firstTime = true;
                for (Lista lista : liste) {
                    String sort;
                    Vector<Object> eData = new Vector<Object>();
                    eData.add(PzFirma.getFirma());
                    eData.add(lista);
                    if (lista.getKomitent() != null) {
                        eData.add(lista.getKomitent());
                    }
                    this.data = DBManager.getArtikals(this.em, lista);
                    if (PzWorkerDialog.getDialogInstance() != null) {
                        PzWorkerDialog.getDialogInstance().getProgressBar().setIndeterminate(false);
                        PzWorkerDialog.getDialogInstance().getProgressBar().setMinimum(0);
                        PzWorkerDialog.getDialogInstance().getProgressBar().setMaximum(this.data.size());
                    }
                    if ((sort = PzParameter.getParameterValue((String)"SORT_NARUDZBENICE", (String)"sifra")).equals("sifra")) {
                        final Integer brNula = Integer.parseInt(PzParameter.getParameterValue((String)"DUZINA_SIFRE", (String)"9", (EntityManager)this.em));
                        Collections.sort(this.data, new Comparator<Artikallista>(){

                            @Override
                            public int compare(Artikallista arg0, Artikallista arg1) {
                                try {
                                    String sifraArg0 = PzEntityUtil.strZero((String)arg0.getSfrProizvod(), (int)brNula);
                                    String sifraArg1 = PzEntityUtil.strZero((String)arg1.getSfrProizvod(), (int)brNula);
                                    return sifraArg0.compareTo(sifraArg1);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    return 0;
                                }
                            }
                        });
                    }
                    PzDataSourceExtended ds = new PzDataSourceExtended(eData, this.data){

                        protected void setProgress(int i) {
                            this.publish(new Integer[]{i});
                        }
                    };
                    ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    TipListe tip = (TipListe)Class.forName(lista.getTip()).newInstance();
                    params.put("title", String.valueOf(tip.getNaziv()) + " broj " + lista.getrBroj() + "/" + PzParameter.getParameterValue((String)"TEKUCA_GODINA"));
                    PzDataSourceExtended headerData = new PzDataSourceExtended(eData, new Vector());
                    headerData.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
                    params.put("headerData", headerData);
                    params.put("headerReport", JRLoader.loadObject((URL)RManager.class.getClassLoader().getResource(headerTip)));
                    String logotip = PzParameter.getParameterValue((String)"LOGOTIP");
                    if (logotip != null && !logotip.equals("")) {
                        params.put("logo", new URL(PzParameter.getParameterValue((String)"LOGOTIP")));
                    }
                    JasperPrint jpTemp = JasperFillManager.fillReport((JasperReport)jr, params, (JRDataSource)ds);
                    if (firstTime) {
                        jp = jpTemp;
                        firstTime = false;
                        continue;
                    }
                    List pages = jpTemp.getPages();
                    for (JRPrintPage page : pages) {
                        jp.addPage(page);
                    }
                }
                return jp;
            }

            @Override
            protected void process(List<Integer> chunks) {
                for (Integer i : chunks) {
                    if (PzWorkerDialog.getDialogInstance() == null) continue;
                    PzWorkerDialog.getDialogInstance().getProgressBar().setValue(i);
                }
            }

            @Override
            protected void done() {
                try {
                    try {
                        String title = "Liste";
                        if (liste.size() == 1) {
                            TipListe tip = (TipListe)Class.forName(((Lista)liste.get(0)).getTip()).newInstance();
                            title = String.valueOf(tip.getNaziv()) + " broj " + ((Lista)liste.get(0)).getrBroj() + "/" + PzParameter.getParameterValue((String)"TEKUCA_GODINA") + " " + PzFirma.getFirma().getNaziv();
                        }
                        PzReportViewer.viewReport((PzDialog)dlg, (JasperPrint)((JasperPrint)this.get()), (String)title);
                        if (dlg != null) {
                            dlg.finished();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PzMysqlExceptionHandler.handle((Component)((Object)dlg), (Throwable)e);
                        this.em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    this.em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        sw.execute();
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+?");
    }

    public static RManager getInstance() {
        if (instance == null) {
            instance = new RManager();
        }
        return instance;
    }

    public TipListe getTipListe(String tip) throws Exception {
        return (TipListe)Class.forName(tip).newInstance();
    }
}

