/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui.narudzbenice;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.ArtikallistaPK;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.PzDateUtility;

public class DopunaPoNabavci
extends PzDialog {
    private JToolBar toolbar;
    private PzToolBarIcon btnSlika;
    private PzPanel plGlavni;
    private Lista lista;
    private PzTable tblTabela;
    private JScrollPane scTabela;
    private PzPanel plTabela;
    private JPanel jPanel1;
    private Kalkulacija selektovanaKalkulacija;
    private String tableID = "";
    private Radnajedinica rj;
    private PzTextField brDokumenta;
    private PzPanel pzPanelN;
    private JLabel jLabel8;
    private PzDateField krajnjiDatum;
    private PzDateField pocetniDatum;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzTable table;
    private PzComponentGroup fieldGroup;
    private PzButton bntTrazi;

    public DopunaPoNabavci(PzDialog dialog) {
        super(dialog);
        this.preInit();
        this.initGUI();
    }

    private void preInit() {
        this.lista = (Lista)this.getSession().getParameter("lista");
        this.rj = (Radnajedinica)this.getSession().getParameter("rj");
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.setTitle("Izaberite ponudu");
        this.tableID = "TABLE_PONUDA";
        this.setId("PONUDA");
    }

    private void initGUI() {
        try {
            this.plGlavni = new PzPanel();
            this.plGlavni.setPaintGradient(true);
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{84, 7};
            plGlavniLayout.columnWeights = new double[]{0.1};
            plGlavniLayout.columnWidths = new int[]{7};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.getContentPane().add((Component)this.plGlavni, "Center");
            this.toolbar = new JToolBar();
            this.plGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.btnSlika = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSlika);
            this.btnSlika.setText("Slika|kalkulacije|(F2)");
            this.btnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/presentation_chart.png")));
            this.btnSlika.setActionCommand("slika");
            this.btnSlika.addActionListener((ActionListener)((Object)this));
            this.btnSlika.setShortcut("F2");
            this.pzPanelN = new PzPanel();
            this.plGlavni.add((Component)this.pzPanelN, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelNLayout = new GridBagLayout();
            pzPanelNLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
            pzPanelNLayout.rowHeights = new int[]{14, 25, 7};
            pzPanelNLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pzPanelNLayout.columnWidths = new int[]{81, 99, 25, 80, 120, 25, 80, 120, 24, 96, 70, 97};
            this.pzPanelN.setLayout((LayoutManager)pzPanelNLayout);
            this.jLabel1 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel1, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Po\u010detni datum:");
            this.jLabel2 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel2, (Object)new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Krajnji datum:");
            this.jLabel8 = new JLabel();
            this.pzPanelN.add((Component)this.jLabel8, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 5), 0, 0));
            this.jLabel8.setText("Dokument:");
            this.fieldGroup = new PzComponentGroup();
            this.brDokumenta = new PzTextField();
            this.fieldGroup.add((Component)this.brDokumenta);
            this.pzPanelN.add((Component)this.brDokumenta, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.brDokumenta.setMaxLength(15);
            this.pocetniDatum = new PzDateField();
            this.fieldGroup.add((Component)this.pocetniDatum);
            this.pzPanelN.add((Component)this.pocetniDatum, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pocetniDatum.setVal((Object)PzDateUtility.getFirstDayOfCurrentYear());
            this.krajnjiDatum = new PzDateField();
            this.fieldGroup.add((Component)this.krajnjiDatum);
            this.pzPanelN.add((Component)this.krajnjiDatum, (Object)new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.krajnjiDatum.setDefaultDate(new Date(new java.util.Date().getTime()));
            this.bntTrazi = new PzButton();
            this.pzPanelN.add((Component)this.bntTrazi, (Object)new GridBagConstraints(9, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.bntTrazi.setText("Tra\u017ei");
            this.bntTrazi.setBounds(90, 6, 126, 33);
            this.bntTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/liste/resource/img/find.png")));
            this.bntTrazi.addActionListener((ActionListener)((Object)this));
            this.bntTrazi.setActionCommand("trazi");
            this.jPanel1 = new JPanel();
            this.plGlavni.add((Component)this.jPanel1, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            BorderLayout jPanel1Layout1 = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout1);
            this.jPanel1.setOpaque(false);
            this.plTabela = new PzPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.add((Component)this.plTabela, "Center");
            this.plTabela.setLayout((LayoutManager)jPanel1Layout);
            this.plTabela.setOpaque(false);
            this.scTabela = new JScrollPane();
            this.plTabela.add((Component)this.scTabela, (Object)"Center");
            this.scTabela.setBackground(new Color(211, 242, 210));
            this.tblTabela = new PzTable();
            this.tblTabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Kalkulacija dok = (Kalkulacija)entity;
                    return new Object[]{dok.getOznDokumenta(), dok.getDatum(), dok.getKomitent().getSfrKomitent(), dok.getKomitent().getNaziv()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Oznaka", "Datum", "Dobavljac", "Naziv dobavljaca"};
                }
            });
            this.tblTabela.setId(this.tableID);
            this.scTabela.setViewportView((Component)this.tblTabela);
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.requestFocusInWindow();
            if (this.tblTabela.getDataSize() > 0) {
                this.tblTabela.setRowSelectionInterval(0, 0);
            }
            this.tblTabela.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DopunaPoNabavci.this.selektovanaKalkulacija = null;
                    if (DopunaPoNabavci.this.tblTabela.getDataSize() > 0) {
                        EntityManager em = PzEntityManager.getEm();
                        try {
                            try {
                                em.getTransaction().begin();
                                DopunaPoNabavci.this.selektovanaKalkulacija = (Kalkulacija)DopunaPoNabavci.this.tblTabela.getSelectedEntity();
                                DopunaPoNabavci.this.dopuniti(em, DopunaPoNabavci.this.selektovanaKalkulacija.getIdDok());
                                em.merge((Object)DopunaPoNabavci.this.lista);
                                em.getTransaction().commit();
                                DopunaPoNabavci.this.table.commitInsert();
                                DopunaPoNabavci.this.dispose();
                                ((PzTable)DopunaPoNabavci.this.getSession().getParameter("tabela")).refreshData();
                            }
                            catch (Exception ex) {
                                PzMysqlExceptionHandler.handle(null, (Throwable)ex);
                                if (em.getTransaction().isActive()) {
                                    em.getTransaction().rollback();
                                }
                                em.close();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                }
            });
            this.setSize(450, 450);
            this.setResizable(false);
            this.setMinimumSize(new Dimension(900, 450));
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("slika")) {
            this.showReport();
        } else if (actionCommand.equals("trazi")) {
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            String upit = "SELECT k FROM Kalkulacija k where k.radnajedinica=:rj and k.arhiviran = 1 and k.datum>=':datumOD' AND k.datum<=':datumDO' and k.tip='KALKULACIJA' ";
            upit = upit.replaceAll(":datumOD", this.pocetniDatum.getVal().toString());
            upit = upit.replaceAll(":datumDO", this.krajnjiDatum.getVal().toString());
            if (!this.brDokumenta.getText().equals("")) {
                upit = String.valueOf(upit) + " and k.oznDokumenta=':oznDokumenta'";
                upit = upit.replaceAll(":oznDokumenta", this.brDokumenta.getVal());
            }
            upit = String.valueOf(upit) + "order by k.datum asc";
            q = em.createQuery(upit);
            q.setParameter("rj", (Object)this.rj);
            Vector data = (Vector)q.getResultList();
            this.tblTabela.setData(data, Kalkulacija.class);
            em.close();
            this.tblTabela.requestFocus();
        }
    }

    private void dopuniti(EntityManager em, int iddok) {
        Query q = null;
        q = em.createQuery("SELECT k.id.sfrProizvod, k.artikal.dobSifra, k.artikal.naziv, k.artikal.bliziOpis, k.artikal.jedMere, k.prodCena, k.kolicina, k.artikal.model.oznModel, k.artikal.model.naziv FROM Artikalkalkulacija k WHERE k.id.idDok=:id");
        q.setParameter("id", (Object)iddok);
        Vector stavke = (Vector)q.getResultList();
        for (Object[] obj : stavke) {
            String sifra = (String)obj[0];
            String sifraDob = (String)obj[1];
            String naziv = (String)obj[2];
            String bliziOpis = (String)obj[3];
            String jm = (String)obj[4];
            BigDecimal cena = (BigDecimal)obj[5];
            double kolicina = (Double)obj[6];
            String model = (String)obj[7];
            String nazivModela = (String)obj[8];
            this.lista.setCounter(this.lista.getNextRBrojArtikli());
            Artikallista artLista = new Artikallista();
            ArtikallistaPK artPK = new ArtikallistaPK(this.lista.getIdLista(), Integer.valueOf(this.lista.getCounter()));
            artLista.setId(artPK);
            artLista.setSfrProizvod(sifra);
            artLista.setDobSifra(sifraDob);
            artLista.setNaziv(naziv);
            artLista.setBliziOpis(bliziOpis);
            artLista.setJm(jm);
            artLista.setCena(cena);
            artLista.setKolicina(kolicina);
            artLista.setPomKolicina(0.0);
            artLista.setTip("1");
            artLista.setOznModel(model);
            artLista.setNazivModel(nazivModela);
            artLista.setLista(this.lista);
            this.lista.getArtikallistas().add(artLista);
            this.table.insert((PzEntity)artLista, em);
        }
        em.merge((Object)this.lista);
    }

    public void showReport() {
        try {
            if (this.tblTabela.getSelectedEntity() != null) {
                try {
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)((Kalkulacija)this.tblTabela.getSelectedEntity()));
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new DopunaPoNabavci(Boolean.FALSE);
    }

    public DopunaPoNabavci(Boolean initGUI) {
    }
}

