/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.liste.gui.narudzbenice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.ArtikallistaPK;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Model;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.liste.ListaUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogModeli;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.sifarnici.gui.PzDialogStopePoreza;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;

public class DopunaPoStoku
extends PzDialog {
    private PzPanelHeader header;
    private PzPanel panel;
    private PzPanel mainPanel;
    private PzTextField tfTip;
    private JLabel jlTarifa;
    private PzTextField tfTarifa;
    private PzTextField tfRGR;
    private PzTextField tfProizvodjac;
    private PzRadioGroup radioGroup;
    private PzPanel panelButtons;
    private PzButton btnOk;
    private Lista lista;
    private PzTable table;
    private JLabel jlTip;
    private Radnajedinica rj;
    private JLabel jlRGR;
    private JLabel jlProizv;
    private Tarifnagrupa tarGrupa;
    private Komitent komitent;
    private Robnagrupa robnaGrupa;
    private Model model;
    private EntityManager em;

    public DopunaPoStoku() {
        this.initGUI();
    }

    public static void main(String[] args) {
        try {
            DopunaPoStoku dialog = new DopunaPoStoku();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DopunaPoStoku(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public DopunaPoStoku(PzDialog dialog) {
        super(dialog);
        this.lista = (Lista)this.getSession().getParameter("lista");
        this.rj = (Radnajedinica)this.getSession().getParameter("rj");
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.initGUI();
    }

    protected void initGUI() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new PzPanel();
        this.mainPanel.setPaintGradient(true);
        BorderLayout mainPanelLayout = new BorderLayout();
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setTitle("Dopuna dokumenta po stoku minimuma i maksimuma");
        this.panel = new PzPanel();
        this.mainPanel.add((Component)this.panel, (Object)"Center");
        GridBagLayout panelLayout = new GridBagLayout();
        panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int[] nArray = new int[6];
        nArray[0] = 25;
        nArray[1] = 24;
        nArray[2] = 25;
        nArray[5] = 49;
        panelLayout.rowHeights = nArray;
        panelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        int[] nArray2 = new int[6];
        nArray2[0] = 31;
        nArray2[1] = 185;
        nArray2[2] = 20;
        nArray2[4] = 100;
        nArray2[5] = 20;
        panelLayout.columnWidths = nArray2;
        this.panel.setLayout((LayoutManager)panelLayout);
        this.radioGroup = DopunaPoStoku.createRadioGroup();
        this.radioGroup.setSelectedIndex(0);
        this.radioGroup.setOpaque(false);
        GridBagConstraints gbc_pzRadioGroupIntervalKonta = new GridBagConstraints();
        gbc_pzRadioGroupIntervalKonta.fill = 2;
        gbc_pzRadioGroupIntervalKonta.anchor = 11;
        gbc_pzRadioGroupIntervalKonta.gridheight = 5;
        gbc_pzRadioGroupIntervalKonta.insets = new Insets(0, 5, 5, 5);
        gbc_pzRadioGroupIntervalKonta.gridx = 1;
        gbc_pzRadioGroupIntervalKonta.gridy = 0;
        this.panel.add((Component)this.radioGroup, (Object)gbc_pzRadioGroupIntervalKonta);
        this.radioGroup.addRadioGroupListener(new PzRadioGroupListener(){

            public void selectionChanged(PzRadioGroupEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                if (evt.getValue().equals("Klasi\u010dna")) {
                    DopunaPoStoku.this.jlProizv.setVisible(false);
                    DopunaPoStoku.this.jlRGR.setVisible(false);
                    DopunaPoStoku.this.jlTarifa.setVisible(false);
                    DopunaPoStoku.this.jlTip.setVisible(false);
                    DopunaPoStoku.this.tfProizvodjac.setVisible(false);
                    DopunaPoStoku.this.tfRGR.setVisible(false);
                    DopunaPoStoku.this.tfTarifa.setVisible(false);
                    DopunaPoStoku.this.tfTip.setVisible(false);
                } else if (evt.getValue().equals("Za odre\u0111eni tip")) {
                    DopunaPoStoku.this.jlProizv.setVisible(false);
                    DopunaPoStoku.this.jlRGR.setVisible(false);
                    DopunaPoStoku.this.jlTarifa.setVisible(false);
                    DopunaPoStoku.this.jlTip.setVisible(true);
                    DopunaPoStoku.this.tfProizvodjac.setVisible(false);
                    DopunaPoStoku.this.tfRGR.setVisible(false);
                    DopunaPoStoku.this.tfTarifa.setVisible(false);
                    DopunaPoStoku.this.tfTip.setVisible(true);
                } else if (evt.getValue().equals("Ista tarifa")) {
                    DopunaPoStoku.this.jlProizv.setVisible(false);
                    DopunaPoStoku.this.jlRGR.setVisible(false);
                    DopunaPoStoku.this.jlTarifa.setVisible(true);
                    DopunaPoStoku.this.jlTip.setVisible(false);
                    DopunaPoStoku.this.tfProizvodjac.setVisible(false);
                    DopunaPoStoku.this.tfRGR.setVisible(false);
                    DopunaPoStoku.this.tfTarifa.setVisible(true);
                    DopunaPoStoku.this.tfTip.setVisible(false);
                } else if (evt.getValue().equals("Ista robna grupa")) {
                    DopunaPoStoku.this.jlProizv.setVisible(false);
                    DopunaPoStoku.this.jlRGR.setVisible(true);
                    DopunaPoStoku.this.jlTarifa.setVisible(false);
                    DopunaPoStoku.this.jlTip.setVisible(false);
                    DopunaPoStoku.this.tfProizvodjac.setVisible(false);
                    DopunaPoStoku.this.tfRGR.setVisible(true);
                    DopunaPoStoku.this.tfTarifa.setVisible(false);
                    DopunaPoStoku.this.tfTip.setVisible(false);
                } else if (evt.getValue().equals("Isti proizvo\u0111a\u010d")) {
                    DopunaPoStoku.this.jlProizv.setVisible(true);
                    DopunaPoStoku.this.jlProizv.setText("Proizvo\u0111a\u010d");
                    DopunaPoStoku.this.jlRGR.setVisible(false);
                    DopunaPoStoku.this.jlTarifa.setVisible(false);
                    DopunaPoStoku.this.jlTip.setVisible(false);
                    DopunaPoStoku.this.tfProizvodjac.setVisible(true);
                    DopunaPoStoku.this.tfRGR.setVisible(false);
                    DopunaPoStoku.this.tfTarifa.setVisible(false);
                    DopunaPoStoku.this.tfTip.setVisible(false);
                } else if (evt.getValue().equals("Isti dobavlja\u010d")) {
                    DopunaPoStoku.this.jlProizv.setVisible(true);
                    DopunaPoStoku.this.jlProizv.setText("Dobavlja\u010d");
                    DopunaPoStoku.this.jlRGR.setVisible(false);
                    DopunaPoStoku.this.jlTarifa.setVisible(false);
                    DopunaPoStoku.this.jlTip.setVisible(false);
                    DopunaPoStoku.this.tfProizvodjac.setVisible(true);
                    DopunaPoStoku.this.tfRGR.setVisible(false);
                    DopunaPoStoku.this.tfTarifa.setVisible(false);
                    DopunaPoStoku.this.tfTip.setVisible(false);
                }
            }
        });
        this.jlTip = new JLabel();
        this.jlTip.setText("Tip        ");
        GridBagConstraints gbc_lblP = new GridBagConstraints();
        gbc_lblP.anchor = 13;
        gbc_lblP.insets = new Insets(0, 0, 5, 5);
        gbc_lblP.gridx = 3;
        gbc_lblP.gridy = 0;
        this.panel.add((Component)this.jlTip, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.jlTip.setVisible(false);
        this.tfTip = new PzTextField();
        this.panel.add((Component)this.tfTip, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.tfTip.setVisible(false);
        this.tfTip.setFKField(Model.class, PzDialogModeli.class, true, "Neispravna oznaka modela!");
        this.jlTarifa = new JLabel();
        this.panel.add((Component)this.jlTarifa, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.jlTarifa.setText("Tarifa     ");
        this.jlTarifa.setVisible(false);
        this.tfTarifa = new PzTextField();
        this.panel.add((Component)this.tfTarifa, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.tfTarifa.setPreferredSize(new Dimension(60, 24));
        this.tfTarifa.setSize(60, 24);
        this.tfTarifa.setVisible(false);
        this.tfTarifa.setFKField(Tarifnagrupa.class, PzDialogStopePoreza.class, true, "Uneta tarifna grupa nije na\u0111ena!");
        this.jlRGR = new JLabel("Robna grupa");
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.insets = new Insets(0, 0, 5, 5);
        gbc_label.gridx = 3;
        gbc_label.gridy = 2;
        this.panel.add((Component)this.jlRGR, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.jlRGR.setVisible(false);
        this.tfRGR = new PzTextField();
        this.panel.add((Component)this.tfRGR, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.tfRGR.setPreferredSize(new Dimension(60, 24));
        this.tfRGR.setSize(60, 24);
        this.tfRGR.setVisible(false);
        this.tfRGR.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, true, "Uneta robna grupa nije na\u0111ena!");
        this.jlProizv = new JLabel("Proizvo\u0111a\u010d");
        gbc_label = new GridBagConstraints();
        gbc_label.insets = new Insets(0, 0, 5, 5);
        gbc_label.gridx = 3;
        gbc_label.gridy = 3;
        this.panel.add((Component)this.jlProizv, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.jlProizv.setVisible(false);
        this.tfProizvodjac = new PzTextField();
        this.panel.add((Component)this.tfProizvodjac, (Object)new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.tfProizvodjac.setSize(60, 24);
        this.tfProizvodjac.setVisible(false);
        this.tfProizvodjac.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
        this.panelButtons = new PzPanel();
        this.panel.add((Component)this.panelButtons, (Object)new GridBagConstraints(0, 5, 6, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.btnOk = new PzButton();
        this.panelButtons.add((Component)this.btnOk);
        this.btnOk.setText("Potvrdi");
        this.btnOk.setActionCommand("potvrdi");
        this.btnOk.addActionListener((ActionListener)((Object)this));
        this.header = new PzPanelHeader();
        this.mainPanel.add((Component)this.header, (Object)"North");
        this.header.setTitle("Dopuna po stoku");
        this.pack();
        this.setSize(460, 290);
        this.setResizable(false);
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            this.em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molimo sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> sw = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    DopunaPoStoku.this.em.getTransaction().begin();
                    DopunaPoStoku.this.dopuniti(DopunaPoStoku.this.em);
                    DopunaPoStoku.this.em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            DopunaPoStoku.this.table.commitInsert();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Throwable)e);
                            PzWorkerDialog.hideStatus();
                            DopunaPoStoku.this.em.close();
                            DopunaPoStoku.this.dispose();
                        }
                    }
                    finally {
                        DopunaPoStoku.this.em.close();
                        DopunaPoStoku.this.dispose();
                    }
                }
            };
            sw.execute();
        }
    }

    private void dopuniti(EntityManager em) {
        Query q = null;
        if (this.radioGroup.getSelectedIndex() == 0) {
            if (this.lista.getTip().equals(ListaUtil.getTipListe("NARUDZBENICA"))) {
                q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, a.stokMax-(s.kolicina-s.alocKolicina), m.oznModel, m.naziv  FROM Stanje s, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and (a.stokMin != 0 OR a.stokMax !=0) AND s.kolicina < a.stokMin AND a.stokMin > 0 AND s.oznRj='" + this.rj.getId().getOznRj() + "'");
            } else if (this.lista.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
                q = em.createQuery("SELECT s.id.sfrProizvod, s.artikal.dobSifra, s.artikal.naziv, s.artikal.bliziOpis, s.artikal.jedMere, s.prodCena, s.kolicina-s.alocKolicina, FROM Stanje s WHERE s.kolicina-s.alocKolicina > 0 AND s.radnajedinica=:rj");
                q.setParameter("rj", (Object)this.rj);
            }
        } else if (this.radioGroup.getSelectedIndex() == 1) {
            if (this.lista.getTip().equals(ListaUtil.getTipListe("NARUDZBENICA"))) {
                q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, a.stokMax-(s.kolicina-s.alocKolicina), m.oznModel, m.naziv FROM Stanje s, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and (a.stokMin != 0 OR a.stokMax !=0) AND s.kolicina < a.stokMin AND a.stokMin > 0 AND s.oznRj='" + this.rj.getId().getOznRj() + "' AND a.oznModel='" + this.model.getOznModel() + "'");
            } else if (this.lista.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
                q = em.createQuery("SELECT s.id.sfrProizvod, s.artikal.dobSifra, s.artikal.naziv, s.artikal.bliziOpis, s.artikal.jedMere, s.prodCena, s.kolicina-s.alocKolicina FROM Stanje s WHERE s.kolicina-s.alocKolicina > 0 AND s.radnajedinica=:rj AND s.artikal.model=:md");
                q.setParameter("rj", (Object)this.rj);
                q.setParameter("md", (Object)this.model);
            }
        } else if (this.radioGroup.getSelectedIndex() == 2) {
            if (this.lista.getTip().equals(ListaUtil.getTipListe("NARUDZBENICA"))) {
                q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, a.stokMax-(s.kolicina-s.alocKolicina), m.oznModel, m.naziv FROM Stanje s, Tarifnagrupa t, TGArtikal c, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and (a.stokMin != 0 OR a.stokMax !=0) AND s.kolicina < a.stokMin AND a.stokMin > 0  and s.oznRj='" + this.rj.getId().getOznRj() + "' " + "and t.oznVrstaTG='PDV' and t.oznTarGr=c.oznTarGr and c.sfrProizvod=a.sfrProizvod and t.oznTarGr='" + this.tarGrupa.getOznTarGr() + "'");
            } else if (this.lista.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
                q = em.createQuery("SELECT s.id.sfrProizvod, s.artikal.dobSifra, s.artikal.naziv, s.artikal.bliziOpis, s.artikal.jedMere, s.prodCena, s.kolicina-s.alocKolicina FROM Stanje s, IN(s.artikal.tarifnagrupas) tg WHERE s.kolicina-s.alocKolicina > 0 AND s.radnajedinica=:rj AND tg=:tgr");
                q.setParameter("rj", (Object)this.rj);
                q.setParameter("tgr", (Object)this.tarGrupa);
            }
        } else if (this.radioGroup.getSelectedIndex() == 3) {
            if (this.lista.getTip().equals(ListaUtil.getTipListe("NARUDZBENICA"))) {
                q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, a.stokMax-(s.kolicina-s.alocKolicina), m.oznModel, m.naziv FROM Stanje s, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and (a.stokMin != 0 OR a.stokMax !=0) AND s.kolicina < a.stokMin AND a.stokMin > 0 and s.oznRj='" + this.rj.getId().getOznRj() + "' AND a.oznRobGr='" + this.robnaGrupa.getOznRobGr() + "'");
            } else if (this.lista.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
                q = em.createQuery("SELECT s.id.sfrProizvod, s.artikal.dobSifra, s.artikal.naziv, s.artikal.bliziOpis, s.artikal.jedMere, s.prodCena, s.kolicina-s.alocKolicina FROM Stanje s WHERE s.kolicina-s.alocKolicina > 0 AND s.radnajedinica=:rj AND s.artikal.robnagrupa=:rgr");
                q.setParameter("rj", (Object)this.rj);
                q.setParameter("rgr", (Object)this.robnaGrupa);
            }
        } else if (this.radioGroup.getSelectedIndex() == 4) {
            if (this.lista.getTip().equals(ListaUtil.getTipListe("NARUDZBENICA"))) {
                q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, a.stokMax-(s.kolicina-s.alocKolicina), m.oznModel, m.naziv FROM Stanje s, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and (a.stokMin != 0 OR a.stokMax !=0) AND s.kolicina < a.stokMin AND a.stokMin > 0 and s.oznRj='" + this.rj.getId().getOznRj() + "' AND a.proizvodjac='" + this.komitent.getSfrKomitent() + "'");
            } else if (this.lista.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
                q = em.createQuery("SELECT s.id.sfrProizvod, s.artikal.dobSifra, s.artikal.naziv, s.artikal.bliziOpis, s.artikal.jedMere, s.prodCena, s.kolicina-s.alocKolicina FROM Stanje s WHERE s.kolicina-s.alocKolicina > 0 AND s.radnajedinica=:rj AND s.artikal.proizvodjac=:pr");
                q.setParameter("rj", (Object)this.rj);
                q.setParameter("pr", (Object)this.komitent);
            }
        } else if (this.radioGroup.getSelectedIndex() == 5) {
            if (this.lista.getTip().equals(ListaUtil.getTipListe("NARUDZBENICA"))) {
                q = em.createNativeQuery("SELECT s.sfrProizvod, a.dobSifra, a.naziv, a.bliziOpis, a.jedMere, s.prodCena, s.kolicina-s.alocKolicina, a.stokMax-(s.kolicina-s.alocKolicina), m.oznModel, m.naziv FROM Stanje s, Artikal a LEFT JOIN Model m ON a.oznModel = m.oznModel WHERE s.sfrProizvod = a.sfrProizvod and (a.stokMin != 0 OR a.stokMax !=0) AND s.kolicina < a.stokMin AND a.stokMin > 0 and s.oznRj='" + this.rj.getId().getOznRj() + "' AND a.dobavljac='" + this.komitent.getSfrKomitent() + "'");
            } else if (this.lista.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
                q = em.createQuery("SELECT s.id.sfrProizvod, s.artikal.dobSifra, s.artikal.naziv, s.artikal.bliziOpis, s.artikal.jedMere, s.prodCena, s.kolicina-s.alocKolicina FROM Stanje s WHERE s.kolicina-s.alocKolicina > 0 AND s.radnajedinica=:rj AND s.artikal.dobavljac=:pr");
                q.setParameter("rj", (Object)this.rj);
                q.setParameter("pr", (Object)this.komitent);
            }
        }
        Vector stavke = (Vector)q.getResultList();
        for (Object[] obj : stavke) {
            String sifra = (String)obj[0];
            String sifraDob = (String)obj[1];
            String naziv = (String)obj[2];
            String bliziOpis = (String)obj[3];
            String jm = (String)obj[4];
            double raspolozivaKolicina = (Double)obj[6];
            BigDecimal cenaB = new BigDecimal(0.0);
            Double cenaD = 0.0;
            Double kolicina = 0.0;
            String model = "";
            String nazivModela = "";
            if (this.lista.getTip().equals(ListaUtil.getTipListe("NARUDZBENICA"))) {
                kolicina = (Double)obj[7];
                model = (String)obj[8];
                nazivModela = (String)obj[9];
                cenaB = (BigDecimal)obj[5];
            } else {
                cenaD = (Double)obj[5];
            }
            this.lista.setCounter(this.lista.getNextRBrojArtikli());
            Artikallista artLista = new Artikallista();
            ArtikallistaPK artPK = new ArtikallistaPK(this.lista.getIdLista(), Integer.valueOf(this.lista.getCounter()));
            artLista.setId(artPK);
            artLista.setSfrProizvod(sifra);
            artLista.setDobSifra(sifraDob);
            artLista.setNaziv(naziv);
            artLista.setBliziOpis(bliziOpis);
            artLista.setJm(jm);
            if (this.lista.getTip().equals(ListaUtil.getTipListe("PONUDA"))) {
                artLista.setKolicina(raspolozivaKolicina);
                artLista.setPomKolicina(0.0);
                artLista.setTip("1");
                artLista.setCena(BDConverter.getProdCena((double)cenaD));
            } else {
                artLista.setOznModel(model);
                artLista.setNazivModel(nazivModela);
                artLista.setKolicina(kolicina.doubleValue());
                artLista.setPomKolicina(raspolozivaKolicina);
                artLista.setCena(BDConverter.getProdCena((double)cenaB.doubleValue()));
            }
            artLista.setLista(this.lista);
            this.lista.getArtikallistas().add(artLista);
            this.table.insert((PzEntity)artLista, em);
        }
        em.merge((Object)this.lista);
    }

    public static PzRadioGroup createRadioGroup() {
        PzRadioGroup radiogroup = PzRadioGroup.create((Object[])new String[]{"Klasi\u010dna", "Za odre\u0111eni tip", "Ista tarifa", "Ista robna grupa", "Isti proizvo\u0111a\u010d", "Isti dobavlja\u010d"});
        radiogroup.setLayoutAxis(1);
        return radiogroup;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        if (this.em != null && this.em.isOpen()) {
            this.em.close();
        }
        super.thisWindowClosing(evt);
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        if (entity instanceof Tarifnagrupa) {
            this.tarGrupa = (Tarifnagrupa)entity;
            this.tfTarifa.setVal((Object)this.tarGrupa.getOznTarGr());
        } else if (entity instanceof Robnagrupa) {
            this.robnaGrupa = (Robnagrupa)entity;
            this.tfRGR.setVal((Object)this.robnaGrupa.getOznRobGr());
        } else if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.tfProizvodjac.setVal((Object)this.komitent.getSfrKomitent());
        } else if (entity instanceof Model) {
            this.model = (Model)entity;
            this.tfTip.setVal((Object)this.model.getOznModel());
        }
    }
}

