/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.agencija.swing.renderers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.tree.TreeCellRenderer;
import rs.pezar.agencija.qui.entity.Firme;
import rs.pezar.db.entity.Firma;

public class PzTreeCellRendererFirme
implements TreeCellRenderer {
    private final Font font = new Font("Tahoma", 0, 14);
    private final Color treeSelectionForeground = Color.WHITE;
    private final Color treeNoSelectionForeground = UIManager.getColor("Tree.textForeground");
    private final Color treeSelectionBackground = Color.BLUE;
    private final Color treeNoSelectionBackground = UIManager.getColor("Tree.textBackground");

    public PzTreeCellRendererFirme() {
        UIDefaults metalDefaults = new MetalLookAndFeel().getDefaults();
        metalDefaults.getIcon("FileView.directoryIcon");
        metalDefaults.getIcon("FileView.hardDriveIcon");
        metalDefaults.getIcon("FileView.fileIcon");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        JLabel treeCellRenderer = new JLabel();
        String text = "";
        ImageIcon icon = null;
        if (value instanceof Vector) {
            text = "Firme";
        } else if (value instanceof Firme) {
            text = String.valueOf(((Firme)value).getGodina());
            String fName = ((Firme)value).getFirmas() == null || ((Firme)value).getFirmas().size() == 0 ? "rg_tree.png" : "rgs_tree.png";
            icon = new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/" + fName));
        } else if (((Firma)value).getStatus() != -1) {
            text = ((Firma)value).getNaziv();
            icon = new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/rg_tree.png"));
        }
        if (sel) {
            treeCellRenderer.setOpaque(true);
            treeCellRenderer.setBackground(this.treeSelectionBackground);
            treeCellRenderer.setForeground(this.treeSelectionForeground);
        } else {
            treeCellRenderer.setOpaque(false);
            treeCellRenderer.setBackground(this.treeNoSelectionBackground);
            treeCellRenderer.setForeground(this.treeNoSelectionForeground);
        }
        treeCellRenderer.setEnabled(tree.isEnabled());
        treeCellRenderer.setText(text);
        treeCellRenderer.setFont(this.font);
        if (icon != null) {
            treeCellRenderer.setIcon(icon);
        }
        return treeCellRenderer;
    }
}

