/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.agencija.widget.firme;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.JXTitledPanel;
import rs.pezar.agencija.qui.entity.Firme;
import rs.pezar.agencija.swing.custom.PzTreeFirme;
import rs.pezar.agencija.swing.renderers.PzTreeCellRendererFirme;
import rs.pezar.core.PzApplication;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Firma;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PnlFirme
extends JXTitledPanel {
    private static final long serialVersionUID = -504871399794511530L;
    private PzPanel pnlContent;
    private GridBagConstraints gbc_scrollPane;
    private JScrollPane scrollPane;
    private JXLayer<PzPanel> layer;
    private PzButton btnOsvezi;
    private PzPanel pnlFields;
    private PzTable table;
    private PzPanel pnlTable;
    private PzButton btnPromeni;
    private PzBusyPainterUI layerUI;
    private PzTreeFirme tree;
    private Properties localProperties;
    private File f;
    private String confFile;

    public PnlFirme() {
        this.setPaintBorderInsets(false);
        this.setTitleFont(new Font("Tahoma", 1, 16));
        this.setTitle("Spisak firmi-klijenata");
        this.initGUI();
        this.paintGradient();
        this.postInit();
    }

    private void postInit() {
        this.localProperties = new Properties();
        try {
            this.confFile = PzParameter.getParameterValue((String)"CONF_FILE", (String)(String.valueOf(PzApplication.getApplication().getDataFolder().getPath()) + File.separator + "config"));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void paintGradient() {
        this.pnlContent.setPaintGradient(true);
        this.pnlContent.setGradient(Color.LIGHT_GRAY, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
    }

    private void initGUI() {
        try {
            this.pnlContent = new PzPanel();
            this.pnlContent.setBorder((Border)new EmptyBorder(0, 5, 2, 5));
            this.setContentContainer((Container)this.getLayer(this.pnlContent));
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.rowWeights = new double[]{0.1, 0.0};
            gridBagLayout.rowHeights = new int[]{200, 20};
            gridBagLayout.columnWeights = new double[]{0.1};
            gridBagLayout.columnWidths = new int[]{7};
            this.pnlContent.setLayout((LayoutManager)gridBagLayout);
            this.pnlTable = new PzPanel();
            BorderLayout pnlTableLayout = new BorderLayout();
            this.pnlContent.add((Component)this.pnlTable, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlTable.setLayout((LayoutManager)pnlTableLayout);
            this.scrollPane = new JScrollPane();
            this.pnlTable.add((Component)this.scrollPane, (Object)"Center");
            this.scrollPane.setVisible(false);
            this.scrollPane.setPreferredSize(new Dimension(67, 62));
            this.tree = new PzTreeFirme();
            this.tree.setRootVisible(false);
            this.scrollPane.setViewportView((Component)((Object)this.tree));
            this.tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    PnlFirme.this.treeKeyReleased(evt);
                }
            });
            this.tree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    PnlFirme.this.doubleClick(e);
                }
            });
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlContent.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 1, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0};
            pnlFieldsLayout.rowHeights = new int[]{25};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{100, 100, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.btnOsvezi = new PzButton();
            this.pnlFields.add((Component)this.btnOsvezi, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 5), 0, 0));
            this.btnOsvezi.setText("Teku\u0107a godina");
            this.btnOsvezi.setIcon((Icon)new ImageIcon(PnlFirme.class.getResource("/rs/pezar/agencija/resource/img/refresh.png")));
            this.btnOsvezi.setFont(new Font("Tahoma", 0, 12));
            this.btnOsvezi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PnlFirme.this.initData();
                }
            });
            this.btnPromeni = new PzButton();
            this.pnlFields.add((Component)this.btnPromeni, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 0, 5), 0, 0));
            this.btnPromeni.setText("Promeni firmu");
            this.btnPromeni.setIcon((Icon)new ImageIcon(PnlFirme.class.getResource("/rs/pezar/agencija/resource/img/refresh.png")));
            this.btnPromeni.setFont(new Font("Tahoma", 0, 12));
            this.btnPromeni.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath selPath = PnlFirme.this.tree.getSelectionPath();
                    PnlFirme.this.restart(selPath);
                }
            });
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    public void initData() {
        this.layerUI.setLocked(true);
        SwingWorker<List<Firma>, Object> worker = new SwingWorker<List<Firma>, Object>(){

            @Override
            protected List<Firma> doInBackground() throws Exception {
                List<Object> f = new ArrayList<Firma>();
                try {
                    f = PnlFirme.this.confFile.equals("") ? (List)PzApplication.getApplication().getPropManager().loadBufferedObject("firme.sav") : (List)PzApplication.getApplication().getPropManager().loadBufferedObject("firme.sav", PnlFirme.this.confFile);
                    Collections.sort(f, new Comparator<Firma>(){

                        @Override
                        public int compare(Firma arg0, Firma arg1) {
                            block4: {
                                try {
                                    if (arg0.getGodina() <= arg1.getGodina()) break block4;
                                    return -1;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    return 0;
                                }
                            }
                            if (arg0.getGodina() < arg1.getGodina()) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                return f;
            }

            @Override
            protected void done() {
                try {
                    try {
                        List firme = (List)this.get();
                        Vector<Firme> vFirme = new Vector<Firme>();
                        Firme f = new Firme();
                        f.setFirmas(new ArrayList<Firma>());
                        int godina = ((Firma)firme.get(0)).getGodina();
                        f.setGodina(godina);
                        int i = 0;
                        while (i <= firme.size()) {
                            if (i == firme.size()) {
                                vFirme.add(f);
                            } else {
                                Firma k = (Firma)firme.get(i);
                                if (godina == k.getGodina()) {
                                    f.getFirmas().add(k);
                                } else {
                                    vFirme.add(f);
                                    f = new Firme();
                                    f.setFirmas(new ArrayList<Firma>());
                                    f.setGodina(k.getGodina());
                                    f.getFirmas().add(k);
                                    godina = k.getGodina();
                                }
                            }
                            ++i;
                        }
                        for (Firme fl : vFirme) {
                            Collections.sort(fl.getFirmas(), new Comparator<Firma>(){

                                @Override
                                public int compare(Firma arg0, Firma arg1) {
                                    return arg0.getNaziv().compareTo(arg1.getNaziv());
                                }
                            });
                        }
                        PnlFirme.this.tree.loadDataFromDB(vFirme);
                        PnlFirme.this.scrollPane.setVisible(true);
                        PnlFirme.this.tree.setCellRenderer(new PzTreeCellRendererFirme());
                        PnlFirme.this.tree.expandRow(0);
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Throwable)e);
                        PnlFirme.this.scrollPane.setVisible(false);
                        PnlFirme.this.layerUI.setLocked(false);
                    }
                }
                finally {
                    PnlFirme.this.layerUI.setLocked(false);
                }
            }
        };
        worker.execute();
    }

    private void setRenderer() {
        if (this.table.getColumnByName("Status") == null) {
            return;
        }
        this.table.getColumnByName("Status").setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean isSelected, boolean arg3, int arg4, int arg5) {
                JLabel renderer = new JLabel();
                int ind = (Integer)value;
                if (ind == -1) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/nav_plain_red.png")));
                } else if (ind == 0) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/nav_plain_green.png")));
                }
                if (isSelected) {
                    Color col = PnlFirme.this.table.getDefaultRenderer(Object.class).getTableCellRendererComponent((JTable)PnlFirme.this.table, value, isSelected, arg3, arg4, arg5).getBackground();
                    renderer.setBackground(col);
                }
                renderer.setOpaque(true);
                renderer.setHorizontalAlignment(0);
                return renderer;
            }
        });
    }

    public JXLayer<PzPanel> getLayer(PzPanel pnl) {
        if (this.layerUI == null) {
            this.layerUI = new PzBusyPainterUI();
            this.layer = new JXLayer((Component)pnl, (LayerUI)this.layerUI);
        }
        return this.layer;
    }

    private void treeKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            TreePath selPath = ((JTree)evt.getSource()).getSelectionPath();
            this.restart(selPath);
        }
    }

    protected void doubleClick(MouseEvent e) {
        TreePath selPath;
        if (e.getClickCount() == 2 && (selPath = ((JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null) {
            this.restart(selPath);
        }
    }

    private void restart(TreePath selPath) {
        if (!(selPath.getLastPathComponent() instanceof Firma)) {
            return;
        }
        PzApplication.getApplication().getLocalMachineUserSettings().setProperty("SERVER_ADDRESS", (Object)("jdbc:postgresql://" + ((Firma)selPath.getLastPathComponent()).getServer() + "/" + ((Firma)selPath.getLastPathComponent()).getBaza()));
        PzApplication.getApplication().restart();
    }
}

