/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.konsignacije.transformation;

import java.sql.Date;
import java.util.HashMap;
import javax.persistence.EntityManager;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.konsignacije.gui.PzDialogDokumentiPrijemMaloprodaja;
import rs.pezar.konsignacije.gui.PzDialogPrijemMaloprodajaPregled;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.util.PzDateUtility;
import util.PzKonsignacijeUtil;

public class PrijemnicaMaloprodajaTransformer
extends DokumentTransformer {
    public static final String PARAMETER_RJ = "RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";
    private boolean priprema = false;

    public HashMap<String, Object> getDokumentParameters(PzDialog parent, Lista l) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)parent, (String[])new String[]{"ET"});
        parameters.put(PARAMETER_RJ, rj);
        parameters.put(PARAMETER_TIP, "KONSIGNACIJA_PRIJEM_M");
        if (parameters.get(PARAMETER_RJ) == null) {
            return null;
        }
        return parameters;
    }

    public PzDokument getDokumentToTransform(PzDialog parent) {
        PzChoice[] choices = new PzChoice[]{new PzChoice("Prijemnica iz arhive", (Object)"ARHIVA"), new PzChoice("Prijemnica u pripremi", (Object)"U_PRIPREMI")};
        String choice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)parent, (PzChoice[])choices, (String)"Izabor prijemnice");
        if (choice == null) {
            return null;
        }
        if (choice.equals("ARHIVA")) {
            return PzDialogPrijemMaloprodajaPregled.getKonsignacijaIzArhive(parent);
        }
        this.priprema = true;
        return PzDialogDokumentiPrijemMaloprodaja.getKonsignacijaUPripermi(parent, "Konsignacija");
    }

    public PzDokument toDokument(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        return PzKonsignacijeUtil.toKonsignacija(l, parameters, em);
    }

    public Lista toLista(PzDokument dokument, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Lista l = new DefaultDokumentTransformer(Konsignacija.class, Artikalkonsignacija.class).toLista(dokument, parameters, em);
        if (this.priprema) {
            l.setNaslov("KONSIGNACIJA_PRIJEM_M " + PzDateUtility.formatDate((Date)dokument.getDatum()));
        }
        return l;
    }

    public String getName() {
        return "Transformator prijemnice kons tu\u0111a roba maloprodaja";
    }

    public String getDescription() {
        return null;
    }
}

