/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.TransformationException;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Artikallista;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Lista;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzMathUtility;

public class PzKonsignacijeUtil {
    public static final String PARAMETER_RJ = "RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";

    public static PzDokument toKonsignacija(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Radnajedinica rj = (Radnajedinica)parameters.get(PARAMETER_RJ);
        DefaultDokumentTransformer ddt = new DefaultDokumentTransformer(Konsignacija.class, Artikalkonsignacija.class);
        Konsignacija kons = (Konsignacija)ddt.toDokument(l, parameters, em);
        kons.setStorno(0);
        kons.setArhiviran((short)0);
        kons.setTip((String)parameters.get(PARAMETER_TIP));
        kons.setRadnajedinica(rj);
        kons.setDatum(PzDateUtility.getCurrentDate());
        kons.setProknjizen((short)0);
        kons.setProcRabata(0.0);
        kons.setIznosBezPoreza(new BigDecimal(0));
        kons.setIznosSaPorezom(new BigDecimal(0));
        kons.setPdvIznos(new BigDecimal(0));
        kons.setRjUlaz(rj.getPunNaziv());
        List<Object[]> stanja = PzKonsignacijeUtil.getStanja(rj, l, em);
        for (Artikalkonsignacija artikal : kons.getArtikalkonsignacijas()) {
            Double stopaPDV;
            Artikal art;
            Double cena;
            if (kons.getCountArtikal(artikal.getId().getSfrProizvod()) > 1) {
                throw new TransformationException("Gre\u0161ka! Artikal " + artikal.getId().getSfrProizvod() + " se nalazi u listi dva ili vi\u0161e puta");
            }
            if (Double.valueOf(PzKonsignacijeUtil.findKolicina(l, artikal.getId().getSfrProizvod())) <= 0.0) {
                throw new TransformationException("Gre\u0161ka! Koli\u010dina ne mo\u017ee biti 0!");
            }
            artikal.setKolicina(PzKonsignacijeUtil.findKolicina(l, artikal.getId().getSfrProizvod()));
            if (PzKonsignacijeUtil.findValue(stanja, artikal.getId().getSfrProizvod(), 0) == null) {
                artikal.setNaziv(PzKonsignacijeUtil.findArtikal(l, artikal.getId().getSfrProizvod()).getNaziv());
                cena = PzKonsignacijeUtil.findArtikal(l, artikal.getId().getSfrProizvod()).getCena().doubleValue();
                art = (Artikal)PzEntityManager.find(Artikal.class, (Object)artikal.getId().getSfrProizvod());
                stopaPDV = art.getTarifnaGrupa("PDV").getStopa();
                if (parameters.get(PARAMETER_TIP).equals("KONSIGNACIJA_PRIJEM_V")) {
                    artikal.setCenaBezPoreza(PzKonsignacijeUtil.findArtikal(l, artikal.getId().getSfrProizvod()).getCena().doubleValue());
                    artikal.setCenaSaPorezom(cena * (1.0 + stopaPDV / 100.0));
                } else {
                    artikal.setCenaSaPorezom(PzKonsignacijeUtil.findArtikal(l, artikal.getId().getSfrProizvod()).getCena().doubleValue());
                    artikal.setCenaBezPoreza(cena * (1.0 - stopaPDV / 100.0));
                }
                artikal.setProcRabata(0.0);
                artikal.setJm(PzKonsignacijeUtil.findArtikal(l, artikal.getId().getSfrProizvod()).getJm());
            } else {
                artikal.setNaziv((String)PzKonsignacijeUtil.findValue(stanja, artikal.getId().getSfrProizvod(), 1));
                cena = (Double)PzKonsignacijeUtil.findValue(stanja, artikal.getId().getSfrProizvod(), 3);
                art = (Artikal)PzEntityManager.find(Artikal.class, (Object)artikal.getId().getSfrProizvod());
                stopaPDV = art.getTarifnaGrupa("PDV").getStopa();
                if (parameters.get(PARAMETER_TIP).equals("KONSIGNACIJA_PRIJEM_V") || parameters.get(PARAMETER_TIP).equals("KONSIGNACIJA_POVRATNICA_V")) {
                    artikal.setCenaBezPoreza(((Double)PzKonsignacijeUtil.findValue(stanja, artikal.getId().getSfrProizvod(), 3)).doubleValue());
                    artikal.setCenaSaPorezom(cena * (1.0 + stopaPDV / 100.0));
                } else {
                    artikal.setCenaSaPorezom(((Double)PzKonsignacijeUtil.findValue(stanja, artikal.getId().getSfrProizvod(), 3)).doubleValue());
                    artikal.setCenaBezPoreza(cena * (1.0 - stopaPDV / 100.0));
                }
                artikal.setProcRabata(0.0);
                artikal.setJm(art.getJedMere());
                artikal.setLokacija(PzKonsignacijeUtil.findLokacija(stanja, artikal.getId().getSfrProizvod()));
            }
            artikal.setKonsignacija(kons);
            kons.setIznosBezPoreza(kons.getIznosBezPoreza().add(PzMathUtility.roundToBigDecimal((double)(artikal.getKolicina() * artikal.getCenaBezPoreza()))));
            kons.setIznosSaPorezom(kons.getIznosSaPorezom().add(PzMathUtility.roundToBigDecimal((double)(artikal.getKolicina() * artikal.getCenaSaPorezom()))));
            kons.setPdvIznos(kons.getIznosSaPorezom().subtract(kons.getIznosBezPoreza()));
        }
        return kons;
    }

    private static List<Object[]> getStanja(Radnajedinica rj, Lista l, EntityManager em) {
        Query q = em.createQuery("SELECT s.id.sfrProizvod, s.artikal.naziv, s.prosNabCena, s.prodCena, s.stalaza, s.nivo, s.paleta FROM Stanje s WHERE s.radnajedinica=:rj AND s.id.sfrProizvod IN (SELECT al.sfrProizvod FROM Artikallista al WHERE al.id.idLista=:idLista)");
        q.setParameter("rj", (Object)rj);
        q.setParameter("idLista", (Object)l.getIdLista());
        return q.getResultList();
    }

    private static String findLokacija(List<Object[]> stanja, String sfrProizvod) {
        String res = null;
        for (Object[] stanje : stanja) {
            if (!stanje[0].equals(sfrProizvod)) continue;
            res = String.valueOf((String)stanje[4]) + (String)stanje[5] + (String)stanje[6];
            break;
        }
        return res;
    }

    private static Object findValue(List<Object[]> stanja, String sfrProizvod, int i) {
        Object res = null;
        for (Object[] stanje : stanja) {
            if (!stanje[0].equals(sfrProizvod)) continue;
            res = stanje[i];
            break;
        }
        return res;
    }

    private static double findKolicina(Lista l, String sfrProizvod) {
        double res = 0.0;
        for (Artikallista al : l.getArtikallistas()) {
            if (!al.getSfrProizvod().equals(sfrProizvod)) continue;
            res = al.getKolicina();
            break;
        }
        return res;
    }

    private static Artikallista findArtikal(Lista l, String sfrProizvod) {
        Artikallista res = null;
        for (Artikallista al : l.getArtikallistas()) {
            if (!al.getSfrProizvod().equals(sfrProizvod)) continue;
            res = al;
            break;
        }
        return res;
    }
}

