/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.proizvodnja.gui.PzDialogTrebovanjeArhiva;
import rs.pezar.proizvodnja.gui.predajnice.Arhiviranje;
import rs.pezar.proizvodnja.gui.trebovanje.Kolicina;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;

public class PzDialogStornoTrebovanja
extends PzDialogInsert {
    private PzPanel pzPanelN;
    private JScrollPane jScrollPane;
    private PzToolBarIcon icnArhiva;
    private PzToolBarIcon icnSelektiranje;
    private PzToolBarIcon icnIzmena;
    private PzPanel pzPanelC;
    private JToolBar jToolBar;
    private Opstidokument original;
    private Opstidokument stornirani;
    private PzPanel mainPanel;
    private boolean izmena;
    private PzTable table;
    private PzDialogTrebovanjeArhiva parent;
    private HashMap<String, Double> mapaKolicina = null;
    private PzStatusBar statusBar;
    private JLabel jlStatusBar = new JLabel();
    private JLabel brDok = new JLabel();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogStornoTrebovanja inst = new PzDialogStornoTrebovanja(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogStornoTrebovanja(JFrame frame) {
        super(frame);
    }

    public PzDialogStornoTrebovanja(PzDialog dialog) {
        super(dialog);
        this.original = (Opstidokument)this.getSession().getParameter("original");
        this.stornirani = (Opstidokument)this.getSession().getParameter("storno");
        this.mapaKolicina = this.setMapaKolicina(this.original);
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            if (this.izmena) {
                this.setTitle("STORNO TREBOVANJA IZ " + this.original.getRadnajedinica().getId().getOznRj() + "(" + this.original.getRadnajedinica().getgTip() + ") " + this.original.getRadnajedinica().getNaziv());
            }
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{116, 62, 114, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pzPanelC = new PzPanel();
            this.mainPanel.add((Component)this.pzPanelC, (Object)new GridBagConstraints(0, 1, 5, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout pzPanelCLayout = new GridBagLayout();
            pzPanelCLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pzPanelCLayout.rowHeights = new int[]{7, 7, 7, 7};
            pzPanelCLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pzPanelCLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pzPanelC.setLayout((LayoutManager)pzPanelCLayout);
            this.pzPanelC.setOpaque(false);
            this.jScrollPane = new JScrollPane();
            this.pzPanelC.add((Component)this.jScrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
            if (this.stornirani.getArtikalopstidokuments() == null) {
                this.stornirani.setArtikalopstidokuments((List)new IndirectList());
            }
            this.table = new PzTable(this.stornirani.getArtikalopstidokuments(), Artikalopstidokument.class);
            this.table.setCheckboxColumn(0);
            this.jScrollPane.setViewportView((Component)this.table);
            this.jToolBar = new JToolBar();
            this.mainPanel.add((Component)this.jToolBar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            this.jToolBar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.jToolBar.setOpaque(false);
            this.icnSelektiranje = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnSelektiranje);
            this.icnSelektiranje.setText("Selektiranje|(F2)");
            this.icnSelektiranje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_add.png")));
            this.icnSelektiranje.setActionCommand("Selektiranje");
            this.icnSelektiranje.addActionListener((ActionListener)((Object)this));
            this.icnSelektiranje.setShortcut("f2");
            this.icnIzmena = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|koli\u010dine|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_edit.png")));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("f3");
            this.icnArhiva = new PzToolBarIcon();
            this.jToolBar.add((Component)this.icnArhiva);
            this.icnArhiva.setText("Arhiva|(ctrl+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/printer_preferences.png")));
            this.icnArhiva.setActionCommand("Arhiviranje");
            this.icnArhiva.addActionListener((ActionListener)((Object)this));
            this.icnArhiva.setShortcut("ctrl+w");
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki ");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setMinimumSize(new Dimension(900, 700));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent e) {
        block16: {
            em = PzEntityManager.getEm();
            try {
                actionCommand = ((PzButton)e.getSource()).getActionCommand();
                if (!actionCommand.equals("Selektiranje")) ** GOTO lbl12
                if (this.table.getSelectedRow() == -1) {
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)this), "Niste odabrali stavku.", "Obavestenje", 1);
lbl7:
                    // 2 sources

                    return;
                }
                try {
                    this.table.switchIt();
                    break block16;
lbl12:
                    // 1 sources

                    if (actionCommand.equals("Izmena")) {
                        this.getSession().putParameter("tabela", (Object)this.table);
                        this.getSession().putParameter("artikal", (Object)this.table.getSelectedEntity());
                        this.showDialog(Kolicina.class);
                    } else if (actionCommand.equals("Arhiviranje")) {
                        if (this.table.getCheckedEntities().size() == 0) {
                            JOptionPane.showMessageDialog(this.getParent(), "Mora biti selektovan barem jedan artikal!", "Informacija", 1);
                            ** continue;
                        }
                        artikli = (Vector)this.table.getCheckedEntities();
                        this.getSession().putParameter("artikli", (Object)artikli);
                        this.getSession().putParameter("trebovanje", (Object)this.original);
                        this.getSession().putParameter("storno", (Object)this.stornirani);
                        this.getSession().putParameter("storniranje", (Object)true);
                        if (this.original.getTip().equals("TREBOVANJE")) {
                            this.showDialog(rs.pezar.proizvodnja.gui.trebovanje.Arhiviranje.class);
                        } else if (this.original.getTip().equals("PREDAJNICA")) {
                            this.showDialog(Arhiviranje.class);
                        }
                    }
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)this, (Throwable)e1);
                }
            }
            finally {
                em.close();
            }
        }
    }

    private HashMap<String, Double> setMapaKolicina(Opstidokument t) {
        HashMap<String, Double> rez = new HashMap<String, Double>();
        for (Artikalopstidokument a : t.getArtikalopstidokuments()) {
            rez.put(String.valueOf(a.getId().getSfrProizvod()) + "/" + a.getId().getrBroj(), a.getKolicina());
        }
        return rez;
    }

    public double getKolicinaFor(Artikalopstidokument a) {
        return this.mapaKolicina.get(String.valueOf(a.getId().getSfrProizvod()) + "/" + a.getId().getrBroj());
    }

    protected void onInsert() {
    }

    protected void onUpdate() {
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
    }

    protected void setHeaderOnUpdate() {
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogStornoTrebovanja(Boolean.FALSE);
    }

    public PzDialogStornoTrebovanja(Boolean initGUI) {
    }

    public void finish() {
        this.dispose();
    }

    private void kreirajTabelu() {
        this.table = new PzTable(this.stornirani.getArtikalopstidokuments(), Artikalopstidokument.class);
        this.jScrollPane.setViewportView((Component)this.table);
        this.brDok.setText(String.valueOf(this.table.getRowCount()));
    }
}

