/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.TaxMap;
import rs.pezar.kasa.lpfr.LPFRException;
import rs.pezar.kasa.lpfr.model.TaxGroup;
import rs.pezar.kasa.lpfr.rest.LPFRClient;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;

public class PzDialogTaxMap
extends PzDialog {
    private JPanel pnlContent;
    private JScrollPane jScrollPane1;
    private JPanel pnlStope;
    private PzButton btnOk;
    private JLabel lblTitle;
    private ArrayList<TaxRateBinding> bindings;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogTaxMap inst = new PzDialogTaxMap(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogTaxMap(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogTaxMap(PzDialog frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.pnlContent = new JPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlContent, "Center");
            pnlContentLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            pnlContentLayout.rowHeights = new int[]{7, 7, 20};
            pnlContentLayout.columnWeights = new double[]{0.1};
            pnlContentLayout.columnWidths = new int[]{7};
            this.pnlContent.setLayout(pnlContentLayout);
            this.lblTitle = new JLabel();
            this.pnlContent.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.lblTitle.setName("lblTitle");
            this.jScrollPane1 = new JScrollPane();
            this.pnlContent.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.pnlStope = new JPanel();
            BoxLayout pnlStopeLayout = new BoxLayout(this.pnlStope, 1);
            this.pnlStope.setLayout(pnlStopeLayout);
            this.jScrollPane1.setViewportView(this.pnlStope);
            this.btnOk = new PzButton();
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/kasa/resource/img/check.png")));
            this.btnOk.addActionListener(this.createActionListener());
            this.pnlContent.add((Component)this.btnOk, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
            this.btnOk.setName("btnOk");
            this.setSize(312, 362);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
            this.populateRates();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityManager em = PzEntityManager.getEm();
                try {
                    em.getTransaction().begin();
                    for (TaxRateBinding binding : PzDialogTaxMap.this.bindings) {
                        TaxMap tm = new TaxMap(binding.tg.getOznTarGr(), binding.rate.getLabel());
                        em.merge((Object)tm);
                    }
                    em.getTransaction().commit();
                    PzDialogTaxMap.this.dispose();
                }
                finally {
                    em.close();
                }
            }
        };
    }

    private void populateRates() {
        try {
            List<TaxGroup.TaxCategory.TaxRate> rates = new LPFRClient().getTaxRates();
            List tarife = PzEntityManager.getList((String)"SELECT e FROM Tarifnagrupa e ORDER BY e.sfrTarGr");
            List taxMap = PzEntityManager.getList((String)"SELECT t FROM TaxMap t");
            this.bindings = new ArrayList();
            for (Object object : tarife) {
                Tarifnagrupa tg = (Tarifnagrupa)object;
                final TaxRateBinding binding = new TaxRateBinding(null, tg);
                this.bindings.add(binding);
                JPanel pnl = new JPanel();
                JLabel lblStopa = new JLabel(String.valueOf(tg.getOznTarGr()) + "   =   ");
                lblStopa.setFont(new Font("SansSerif", 0, 18));
                pnl.add(lblStopa);
                JComboBox<TaxRateObject> cbRates = new JComboBox<TaxRateObject>();
                cbRates.setFont(new Font("SansSerif", 0, 18));
                for (TaxGroup.TaxCategory.TaxRate rate : rates) {
                    cbRates.addItem(new TaxRateObject(rate));
                }
                cbRates.setSelectedIndex(-1);
                cbRates.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        TaxRateObject o = (TaxRateObject)e.getItem();
                        binding.rate = o.rate;
                    }
                });
                TaxMap found = null;
                for (Object object2 : taxMap) {
                    TaxMap tm = (TaxMap)object2;
                    if (!tm.getOznTarGr().equals(tg.getOznTarGr())) continue;
                    found = tm;
                }
                if (found != null) {
                    int i = 0;
                    while (i < rates.size()) {
                        if (rates.get(i).getLabel().equals(found.getLabel())) {
                            cbRates.setSelectedIndex(i);
                        }
                        ++i;
                    }
                } else {
                    cbRates.setSelectedIndex(0);
                }
                pnl.add(cbRates);
                this.pnlStope.add(pnl);
                this.pnlStope.add(new JSeparator(0));
            }
        }
        catch (LPFRException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getFullMessage(), "L-PFR greska", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)this), "Gre\u0161ka prilikom u\u010ditavanja stopa", "Problem sa stopama", 0);
        }
    }

    public static void checkRates(PzDialog parent) {
        if (PzDialogTaxMap.ratesExist()) {
            return;
        }
        PzDialogTaxMap dlg = new PzDialogTaxMap(parent);
        dlg.setLocationRelativeTo((Component)parent);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean ratesExist() {
        try {
            Vector tarife = PzEntityManager.selectAll((String)"Tarifnagrupa");
            List map = PzEntityManager.getList((String)"Select t FROM TaxMap t");
            Iterator iterator = tarife.iterator();
            block2: while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                PzEntity e = (PzEntity)iterator.next();
                Tarifnagrupa rg = (Tarifnagrupa)e;
                TaxMap found = null;
                Iterator iterator2 = map.iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        if (found != null) continue block2;
                        return false;
                    }
                    Object object = iterator2.next();
                    TaxMap tm = (TaxMap)object;
                    if (!rg.getOznTarGr().equals(tm.getOznTarGr())) continue;
                    found = tm;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    private static class TaxRateBinding {
        private TaxGroup.TaxCategory.TaxRate rate;
        private Tarifnagrupa tg;

        public TaxRateBinding(TaxGroup.TaxCategory.TaxRate rate, Tarifnagrupa tg) {
            this.rate = rate;
            this.tg = tg;
        }
    }

    private static class TaxRateObject {
        private TaxGroup.TaxCategory.TaxRate rate;

        public TaxRateObject(TaxGroup.TaxCategory.TaxRate rate) {
            this.rate = rate;
        }

        public String toString() {
            return String.valueOf(this.rate.getLabel()) + " (" + this.rate.getRate() + "%)";
        }
    }
}

