/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite;

import org.cheffo.jeplite.ParseException;
import org.cheffo.jeplite.Parser;
import org.cheffo.jeplite.ParserVisitor;
import org.cheffo.jeplite.SimpleNode;
import org.cheffo.jeplite.function.PostfixMathCommand;
import org.cheffo.jeplite.util.DoubleStack;

public class ASTFunNode
extends SimpleNode {
    private PostfixMathCommand pfmc;

    public ASTFunNode(int id) {
        super(id);
    }

    public ASTFunNode(Parser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public void setFunction(String name_in, PostfixMathCommand pfmc_in) {
        this.name = name_in;
        this.pfmc = pfmc_in;
    }

    @Override
    public String toString() {
        if (this.name != null) {
            try {
                return "Function \"" + this.name + "\" = " + this.getValue();
            }
            catch (Exception exception) {
                return "Function \"" + this.name + "\"";
            }
        }
        return "Function: no function class set";
    }

    @Override
    public double getValue() throws ParseException {
        DoubleStack tempStack = new DoubleStack();
        this.getValue(tempStack);
        return tempStack.pop();
    }

    @Override
    public final void getValue(DoubleStack tempStack) throws ParseException {
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            this.children[i].getValue(tempStack);
            ++i;
        }
        if (this.pfmc != null) {
            try {
                if (this.pfmc.getNumberOfParameters() != -1 && this.pfmc.getNumberOfParameters() != this.children.length) {
                    throw new ParseException("Function requires " + this.pfmc.getNumberOfParameters() + " parameter(s), but you provided " + this.children.length);
                }
                this.pfmc.run(tempStack, this.children.length);
            }
            catch (ParseException e) {
                String errorStr = "Error in \"" + this.name + "\" function: ";
                errorStr = String.valueOf(errorStr) + e.getErrorInfo();
                throw new ParseException(errorStr);
            }
        }
    }
}

