/*
 * Decompiled with CFR 0.152.
 */
package org.cheffo.jeplite;

import org.cheffo.jeplite.SimpleNode;
import org.cheffo.jeplite.util.IntegerStack;
import org.cheffo.jeplite.util.SimpleNodeStack;

class JJTParserState {
    private SimpleNodeStack nodes = new SimpleNodeStack(100);
    private IntegerStack marks = new IntegerStack(100);
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;

    JJTParserState() {
    }

    final boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    final SimpleNode rootNode() {
        return this.nodes.elementAt(0);
    }

    final void pushNode(SimpleNode n) {
        this.nodes.push(n);
        ++this.sp;
    }

    final SimpleNode popNode() {
        if (--this.sp < this.mk) {
            this.mk = this.marks.pop();
        }
        return this.nodes.pop();
    }

    final SimpleNode peekNode() {
        return this.nodes.peek();
    }

    final int nodeArity() {
        return this.sp - this.mk;
    }

    final void clearNodeScope(SimpleNode n) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = this.marks.pop();
    }

    final void openNodeScope(SimpleNode n) {
        this.marks.push(this.mk);
        this.mk = this.sp;
        n.jjtOpen();
    }

    final void closeNodeScope(SimpleNode n, int num) {
        this.mk = this.marks.pop();
        while (num-- > 0) {
            SimpleNode c = this.popNode();
            c.jjtSetParent(n);
            n.jjtAddChild(c, num);
        }
        n.jjtClose();
        this.pushNode(n);
        this.node_created = true;
    }

    final void closeNodeScope(SimpleNode n, boolean condition) {
        if (condition) {
            int a = this.nodeArity();
            this.mk = this.marks.pop();
            while (a-- > 0) {
                SimpleNode c = this.popNode();
                c.jjtSetParent(n);
                n.jjtAddChild(c, a);
            }
            n.jjtClose();
            this.pushNode(n);
            this.node_created = true;
        } else {
            this.mk = this.marks.pop();
            this.node_created = false;
        }
    }
}

