/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellRenderer;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXStatusBar;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.ArtikalTemp;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.sifarnici.gui.artikli.DialogSlike;
import rs.pezar.sifarnici.gui.artikli.DodavanjeExtended;
import rs.pezar.sifarnici.gui.artikli.Lokacije;
import rs.pezar.sifarnici.gui.artikli.NaprednaPretraga;
import rs.pezar.sifarnici.gui.artikli.OEMBrojevi;
import rs.pezar.sifarnici.gui.artikli.Opis;
import rs.pezar.sifarnici.gui.artikli.SlikePreview;
import rs.pezar.sifarnici.gui.artikli.Upit;
import rs.pezar.sifarnici.gui.artikli.Zamene;
import rs.pezar.sifarnici.gui.artikli.importArtikala.UnosPutanje;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzManageableTable;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzShortcutListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.renderers.StanjeRenderer;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogArtikliExtended
extends PzDialog {
    private PzPanel plLabeleDugmici;
    private JToolBar toolbar;
    private JLabel jLabel2;
    private PzTextField tfBliziOpis;
    private PzButton btnCisti;
    private JLabel nfUkupnoSlogova;
    private PzToolBarIcon icnSlika;
    private JPanel pnlBtn;
    private PzButton btnTrazi;
    private JLabel lblUkupnoSlogova;
    private PzToolBarIcon icnZamena;
    private PzToolBarIcon icnLokacije;
    private PzToolBarIcon icnOEM;
    private PzToolBarIcon icnBrisanjeArtikla;
    private PzToolBarIcon icnOpis;
    private PzManageableTable tblTabela;
    private JScrollPane scPane;
    private PzPanel plTabela;
    private JXStatusBar plDonji;
    private PzTextField tfRgr;
    private PzTextField tfOemBroj;
    private PzTextField tfKatalBroj;
    private JLabel lblRgr;
    private JLabel lblOemBroj;
    private JLabel lblKatalBroj;
    private JLabel lblDobavljac;
    private PzToolBarIcon icnStampaj;
    private JLabel lblSifra;
    private PzTextField tfSifra;
    private PzTextField tfDobavljac;
    private JLabel lblModel;
    private PzTextField tfModel;
    private PzTextField tfNaziv;
    private JLabel lblNaziv;
    private JLabel lblProizvodjac;
    private PzTextField tfProizvodjac;
    private JPanel plOkvir;
    private PzToolBarIcon icnUpitURadneJedinice;
    private PzToolBarIcon icnIzmeniPostojeceOsnovnePodatke;
    private PzToolBarIcon icnOtvoriNovArtikal;
    private PzToolBarIcon icnSvi;
    private Radnajedinica rj;
    private String direktorijum;
    private ScrollableCursor cursor;
    private JLabel jLabel1;
    private PzTable tblZamene;
    private JScrollPane scpZamene;
    private JXCollapsiblePane plZamene;
    private Long i;
    private EntityManager em;
    private Query q;
    private boolean collapsed = true;
    private DialogSlike dialogSlike;
    private HashMap<String, Object> map;
    private String lastQuery;
    private PzToolBarIcon icnNaprednaPretraga;
    private FetchGroup grp;
    private Robnagrupa rGrupa;
    private PzToolBarIcon icnUvoz;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogArtikliExtended inst = new PzDialogArtikliExtended(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogArtikliExtended() {
    }

    public PzDialogArtikliExtended(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogArtikliExtended(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.initData();
    }

    public PzDialogArtikliExtended(PzDialog parent, boolean izmena, Object data1, Object data2) {
        super(parent);
        this.rj = (Radnajedinica)data1;
        this.initGUI();
        this.updateGUI();
        this.initData();
    }

    private void initData() {
        if (this.rj == null) {
            return;
        }
        this.map = (HashMap)PzApplication.getApplication().getSession().getRuntimeStore().get("artikli_cursor");
        if (this.map != null) {
            Radnajedinica rj1 = (Radnajedinica)this.map.get("rj");
            this.map.put("time", new Long(-1L));
            if (rj1.getId().equals((Object)this.rj.getId())) {
                String query = (String)this.map.get("query");
                if (this.map.get("cursor") != null) {
                    this.cursor = (ScrollableCursor)this.map.get("cursor");
                } else if (this.map.get("query") != null) {
                    this.em = PzEntityManager.getEm();
                    Query q = this.em.createQuery(query);
                    q.setHint("eclipselink.read-only", (Object)true);
                    q.setHint("eclipselink.cursor.scrollable", (Object)true);
                    this.cursor = (ScrollableCursor)q.getSingleResult();
                    this.em.close();
                }
                this.instantiateTable();
                if (this.map.get("selected") != null && this.tblTabela.getRowCount() > 0) {
                    final int selectedRow = (Integer)this.map.get("selected");
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PzDialogArtikliExtended.this.tblTabela.requestFocusInWindow();
                            PzDialogArtikliExtended.this.tblTabela.scrollRowToVisible(selectedRow);
                            PzDialogArtikliExtended.this.tblTabela.setRowSelectionInterval(selectedRow, selectedRow);
                        }
                    });
                }
            } else if (!rj1.getId().equals((Object)this.rj.getId()) && this.map.get("cursor") != null) {
                this.cursor = (ScrollableCursor)this.map.get("cursor");
                this.cursor.close();
                this.map.put("cursor", null);
            }
        }
    }

    private void updateGUI() {
        if (this.rj != null) {
            this.icnOtvoriNovArtikal.setEnabled(false);
            this.icnIzmeniPostojeceOsnovnePodatke.setEnabled(false);
            this.icnBrisanjeArtikla.setEnabled(false);
            this.icnLokacije.setEnabled(false);
        }
    }

    private void initGUI() {
        try {
            if (this.direktorijum == null || this.direktorijum.equals("")) {
                this.direktorijum = PzParameter.getParameterValue((String)"DIR_SLIKE");
            }
            this.setTitle("\u0160ifarnik artikala");
            this.plLabeleDugmici = new PzPanel();
            this.getContentPane().add((Component)this.plLabeleDugmici, "North");
            GridBagLayout plLabeleDugmiciLayout = new GridBagLayout();
            this.plLabeleDugmici.setPreferredSize(new Dimension(1012, 221));
            plLabeleDugmiciLayout.rowWeights = new double[]{0.0, 0.1, 0.0, 0.0};
            plLabeleDugmiciLayout.rowHeights = new int[]{110, 7, 29, 25};
            plLabeleDugmiciLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            plLabeleDugmiciLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.plLabeleDugmici.setLayout((LayoutManager)plLabeleDugmiciLayout);
            this.toolbar = new JToolBar();
            this.plLabeleDugmici.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.icnOtvoriNovArtikal = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnOtvoriNovArtikal);
            this.icnOtvoriNovArtikal.setText("Otvori nov|artikal|(INS)");
            this.icnOtvoriNovArtikal.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_add.png")));
            this.icnOtvoriNovArtikal.addActionListener((ActionListener)((Object)this));
            this.icnOtvoriNovArtikal.setActionCommand("insert");
            this.icnOtvoriNovArtikal.setShortcut("insert");
            this.icnUpitURadneJedinice = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUpitURadneJedinice);
            this.icnUpitURadneJedinice.setText("Upit|u stanje|(F2)");
            this.icnUpitURadneJedinice.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_view.png")));
            this.icnUpitURadneJedinice.addActionListener((ActionListener)((Object)this));
            this.icnUpitURadneJedinice.setActionCommand("upit");
            this.icnUpitURadneJedinice.setShortcut("F2");
            this.icnIzmeniPostojeceOsnovnePodatke = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmeniPostojeceOsnovnePodatke);
            this.icnIzmeniPostojeceOsnovnePodatke.setText("Izmeni|podatke| (F3)");
            this.icnIzmeniPostojeceOsnovnePodatke.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_edit.png")));
            this.icnIzmeniPostojeceOsnovnePodatke.setActionCommand("izmeni");
            this.icnIzmeniPostojeceOsnovnePodatke.addActionListener((ActionListener)((Object)this));
            this.icnIzmeniPostojeceOsnovnePodatke.setShortcut("F3");
            this.icnBrisanjeArtikla = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanjeArtikla);
            this.icnBrisanjeArtikla.setText("Brisanje|artikla|(DEL)");
            this.icnBrisanjeArtikla.setBounds(58, 42, 107, 16);
            this.icnBrisanjeArtikla.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_delete.png")));
            this.icnBrisanjeArtikla.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeArtikla.setActionCommand("obrisi");
            this.icnBrisanjeArtikla.setShortcut("delete");
            this.icnOpis = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnOpis);
            this.toolbar.add((Component)this.getIcnZamena());
            this.toolbar.add((Component)this.getIcnSlika());
            this.icnOEM = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnOEM);
            this.icnOEM.setText("OEM|brojevi|(ALT+F10)");
            this.icnOEM.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_oem.png")));
            this.icnOEM.addActionListener((ActionListener)((Object)this));
            this.icnOEM.setActionCommand("oem");
            this.icnOEM.setShortcut("alt+F10");
            this.icnLokacije = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnLokacije);
            this.icnLokacije.setText("Lokacije|artikala|(F11)");
            this.icnLokacije.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_signpost.png")));
            this.icnLokacije.addActionListener((ActionListener)((Object)this));
            this.icnLokacije.setActionCommand("lokacije");
            this.icnLokacije.setShortcut("F11");
            this.icnNaprednaPretraga = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnNaprednaPretraga);
            this.icnNaprednaPretraga.setText("Napredna|pretraga|(ALT+F12)");
            this.icnNaprednaPretraga.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_find.png")));
            this.icnNaprednaPretraga.addActionListener((ActionListener)((Object)this));
            this.icnNaprednaPretraga.setActionCommand("napredna_pretraga");
            this.icnNaprednaPretraga.setShortcut("ALT+F12");
            this.icnOpis.setText("Opis|artikla|(ALT+F4)");
            this.icnOpis.addActionListener((ActionListener)((Object)this));
            this.icnOpis.setActionCommand("Opis");
            this.icnOpis.setShortcut("alt+F4");
            this.icnOpis.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_text.png")));
            this.icnSvi = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSvi);
            this.icnSvi.setText("Ceo|\u0161ifarnik|(ALT+F7)");
            this.icnSvi.setActionCommand("svi");
            this.icnSvi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_view.png")));
            this.icnSvi.addActionListener((ActionListener)((Object)this));
            this.icnSvi.setShortcut("ALT+F7");
            this.icnUvoz = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnUvoz);
            this.icnUvoz.setText("Uvoz|artikala|(ALT+F2)");
            this.icnUvoz.setActionCommand("uvoz");
            this.icnUvoz.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/import2.png")));
            this.icnUvoz.addActionListener((ActionListener)((Object)this));
            this.icnUvoz.setShortcut("ALT+F2");
            this.plOkvir = new JPanel();
            GridBagLayout plOkvirLayout = new GridBagLayout();
            this.plLabeleDugmici.add((Component)this.plOkvir, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.plOkvir.setBorder(BorderFactory.createTitledBorder("Tra\u017ei po"));
            plOkvirLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            plOkvirLayout.rowHeights = new int[]{25, 14, 25, 14};
            plOkvirLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            plOkvirLayout.columnWidths = new int[]{247, 132, 171, 110, 167, 20};
            this.plOkvir.setLayout(plOkvirLayout);
            this.tfProizvodjac = new PzTextField();
            this.tfProizvodjac.removeEnterBehaviour();
            this.plOkvir.add((Component)this.tfProizvodjac, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.tfProizvodjac.setPreferredSize(new Dimension(266, 21));
            this.lblProizvodjac = new JLabel();
            this.plOkvir.add((Component)this.lblProizvodjac, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0));
            this.lblProizvodjac.setText("Proizvo\u0111a\u010d (F4)");
            this.lblNaziv = new JLabel();
            this.plOkvir.add((Component)this.lblNaziv, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 15, 0, 0), 0, 0));
            this.lblNaziv.setText("Naziv (F8)");
            this.tfNaziv = new PzTextField();
            this.tfNaziv.removeEnterBehaviour();
            this.plOkvir.add((Component)this.tfNaziv, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.tfModel = new PzTextField();
            this.tfModel.removeEnterBehaviour();
            this.plOkvir.add((Component)this.tfModel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.tfModel.setPreferredSize(new Dimension(150, 21));
            this.lblModel = new JLabel();
            this.plOkvir.add((Component)this.lblModel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblModel.setText("Model (F5)");
            this.tfDobavljac = new PzTextField();
            this.tfDobavljac.removeEnterBehaviour();
            this.plOkvir.add((Component)this.tfDobavljac, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.tfDobavljac.setPreferredSize(new Dimension(150, 21));
            this.tfSifra = new PzTextField();
            this.tfSifra.removeEnterBehaviour();
            this.plOkvir.add((Component)this.tfSifra, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.tfSifra.setFont(new Font("Tahoma", 0, 14));
            this.tfSifra.setPreferredSize(new Dimension(150, 21));
            this.lblSifra = new JLabel();
            this.plOkvir.add((Component)this.lblSifra, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 9, 0, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra (F7)");
            this.lblDobavljac = new JLabel();
            this.plOkvir.add((Component)this.lblDobavljac, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblDobavljac.setText("Dobavlja\u010d (F6)");
            this.lblKatalBroj = new JLabel();
            this.plOkvir.add((Component)this.lblKatalBroj, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKatalBroj.setText("Katalo\u0161ki broj (F10)");
            this.lblOemBroj = new JLabel();
            this.plOkvir.add((Component)this.lblOemBroj, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblOemBroj.setText("OEM broj (ALT+F11)");
            this.lblRgr = new JLabel();
            this.plOkvir.add((Component)this.lblRgr, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblRgr.setText("Robna grupa(F12)");
            this.tfKatalBroj = new PzTextField();
            this.tfKatalBroj.removeEnterBehaviour();
            this.plOkvir.add((Component)this.tfKatalBroj, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.tfOemBroj = new PzTextField();
            this.tfOemBroj.removeEnterBehaviour();
            this.plOkvir.add((Component)this.tfOemBroj, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.tfRgr = new PzTextField();
            this.tfRgr.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, false, null);
            this.tfRgr.removeEnterBehaviour();
            this.plOkvir.add((Component)this.tfRgr, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.pnlBtn = new JPanel();
            this.plOkvir.add((Component)this.pnlBtn, new GridBagConstraints(5, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlBtn.setLayout(null);
            this.btnTrazi = new PzButton();
            this.pnlBtn.add((Component)this.btnTrazi);
            this.btnTrazi.setText("Tra\u017ei (ENTER)");
            this.btnTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/find.png")));
            this.btnTrazi.setActionCommand("trazi");
            this.btnTrazi.setBounds(7, 6, 142, 24);
            this.btnTrazi.addActionListener((ActionListener)((Object)this));
            this.btnTrazi.setShortcut("enter");
            this.btnCisti = new PzButton();
            this.pnlBtn.add((Component)this.btnCisti);
            this.btnCisti.setText("\u010cisti (CTRL+Q)");
            this.btnCisti.setBounds(7, 35, 142, 23);
            this.btnCisti.addActionListener((ActionListener)((Object)this));
            this.btnCisti.setShortcut("ctrl+q");
            this.btnCisti.setActionCommand("cisti");
            this.tfBliziOpis = new PzTextField();
            this.tfBliziOpis.removeEnterBehaviour();
            this.plOkvir.add((Component)this.tfBliziOpis, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.jLabel2 = new JLabel();
            this.plOkvir.add((Component)this.jLabel2, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 9, 0, 0), 0, 0));
            this.jLabel2.setText("Bli\u017ei opis (F9)");
            this.plTabela = new PzPanel();
            GridBagLayout plTabelaLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.plTabela, "Center");
            this.plTabela.setLayout((LayoutManager)plTabelaLayout);
            plTabelaLayout.rowWeights = new double[]{0.1, 0.0};
            plTabelaLayout.columnWeights = new double[]{0.1};
            this.scPane = new JScrollPane();
            this.plTabela.add((Component)this.scPane, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 5, 10), 0, 0));
            this.tblTabela = new PzTable(){

                protected void onSelectionChanged() {
                    try {
                        PzDialogArtikliExtended.this.selectionChanged();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    }
                }

                public void replaceEntity(PzEntity entity) {
                    Artikal a = (Artikal)entity;
                    int i = 0;
                    while (i < this.getAllEntities().size()) {
                        if (((Artikal)this.getAllEntities().get(i)).getSfrProizvod().equals(a.getSfrProizvod())) {
                            this.getAllEntities().set(i, a);
                        }
                        ++i;
                    }
                }
            };
            this.tblTabela.setId("PzTable");
            this.scPane.setViewportView((Component)this.tblTabela);
            this.plDonji = new JXStatusBar();
            this.plTabela.add((Component)this.plDonji, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblUkupnoSlogova = new JLabel();
            this.plDonji.add((Component)this.lblUkupnoSlogova);
            this.lblUkupnoSlogova.setText("Ukupno pogodaka:");
            this.lblUkupnoSlogova.setFont(new Font("Tahoma", 0, 12));
            this.lblUkupnoSlogova.setBounds(12, 79, 112, 15);
            this.nfUkupnoSlogova = new JLabel();
            this.plDonji.add((Component)this.nfUkupnoSlogova);
            this.nfUkupnoSlogova.setFont(new Font("Tahoma", 0, 12));
            this.nfUkupnoSlogova.setBounds(142, 76, 56, 22);
            this.setSize(1020, 740);
            this.restoreSize();
            this.registerShortcuts(new String[]{"f8", "f5", "f12", "alt+f11", "f4", "f6", "f10", "f7", "f9"});
            this.setShortcutListener(this.getShortcutListener());
            this.loadHints();
            this.setFirstComponentInFocus((Component)this.tfNaziv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        PzManageableTable data1 = null;
        PzEntity data2 = null;
        boolean izmena = false;
        String actionCommand = ((PzButton)e.getSource()).getActionCommand();
        try {
            if (actionCommand.equals("trazi")) {
                if (this.tfNaziv.getVal().toString().equalsIgnoreCase("") && this.tfModel.getVal().toString().equalsIgnoreCase("") && this.tfDobavljac.getVal().toString().equalsIgnoreCase("") && this.tfSifra.getVal().toString().equalsIgnoreCase("") && this.tfProizvodjac.getVal().toString().equalsIgnoreCase("") && this.tfKatalBroj.getVal().toString().equalsIgnoreCase("") && this.tfOemBroj.getVal().toString().equalsIgnoreCase("") && this.tfRgr.getVal().toString().equalsIgnoreCase("") && this.tfBliziOpis.getVal().equalsIgnoreCase("")) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Morate uneti kriterijum pretrage.");
                    return;
                }
                this.runSearch();
                return;
            }
            if (actionCommand.equalsIgnoreCase("cisti")) {
                this.tfProizvodjac.setVal((Object)"");
                this.tfNaziv.setVal((Object)"");
                this.tfModel.setVal((Object)"");
                this.tfDobavljac.setVal((Object)"");
                this.tfSifra.setVal((Object)"");
                this.tfKatalBroj.setVal((Object)"");
                this.tfOemBroj.setVal((Object)"");
                this.tfRgr.setVal((Object)"");
                this.tfBliziOpis.setVal((Object)"");
                return;
            }
            if (actionCommand.equalsIgnoreCase("svi")) {
                this.svi();
                this.selectionChanged();
                return;
            }
            if (actionCommand.equalsIgnoreCase("izmeni")) {
                if (this.tblTabela.getSelectedEntity() == null || this.tblTabela.getSelectedEntity() instanceof Stanjeartikal) return;
                izmena = true;
            } else {
                if (actionCommand.equals("obrisi")) {
                    Artikal aa = (Artikal)((PzTable)this.tblTabela).getSelectedEntity();
                    if (aa == null) {
                        return;
                    }
                    boolean imastanje = false;
                    if (aa.getStanjes() != null && aa.getStanjes().size() > 0) {
                        for (Stanje s : aa.getStanjes()) {
                            if (!(s.getKolicina() > 0.0) && !(s.getAlocKolicina() > 0.0)) continue;
                            imastanje = true;
                        }
                    }
                    if (imastanje) {
                        throw new PzInfoException("Artikal ima koli\u010dinu u jednoj od radnih jedinica i zbog toga je njegovo brisanje onemogu\u0107eno.");
                    }
                    PzEntityManager.delete(ArtikalTemp.class, (Object)aa.getSfrProizvod());
                    ((PzTable)this.tblTabela).removeSelectedEntity(true, true);
                    return;
                }
                if (actionCommand.equalsIgnoreCase("slika")) {
                    if (this.tblTabela.getSelectedEntity() == null) return;
                    if (this.tblTabela.getSelectedEntity() instanceof Artikal) {
                        this.getSession().putParameter("artikal", (Object)this.tblTabela.getSelectedEntity());
                        this.showDialog(SlikePreview.class);
                    } else if (this.tblTabela.getSelectedEntity() instanceof Stanjeartikal) {
                        if (this.dialogSlike != null && this.dialogSlike.isVisible()) {
                            this.dialogSlike.dispose();
                            return;
                        }
                        this.getSession().putParameter("artikal", (Object)this.tblTabela.getSelectedEntity());
                        this.dialogSlike = new DialogSlike(this);
                        this.dialogSlike.setModalityType(Dialog.ModalityType.MODELESS);
                        this.dialogSlike.setFocusable(false);
                        this.dialogSlike.setVisible(true);
                    }
                    this.tblTabela.setRowSelectionInterval(this.tblTabela.getSelectedRow(), this.tblTabela.getSelectedRow());
                    this.selectionChanged();
                    return;
                }
                if (actionCommand.equalsIgnoreCase("lokacije")) {
                    if (this.tblTabela.getSelectedEntity() == null) return;
                    this.getSession().putParameter("tabela", (Object)this.tblTabela);
                    this.getSession().putParameter("artikal", (Object)this.tblTabela.getSelectedEntity());
                    this.showDialog(Lokacije.class);
                    this.selectionChanged();
                    return;
                }
                if (actionCommand.equals("uvoz")) {
                    this.getSession().putParameter("dlg", (Object)this);
                    this.getSession().putParameter("parameter", (Object)"artikli");
                    this.showDialog(UnosPutanje.class);
                    this.nfUkupnoSlogova.setText(String.valueOf(this.tblTabela.getRowCount()));
                    this.tblTabela.requestFocusInWindow();
                    return;
                }
                if (actionCommand.equalsIgnoreCase("upit")) {
                    if (this.tblTabela.getSelectedEntity() == null) return;
                    Upit.upit((PzDialog)this, (Artikal)(this.rj == null ? (Artikal)this.tblTabela.getSelectedEntity() : PzEntityManager.find(Artikal.class, (Object)((Stanjeartikal)this.tblTabela.getSelectedEntity()).getId().getSfrProizvod())));
                    return;
                }
                if (actionCommand.equalsIgnoreCase("oem")) {
                    if (this.tblTabela.getSelectedEntity() == null) return;
                    data1 = this.tblTabela;
                    data2 = this.tblTabela.getSelectedEntity() instanceof Artikal ? this.tblTabela.getSelectedEntity() : PzEntityManager.find(Artikal.class, (Object)((Stanjeartikal)this.tblTabela.getSelectedEntity()).getId().getSfrProizvod());
                    this.showDialog(OEMBrojevi.class, izmena, data1, data2);
                    this.tblTabela.setRowSelectionInterval(this.tblTabela.getSelectedRow(), this.tblTabela.getSelectedRow());
                    this.selectionChanged();
                    return;
                }
                if (actionCommand.equalsIgnoreCase("Zamena")) {
                    if (this.tblTabela.getSelectedEntity() == null) return;
                    data1 = this.tblTabela;
                    if (this.tblTabela.getSelectedEntity() instanceof Artikal) {
                        data2 = this.tblTabela.getSelectedEntity();
                    } else if (this.tblTabela.getSelectedEntity() instanceof Stanjeartikal) {
                        boolean bl = this.collapsed = !this.collapsed;
                        if (!this.collapsed) {
                            this.tblZamene.setData(this.getZamene(), Stanjeartikal.class);
                            if (this.tblZamene.getColumnCount() > 0) {
                                this.setTable((PzAbstractTable)this.tblZamene);
                            }
                        }
                        this.plZamene.setCollapsed(this.collapsed);
                        return;
                    }
                    this.showDialog(Zamene.class, izmena, data1, data2);
                    return;
                }
                if (actionCommand.equalsIgnoreCase("Opis")) {
                    if (this.tblTabela.getSelectedEntity() == null) return;
                    this.getSession().putParameter("tabela", (Object)this.tblTabela);
                    this.getSession().putParameter("artikal", (Object)this.tblTabela.getSelectedEntity());
                    this.showDialog(Opis.class);
                    return;
                }
                if (actionCommand.equals("napredna_pretraga")) {
                    String query = NaprednaPretraga.getQuery(this);
                    if (query == null) {
                        return;
                    }
                    this.trazi(query);
                    return;
                }
            }
            data1 = this.tblTabela;
            if (this.tblTabela.getSelectedEntity() instanceof Artikal) {
                data2 = this.tblTabela.getSelectedEntity();
            } else if (this.tblTabela.getSelectedEntity() instanceof Stanjeartikal) {
                data2 = PzEntityManager.find(Artikal.class, (Object)((Stanjeartikal)this.tblTabela.getSelectedEntity()).getId().getSfrProizvod());
            }
            this.showDialog(DodavanjeExtended.class, izmena, data1, data2);
            return;
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public void reloadTable(List<Artikal> data) {
        ((PzTable)this.tblTabela).setData(data, Artikal.class);
    }

    private void svi() {
        PzWorkerDialog.showStatus((String)"Pretraga u toku. Molim sa\u010dekajte.", (PzDialog)this);
        SwingWorker<List<Artikal>, Integer> worker = new SwingWorker<List<Artikal>, Integer>(){

            @Override
            protected List<Artikal> doInBackground() throws Exception {
                return PzEntityManager.getList((String)"SELECT a FROM Artikal a ORDER BY a.sfrSort");
            }

            @Override
            protected void done() {
                try {
                    try {
                        ((PzTable)PzDialogArtikliExtended.this.tblTabela).setData((List)this.get(), Artikal.class);
                        PzDialogArtikliExtended.this.nfUkupnoSlogova.setText(String.valueOf(PzDialogArtikliExtended.this.tblTabela.getRowCount()));
                        PzDialogArtikliExtended.this.tblTabela.requestFocusInWindow();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogArtikliExtended.this), (Throwable)e);
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    private PzToolBarIcon getIcnSlika() {
        if (this.icnSlika == null) {
            this.icnSlika = new PzToolBarIcon();
            this.icnSlika.setText("Slike|artikla|(ALT+F6)");
            this.icnSlika.addActionListener((ActionListener)((Object)this));
            this.icnSlika.setActionCommand("slika");
            this.icnSlika.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_photo.png")));
            this.icnSlika.setShortcut("alt+F6");
        }
        return this.icnSlika;
    }

    private PzToolBarIcon getIcnZamena() {
        if (this.icnZamena == null) {
            this.icnZamena = new PzToolBarIcon();
            this.icnZamena.setText("Zamene|za artikle|(ALT+F5)");
            this.icnZamena.addActionListener((ActionListener)((Object)this));
            this.icnZamena.setActionCommand("Zamena");
            this.icnZamena.setShortcut("alt+F5");
            this.icnZamena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/product_replace.png")));
        }
        return this.icnZamena;
    }

    protected PzShortcutListener getShortcutListener() {
        return new PzShortcutListener(){

            public void actionPerformed(PzShortcutListener.PzShortcutEvent arg0) {
                String command = arg0.getShortcut();
                if (command.equals("f8")) {
                    PzDialogArtikliExtended.this.tfNaziv.requestFocusInWindow();
                } else if (command.equals("f5")) {
                    PzDialogArtikliExtended.this.tfModel.requestFocusInWindow();
                } else if (command.equals("f10")) {
                    PzDialogArtikliExtended.this.tfKatalBroj.requestFocusInWindow();
                } else if (command.equals("f4")) {
                    PzDialogArtikliExtended.this.tfProizvodjac.requestFocusInWindow();
                } else if (command.equals("f6")) {
                    PzDialogArtikliExtended.this.tfDobavljac.requestFocusInWindow();
                } else if (command.equals("f12")) {
                    PzDialogArtikliExtended.this.tfRgr.requestFocusInWindow();
                } else if (command.equals("alt+f11")) {
                    PzDialogArtikliExtended.this.tfOemBroj.requestFocusInWindow();
                } else if (command.equals("f7")) {
                    PzDialogArtikliExtended.this.tfSifra.requestFocusInWindow();
                } else if (command.equals("f9")) {
                    PzDialogArtikliExtended.this.tfBliziOpis.requestFocusInWindow();
                }
            }
        };
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogArtikliExtended(Boolean.FALSE);
    }

    public PzDialogArtikliExtended(Boolean initGUI) {
    }

    public void loadHints() {
        try {
            this.tfModel.setAutoCompletionList((List)PzApplication.getApplication().getSession().getRuntimeStore().get("list_modeli"));
            this.tfDobavljac.setAutoCompletionList((List)PzApplication.getApplication().getSession().getRuntimeStore().get("list_komitenti"));
            this.tfProizvodjac.setAutoCompletionList((List)PzApplication.getApplication().getSession().getRuntimeStore().get("list_komitenti"));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setTable(PzAbstractTable tbl) {
        if (tbl.getRowCount() > 0) {
            tbl.setRowSelectionInterval(0, 0);
            tbl.convertColumnIndexToView(0);
            if (tbl.convertColumnIndexToView(0) != -1) {
                tbl.getColumn(0).setMinWidth(20);
                tbl.getColumn(0).setMaxWidth(20);
                tbl.getColumn(0).setPreferredWidth(20);
                tbl.getColumn(0).setCellRenderer((TableCellRenderer)new StanjeRenderer());
            }
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity != null) {
            this.tfRgr.setVal((Object)((Robnagrupa)entity).getOznRobGr());
            this.rGrupa = (Robnagrupa)entity;
        }
    }

    private void selectionChanged() throws Exception {
        if (this.tblTabela.getSelectedEntity() instanceof Artikal) {
            Artikal cfr_ignored_0 = (Artikal)this.tblTabela.getSelectedEntity();
        } else if (this.tblTabela.getSelectedEntity() instanceof Stanjeartikal) {
            if (!this.plZamene.isCollapsed()) {
                this.tblZamene.setData(this.getZamene(), Stanjeartikal.class);
                if (this.tblZamene.getColumnCount() > 0) {
                    this.setTable((PzAbstractTable)this.tblZamene);
                }
            }
            if (this.dialogSlike != null) {
                if (this.dialogSlike.isVisible()) {
                    this.getSession().putParameter("artikal", (Object)this.tblTabela.getSelectedEntity());
                }
            } else {
                return;
            }
        }
    }

    private void trazi(String napredna) throws Exception {
        this.em = PzEntityManager.getEm();
        if (this.rj == null) {
            Vector data;
            Long n = this.brojPogodaka(napredna);
            if (n > 5000L) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Broj pogodaka je preveliki. Molim suzite pretragu.");
                return;
            }
            this.q = this.em.createQuery(napredna != null ? napredna : this.createQueryArtikal(true, napredna));
            this.q.setHint("eclipselink.fetch-group", this.createFetchGroupArtikal());
            List data1 = this.q.getResultList();
            if (data1 instanceof ArrayList) {
                data = new Vector();
                data.addAll(data1);
            } else {
                data = (Vector)data1;
            }
            ((PzTable)this.tblTabela).setData(data, Artikal.class);
            if (data.size() > 0) {
                this.nfUkupnoSlogova.setText(String.valueOf(data.size()));
                this.tblTabela.requestFocusInWindow();
                this.tblTabela.setRowSelectionInterval(0, 0);
            } else {
                this.nfUkupnoSlogova.setText("0");
            }
        } else {
            this.lastQuery = this.createQueryStanjeartikal();
            Query q = this.em.createQuery(this.lastQuery);
            q.setHint("eclipselink.read-only", (Object)true);
            q.setHint("eclipselink.cursor.scrollable", (Object)true);
            if (this.cursor != null && !this.cursor.isClosed()) {
                this.cursor.close();
            }
            this.cursor = (ScrollableCursor)q.getSingleResult();
            this.instantiateTable();
        }
        this.em.clear();
        this.em.close();
    }

    private Object createFetchGroupArtikal() {
        if (this.grp == null) {
            this.grp = new FetchGroup();
            this.grp.addAttribute("sfrProizvod");
            this.grp.addAttribute("naziv");
            this.grp.addAttribute("jedMere");
            this.grp.addAttribute("robnagrupa.oznRobGr");
            this.grp.addAttribute("proizvodjac.sfrKomitent");
            this.grp.addAttribute("model.oznModel");
            this.grp.addAttribute("dobavljac.sfrKomitent");
            this.grp.addAttribute("ambalaza.oznAmbalaza");
            this.grp.addAttribute("barKod");
            this.grp.addAttribute("dobSifra");
            this.grp.addAttribute("standPak");
            this.grp.addAttribute("stokMin");
            this.grp.addAttribute("stokMax");
            this.grp.addAttribute("tezina");
        }
        return this.grp;
    }

    private void instantiateTable() {
        if (!(this.tblTabela instanceof PzScrollableTableEntity)) {
            this.tblTabela = new PzScrollableTableEntity(Stanjeartikal.class){
                private static final long serialVersionUID = 1L;

                protected void onSelectionChanged() {
                    try {
                        PzDialogArtikliExtended.this.selectionChanged();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                    }
                }
            };
            this.tblTabela.setId("PzScrollableTable");
            this.scPane.setViewportView((Component)this.tblTabela);
        }
        if (this.cursor != null) {
            if (this.cursor.size() > 0) {
                ((PzScrollableTableEntity)this.tblTabela).read(this.cursor);
                this.nfUkupnoSlogova.setText(String.valueOf(this.cursor.size()));
                this.setTable((PzAbstractTable)this.tblTabela);
            } else {
                this.cursor.close();
                ((PzScrollableTableEntity)this.tblTabela).clear();
            }
        }
    }

    public Long brojPogodaka(String napredna) {
        this.q = this.em.createQuery(this.createQueryArtikal(false, napredna));
        this.i = (Long)this.q.getSingleResult();
        return this.i;
    }

    private Vector<Stanjeartikal> getZamene() throws Exception {
        this.em = PzEntityManager.getEm();
        this.q = this.em.createQuery("SELECT s FROM Stanjeartikal s, Zamena z WHERE ((s.id.sfrProizvod=z.id.zamena AND z.id.artikal=:sifra) OR (s.id.sfrProizvod=z.id.artikal AND z.id.zamena=:sifra)) AND s.id.oznRj=:oznRj AND s.id.oznOgranak=:oznOgranak");
        this.q.setParameter("sifra", (Object)((Stanjeartikal)this.tblTabela.getSelectedEntity()).getId().getSfrProizvod());
        this.q.setParameter("oznRj", (Object)this.rj.getId().getOznRj());
        this.q.setParameter("oznOgranak", (Object)this.rj.getId().getOznOgranak());
        Vector res = (Vector)this.q.getResultList();
        this.em.close();
        return res;
    }

    private void runSearch() {
        PzDialogArtikliExtended instance = this;
        try {
            this.trazi(null);
            this.tblTabela.requestFocusInWindow();
            this.selectionChanged();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)instance), (Throwable)e);
        }
    }

    private String createQueryArtikal(boolean parametar, String napredna) {
        int i;
        String robneGrupe;
        if (napredna != null) {
            String q = napredna.replace("SELECT a", "SELECT COUNT(a)");
            return q;
        }
        String queryPomocni = "";
        String pomParametar = "";
        String pomParametar1 = "";
        Vector<String> vector = new Vector<String>();
        String pomString = "";
        String pomString1 = "";
        String naziv = this.tfNaziv.getVal();
        String bliziOpis = this.tfBliziOpis.getVal();
        String upitNaziv = "";
        String upitBliziOpis = "";
        String string = this.tfRgr.getVal().equals("") ? "" : (robneGrupe = this.rGrupa != null ? this.rGrupa.getRobnaGrupaListAsString() : ((Robnagrupa)this.em.find(Robnagrupa.class, (Object)this.tfRgr.getVal())).getRobnaGrupaListAsString());
        if (!naziv.equals("")) {
            i = 0;
            while (i < naziv.length()) {
                pomString = naziv.substring(i, i + 1);
                if (!pomString.equals(" ")) {
                    pomString1 = String.valueOf(pomString1) + pomString;
                } else {
                    vector.add(pomString1);
                    pomString1 = "";
                }
                ++i;
            }
            vector.add(pomString1);
            i = 0;
            while (i < vector.size()) {
                upitNaziv = String.valueOf(upitNaziv) + "LOWER(a.naziv) LIKE '%" + ((String)vector.elementAt(i)).toLowerCase() + "%'";
                if (i != vector.size() - 1) {
                    upitNaziv = String.valueOf(upitNaziv) + " AND ";
                }
                ++i;
            }
        }
        vector.clear();
        pomString = "";
        pomString1 = "";
        if (!bliziOpis.equals("")) {
            i = 0;
            while (i < bliziOpis.length()) {
                pomString = bliziOpis.substring(i, i + 1);
                if (!pomString.equals(" ")) {
                    pomString1 = String.valueOf(pomString1) + pomString;
                } else {
                    vector.add(pomString1);
                    pomString1 = "";
                }
                ++i;
            }
            vector.add(pomString1);
            i = 0;
            while (i < vector.size()) {
                upitBliziOpis = String.valueOf(upitBliziOpis) + "LOWER(a.bliziOpis) LIKE '%" + (String)vector.elementAt(i) + "%'";
                if (i != vector.size() - 1) {
                    upitBliziOpis = String.valueOf(upitBliziOpis) + " AND ";
                }
                ++i;
            }
        }
        String kritProizvodjac = "%" + this.tfProizvodjac.getVal().replaceAll("\\s+", "%").trim().toLowerCase() + "%";
        String kritModel = "%" + this.tfModel.getVal().replaceAll("\\s+", "%").trim().toLowerCase() + "%";
        String kritDobav = "%" + this.tfDobavljac.getVal().replaceAll("\\s+", "%").trim().toLowerCase() + "%";
        String kritOEM = this.tfOemBroj.getVal().replaceAll("\\D", "").trim();
        if (parametar) {
            pomParametar = "a";
            pomParametar1 = "";
        } else {
            pomParametar = "count(a)";
        }
        String query = "SELECT %pomParametar FROM Artikal %queryPomocni" + (this.tfNaziv.isValueValid() ? " AND %upitNaziv" : "") + (this.tfProizvodjac.isValueValid() ? " AND LOWER(a.proizvodjac.naziv) LIKE '%kritProizvodjac' " : "") + (this.tfModel.isValueValid() ? " AND LOWER(a.model.naziv) LIKE '%kritModel' " : "") + (this.tfKatalBroj.isValueValid() ? " AND a.dobSifra = '%kritKatBroj' " : "") + (this.tfSifra.isValueValid() ? " AND a.sfrProizvod = '%kritSifra' " : "") + (this.tfDobavljac.isValueValid() ? " AND LOWER(a.dobavljac.naziv) LIKE '%kritDobav' " : "") + (this.tfRgr.isValueValid() ? " AND a.robnagrupa.oznRobGr IN %kritOznRg" : "") + (this.tfBliziOpis.isValueValid() ? " AND %upitBliziOpis" : "") + " %pomParametar1";
        queryPomocni = !this.tfOemBroj.getVal().equals("") && parametar ? "AS a, OEBroj oe WHERE a.sfrProizvod = oe.id.sfrProizvod AND LOWER(oe.oemStripped) LIKE '%kritOEM'" : (!this.tfOemBroj.getVal().equals("") && !parametar ? "AS a, OEBroj oe WHERE a.sfrProizvod = oe.id.sfrProizvod AND LOWER(oe.oemStripped) LIKE '%kritOEM'" : "a WHERE");
        query = query.replaceAll("%upitNaziv", upitNaziv).replaceAll("%queryPomocni", queryPomocni).replaceAll("%pomParametar1", pomParametar1).replaceAll("%pomParametar", pomParametar).replaceAll("%kritProizvodjac", kritProizvodjac).replaceAll("%kritModel", kritModel).replaceAll("%kritKatBroj", this.tfKatalBroj.getVal()).replaceAll("%kritSifra", this.tfSifra.getVal()).replaceAll("%kritDobav", kritDobav).replaceAll("%kritOznRg", robneGrupe).replaceAll("%kritOEM", kritOEM).replaceAll("%upitBliziOpis", upitBliziOpis).replaceAll("WHERE\\s+AND", "WHERE ").replaceAll("AND\\s+ORDER", "ORDER ").replaceAll("AND\\s+AND", "AND ");
        return query;
    }

    private String createQueryStanjeartikal() {
        int i;
        String queryPomocni = "";
        Vector<String> vector = new Vector<String>();
        String pomString = "";
        String pomString1 = "";
        String naziv = this.tfNaziv.getVal();
        String bliziOpis = this.tfBliziOpis.getVal();
        String upitNaziv = "";
        String upitBliziOpis = "";
        if (!naziv.equals("")) {
            i = 0;
            while (i < naziv.length()) {
                pomString = naziv.substring(i, i + 1);
                if (!pomString.equals(" ")) {
                    pomString1 = String.valueOf(pomString1) + pomString;
                } else {
                    vector.add(pomString1);
                    pomString1 = "";
                }
                ++i;
            }
            vector.add(pomString1);
            i = 0;
            while (i < vector.size()) {
                upitNaziv = String.valueOf(upitNaziv) + "LOWER(sa.naziv) LIKE '%" + (String)vector.elementAt(i) + "%'";
                if (i != vector.size() - 1) {
                    upitNaziv = String.valueOf(upitNaziv) + " AND ";
                }
                ++i;
            }
        }
        vector.clear();
        pomString = "";
        pomString1 = "";
        if (!bliziOpis.equals("")) {
            i = 0;
            while (i < bliziOpis.length()) {
                pomString = bliziOpis.substring(i, i + 1);
                if (!pomString.equals(" ")) {
                    pomString1 = String.valueOf(pomString1) + pomString;
                } else {
                    vector.add(pomString1);
                    pomString1 = "";
                }
                ++i;
            }
            vector.add(pomString1);
            i = 0;
            while (i < vector.size()) {
                upitBliziOpis = String.valueOf(upitBliziOpis) + "LOWER(sa.bliziOpis) LIKE '%" + (String)vector.elementAt(i) + "%'";
                if (i != vector.size() - 1) {
                    upitBliziOpis = String.valueOf(upitBliziOpis) + " AND ";
                }
                ++i;
            }
        }
        String kritProizvodjac = "%" + this.tfProizvodjac.getVal().replaceAll("\\s+", "%").trim().toLowerCase() + "%";
        String kritModel = "%" + this.tfModel.getVal().replaceAll("\\s+", "%").trim().toLowerCase() + "%";
        String kritDobav = "%" + this.tfDobavljac.getVal().replaceAll("\\s+", "%").trim().toLowerCase() + "%";
        String kritOEM = this.tfOemBroj.getVal().replaceAll("\\D", "").trim();
        String query = "SELECT sa FROM Stanjeartikal sa %queryPomocni" + (this.tfNaziv.isValueValid() ? " AND %upitNaziv " : "") + (this.tfProizvodjac.isValueValid() ? " AND LOWER(sa.nazivProizvodjac) LIKE '%kritProizvodjac' " : "") + (this.tfModel.isValueValid() ? " AND LOWER(sa.nazivModela) LIKE '%kritModel' " : "") + (this.tfKatalBroj.isValueValid() ? " AND sa.katBroj = '%kritKatBroj' " : "") + (this.tfSifra.isValueValid() ? " AND sa.id.sfrProizvod = '%kritSifra' " : "") + (this.tfDobavljac.isValueValid() ? " AND LOWER(sa.nazivDobavljac) LIKE '%kritDobav' " : "") + (this.tfRgr.isValueValid() ? " AND sa.oznRobGr = '%kritOznRg' " : "") + (this.tfBliziOpis.isValueValid() ? " AND %upitBliziOpis " : "") + " AND ((sa.id.oznRj = '%oznRj' AND sa.id.oznOgranak = '%oznOgranak'))" + " ORDER BY sa.naziv, sa.bliziOpis";
        queryPomocni = !this.tfOemBroj.getVal().equals("") ? ", Artikal AS a, OEBroj oe WHERE sa.sfrProizvod = a.sfrProizvod AND a.sfrProizvod = oe.id.sfrProizvod AND LOWER(oe.oemStripped) LIKE '%kritOEM'" : "WHERE";
        query = query.replaceAll("%upitNaziv", upitNaziv).replaceAll("%queryPomocni", queryPomocni).replaceAll("%kritProizvodjac", kritProizvodjac).replaceAll("%kritModel", kritModel).replaceAll("%kritKatBroj", this.tfKatalBroj.getVal()).replaceAll("%kritSifra", this.tfSifra.getVal()).replaceAll("%kritDobav", kritDobav).replaceAll("%kritOznRg", this.tfRgr.getVal()).replaceAll("%oznRj", this.rj.getId().getOznRj()).replaceAll("%oznOgranak", this.rj.getId().getOznOgranak()).replaceAll("%kritOEM", kritOEM).replaceAll("%upitBliziOpis", upitBliziOpis).replaceAll("WHERE\\s+AND", "WHERE ").replaceAll("AND\\s+AND", "AND ").replaceAll("AND\\s+ORDER", "ORDER ");
        return query;
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        if (this.rj != null) {
            int index;
            if (this.map == null) {
                this.map = new HashMap();
                this.map.put("rj", this.rj);
                PzApplication.getApplication().getSession().getRuntimeStore().put("artikli_cursor", this.map);
            }
            if (this.lastQuery != null) {
                this.map.put("cursor", this.cursor);
                this.map.put("query", this.lastQuery);
                this.map.put("rj", this.rj);
            } else if (this.cursor != null) {
                this.map.put("cursor", this.cursor);
            }
            this.map.put("time", new Date().getTime());
            int n = index = this.tblTabela.getSelectedRow() != -1 ? this.tblTabela.convertRowIndexToModel(this.tblTabela.getSelectedRow()) : -1;
            if (index != -1) {
                this.map.put("selected", new Integer(index));
            }
        }
    }
}

