/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jasperreports.engine.JRDataSource;
import org.jdesktop.application.Application;
import org.jdesktop.swingx.JXTitledPanel;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Konto;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.PzTableDataSource;
import rs.pezar.sifarnici.gui.kontniPlan.Dodavanje;
import rs.pezar.sifarnici.gui.kontniPlan.PzDialogAnalitikaKonta;
import rs.pezar.sifarnici.gui.kontniPlan.PzDialogAzuriranjeAOP;
import rs.pezar.sifarnici.util.KontniPlanUtility;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogKontniPlan
extends PzDialog {
    private static final long serialVersionUID = -7745443644331406254L;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnAOP;
    private PzButton btnOdustani;
    private PzButton bntTrazi;
    private JPanel pnlButtons;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanel pnlPretraga;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private PzToolBarIcon icnSifarnik;
    private JLabel jLabelUP;
    private JLabel jLabelTP;
    private JLabel jLabelPS;
    private JLabel jLabelSaldo;
    private JLabel jLabelPotrazuje;
    private JLabel jLabelDuguje;
    private JLabel jLabelOpis;
    private JLabel jLabelNaziv;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnKartica;
    private PzToolBarIcon icnIzmena;
    private JPanel pnlBilans;
    private PzTable table;
    private JScrollPane scpKontniPlan;
    private JToolBar toolbar;
    private PzDoubleField PSDuguje;
    private PzDoubleField PSPotrazuje;
    private PzTextField txtNazivKonta;
    private PzTextField naziv;
    private PzNumericOnlyTextField oznaka;
    private PzDoubleField PSSaldo;
    private PzDoubleField TPDuguje;
    private PzDoubleField TPPotrazuje;
    private PzDoubleField TPSaldo;
    private PzDoubleField UPDuguje;
    private PzDoubleField UPPotrazuje;
    private PzDoubleField UPSaldo;
    private PzComponentGroup fieldGroup;
    private int selrow;
    boolean wait = false;
    private Timer t;
    private PzToolBarIcon icnStampa;
    private JXTitledPanel pnlBilansiTitled;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogKontniPlan inst = new PzDialogKontniPlan(frame);
                BorderLayout instLayout = new BorderLayout();
                instLayout.setHgap(5);
                instLayout.setVgap(5);
                inst.getContentPane().setLayout(instLayout);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogKontniPlan(JFrame frame) {
        super(frame);
        this.initGUI();
        try {
            this.restoreData();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public PzDialogKontniPlan(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        try {
            this.restoreData();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void restoreData() throws Exception {
        SwingWorker<List<Konto>, Object> worker = new SwingWorker<List<Konto>, Object>(){

            @Override
            protected List<Konto> doInBackground() throws Exception {
                List<Object> konta = new ArrayList<Konto>();
                if ("SELECT k FROM Konto k ORDER BY k.id.oznKonto, k.id.analitika" != null) {
                    EntityManager em = PzEntityManager.getEm();
                    Query query = em.createQuery("SELECT k FROM Konto k ORDER BY k.id.oznKonto, k.id.analitika");
                    konta = query.getResultList();
                    em.close();
                }
                return konta;
            }

            @Override
            protected void done() {
                try {
                    PzDialogKontniPlan.this.table = new PzTable();
                    PzDialogKontniPlan.this.table.setData((List)this.get(), Konto.class);
                    PzDialogKontniPlan.this.scpKontniPlan.setViewportView((Component)PzDialogKontniPlan.this.table);
                    Integer row = (Integer)PzApplication.getApplication().getSession().getRuntimeStore().get("kontniPlan_row");
                    if (row != null && row != 0 && row != -1 && row < PzDialogKontniPlan.this.table.getRowCount()) {
                        PzDialogKontniPlan.this.table.setRowSelectionInterval(row.intValue(), row.intValue());
                        PzDialogKontniPlan.this.table.scrollRowToVisible(row.intValue());
                    }
                    PzDialogKontniPlan.this.table.requestFocusInWindow();
                    PzDialogKontniPlan.this.table.getSelectionModel().addListSelectionListener(PzDialogKontniPlan.this.getSelectionListener());
                    PzDialogKontniPlan.this.activateTimer();
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)PzDialogKontniPlan.this), (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    private ListSelectionListener getSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PzDialogKontniPlan.this.wait = true;
            }
        };
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        this.deactivateTimer();
        PzApplication.getApplication().getSession().getRuntimeStore().put("kontniPlan_row", (Object)this.table.getSelectedRow());
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            thisLayout.setHgap(5);
            thisLayout.setVgap(5);
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Kontni plan");
            this.jPanel2 = new JPanel();
            BorderLayout jPanel2Layout = new BorderLayout();
            this.jPanel2.setLayout(jPanel2Layout);
            this.getContentPane().add((Component)this.jPanel2, "Center");
            this.jPanel2.setPreferredSize(new Dimension(725, 305));
            this.pnlPretraga = new PzPanel();
            this.jPanel2.add((Component)this.pnlPretraga, "North");
            GridBagLayout panelPretragaLayout = new GridBagLayout();
            panelPretragaLayout.columnWidths = new int[]{127, 112, 134, 7};
            int[] nArray = new int[10];
            nArray[0] = 25;
            nArray[1] = 25;
            nArray[7] = 16;
            nArray[9] = 45;
            panelPretragaLayout.rowHeights = nArray;
            panelPretragaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelPretragaLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            this.pnlPretraga.setPreferredSize(new Dimension(725, 174));
            this.pnlPretraga.setBorder((Border)BorderFactory.createTitledBorder(null, "Pretraga", 4, 0));
            this.pnlPretraga.setLayout((LayoutManager)panelPretragaLayout);
            this.pnlPretraga.setVisible(false);
            this.jLabel1 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setText("Naziv:");
            this.jLabel2 = new JLabel();
            this.pnlPretraga.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel2.setText("Oznaka:");
            this.pnlButtons = new JPanel();
            GridBagLayout pnlButtonsLayout = new GridBagLayout();
            this.pnlPretraga.add((Component)this.pnlButtons, (Object)new GridBagConstraints(0, 9, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButtons.setLayout(pnlButtonsLayout);
            pnlButtonsLayout.rowWeights = new double[]{0.0};
            pnlButtonsLayout.rowHeights = new int[]{43};
            pnlButtonsLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlButtonsLayout.columnWidths = new int[]{242, 145, 7, 7};
            this.bntTrazi = new PzButton();
            this.pnlButtons.add((Component)this.bntTrazi, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.bntTrazi.setText("Tra\u017ei");
            this.bntTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/find.png")));
            this.bntTrazi.setActionCommand("trazi");
            this.bntTrazi.setBounds(586, 6, 113, 29);
            this.bntTrazi.setLayout(null);
            this.bntTrazi.setPreferredSize(new Dimension(115, 30));
            this.bntTrazi.addActionListener((ActionListener)((Object)this));
            this.btnOdustani = new PzButton();
            this.pnlButtons.add((Component)this.btnOdustani, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOdustani.setText("Odustani");
            this.btnOdustani.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/forbidden.png")));
            this.btnOdustani.setActionCommand("odustani");
            this.btnOdustani.setBounds(586, 6, 113, 29);
            this.btnOdustani.setPreferredSize(new Dimension(115, 30));
            this.btnOdustani.addActionListener((ActionListener)((Object)this));
            this.fieldGroup = new PzComponentGroup();
            this.oznaka = new PzNumericOnlyTextField();
            this.fieldGroup.add((Component)this.oznaka);
            this.pnlPretraga.add((Component)this.oznaka, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.naziv = new PzTextField();
            this.fieldGroup.add((Component)this.naziv);
            this.pnlPretraga.add((Component)this.naziv, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.naziv.setMaxLength(30);
            this.jPanel1 = new JPanel();
            this.jPanel2.add((Component)this.jPanel1, "Center");
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.jPanel1.setPreferredSize(new Dimension(725, 318));
            jPanel1Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7};
            jPanel1Layout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel1Layout.columnWidths = new int[]{7, 7, 7, 7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.scpKontniPlan = new JScrollPane();
            this.jPanel1.add((Component)this.scpKontniPlan, new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
            this.scpKontniPlan.setBackground(new Color(211, 242, 210));
            this.setSize(733, 603);
            this.toolbar = new JToolBar();
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.getContentPane().add((Component)this.toolbar, "North");
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/row_add.png")));
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/row_edit.png")));
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/row_delete.png")));
            this.icnBrisanje.setText("Brisanje| (DEL)");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnKartica = new PzToolBarIcon();
            this.icnKartica.setEnabled(false);
            this.toolbar.add((Component)this.icnKartica);
            this.icnKartica.setText("Kartica konta| (F2)");
            this.icnKartica.setActionCommand("KarticaKonta");
            this.icnKartica.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/box_text.png")));
            this.icnKartica.addActionListener((ActionListener)((Object)this));
            this.icnKartica.setShortcut("F2");
            this.icnSifarnik = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSifarnik);
            this.icnSifarnik.setText("\u0160ifarnik slobodne|analitike (F4)");
            this.icnSifarnik.setShortcut("F4");
            this.icnSifarnik.setActionCommand("PzDialogAnalitikaKonta");
            this.icnSifarnik.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/box_text.png")));
            this.icnSifarnik.addActionListener((ActionListener)((Object)this));
            this.icnAOP = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnAOP);
            this.icnAOP.setText("A\u017euriranje|AOP-a (F5)");
            this.icnAOP.setShortcut("F5");
            this.icnAOP.setActionCommand("AOP");
            this.icnAOP.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/box_text.png")));
            this.icnAOP.addActionListener((ActionListener)((Object)this));
            this.icnStampa = new PzToolBarIcon();
            this.icnStampa.setText("\u0160tampa|(Alt+S)");
            this.icnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/printer_view.png")));
            this.icnStampa.addActionListener((ActionListener)((Object)this));
            this.icnStampa.setShortcut("alt+s");
            this.icnStampa.setActionCommand("stampa");
            this.pnlBilansiTitled = new JXTitledPanel();
            this.pnlBilansiTitled.setTitle("Izvod iz bilansa");
            this.pnlBilans = new JPanel();
            this.pnlBilansiTitled.setContentContainer((Container)this.pnlBilans);
            this.getContentPane().add((Component)this.pnlBilansiTitled, "South");
            GridBagLayout pnlBilansLayout = new GridBagLayout();
            this.pnlBilans.setPreferredSize(new Dimension(725, 170));
            pnlBilansLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            pnlBilansLayout.rowHeights = new int[]{22, 22, 24, 24, 24};
            pnlBilansLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.0, 0.1, 0.0, 0.1, 0.0};
            pnlBilansLayout.columnWidths = new int[]{18, 100, 100, 39, 100, 35, 100, 52};
            this.pnlBilans.setLayout(pnlBilansLayout);
            this.jLabelNaziv = new JLabel();
            this.pnlBilans.add((Component)this.jLabelNaziv, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 15), 0, 0));
            this.jLabelNaziv.setText("Naziv konta");
            this.jLabelOpis = new JLabel();
            this.pnlBilans.add((Component)this.jLabelOpis, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 15), 0, 0));
            this.jLabelOpis.setText("Opis");
            this.jLabelPS = new JLabel();
            this.pnlBilans.add((Component)this.jLabelPS, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 15), 0, 0));
            this.jLabelPS.setText("Pocetno stanje");
            this.jLabelTP = new JLabel();
            this.pnlBilans.add((Component)this.jLabelTP, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 15), 0, 0));
            this.jLabelTP.setText("Tekuci promet");
            this.jLabelUP = new JLabel();
            this.pnlBilans.add((Component)this.jLabelUP, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 15), 0, 0));
            this.jLabelUP.setText("Ukupan promet");
            this.jLabelDuguje = new JLabel();
            this.pnlBilans.add((Component)this.jLabelDuguje, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabelDuguje.setText("Duguje");
            this.jLabelPotrazuje = new JLabel();
            this.pnlBilans.add((Component)this.jLabelPotrazuje, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabelPotrazuje.setText("Potrazuje");
            this.jLabelSaldo = new JLabel();
            this.pnlBilans.add((Component)this.jLabelSaldo, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabelSaldo.setText("Saldo");
            this.PSDuguje = new PzDoubleField();
            this.pnlBilans.add((Component)this.PSDuguje, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.PSDuguje.setFont(new Font("Tahoma", 0, 14));
            this.PSDuguje.setEditable(false);
            this.PSDuguje.setFocusable(false);
            this.PSPotrazuje = new PzDoubleField();
            this.pnlBilans.add((Component)this.PSPotrazuje, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.PSPotrazuje.setFont(new Font("Tahoma", 0, 14));
            this.PSPotrazuje.setEditable(false);
            this.PSPotrazuje.setFocusable(false);
            this.PSSaldo = new PzDoubleField();
            this.pnlBilans.add((Component)this.PSSaldo, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.PSSaldo.setFont(new Font("Tahoma", 0, 14));
            this.PSSaldo.setEditable(false);
            this.PSSaldo.setFocusable(false);
            this.TPDuguje = new PzDoubleField();
            this.pnlBilans.add((Component)this.TPDuguje, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.TPDuguje.setFont(new Font("Tahoma", 0, 14));
            this.TPDuguje.setEditable(false);
            this.TPDuguje.setFocusable(false);
            this.TPPotrazuje = new PzDoubleField();
            this.pnlBilans.add((Component)this.TPPotrazuje, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.TPPotrazuje.setFont(new Font("Tahoma", 0, 14));
            this.TPPotrazuje.setEditable(false);
            this.TPPotrazuje.setFocusable(false);
            this.TPSaldo = new PzDoubleField();
            this.pnlBilans.add((Component)this.TPSaldo, new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.TPSaldo.setFont(new Font("Tahoma", 0, 14));
            this.TPSaldo.setEditable(false);
            this.TPSaldo.setFocusable(false);
            this.UPDuguje = new PzDoubleField();
            this.pnlBilans.add((Component)this.UPDuguje, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.UPDuguje.setFont(new Font("Tahoma", 0, 14));
            this.UPDuguje.setEditable(false);
            this.UPDuguje.setFocusable(false);
            this.UPPotrazuje = new PzDoubleField();
            this.pnlBilans.add((Component)this.UPPotrazuje, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.UPPotrazuje.setFont(new Font("Tahoma", 0, 14));
            this.UPPotrazuje.setEditable(false);
            this.UPPotrazuje.setFocusable(false);
            this.UPSaldo = new PzDoubleField();
            this.pnlBilans.add((Component)this.UPSaldo, new GridBagConstraints(6, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.UPSaldo.setFont(new Font("Tahoma", 0, 14));
            this.UPSaldo.setEditable(false);
            this.UPSaldo.setFocusable(false);
            this.txtNazivKonta = new PzTextField();
            this.pnlBilans.add((Component)this.txtNazivKonta, new GridBagConstraints(2, 0, 5, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.txtNazivKonta.setName("txtNazivKonta");
            this.setLocationRelativeTo(null);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent arg0) {
        PzTable data1 = null;
        PzEntity data2 = null;
        boolean izmena = false;
        PzButton button = (PzButton)arg0.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("brisanje")) {
            this.table.removeSelectedEntity(true, true);
            return;
        }
        if (actionCommand.equalsIgnoreCase("Izmena")) {
            actionCommand = "Dodavanje";
            izmena = true;
        } else {
            if (actionCommand.equals("PzDialogAnalitikaKonta")) {
                this.showDialog(PzDialogAnalitikaKonta.class);
                return;
            }
            if (actionCommand.equals("AOP")) {
                this.showDialog(PzDialogAzuriranjeAOP.class);
                return;
            }
        }
        data1 = this.table;
        data2 = this.table.getSelectedEntity();
        this.showDialog(Dodavanje.class, izmena, data1, data2);
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogKontniPlan(Boolean.FALSE);
    }

    public PzDialogKontniPlan(Boolean initGUI) {
    }

    public void activateTimer() {
        this.selrow = -1;
        if (this.t != null) {
            this.t.restart();
        } else {
            this.t = new Timer(400, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (PzDialogKontniPlan.this.table != null && PzDialogKontniPlan.this.table.getRowCount() > 0) {
                        if (PzDialogKontniPlan.this.table.getSelectedRow() == PzDialogKontniPlan.this.selrow) {
                            return;
                        }
                        if (!PzDialogKontniPlan.this.wait) {
                            PzDialogKontniPlan.this.setFieldValue();
                            PzDialogKontniPlan.this.selrow = PzDialogKontniPlan.this.table.getSelectedRow();
                        }
                        PzDialogKontniPlan.this.wait = false;
                    }
                }
            });
        }
        this.t.start();
    }

    private void showReports() {
        try {
            new Vector();
            Vector<Firma> data = new Vector<Firma>();
            data.add(PzFirma.getFirma());
            PzTableDataSource ds = new PzTableDataSource((PzAbstractTable)this.table, data);
            HashMap<String, String> params = new HashMap<String, String>();
            String title = null;
            String fname = null;
            title = "\u0160IFARNIK KOMITENATA";
            fname = "rs/pezar/reports/compiled/komitenti.stampa.red.jasper";
            params.put("title", title);
            PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (String)fname, params, (String)title);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void setFieldValue() {
        Konto konto = (Konto)this.table.getSelectedEntity();
        if (konto == null) {
            return;
        }
        this.txtNazivKonta.setVal((Object)konto.getNaziv());
        Object[] pocetno = KontniPlanUtility.createQuery(KontniPlanUtility.getPocetno(konto));
        Object[] tekuci = KontniPlanUtility.createQuery(KontniPlanUtility.getTekuci(konto));
        this.PSDuguje.setVal((Object)this.getBigDecimalValue(pocetno, 0));
        this.PSPotrazuje.setVal((Object)this.getBigDecimalValue(pocetno, 1));
        this.PSSaldo.setVal((Object)(this.PSDuguje.getVal() - this.PSPotrazuje.getVal()));
        this.TPDuguje.setVal((Object)this.getBigDecimalValue(tekuci, 0));
        this.TPPotrazuje.setVal((Object)this.getBigDecimalValue(tekuci, 1));
        this.TPSaldo.setVal((Object)(this.TPDuguje.getVal() - this.TPPotrazuje.getVal()));
        this.UPDuguje.setVal((Object)(this.PSDuguje.getVal() + this.TPDuguje.getVal()));
        this.UPPotrazuje.setVal((Object)(this.PSPotrazuje.getVal() + this.TPPotrazuje.getVal()));
        this.UPSaldo.setVal((Object)(this.PSSaldo.getVal() + this.TPSaldo.getVal()));
    }

    private BigDecimal getBigDecimalValue(Object[] rez, int i) {
        return rez[i] == null ? new BigDecimal(0) : (BigDecimal)rez[i];
    }

    public void deactivateTimer() {
        if (this.t.isRunning()) {
            this.t.stop();
        }
    }
}

