/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Slika;
import rs.pezar.sifarnici.gui.artikli.SlikePreview;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;

public class ImagePreviewSettings
extends PzPanel
implements PropertyChangeListener,
ListSelectionListener {
    private int width;
    private int height;
    private ImageIcon icon;
    private Image image;
    private static final int ACCSIZE = 155;
    private Color bg;
    private PzTable table;
    private String parameterDirSlike;
    private Slika slika;

    public ImagePreviewSettings() {
        this.setPreferredSize(new Dimension(155, -1));
        this.bg = this.getBackground();
        this.parameterDirSlike = PzParameter.getParameterValue((String)"DIR_SLIKE");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if (propertyName.equals("SelectedFileChangedProperty")) {
            File selection = (File)e.getNewValue();
            if (selection == null) {
                return;
            }
            String name = selection.getAbsolutePath();
            if (name != null && name.toLowerCase().endsWith(".jpg") || name.toLowerCase().endsWith(".jpeg") || name.toLowerCase().endsWith(".bmp") || name.toLowerCase().endsWith(".tif") || name.toLowerCase().endsWith(".gif") || name.toLowerCase().endsWith(".png")) {
                this.icon = new ImageIcon(name);
                this.image = this.icon.getImage();
                this.scaleImage();
                this.repaint();
            }
        }
    }

    private void scaleImage() {
        this.width = this.image.getWidth((ImageObserver)((Object)this));
        this.height = this.image.getHeight((ImageObserver)((Object)this));
        double ratio = 1.0;
        if (this.width >= this.height) {
            ratio = 150.0 / (double)this.width;
            this.width = 150;
            this.height = (int)((double)this.height * ratio);
        } else if (this.getHeight() > 150) {
            ratio = 150.0 / (double)this.height;
            this.height = 150;
            this.width = (int)((double)this.width * ratio);
        } else {
            ratio = (double)this.getHeight() / (double)this.height;
            this.height = this.getHeight();
            this.width = (int)((double)this.width * ratio);
        }
        this.image = this.image.getScaledInstance(this.width, this.height, 1);
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.bg);
        g.fillRect(0, 0, 155, this.getHeight());
        g.drawImage(this.image, this.getWidth() / 2 - this.width / 2 + 5, this.getHeight() / 2 - this.height / 2, (ImageObserver)((Object)this));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.table = SlikePreview.getTable();
        if (this.table != null) {
            if (this.table.getSelectedEntity() == null && this.table.getRowCount() != 0) {
                this.table.getSelectionModel().setSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
            }
            if (e.getSource() == this.table.getSelectionModel() && this.table.getName().equals("slikePreviewTable") && this.table.getSelectedEntity() != null) {
                String slikaName = ((Slika)this.table.getSelectedEntity()).getFileName();
                String apsloutePath = String.valueOf(this.parameterDirSlike) + File.separator + slikaName;
                File slika = new File(apsloutePath);
                if (slika.exists()) {
                    this.icon = new ImageIcon(apsloutePath);
                    this.image = this.icon.getImage();
                    this.scaleImage();
                    this.repaint();
                    System.out.println(apsloutePath);
                } else {
                    this.icon = new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/no_image.png"));
                    this.image = this.icon.getImage();
                    this.scaleImage();
                    this.repaint();
                }
            }
        }
    }
}

