/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli.browser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserAlociranoPanel;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserComponent;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserDescPanel;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserImgPanel;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserInfoPanel;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserOemPanel;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserRabatiPanel;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserSearchPanel;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserTablePanel;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserZamenePanel;

public class ComponentRegistry {
    private static ComponentRegistry instance;
    private List<BrowserComponent> components = new ArrayList<BrowserComponent>();
    private BrowserComponent defaultComponent;

    public static ComponentRegistry getInstance() {
        if (instance == null) {
            instance = new ComponentRegistry();
        }
        return instance;
    }

    public ComponentRegistry() {
        this.init();
    }

    public void addBrowserComponent(BrowserComponent c, boolean defaultComponent) {
        this.components.add(c);
        if (defaultComponent) {
            this.setDefaultBrowserComponent(c);
        }
    }

    public BrowserComponent getBrowserComponent(String id) {
        BrowserComponent res = null;
        Iterator<BrowserComponent> iterator = this.components.iterator();
        while (iterator.hasNext() && res == null) {
            BrowserComponent component = iterator.next();
            if (!component.getId().equals(id)) continue;
            res = component;
        }
        return res;
    }

    public List<BrowserComponent> getBrowserComponents() {
        return this.components;
    }

    public BrowserComponent getDefaultBrowserComponent() {
        return this.defaultComponent;
    }

    public void setDefaultBrowserComponent(BrowserComponent defaultComponent) {
        this.defaultComponent = defaultComponent;
    }

    private void init() {
        BrowserSearchPanel pnlSearch = new BrowserSearchPanel();
        BrowserInfoPanel pnlInfo = new BrowserInfoPanel();
        BrowserDescPanel pnlDesc = new BrowserDescPanel();
        BrowserImgPanel pnlImage = new BrowserImgPanel();
        BrowserTablePanel pnlTable = new BrowserTablePanel();
        BrowserZamenePanel pnlZamene = new BrowserZamenePanel();
        BrowserOemPanel pnlOem = new BrowserOemPanel();
        BrowserRabatiPanel pnlRabati = new BrowserRabatiPanel();
        BrowserAlociranoPanel pnlAlocirano = new BrowserAlociranoPanel();
        this.addBrowserComponent(pnlSearch, true);
        this.addBrowserComponent(pnlInfo, false);
        this.addBrowserComponent(pnlDesc, false);
        this.addBrowserComponent(pnlImage, false);
        this.addBrowserComponent(pnlTable, false);
        this.addBrowserComponent(pnlZamene, false);
        this.addBrowserComponent(pnlOem, false);
        this.addBrowserComponent(pnlRabati, false);
        this.addBrowserComponent(pnlAlocirano, false);
        pnlTable.addSubscriber(pnlInfo);
        pnlTable.addSubscriber(pnlDesc);
        pnlTable.addSubscriber(pnlImage);
        pnlTable.addSubscriber(pnlZamene);
        pnlTable.addSubscriber(pnlOem);
        pnlTable.addSubscriber(pnlRabati);
        pnlTable.addSubscriber(pnlAlocirano);
        pnlSearch.setTablePanel(pnlTable);
    }
}

