/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.blagajne;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Blagajna;
import rs.pezar.db.entity.Konto;
import rs.pezar.db.entity.KontoPK;
import rs.pezar.sifarnici.gui.PzDialogKontniPlan;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;

public class Dodavanje
extends PzDialogInsert {
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanel panel;
    private PzTextField jLabel5;
    private PzTextField sifBlagajne;
    private PzTextField opis;
    private PzNumericOnlyTextField konto;
    private PzButton btnOK;
    private PzTextField lblOpisKonta;
    private JPanel pnlButtons;
    private PzFieldIndikator indSifBlagajne;
    private PzFieldIndikator indOpis;
    private PzFieldIndikator indKonto;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanelHeader header;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Dodavanje inst = new Dodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Dodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    public Dodavanje(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)data1, data2);
    }

    protected void initGUI() {
        try {
            this.setResizable(false);
            this.getContentPane().setForeground(new Color(255, 128, 128));
            this.panel = new PzPanel();
            this.panel.setTransferFocusOnEnter(true);
            GridBagLayout panelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panel, "Center");
            this.panel.setPreferredSize(new Dimension(435, 105));
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            panelLayout.rowHeights = new int[]{25, 25, 25, 25};
            panelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            panelLayout.columnWidths = new int[]{128, 60, 100, 43, 49, 7};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("\u0160ifra blagajne");
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Opis");
            this.jLabel3 = new JLabel();
            this.panel.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setText("Konto");
            this.sifBlagajne = new PzTextField();
            this.panel.add((Component)this.sifBlagajne, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.sifBlagajne.setFont(new Font("Tahoma", 0, 14));
            this.sifBlagajne.setMaxLength(2);
            this.sifBlagajne.setSize(80, 24);
            this.sifBlagajne.setPKField(Blagajna.class, null);
            this.opis = new PzTextField();
            this.panel.add((Component)this.opis, (Object)new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 3), 0, 0));
            this.opis.setFont(new Font("Tahoma", 0, 14));
            this.opis.setMaxLength(30);
            this.opis.setSize(85, 24);
            this.opis.setVerifyInput(true);
            this.konto = new PzNumericOnlyTextField();
            this.panel.add((Component)this.konto, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.konto.setFont(new Font("Tahoma", 0, 14));
            this.konto.setSize(85, 24);
            this.konto.setMaxLength(6);
            this.konto.setFKField(Konto.class, PzDialogKontniPlan.class, true, null);
            this.konto.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    try {
                        return PzEntityManager.find(Konto.class, (Object)new KontoPK(Dodavanje.this.konto.getText(), ""));
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)Dodavanje.this.konto, (Throwable)e);
                        return null;
                    }
                }
            });
            this.lblOpisKonta = new PzTextField();
            this.panel.add((Component)this.lblOpisKonta, (Object)new GridBagConstraints(2, 2, 3, 1, 0.0, 0.0, 17, 1, new Insets(1, 25, 0, 4), 0, 0));
            this.lblOpisKonta.setVal((Object)"");
            this.lblOpisKonta.setSize(40, 24);
            this.lblOpisKonta.setFocusable(false);
            this.lblOpisKonta.setEditable(false);
            this.lblOpisKonta.setForeground(new Color(0, 128, 0));
            this.jLabel5 = new PzTextField();
            this.panel.add((Component)this.jLabel5, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 3, 0, 0), 0, 0));
            this.jLabel5.setText("TipAnalitika / I");
            this.jLabel5.setForeground(new Color(0, 0, 255));
            this.jLabel5.setSize(40, 24);
            this.jLabel5.setEditable(false);
            this.jLabel5.setFocusable(false);
            this.indSifBlagajne = new PzFieldIndikator();
            this.panel.add((Component)this.indSifBlagajne, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indOpis = new PzFieldIndikator();
            this.panel.add((Component)this.indOpis, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indKonto = new PzFieldIndikator();
            this.panel.add((Component)this.indKonto, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.getContentPane().add((Component)this.header, "North");
            this.pnlButtons = new JPanel();
            this.getContentPane().add((Component)this.pnlButtons, "South");
            this.pnlButtons.setPreferredSize(new Dimension(435, 55));
            this.btnOK = new PzButton();
            this.pnlButtons.add((Component)this.btnOK);
            this.btnOK.setText("Potvrdi");
            this.btnOK.setBounds(48, 9, 133, 30);
            this.btnOK.setFont(new Font("Tahoma", 1, 12));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnOK.setPreferredSize(new Dimension(140, 31));
            this.btnOK.setActionCommand("dodavanje");
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.sifBlagajne.setStateIndikator(this.indSifBlagajne);
            this.opis.setStateIndikator(this.indOpis);
            this.konto.setStateIndikator(this.indKonto);
            this.setSize(441, 262);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equalsIgnoreCase("odustajanje")) {
                this.dispose();
            } else if (actionCommand.equals("insert")) {
                Blagajna b = new Blagajna(this.sifBlagajne.getVal(), this.opis.getVal(), (Konto)PzEntityManager.find(Konto.class, (Object)new KontoPK(this.konto.getText(), "")));
                this.getTable().insert((PzEntity)b, true);
            } else if (actionCommand.equals("update")) {
                Blagajna b = (Blagajna)this.getTable().getSelectedEntity();
                b.setOpis(this.opis.getVal());
                b.setKonto((Konto)PzEntityManager.find(Konto.class, (Object)new KontoPK(this.konto.getVal(), "")));
                this.getTable().updateSelectedEntity((PzEntity)b, true);
            }
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new Dodavanje(Boolean.FALSE);
    }

    public Dodavanje(Boolean initGUI) {
    }

    protected void onInsert() {
        this.btnOK.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.btnOK.setActionCommand("update");
        Blagajna b = (Blagajna)this.getTable().getSelectedEntity();
        this.sifBlagajne.setVal((Object)b.getOznBlagajna());
        this.sifBlagajne.setEnabled(false);
        this.opis.setVal((Object)b.getOpis());
        this.konto.setVal((Object)b.getKonto().getId().getOznKonto());
        this.lblOpisKonta.setVal((Object)b.getKonto().getNaziv());
        this.panel.updateAllFieldsState();
    }

    public void setEntity(PzEntity entity, Component component) {
        PzFieldImpl field = (PzFieldImpl)component;
        Konto konto = (Konto)entity;
        field.setVal((Object)konto.getId().getOznKonto());
        this.lblOpisKonta.setVal((Object)konto.getNaziv());
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Unos blagajne");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/chest_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena blagajne");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/chest_edit.png")));
    }
}

