/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.komintenti.emailKomintenta;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Email;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Tipemaila;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class EmailDodavanje
extends PzDialog {
    private PzPanelHeader pzPanelHeader1;
    private PzPanel pnlButton;
    private PzButton btnAdd;
    private PzButton btnCancel;
    private PzPanel pnlMain;
    private PzTable table;
    private Komitent komitent;
    private boolean update;
    private PzTextField txtEmail;
    private JLabel jLabel1;
    private Tipemaila tipEmaila;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                EmailDodavanje inst = new EmailDodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public EmailDodavanje(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public EmailDodavanje(PzDialog dialog) {
        super(dialog);
        this.table = (PzTable)this.getSession().getParameter("table");
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        this.update = (Boolean)this.getSession().getParameter("update");
        this.initGUI();
        if (this.update) {
            this.onUpdate();
        }
    }

    private void onUpdate() {
        this.pzPanelHeader1.setTitle("Izmena email adrese");
        this.btnAdd.setText("Izmeni");
        this.btnAdd.setActionCommand("Izmeni");
        this.txtEmail.setText(((Email)this.table.getSelectedEntity()).getAdresa());
    }

    private void initGUI() {
        try {
            this.pzPanelHeader1 = new PzPanelHeader();
            this.getContentPane().add((Component)this.pzPanelHeader1, "North");
            this.pzPanelHeader1.setTitle("Dodavanje email adrese");
            this.pzPanelHeader1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/mail.png")));
            this.pnlMain = new PzPanel();
            GridBagLayout pnlMainLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlMain, "Center");
            pnlMainLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlMainLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlMainLayout.columnWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlMainLayout.columnWidths = new int[]{114, 7, 7, 7};
            this.pnlMain.setLayout((LayoutManager)pnlMainLayout);
            this.jLabel1 = new JLabel();
            this.pnlMain.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.txtEmail = new PzTextField();
            this.pnlMain.add((Component)this.txtEmail, (Object)new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 10), 0, 0));
            this.pnlButton = new PzPanel();
            this.getContentPane().add((Component)this.pnlButton, "South");
            this.btnAdd = new PzButton();
            this.pnlButton.add((Component)this.btnAdd);
            this.btnAdd.setName("btnAdd");
            this.btnAdd.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnAdd.addActionListener((ActionListener)((Object)this));
            this.btnAdd.setActionCommand("dodaj");
            this.btnCancel = new PzButton();
            this.pnlButton.add((Component)this.btnCancel);
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/forbidden.png")));
            this.btnCancel.addActionListener((ActionListener)((Object)this));
            this.btnCancel.setActionCommand("odustani");
            this.setSize(400, 300);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        try {
            if (actionCommand.equalsIgnoreCase("odustani")) {
                this.dispose();
            }
            if (actionCommand.equalsIgnoreCase("dodaj")) {
                if (this.txtEmail.getVal().equals("")) {
                    return;
                }
                Email emailFind = (Email)PzEntityManager.find(Email.class, (Object)this.txtEmail.getVal());
                if (emailFind != null) {
                    if (emailFind.getKomitent() == null) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"<html><DIV align = \"center\">Ova email adresa je ve\u0107 uneta za komitenta. <br>Molimo unesite drugu adresu.</DIV></html>");
                    } else {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)("<html><DIV align = \"center\">Ova email adresa je ve\u0107 uneta za komitenta " + emailFind.getKomitent().getNaziv() + ". <br>Molimo unesite drugu adresu.</DIV></html>"));
                    }
                    return;
                }
                Email email = new Email();
                email.setAdresa(this.txtEmail.getVal().trim().toLowerCase());
                this.setTipEmaila();
                email.setTipEmaila(this.tipEmaila);
                email.setKomitent(this.komitent);
                if (this.komitent.getEmails() == null) {
                    this.komitent.setEmails(new ArrayList());
                }
                this.table.insert((PzEntity)email, false);
                PzEntityManager.update((Object)this.komitent);
                this.dispose();
            }
            if (actionCommand.equalsIgnoreCase("Izmeni")) {
                if (this.txtEmail.getVal().equals("")) {
                    return;
                }
                Email emailNew = (Email)PzEntityManager.find(Email.class, (Object)this.txtEmail.getVal());
                if (emailNew != null) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)("<html><DIV align = \"center\">Ova email adresa je ve\u0107 uneta za komitenta " + emailNew.getKomitent().getNaziv() + ". <br>Molimo unesite drugu adresu.</DIV></html>"));
                    return;
                }
                Email emailOld = (Email)this.table.getSelectedEntity();
                emailNew = new Email();
                emailNew.setTipEmaila(emailOld.getTipEmaila());
                emailNew.setKomitent(this.komitent);
                emailNew.setAdresa(this.txtEmail.getVal().trim().toLowerCase());
                this.table.removeSelectedEntity(false, true);
                this.table.insert((PzEntity)emailNew, false);
                PzEntityManager.update((Object)this.komitent);
                this.dispose();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void setTipEmaila() {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                this.tipEmaila = (Tipemaila)em.find(Tipemaila.class, (Object)1);
                if (this.tipEmaila == null) {
                    em.getTransaction().begin();
                    this.tipEmaila = new Tipemaila();
                    this.tipEmaila.setIdTipEmaila(Integer.valueOf(1));
                    this.tipEmaila.setNaziv("POSLOVNI EMAIL");
                    this.tipEmaila.setPredefinisan(Integer.valueOf(0));
                    em.persist((Object)this.tipEmaila);
                    em.getTransaction().commit();
                }
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

