/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.dataimport.importers;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.apache.commons.beanutils.BeanUtils;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.nabavka.dataimport.DataImporter;
import rs.pezar.nabavka.dataimport.DataImporterOptionsPanel;
import rs.pezar.nabavka.dataimport.importers.panels.CSVPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class CSVDataImporter
extends DataImporter {
    private Map<Object, Object> hm;
    private CSVPanel panel;
    private Object[][] niz;
    private File file;

    @Override
    public DataImporterOptionsPanel getOptionsPanel() {
        this.panel = new CSVPanel();
        return this.panel;
    }

    @Override
    public String getFileExtension() {
        return "csv";
    }

    @Override
    public String getImporterName() {
        return "Comma-separated values";
    }

    @Override
    public boolean isValidFileFormat(File f, Map<Object, Object> userOptions) {
        return true;
    }

    @Override
    public Kalkulacija getKalkulacija(File f, Map<Object, Object> userOptions) {
        return null;
    }

    @Override
    public List<Artikalkalkulacija> getArtikalKalkulacijas(File f, Map<Object, Object> userOptions) {
        this.hm = this.panel.getOptions();
        this.niz = (Object[][])this.hm.get("niz");
        int redOd = (Integer)this.hm.get("red_od");
        int redDo = (Integer)this.hm.get("red_do");
        this.file = (File)this.hm.get("file");
        char separator = ((Character)this.hm.get("separator")).charValue();
        ArrayList<Artikalkalkulacija> lista = new ArrayList<Artikalkalkulacija>();
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            CSVReader reader = new CSVReader((Reader)new FileReader(this.file), separator);
            List nextLine = reader.readAll();
            if (nextLine.size() != 0) {
                if (redDo == -1) {
                    redDo = nextLine.size();
                }
                int j = redOd;
                while (j <= redDo) {
                    if (j != nextLine.size()) {
                        Artikalkalkulacija al;
                        String[] row = null;
                        row = separator == ';' ? (String[])nextLine.get(j) : ((String[])nextLine.get(j))[0].split(";");
                        int red = j + 1;
                        if (row.length != 0) {
                            al = new Artikalkalkulacija();
                            int i = 1;
                            while (i < this.niz.length) {
                                if (this.getCriteriaOpstiInt(2)[i] != -1) {
                                    if (this.getCriteriaOpstiInt(2)[i] > row.length) {
                                        throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[i] + " niie dobro definisana! ");
                                    }
                                    if (row[this.getCriteriaOpstiInt(2)[i]] == null) {
                                        throw new PzInfoException("Gre\u0161ka! Kolona za polje " + this.getCriteriaOpsti(0)[i] + " je prazna");
                                    }
                                    if (this.getCriteriaOpsti(3)[i].equals("STRING")) {
                                        if (row[this.getCriteriaOpstiInt(2)[i]].length() > this.getCriteriaOpstiInt(4)[i]) {
                                            throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[i] + " u " + red + ". redu ie preduga\u010dka. Polie " + this.getCriteriaOpsti(0)[i] + " ima " + this.getCriteriaOpstiInt(4)[i] + " karaktera");
                                        }
                                        BeanUtils.setProperty((Object)al, (String)this.getCriteriaOpsti(1)[i], (Object)row[this.getCriteriaOpstiInt(2)[i]]);
                                    } else if (this.getCriteriaOpsti(3)[i].equals("DOUBLE") || this.getCriteriaOpsti(3)[i].equals("BIG_DECIMAL")) {
                                        double broi = this.getDouble(row[this.getCriteriaOpstiInt(2)[i]].replace(",00", ""));
                                        if (broi == -1.0) {
                                            throw new PzInfoException("Gre\u0161ka! Vrednost kolone za polje " + this.getCriteriaOpsti(0)[i] + " u " + red + ". redu nije broj. ");
                                        }
                                        BeanUtils.setProperty((Object)al, (String)this.getCriteriaOpsti(1)[i], (Object)broi);
                                    }
                                }
                                ++i;
                            }
                        } else {
                            throw new PzInfoException("Informacija! Red " + red + " je prazan");
                        }
                        lista.add(al);
                        ++j;
                        continue;
                    }
                    break;
                }
            } else {
                throw new PzInfoException("Informacija! List je prazan!");
            }
            ArrayList<Artikalkalkulacija> arrayList = lista;
            return arrayList;
        }
        catch (PzInfoException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (FileNotFoundException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
            return null;
        }
        finally {
            em.close();
        }
    }

    public double getDouble(String input) {
        try {
            double broj = new DecimalFormat("###,###.##").parse(input).doubleValue();
            return broj;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public String[] getCriteriaOpsti(int x) {
        int len = this.niz.length;
        Object[][] array = this.niz;
        String[] criterias = new String[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (String)array[i][x];
            ++i;
        }
        return criterias;
    }

    public int[] getCriteriaOpstiInt(int x) {
        int len = this.niz.length;
        Object[][] array = this.niz;
        int[] criterias = new int[len];
        int i = 0;
        while (i < len) {
            criterias[i] = (Integer)array[i][x];
            ++i;
        }
        return criterias;
    }

    @Override
    public void validateDokument(Kalkulacija k) throws Exception {
        if (k.getId() == 0) {
            throw new PzInfoException("Da biste mogli da uvezete podatke, zaglavlje kalkulacije mora prethodno biti snimljeno.");
        }
    }

    public static class Type {
        public static final String T_DOUBLE = "DOUBLE";
        public static final String T_BIG_DECIMAL = "BIG_DECIMAL";
        public static final String T_STRING = "STRING";
        public static final String T_DATE = "DATE";
        public static final String T_INTEGER = "INTEGER";
        public static final String T_BOOLEAN = "BOOLEAN";
    }
}

