/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.gui.korekcije;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.nabavka.gui.PzDialogVratiKalkulacijuUPripremu;
import rs.pezar.reports.PzReportManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class UzmiDokument
extends PzDialog {
    private static final long serialVersionUID = 5284942039737355206L;
    private JToolBar toolbar;
    private PzToolBarIcon btnSlikaProfakture;
    private PzToolBarIcon btnNeplacene;
    private PzPanel plGlavni;
    private PzTable tblTabela;
    private JScrollPane scTabela;
    private PzPanel plTabela;
    private JPanel jPanel1;
    private String tipDokumenta;
    private Radnajedinica radnaJedinica;
    private Kalkulacija selektovanaKalkulacija;
    private String tableID = "";
    private String komitent;
    private boolean vracanjeFakture = false;

    public UzmiDokument(PzDialog dialog) {
        super(dialog);
        this.komitent = (String)this.getSession().getParameter("sifraDobavljaca");
        this.radnaJedinica = (Radnajedinica)this.getSession().getParameter("radnajedinica");
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.plGlavni = new PzPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            plGlavniLayout.rowWeights = new double[]{0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{84, 7};
            plGlavniLayout.columnWeights = new double[]{0.1};
            plGlavniLayout.columnWidths = new int[]{7};
            this.plGlavni.setLayout((LayoutManager)plGlavniLayout);
            this.getContentPane().add((Component)this.plGlavni, "Center");
            this.toolbar = new JToolBar();
            this.plGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.btnSlikaProfakture = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnSlikaProfakture);
            this.btnSlikaProfakture.setText("Slika|dokumenta|(F2)");
            this.btnSlikaProfakture.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/presentation.png")));
            this.btnSlikaProfakture.setActionCommand("slika");
            this.btnSlikaProfakture.addActionListener((ActionListener)((Object)this));
            this.btnSlikaProfakture.setShortcut("F2");
            this.btnNeplacene = new PzToolBarIcon();
            this.toolbar.add((Component)this.btnNeplacene);
            this.btnNeplacene.setText("Samo|neplacene|(F4)");
            this.btnNeplacene.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/nabavka/resource/img/presentation.png")));
            this.btnNeplacene.setActionCommand("neplacene");
            this.btnNeplacene.addActionListener((ActionListener)((Object)this));
            this.btnNeplacene.setShortcut("F4");
            this.btnNeplacene.setVisible(false);
            this.jPanel1 = new JPanel();
            this.plGlavni.add((Component)this.jPanel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            BorderLayout jPanel1Layout1 = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout1);
            this.plTabela = new PzPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.add((Component)this.plTabela, "Center");
            this.plTabela.setLayout((LayoutManager)jPanel1Layout);
            this.scTabela = new JScrollPane();
            this.plTabela.add((Component)this.scTabela, (Object)"Center");
            this.scTabela.setBackground(new Color(211, 242, 210));
            this.tblTabela = new PzTable();
            this.tblTabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Kalkulacija dok = (Kalkulacija)entity;
                    return new Object[]{dok.getOznDokumenta(), dok.getIznos(), dok.getIznos(), dok.getDatum(), dok.getDatValute()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Oznaka dokumenta", "Iznos dokumenta", "Dug po dokumentu", "Datum dokumenta", "Datum valute"};
                }
            });
            EntityManager em = PzEntityManager.getEm();
            Query q = null;
            System.out.println("Radna jedinica je: " + this.radnaJedinica.getId().getOznRj());
            System.out.println("Komitent je: " + this.komitent);
            q = em.createQuery("SELECT k FROM Kalkulacija k where k.arhiviran=1 and k.dokument.proknjizen=0 and k.radnajedinica=:rj and k.komitent.sfrKomitent=:sifra and k.storno=0");
            q.setParameter("rj", (Object)this.radnaJedinica);
            q.setParameter("sifra", (Object)this.komitent);
            Vector data = (Vector)q.getResultList();
            System.out.println("Nasao je kalkulacija: " + data.size());
            this.tblTabela.setData(data, Kalkulacija.class);
            em.close();
            this.tblTabela.setId(this.tableID);
            this.scTabela.setViewportView((Component)this.tblTabela);
            this.tblTabela.getTableHeader().setFocusable(false);
            this.tblTabela.requestFocusInWindow();
            if (this.tblTabela.getDataSize() > 0) {
                this.tblTabela.setRowSelectionInterval(0, 0);
            }
            this.tblTabela.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (UzmiDokument.this.tblTabela.getDataSize() > 0) {
                        EntityManager em = PzEntityManager.getEm();
                        try {
                            try {
                                UzmiDokument.this.selektovanaKalkulacija = (Kalkulacija)UzmiDokument.this.tblTabela.getSelectedEntity();
                                ((PzDialogVratiKalkulacijuUPripremu)((Object)UzmiDokument.this.getParent())).setOznakaDokumenta(UzmiDokument.this.selektovanaKalkulacija.getOznDokumenta());
                                UzmiDokument.this.dispose();
                            }
                            catch (Exception ex) {
                                PzMysqlExceptionHandler.handle(null, (Throwable)ex);
                                if (em.getTransaction().isActive()) {
                                    em.getTransaction().rollback();
                                }
                                em.close();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                }
            });
            this.setSize(900, 450);
            this.pack();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(null, (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("slika")) {
            this.showReport();
        }
    }

    public void showReport() {
        try {
            if (this.tblTabela.getSelectedEntity() != null) {
                Kalkulacija kalkulacija = (Kalkulacija)this.tblTabela.getSelectedEntity();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)kalkulacija);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new UzmiDokument(Boolean.FALSE);
    }

    public UzmiDokument(Boolean initGUI) {
    }
}

