/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.nabavka.util;

import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentFinalizer;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.globals.TipDokumentConfig;

public class PzNabavkaFinalizer
implements PzDokumentFinalizer {
    List<String> tipovi = new Vector<String>();

    public PzNabavkaFinalizer() {
        this.tipovi.add(TipDokumentConfig.get().ZAPISNIK_OTPREMNICE);
        this.tipovi.add(TipDokumentConfig.get().RACUN_DOBAVLJACA);
        this.tipovi.add(TipDokumentConfig.get().TROSAK);
    }

    public boolean appliesTo(PzDokument d) {
        if (d.getTip().equals(TipDokumentConfig.get().KALKULACIJA) && d.getPodTip().equals(TipDokumentConfig.get().PODTIP_KALKULACIJA_FAKTURA)) {
            return true;
        }
        return this.tipovi.contains(d.getTip());
    }

    public void finalize(PzDokument d, EntityManager em) {
        if (d.getDokument() != null) {
            if (d.getDokument().getStorno() == 0) {
                d.getDokument().setVrstaDuga("D");
            } else {
                d.getDokument().setVrstaDuga("DS");
            }
        }
        if (d.getDokument().getArtikaldokuments() != null) {
            for (Artikaldokument ad : d.getDokument().getArtikaldokuments()) {
                if (d.getDokument().getStorno() == 0) {
                    ad.setVrstaPromene("D");
                    continue;
                }
                ad.setVrstaPromene("DS");
            }
        }
    }
}

