/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.gui.dock.util.text.DialogText;
import bibliothek.gui.dock.util.text.SwingActionText;
import bibliothek.gui.dock.util.text.TextValue;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class AbstractPreferenceDialog<M extends PreferenceModel>
extends JPanel {
    private M model;
    private JComponent content;
    private JDialog dialog;
    private boolean destroyOnClose;
    private List<TextValue> texts = new ArrayList<TextValue>();

    public AbstractPreferenceDialog(boolean destroyOnClose) {
        this(null, destroyOnClose);
    }

    public AbstractPreferenceDialog(M model, boolean destroyOnClose) {
        this.init(model, destroyOnClose);
    }

    protected AbstractPreferenceDialog(boolean init, M model, boolean destroyOnClose) {
        if (init) {
            this.init(model, destroyOnClose);
        }
    }

    protected void init(M model, boolean destroyOnClose) {
        if (this.content != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.setLayout(new GridBagLayout());
        this.model = model;
        this.destroyOnClose = destroyOnClose;
        this.content = this.getContent();
        JPanel buttons = new JPanel(new GridLayout(1, 4));
        buttons.add(new JButton(new ApplyAction()));
        buttons.add(new JButton(new ResetAction()));
        buttons.add(new JButton(new OkAction()));
        buttons.add(new JButton(new CancelAction()));
        this.add((Component)this.content, new GridBagConstraints(0, 0, 1, 1, 1.0, 1000.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)buttons, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 26, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.setModel(model);
    }

    protected abstract JComponent getContent();

    protected abstract void setModelForContent(M var1);

    public void setModel(M model) {
        this.model = model;
        if (model == null) {
            for (TextValue text : this.texts) {
                text.setManager(null);
            }
        } else {
            for (TextValue text : this.texts) {
                text.setManager(model.getController().getTexts());
            }
        }
        this.setModelForContent(model);
    }

    public M getModel() {
        return this.model;
    }

    public void openDialog(Component owner, boolean modal) {
        if (this.dialog != null) {
            return;
        }
        this.dialog = this.createDialog(owner);
        this.dialog.setModal(modal);
        this.dialog.add(this);
        this.doReset();
        this.dialog.pack();
        this.dialog.setSize((int)((double)this.dialog.getWidth() * 1.5), this.dialog.getHeight());
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.setVisible(true);
    }

    private JDialog createDialog(Component owner) {
        Window window;
        JDialog dialog = owner == null ? new JDialog() : ((window = SwingUtilities.getWindowAncestor(owner)) instanceof Frame ? new JDialog((Frame)window) : (window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog()));
        final DialogText title = new DialogText("preference.dialog.title", dialog){

            @Override
            protected void changed(String oldValue, String newValue) {
                this.getDialog().setTitle(newValue);
            }
        };
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractPreferenceDialog.this.doCancel();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                AbstractPreferenceDialog.this.texts.remove(title);
                title.setController(null);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                AbstractPreferenceDialog.this.texts.add(title);
                if (AbstractPreferenceDialog.this.model != null) {
                    title.setController(AbstractPreferenceDialog.this.model.getController());
                }
            }
        });
        return dialog;
    }

    public void doOk() {
        this.doApply();
        this.close();
    }

    public void doApply() {
        this.getModel().write();
    }

    public void doCancel() {
        this.doReset();
        this.close();
    }

    public void doReset() {
        this.getModel().read();
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog.remove(this);
            this.dialog = null;
        }
        if (this.destroyOnClose) {
            this.destroy();
        }
    }

    public void destroy() {
        this.setModel(null);
    }

    public boolean isDestroyOnClose() {
        return this.destroyOnClose;
    }

    public void setDestroyOnClose(boolean destroyOnClose) {
        this.destroyOnClose = destroyOnClose;
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            AbstractPreferenceDialog.this.texts.add(new SwingActionText("preference.dialog.apply.text", "Name", this));
            AbstractPreferenceDialog.this.texts.add(new SwingActionText("preference.dialog.apply.description", "ShortDescription", this));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPreferenceDialog.this.doApply();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            AbstractPreferenceDialog.this.texts.add(new SwingActionText("preference.dialog.cancel.text", "Name", this));
            AbstractPreferenceDialog.this.texts.add(new SwingActionText("preference.dialog.cancel.description", "ShortDescription", this));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPreferenceDialog.this.doCancel();
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            AbstractPreferenceDialog.this.texts.add(new SwingActionText("preference.dialog.ok.text", "Name", this));
            AbstractPreferenceDialog.this.texts.add(new SwingActionText("preference.dialog.ok.description", "ShortDescription", this));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPreferenceDialog.this.doOk();
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            AbstractPreferenceDialog.this.texts.add(new SwingActionText("preference.dialog.reset.text", "Name", this));
            AbstractPreferenceDialog.this.texts.add(new SwingActionText("preference.dialog.reset.description", "ShortDescription", this));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPreferenceDialog.this.doReset();
        }
    }
}

