/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme;

import bibliothek.extension.gui.dock.theme.flat.FlatButtonTitle;
import bibliothek.extension.gui.dock.theme.flat.FlatColorScheme;
import bibliothek.extension.gui.dock.theme.flat.FlatDisplayerFactory;
import bibliothek.extension.gui.dock.theme.flat.FlatStationPaint;
import bibliothek.extension.gui.dock.theme.flat.FlatTabPane;
import bibliothek.extension.gui.dock.theme.flat.FlatTitleFactory;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.ButtonDockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewGenerator;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.dockable.ScreencaptureMovingImageFactory;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.StackDockComponentFactory;
import bibliothek.gui.dock.station.stack.StackDockComponentParent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.ThemeProperties;
import bibliothek.gui.dock.themes.basic.action.BasicButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicMenuHandler;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.gui.dock.themes.basic.action.BasicSelectableHandler;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.basic.action.buttons.BasicMiniButton;
import bibliothek.gui.dock.themes.basic.action.buttons.DropDownMiniButton;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButton;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.property.DynamicPropertyFactory;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

@ThemeProperties(nameBundle="theme.flat", descriptionBundle="theme.flat.description", authors={"Benjamin Sigg"}, webpages={})
public class FlatTheme
extends BasicTheme {
    protected DisplayerFactory splitDisplayFactory = new FlatDisplayerFactory(true);
    public static final PropertyKey<ColorScheme> FLAT_COLOR_SCHEME = new PropertyKey<ColorScheme>("dock.ui.FlatTheme.ColorScheme", new DynamicPropertyFactory<ColorScheme>(){

        @Override
        public ColorScheme getDefault(PropertyKey<ColorScheme> key, DockProperties properties) {
            return new FlatColorScheme();
        }
    }, true);

    public FlatTheme() {
        this.setColorSchemeKey(FLAT_COLOR_SCHEME);
        this.setPaint(new FlatStationPaint(), Priority.DEFAULT);
        this.setTitleFactory(new FlatTitleFactory(), Priority.DEFAULT);
        this.setDisplayerFactory(new FlatDisplayerFactory(false), Priority.DEFAULT);
        this.setStackDockComponentFactory(new StackDockComponentFactory(){

            @Override
            public StackDockComponent create(StackDockComponentParent station) {
                return new FlatTabPane(station);
            }
        }, Priority.DEFAULT);
        this.setMovingImageFactory(new ScreencaptureMovingImageFactory(new Dimension(300, 200)), Priority.DEFAULT);
        this.setTabPlacement(TabPlacement.BOTTOM_OF_DOCKABLE, Priority.DEFAULT);
    }

    @Override
    public void install(DockController controller) {
        super.install(controller);
        controller.getDockTitleManager().registerTheme("flap button", new DockTitleFactory(){

            @Override
            public void install(DockTitleRequest request) {
            }

            @Override
            public void uninstall(DockTitleRequest request) {
            }

            @Override
            public void request(DockTitleRequest request) {
                request.answer(new FlatButtonTitle(request.getTarget(), request.getVersion()));
            }
        });
        controller.getActionViewConverter().putTheme(ActionType.BUTTON, ViewTarget.TITLE, new ViewGenerator<ButtonDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, ButtonDockAction action, Dockable dockable) {
                BasicButtonHandler handler = new BasicButtonHandler(action, dockable);
                MiniButton<BasicButtonModel> button = FlatTheme.this.createTitleMiniButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        controller.getActionViewConverter().putTheme(ActionType.CHECK, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                BasicSelectableHandler.Check handler = new BasicSelectableHandler.Check(action, dockable);
                MiniButton<BasicButtonModel> button = FlatTheme.this.createTitleMiniButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        controller.getActionViewConverter().putTheme(ActionType.MENU, ViewTarget.TITLE, new ViewGenerator<MenuDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, MenuDockAction action, Dockable dockable) {
                BasicMenuHandler handler = new BasicMenuHandler(action, dockable);
                MiniButton<BasicButtonModel> button = FlatTheme.this.createTitleMiniButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        controller.getActionViewConverter().putTheme(ActionType.RADIO, ViewTarget.TITLE, new ViewGenerator<SelectableDockAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, SelectableDockAction action, Dockable dockable) {
                BasicSelectableHandler.Radio handler = new BasicSelectableHandler.Radio(action, dockable);
                MiniButton<BasicButtonModel> button = FlatTheme.this.createTitleMiniButton(handler, handler);
                handler.setModel(button.getModel());
                return handler;
            }
        });
        controller.getActionViewConverter().putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, new ViewGenerator<DropDownAction, BasicTitleViewItem<JComponent>>(){

            @Override
            public BasicTitleViewItem<JComponent> create(ActionViewConverter converter, DropDownAction action, Dockable dockable) {
                BasicDropDownButtonHandler handler = new BasicDropDownButtonHandler(action, dockable);
                DropDownMiniButton button = new DropDownMiniButton(handler);
                handler.setModel((BasicDropDownButtonModel)button.getModel());
                button.setMouseOverBorder(BorderFactory.createEtchedBorder());
                return handler;
            }
        });
    }

    protected MiniButton<BasicButtonModel> createTitleMiniButton(BasicTrigger trigger, BasicResourceInitializer initializer) {
        BasicMiniButton button = new BasicMiniButton(trigger, initializer);
        button.setMouseOverBorder(BorderFactory.createEtchedBorder());
        button.setNormalSelectedBorder(BorderFactory.createEtchedBorder());
        return button;
    }

    @Override
    public void uninstall(DockController controller) {
        super.uninstall(controller);
        controller.getDockTitleManager().clearThemeFactories();
        controller.getActionViewConverter().putTheme(ActionType.BUTTON, ViewTarget.TITLE, null);
        controller.getActionViewConverter().putTheme(ActionType.CHECK, ViewTarget.TITLE, null);
        controller.getActionViewConverter().putTheme(ActionType.MENU, ViewTarget.TITLE, null);
        controller.getActionViewConverter().putTheme(ActionType.RADIO, ViewTarget.TITLE, null);
        controller.getActionViewConverter().putTheme(ActionType.DROP_DOWN, ViewTarget.TITLE, null);
    }

    public void setSplitDisplayFactory(DisplayerFactory splitDisplayFactory) {
        this.splitDisplayFactory = splitDisplayFactory;
    }

    public DisplayerFactory getSplitDisplayFactory() {
        return this.splitDisplayFactory;
    }

    @Override
    public DisplayerFactory getDisplayFactory(DockStation station) {
        if (station instanceof SplitDockStation) {
            return this.splitDisplayFactory;
        }
        return super.getDisplayFactory(station);
    }
}

