/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockActionSource;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.CombinedInfoComponent;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import java.awt.Component;
import java.awt.Dimension;

public class EclipseTabInfo
extends AbstractTabPaneComponent
implements CombinedInfoComponent,
LayoutBlock {
    private EclipseTabPane pane;
    private ButtonPanel buttons;
    private Dockable dockable;

    public EclipseTabInfo(EclipseTabPane pane) {
        super(pane);
        this.pane = pane;
        this.buttons = new ButtonPanel(true);
    }

    public void setSelection(Dockable dockable) {
        this.dockable = dockable;
        this.updateContent();
    }

    protected void updateContent() {
        if (this.dockable == null) {
            this.buttons.set(null, null);
        } else {
            EclipseDockActionSource source = new EclipseDockActionSource(this.pane.getTheme(), this.dockable.getGlobalActionOffers(), this.dockable, false);
            this.buttons.set(this.dockable, source);
        }
    }

    @Override
    public Component getComponent() {
        return this.buttons;
    }

    @Override
    public boolean isPaneVisible() {
        return this.pane.getInfoHandler().isVisible(this);
    }

    @Override
    public void setPaneVisible(boolean visible) {
        this.pane.getInfoHandler().setVisible(this, visible);
    }

    @Override
    public int getZOrder() {
        return this.pane.getInfoHandler().getZOrder(this);
    }

    @Override
    public void setZOrder(int order) {
        this.pane.getInfoHandler().setZOrder(this, order);
    }

    @Override
    public LayoutBlock toLayoutBlock() {
        return this;
    }

    @Override
    public void setOrientation(TabPlacement orientation) {
        super.setOrientation(orientation);
        this.buttons.setOrientation(orientation.toOrientation());
    }

    @Override
    public Size[] getSizes() {
        Dimension[] sizes = this.buttons.getPreferredSizes();
        Size[] result = new Size[sizes.length];
        int i = 0;
        while (i < sizes.length) {
            Size.Type type = i + 1 == sizes.length ? Size.Type.PREFERRED : Size.Type.MINIMUM;
            result[i] = new CountingSize(type, sizes[i], i);
            ++i;
        }
        return result;
    }

    @Override
    public void setLayout(Size size) {
        if (!(size instanceof CountingSize)) {
            throw new IllegalArgumentException("size not created by this component");
        }
        this.buttons.setVisibleActions(((CountingSize)size).getCount());
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.buttons.setBounds(x, y, width, height);
    }

    private static class CountingSize
    extends Size {
        private int count;

        public CountingSize(Size.Type type, Dimension size, int count) {
            super(type, size);
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

