/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.popup;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.popup.ActionPopupMenu;
import bibliothek.gui.dock.action.popup.ActionPopupMenuListener;
import bibliothek.gui.dock.themes.basic.action.menu.MenuMenuHandler;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DefaultActionPopupMenu
implements ActionPopupMenu {
    private Dockable dockable;
    private JPopupMenu menu;
    private MenuMenuHandler handler;
    private List<ActionPopupMenuListener> listeners = new ArrayList<ActionPopupMenuListener>();
    private boolean showing = false;

    public DefaultActionPopupMenu(Dockable dockable, DockActionSource actions) {
        this.menu = new JPopupMenu();
        this.handler = new MenuMenuHandler(actions, dockable, this.menu);
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DefaultActionPopupMenu.this.handler.unbind();
                        DefaultActionPopupMenu.this.showing = false;
                        DefaultActionPopupMenu.this.fireClosed();
                    }
                });
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void fireClosed() {
        ActionPopupMenuListener[] actionPopupMenuListenerArray = this.listeners.toArray(new ActionPopupMenuListener[this.listeners.size()]);
        int n = actionPopupMenuListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionPopupMenuListener listener = actionPopupMenuListenerArray[n2];
            listener.closed(this);
            ++n2;
        }
    }

    @Override
    public void addListener(ActionPopupMenuListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public Dockable getDockable() {
        return this.dockable;
    }

    @Override
    public void removeListener(ActionPopupMenuListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void show(Component owner, int x, int y) {
        if (!this.isShowing()) {
            this.handler.bind();
            this.menu.show(owner, x, y);
            this.showing = true;
        }
    }

    public boolean isShowing() {
        return this.showing;
    }
}

