/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.dock.common.event.ColorMapListener;
import bibliothek.gui.dock.common.intern.CDockable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColorMap {
    public static final String COLOR_KEY_TAB_BACKGROUND = "tab.background";
    public static final String COLOR_KEY_TAB_FOREGROUND = "tab.foreground";
    public static final String COLOR_KEY_TAB_BACKGROUND_SELECTED = "tab.background.selected";
    public static final String COLOR_KEY_TAB_FOREGROUND_SELECTED = "tab.foreground.selected";
    public static final String COLOR_KEY_TAB_BACKGROUND_FOCUSED = "tab.background.focused";
    public static final String COLOR_KEY_TAB_FOREGROUND_FOCUSED = "tab.foreground.focused";
    public static final String COLOR_KEY_TITLE_BACKGROUND = "title.background";
    public static final String COLOR_KEY_TITLE_FOREGROUND = "title.foreground";
    public static final String COLOR_KEY_TITLE_BACKGROUND_FOCUSED = "title.background.focused";
    public static final String COLOR_KEY_TITLE_FOREGROUND_FOCUSED = "title.foreground.focused";
    public static final String COLOR_KEY_MINIMIZED_BUTTON_BACKGROUND = "minimized.background";
    public static final String COLOR_KEY_MINIMIZED_BUTTON_FOREGROUND = "minimized.foreground";
    public static final String COLOR_KEY_MINIMIZED_BUTTON_BACKGROUND_FOCUSED = "minimized.background.focused";
    public static final String COLOR_KEY_MINIMIZED_BUTTON_FOREGROUND_FOCUSED = "minimized.foreground.focused";
    public static final String COLOR_KEY_MINIMIZED_BUTTON_BACKGROUND_SELECTED = "minimized.background.selected";
    public static final String COLOR_KEY_MINIMIZED_BUTTON_FOREGROUND_SELECTED = "minimized.foreground.selected";
    private List<ColorMapListener> listeners = new ArrayList<ColorMapListener>();
    private Map<String, Color> colors = new HashMap<String, Color>();
    private CDockable dockable;

    public ColorMap(CDockable dockable) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.dockable = dockable;
    }

    public CDockable getDockable() {
        return this.dockable;
    }

    public void addListener(ColorMapListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ColorMapListener listener) {
        this.listeners.remove(listener);
    }

    public Color getColor(String key) {
        return this.colors.get(key);
    }

    public void setColor(String key, Color color) {
        Color old = color == null ? this.colors.remove(key) : this.colors.put(key, color);
        if (old == null && color != null || old != null && !old.equals(color)) {
            ColorMapListener[] colorMapListenerArray = this.listeners.toArray(new ColorMapListener[this.listeners.size()]);
            int n = colorMapListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColorMapListener listener = colorMapListenerArray[n2];
                listener.colorChanged(this, key, color);
                ++n2;
            }
        }
    }
}

