/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import java.util.HashMap;

public class WorkingAreaAcceptance
implements DockAcceptance {
    private CControlAccess control;

    public WorkingAreaAcceptance(CControlAccess control) {
        this.control = control;
    }

    @Override
    public boolean accept(DockStation parent, Dockable child, Dockable next) {
        return this.accept(parent, next);
    }

    @Override
    public boolean accept(DockStation parent, Dockable child) {
        CGroupMovement action;
        CLocationModeManager manager = this.control.getLocationManager();
        if (manager.isOnTransaction() && ((action = manager.getCurrentAction()) == null || action.forceAccept(parent, child))) {
            return true;
        }
        ExtendedMode extendedMode = manager.childsExtendedMode(parent);
        if (extendedMode == null && (extendedMode = manager.getMode(child)) == null) {
            return true;
        }
        CLocationMode mode = (CLocationMode)manager.getMode(extendedMode.getModeIdentifier());
        if (mode == null) {
            return true;
        }
        if (!mode.respectWorkingAreas(parent)) {
            return true;
        }
        CStation<?> area = this.searchArea(parent);
        return this.match(area, child);
    }

    private CStation<?> searchArea(DockElement element) {
        CStation<?> station2;
        HashMap stations = new HashMap();
        for (CStation<?> station2 : this.control.getOwner().getStations()) {
            if (!station2.isWorkingArea()) continue;
            stations.put(station2.getStation(), station2);
        }
        station2 = element.asDockStation();
        Dockable dockable = element.asDockable();
        while (dockable != null || station2 != null) {
            CStation cstation;
            if (station2 != null && (cstation = (CStation)stations.get(station2)) != null) {
                return cstation;
            }
            dockable = station2 == null ? null : station2.asDockable();
            CStation<?> cStation = station2 = dockable == null ? null : dockable.getDockParent();
        }
        return null;
    }

    private boolean match(CStation<?> area, Dockable dockable) {
        CDockable fdockable;
        CStation<?> request;
        if (dockable instanceof CommonDockable && (request = (fdockable = ((CommonDockable)dockable).getDockable()).getWorkingArea()) != area) {
            return false;
        }
        DockStation station = dockable.asDockStation();
        if (station != null) {
            CStation<?> cstation;
            if (dockable instanceof CommonDockable && (cstation = ((CommonDockable)dockable).getStation()) != null && cstation.isWorkingArea()) {
                return true;
            }
            return this.match(area, station);
        }
        return true;
    }

    private boolean match(CStation<?> area, DockStation station) {
        int i = 0;
        int n = station.getDockableCount();
        while (i < n) {
            boolean result = this.match(area, station.getDockable(i));
            if (!result) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

