/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.action.predefined.CNormalizeAction;
import bibliothek.gui.dock.common.action.predefined.CUnexternalizeAction;
import bibliothek.gui.dock.common.mode.CExternalizedMode;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.CModeArea;
import bibliothek.gui.dock.common.mode.CNormalModeArea;
import bibliothek.gui.dock.common.mode.KeyedLocationModeActionProvider;
import bibliothek.gui.dock.common.perspective.mode.CNormalModePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModePerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.MappingLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.support.mode.Mode;

public class CNormalMode
extends NormalMode<CNormalModeArea>
implements CLocationMode {
    private LocationModeActionProvider normalize;
    private LocationModeActionProvider unexternalize;

    public CNormalMode(CControl control) {
        this.normalize = new KeyedLocationModeActionProvider("cdockable.normalize", new CNormalizeAction(control));
        this.unexternalize = new KeyedLocationModeActionProvider("cdockable.unexternalize", new CUnexternalizeAction(control));
        this.setActionProvider(new MappingLocationModeActionProvider(){

            @Override
            protected LocationModeActionProvider getProvider(Dockable dockable, Mode<Location> currentMode, DockActionSource currentSource) {
                if (currentMode instanceof CMaximizedMode) {
                    currentMode = ((CMaximizedMode)currentMode).getUnmaximizedMode(dockable);
                }
                if (currentMode instanceof CExternalizedMode) {
                    return CNormalMode.this.unexternalize;
                }
                return CNormalMode.this.normalize;
            }
        });
    }

    @Override
    public CLocation getCLocation(Dockable dockable) {
        CNormalModeArea area = (CNormalModeArea)this.get(dockable);
        if (area == null) {
            return null;
        }
        return area.getCLocation(dockable);
    }

    @Override
    public CLocation getCLocation(Dockable dockable, Location location) {
        CModeArea area = (CModeArea)this.get(dockable);
        if (area == null) {
            return null;
        }
        return area.getCLocation(dockable, location);
    }

    @Override
    public boolean isBasicMode() {
        return true;
    }

    public CLocation getDefaultLocation() {
        CNormalModeArea area = (CNormalModeArea)this.getDefaultArea();
        if (area == null || area.isWorkingArea()) {
            for (CNormalModeArea check : this) {
                if (check.isWorkingArea()) continue;
                area = check;
                break;
            }
        }
        if (area == null) {
            return null;
        }
        return area.getBaseLocation();
    }

    @Override
    public boolean respectWorkingAreas(DockStation station) {
        CModeArea area = (CModeArea)this.get(station);
        if (area == null) {
            return true;
        }
        return area.respectWorkingAreas();
    }

    @Override
    public LocationModePerspective createPerspective() {
        return new CNormalModePerspective();
    }
}

