/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockStationAdapter;

public class VisibilityFocusObserver
implements DockRegisterListener {
    private StationListener listener = new StationListener();
    private DockController controller;

    public VisibilityFocusObserver(DockController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = controller;
    }

    @Override
    public void dockStationRegistered(DockController controller, DockStation station) {
        station.addDockStationListener(this.listener);
    }

    @Override
    public void dockStationUnregistered(DockController controller, DockStation station) {
        station.removeDockStationListener(this.listener);
    }

    @Override
    public void dockableUnregistered(DockController controller, Dockable dockable) {
        if (dockable == controller.getFocusedDockable()) {
            controller.setFocusedDockable(null, null, false);
        }
    }

    @Override
    public void dockStationRegistering(DockController controller, DockStation station) {
    }

    @Override
    public void dockableRegistered(DockController controller, Dockable dockable) {
    }

    @Override
    public void dockableRegistering(DockController controller, Dockable dockable) {
    }

    @Override
    public void dockableCycledRegister(DockController controller, Dockable dockable) {
    }

    private class StationListener
    extends DockStationAdapter {
        private StationListener() {
        }

        @Override
        public void dockableAdded(DockStation station, Dockable dockable) {
            Dockable focusedDockable;
            if (!VisibilityFocusObserver.this.controller.getRelocator().isOnPut() && (dockable == (focusedDockable = VisibilityFocusObserver.this.controller.getFocusedDockable()) || focusedDockable == null) && dockable.isDockableVisible()) {
                VisibilityFocusObserver.this.controller.setFocusedDockable(dockable, null, true);
            }
        }

        @Override
        public void dockableVisibiltySet(DockStation station, Dockable dockable, boolean visible) {
            if (!VisibilityFocusObserver.this.controller.isOnFocusing() && !visible && VisibilityFocusObserver.this.controller.isFocused(dockable)) {
                DockStation parent = dockable.getDockParent();
                while (parent != null) {
                    dockable = parent.asDockable();
                    if (dockable == null) break;
                    parent = dockable.getDockParent();
                    if (parent == null || !parent.isVisible(dockable)) continue;
                    VisibilityFocusObserver.this.controller.setFocusedDockable(dockable, null, false);
                    return;
                }
                VisibilityFocusObserver.this.controller.setFocusedDockable(null, null, false);
            }
        }
    }
}

