/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import java.util.ArrayList;
import java.util.List;

public class DockHierarchyObserver
implements DockHierarchyListener {
    private DockElement parent;
    private List<DockHierarchyListener> hierarchyListeners = new ArrayList<DockHierarchyListener>();
    private Dockable owner;

    public DockHierarchyObserver(Dockable owner) {
        this.owner = owner;
    }

    @Override
    public void hierarchyChanged(DockHierarchyEvent event) {
        this.fireHierarchyChanged();
    }

    @Override
    public void controllerChanged(DockHierarchyEvent event) {
    }

    public void controllerChanged(DockController controller) {
        this.fireControllerChanged(controller);
    }

    public void addDockHierarchyListener(DockHierarchyListener listener) {
        this.hierarchyListeners.add(listener);
    }

    public void removeDockHierarchyListener(DockHierarchyListener listener) {
        this.hierarchyListeners.remove(listener);
    }

    protected void fireHierarchyChanged() {
        if (!this.hierarchyListeners.isEmpty()) {
            DockHierarchyEvent event = new DockHierarchyEvent(this.owner);
            DockHierarchyListener[] dockHierarchyListenerArray = this.hierarchyListeners.toArray(new DockHierarchyListener[this.hierarchyListeners.size()]);
            int n = dockHierarchyListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockHierarchyListener listener = dockHierarchyListenerArray[n2];
                listener.hierarchyChanged(event);
                ++n2;
            }
        }
    }

    protected void fireControllerChanged(DockController controller) {
        if (!this.hierarchyListeners.isEmpty()) {
            DockHierarchyEvent event = new DockHierarchyEvent(this.owner, controller);
            DockHierarchyListener[] dockHierarchyListenerArray = this.hierarchyListeners.toArray(new DockHierarchyListener[this.hierarchyListeners.size()]);
            int n = dockHierarchyListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockHierarchyListener listener = dockHierarchyListenerArray[n2];
                listener.controllerChanged(event);
                ++n2;
            }
        }
    }

    public void update() {
        DockElement old = this.parent;
        this.parent = this.owner.getDockParent();
        if (old != this.parent) {
            if (old != null && old.asDockable() != null) {
                old.asDockable().removeDockHierarchyListener(this);
            }
            if (this.parent != null && this.parent.asDockable() != null) {
                this.parent.asDockable().addDockHierarchyListener(this);
            }
            this.fireHierarchyChanged();
        }
    }
}

