/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.station.screen.BoundaryRestriction;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class HardBoundaryRestriction
implements BoundaryRestriction {
    @Override
    public Rectangle check(ScreenDockWindow window) {
        return this.check(window, window.getWindowBounds());
    }

    @Override
    public Rectangle check(ScreenDockWindow window, Rectangle target) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        int x = target.x;
        int y = target.y;
        int width = target.width;
        int height = target.height;
        double fit = -1.0;
        GraphicsDevice best = null;
        GraphicsDevice[] graphicsDeviceArray = screens;
        int n = screens.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice screen = graphicsDeviceArray[n2];
            double check = this.measureBounds(window, x, y, width, height, screen);
            if (check > fit) {
                fit = check;
                best = screen;
            }
            ++n2;
        }
        if (best == null) {
            return null;
        }
        return this.boundsInDevice(window, x, y, width, height, best);
    }

    protected double measureBounds(ScreenDockWindow window, int x, int y, int width, int height, GraphicsDevice device) {
        if (width == 0 || height == 0) {
            return 0.0;
        }
        Rectangle next = new Rectangle(x, y, width, height);
        Rectangle screen = device.getDefaultConfiguration().getBounds();
        Rectangle intersection = screen.intersection(next);
        if (intersection.width <= 0 || intersection.height <= 0) {
            return 0.0;
        }
        return (double)(intersection.width * intersection.height) / ((double)next.width * (double)next.height);
    }

    protected Rectangle boundsInDevice(ScreenDockWindow window, int x, int y, int width, int height, GraphicsDevice device) {
        Rectangle size = device.getDefaultConfiguration().getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(device.getDefaultConfiguration());
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        width = Math.min(size.width - insets.left - insets.right, width);
        height = Math.min(size.height - insets.top - insets.bottom, height);
        x = Math.max(x, size.x + insets.left);
        y = Math.max(y, size.y + insets.right);
        x = Math.min(x, size.width - insets.left - insets.right - width + size.x);
        y = Math.min(y, size.height - insets.top - insets.bottom - height + size.y);
        return new Rectangle(x, y, width, height);
    }
}

