/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButton;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.Border;

public class DropDownMiniButton
extends MiniButton<BasicDropDownButtonModel> {
    private Icon dropIcon;
    private Icon disabledDropIcon;
    private Color dropIconColor;
    private BasicDropDownButtonHandler handler;

    public DropDownMiniButton(BasicDropDownButtonHandler handler) {
        super(null);
        this.handler = handler;
        BasicDropDownButtonModel model = new BasicDropDownButtonModel(this, handler, handler){

            @Override
            public void changed() {
                DropDownMiniButton.this.updateBorder();
                DropDownMiniButton.this.repaint();
            }

            @Override
            protected boolean inDropDownArea(int x, int y) {
                return DropDownMiniButton.this.isOverDropIcon(x, y);
            }
        };
        this.setModel(model);
        this.dropIcon = this.createDropIcon();
    }

    public void setDropIconColor(Color dropIconColor) {
        this.dropIconColor = dropIconColor;
        this.disabledDropIcon = null;
        this.repaint();
    }

    public Color getDropIconColor() {
        return this.dropIconColor;
    }

    @Override
    public void setForeground(Color fg) {
        this.disabledDropIcon = null;
        super.setForeground(fg);
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getMaxBorderInsets();
        Dimension icon = ((BasicDropDownButtonModel)this.getModel()).getMaxIconSize();
        icon.width = Math.max(icon.width, 16);
        icon.height = Math.max(icon.height, 16);
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int width = insets.left + 2 * insets.right + icon.width;
            int height = this.dropIcon.getIconHeight();
            height = icon == null ? Math.max(height, 16) : Math.max(height, icon.height);
            return new Dimension(width += this.dropIcon.getIconWidth(), height += insets.top + insets.bottom);
        }
        int height = insets.top + 2 * insets.bottom + icon.height;
        int width = this.dropIcon.getIconWidth();
        width = icon == null ? Math.max(width, 16) : Math.max(width, icon.width);
        return new Dimension(width += insets.left + insets.right, height += this.dropIcon.getIconHeight());
    }

    @Override
    public void updateUI() {
        this.disabledDropIcon = null;
        if (this.handler != null) {
            this.handler.updateUI();
        }
        super.updateUI();
    }

    @Override
    public void paint(Graphics g) {
        BasicDropDownButtonModel model = (BasicDropDownButtonModel)this.getModel();
        BackgroundPaint paint = model.getBackground();
        BackgroundComponent component = model.getBackgroundComponent();
        AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

            @Override
            protected void background(Graphics g) {
            }

            @Override
            protected void foreground(Graphics g) {
                DropDownMiniButton.this.doPaintForeground(g);
            }

            @Override
            protected void border(Graphics g) {
                DropDownMiniButton.this.doPaintBorder(g);
            }

            @Override
            protected void children(Graphics g) {
            }

            @Override
            protected void overlay(Graphics g) {
            }

            @Override
            public boolean isSolid() {
                return false;
            }

            @Override
            public boolean isTransparent() {
                return false;
            }
        };
        paintable.paint(g);
    }

    private void doPaintForeground(Graphics g) {
        Icon icon = ((BasicDropDownButtonModel)this.getModel()).getPaintIcon();
        Insets insets = this.getMaxBorderInsets();
        Icon drop = this.dropIcon;
        if (!this.isEnabled()) {
            if (this.disabledDropIcon == null) {
                this.disabledDropIcon = DockUtilities.disabledIcon(this, this.dropIcon);
            }
            drop = this.disabledDropIcon;
        }
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int iconWidth = icon == null ? 16 : icon.getIconWidth();
            int dropWidth = this.dropIcon.getIconWidth();
            double sum = insets.left + iconWidth + insets.right + dropWidth + insets.right;
            double factor = (double)this.getWidth() / sum;
            if (icon != null) {
                icon.paintIcon(this, g, (int)(factor * (double)(insets.left + iconWidth / 2) - (double)(iconWidth / 2)), insets.top + (this.getHeight() - insets.top - insets.bottom - icon.getIconHeight()) / 2);
            }
            drop.paintIcon(this, g, (int)(factor * (double)(insets.left + insets.right + iconWidth + dropWidth / 2) - (double)(dropWidth / 2)), insets.top + (this.getHeight() - insets.top - insets.bottom - this.dropIcon.getIconHeight()) / 2);
        } else {
            int iconHeight = icon == null ? 16 : icon.getIconHeight();
            int dropHeight = this.dropIcon.getIconHeight();
            double sum = insets.top + iconHeight + insets.bottom + dropHeight + insets.bottom;
            double factor = (double)this.getHeight() / sum;
            if (icon != null) {
                icon.paintIcon(this, g, insets.left + (this.getWidth() - insets.left - insets.right - icon.getIconWidth()) / 2, (int)(factor * (double)(insets.top + iconHeight / 2) - (double)(iconHeight / 2)));
            }
            drop.paintIcon(this, g, insets.left + (this.getWidth() - insets.left - insets.right - this.dropIcon.getIconWidth()) / 2, (int)(factor * (double)(insets.top + insets.bottom + iconHeight + dropHeight / 2) - (double)(dropHeight / 2)));
        }
        if (this.isFocusOwner() && this.isFocusable() && this.isEnabled()) {
            this.paintFocus(g);
        }
    }

    private void doPaintBorder(Graphics g) {
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = this.getMaxBorderInsets();
            Icon icon = ((BasicDropDownButtonModel)this.getModel()).getPaintIcon();
            if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
                int iconWidth = icon == null ? 16 : icon.getIconWidth();
                int dropWidth = this.dropIcon.getIconWidth();
                double sum = insets.left + iconWidth + insets.right + dropWidth + insets.right;
                double factor = (double)this.getWidth() / sum;
                border.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
                if (((BasicDropDownButtonModel)this.getModel()).isMouseOverDropDown()) {
                    border.paintBorder(this, g, 0, 0, (int)(factor * (double)(insets.left + insets.right + iconWidth)), this.getHeight());
                }
            } else {
                int iconHeight = icon == null ? 16 : icon.getIconHeight();
                int dropHeight = this.dropIcon.getIconHeight();
                double sum = insets.top + iconHeight + insets.bottom + dropHeight + insets.bottom;
                double factor = (double)this.getHeight() / sum;
                if (((BasicDropDownButtonModel)this.getModel()).isMouseOverDropDown()) {
                    border.paintBorder(this, g, 0, 0, this.getWidth(), (int)(factor * (double)(insets.top + insets.bottom + iconHeight)));
                }
            }
        }
    }

    protected Icon createDropIcon() {
        return new Icon(){

            @Override
            public int getIconHeight() {
                return 7;
            }

            @Override
            public int getIconWidth() {
                return 7;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                ++x;
                if (DropDownMiniButton.this.dropIconColor == null) {
                    g.setColor(DropDownMiniButton.this.getForeground());
                } else {
                    g.setColor(DropDownMiniButton.this.dropIconColor);
                }
                g.drawLine(x, y + 1, x + 4, y + 1);
                g.drawLine(x + 1, y + 2, x + 3, y + 2);
                g.drawLine(x + 2, y + 3, x + 2, y + 3);
            }
        };
    }

    public boolean isOverDropIcon(int x, int y) {
        if (!this.contains(x, y)) {
            return false;
        }
        Dimension icon = ((BasicDropDownButtonModel)this.getModel()).getMaxIconSize();
        Insets insets = this.getMaxBorderInsets();
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int iconWidth = icon.width < 16 ? 16 : icon.width;
            int dropWidth = this.dropIcon.getIconWidth();
            double sum = insets.left + iconWidth + insets.right + dropWidth + insets.right;
            double factor = (double)this.getWidth() / sum;
            int barrier = (int)(factor * (double)(insets.left + insets.right + iconWidth)) - insets.right;
            return x > barrier;
        }
        int iconHeight = icon.height < 16 ? 16 : icon.height;
        int dropHeight = this.dropIcon.getIconHeight();
        double sum = insets.top + iconHeight + insets.bottom + dropHeight + insets.bottom;
        double factor = (double)this.getHeight() / sum;
        int barrier = (int)(factor * (double)(insets.top + insets.bottom + iconHeight)) - insets.bottom;
        return y > barrier;
    }
}

